/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.sx140;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamento;
import jalis.laboratorio.interfaceamento.abas.AbaDefaultNaoEnviados;
import jalis.laboratorio.interfaceamento.interfaces.sx140.RequisicaoRack;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.TempoUtil;
import jalis.util.componentes.BotaoNavegavel;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class AbaExamesNaoEnviadosRack
extends AbaDefaultNaoEnviados {
    private JButton buttonRack = new BotaoNavegavel("Rack", 'A');
    JPanel panel_rack = new JPanel(new FlowLayout());

    public AbaExamesNaoEnviadosRack(JFrame parent, AbstractInterfaceamento equip) {
        super(parent, equip);
        this.configPanelRack();
    }

    private void configPanelRack() {
        TitledBorder b = ComponenteFactory.novoTitledEtchedBorder("Rack");
        this.panel_rack.setBorder(b);
        ((FlowLayout)this.panel_rack.getLayout()).setVgap(0);
        ((FlowLayout)this.panel_rack.getLayout()).setHgap(0);
        this.buttonRack.setMargin(new Insets(2, 5, 2, 5));
        this.buttonRack.setPreferredSize(new Dimension(50, 20));
        this.panel_rack.add(this.buttonRack);
        this.jPanelHeader.add((Component)this.panel_rack, "West");
        this.buttonRack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbaExamesNaoEnviadosRack.this.rack();
            }
        });
    }

    private void rack() {
        RequisicaoRack tela = new RequisicaoRack(this.parent, this.equipamento, this.exames, this.getColIndice("C\u00f3digo"), this.getColIndice("Paciente"), this.getColIndice("Exame"), this.getColIndice("Rack"), this.getColIndice("Tubo"), this.getColIndice("Interface"), this.getColIndice("C\u00f3d. Mat."), false, this);
        tela.setVisible(true);
    }

    @Override
    public void transmiteExames(int row, String exames) {
        if (row >= 0 && this.tabelaExames.getRowCount() > 0) {
            String req_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("C\u00f3digo"));
            String rec_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Tubo"));
            String mco_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("C\u00f3d. Mat."));
            String pac_sexo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("S"));
            String pac_idade = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Ide"));
            String pac_nome = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Paciente"));
            String pac_exames = Funcoes.textoVazio(exames) ? (String)this.tabelaExames.getValueAt(row, this.getColIndice("Exame")) : exames;
            String hora = TempoUtil.getCurrentTime();
            String data = TempoUtil.getCurrentDateBr();
            String rackpos = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Rack"));
            String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
            String int_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Interface"));
            req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial());
            String urgencia = "";
            try {
                String resposta = this.equipamento.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rackpos, urgencia, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames, "N");
                if (resposta != null) {
                    this.equipamento.novaMensagem(resposta, 0, resposta.startsWith("Erro") ? 5000 : 10000);
                }
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(this.parent, ex.getMessage(), ex.getStackTrace(), "AbaDefaultNaoEnviados (152)");
            }
        }
    }

    @Override
    protected ArrayList agrupaExamesMesmaRequisicao(ArrayList lista) throws SQLException {
        ArrayList<Object> nova = new ArrayList<Object>();
        int exameRotina = this.getColIndice("Exame da Rotina");
        int codigo = this.getColIndice("C\u00f3digo");
        int tubo = this.getColIndice("Tubo");
        int exames = this.getColIndice("Exame");
        int material = this.getColIndice("C\u00f3d. Mat.");
        int rack = this.getColIndice("Rack");
        if (this.equipamento.configuracao.getValidaRotinaExames()) {
            Statement st = Conexao.getStatement();
            Calendar c = Calendar.getInstance();
            int diaAtual = c.get(7);
            for (int i = 0; i < lista.size(); ++i) {
                Object[] temp = (Object[])lista.get(i);
                String filial = ((String)temp[codigo]).substring(0, ParametrosGerais.getDigitosTuboFilial());
                temp[exameRotina] = new Boolean(BDUtil.verificaDiaDeRotina(filial, (String)temp[exames], (String)temp[material], diaAtual));
            }
            Object[] temp = null;
            while (!lista.isEmpty()) {
                Object[] prox = (Object[])lista.remove(0);
                String reqa = temp != null ? (String)temp[codigo] : "";
                String reca = temp != null ? (String)temp[tubo] : "";
                String reqb = (String)prox[codigo];
                String recb = (String)prox[tubo];
                if (!((Boolean)prox[exameRotina]).booleanValue()) {
                    if (temp != null) {
                        nova.add(temp.clone());
                    }
                    nova.add(prox.clone());
                    temp = null;
                    continue;
                }
                if (reqa.equalsIgnoreCase(reqb) && reca.equalsIgnoreCase(recb)) {
                    String a = (String)temp[exames];
                    String b = (String)prox[exames];
                    temp[exames] = a + " " + b;
                    continue;
                }
                if (temp != null) {
                    nova.add(temp.clone());
                }
                temp = prox;
            }
            return nova;
        }
        if (lista.size() >= 2) {
            Object[] temp = (Object[])lista.remove(0);
            while (!lista.isEmpty()) {
                Object[] prox = (Object[])lista.remove(0);
                String reqa = (String)temp[codigo];
                String reca = (String)temp[tubo];
                String racka = (String)temp[rack];
                String reqb = (String)prox[codigo];
                String recb = (String)prox[tubo];
                String rackb = (String)prox[rack];
                if (reqa.equalsIgnoreCase(reqb) && reca.equalsIgnoreCase(recb)) {
                    String a = (String)temp[exames];
                    String b = (String)prox[exames];
                    temp[exames] = a + " " + b;
                    if (!Funcoes.textoVazio(racka)) {
                        temp[rack] = racka;
                    }
                    if (Funcoes.textoVazio(rackb)) continue;
                    temp[rack] = rackb;
                    continue;
                }
                nova.add(temp.clone());
                temp = prox;
            }
            nova.add(temp.clone());
            return nova;
        }
        return lista;
    }
}

