/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.stks;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.interfaces.stks.InterfaceConfiguracao;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.interfaceamento.util.Checksum;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    public String remain = "";
    public List<String> blocos = new LinkedList<String>();
    public String numeroBlocos = "";
    char LF = (char)10;
    char CR = (char)13;
    protected char SP = (char)32;
    protected char NUL = '\u0000';
    protected String LINE = String.valueOf(this.CR) + String.valueOf(this.LF);
    String retorno = "";
    public String PREAMBLE = this.LINE + this.LINE + this.LINE + this.LINE + this.LINE + this.LINE + "--------------" + this.LINE;
    public String POSTAMBLE = this.LINE + this.LINE + "--------------" + this.LINE;
    protected String EXAME_PADRAO = "HEMOG";
    protected InterfaceConfiguracao configuracao = new InterfaceConfiguracao();

    public InterfaceListener() {
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        this.configuracao = new InterfaceConfiguracao();
        this.configuracao.setXmlVariaveis(c.getVariaveisConfiguracao());
    }

    @Override
    public void dataChanged() {
        try {
            int posStx;
            this.retorno = this.retorno + this.getPortaCOM().getInputString();
            String message = this.getPortaCOM().removeInputString(String.valueOf('\u0003'));
            if (!message.equals("") && this.configuracao.getTratarBlocosExtensos() && (posStx = message.indexOf(this.getMsgStart())) > -1) {
                String numberBlocks = message.substring(0, posStx);
                if (Funcoes.isNumeric(numberBlocks)) {
                    this.numeroBlocos = numberBlocks;
                }
                if (message.substring(posStx, posStx + 2).equalsIgnoreCase("01")) {
                    this.blocos.clear();
                }
                this.blocos.add(message);
                if (message.substring(posStx + 1, posStx + 3).equalsIgnoreCase(this.numeroBlocos)) {
                    message = "";
                    for (String b : this.blocos) {
                        message = message + b;
                    }
                } else {
                    message = "";
                }
            }
            if (!message.equals("")) {
                String retorno = this.parse(message);
                this.blocos.clear();
                this.numeroBlocos = "";
                if (retorno != null && retorno.startsWith("Erro")) {
                    this.fireExcecaoEncontrada(retorno);
                    this.fireMensagemEnviada(retorno, 1, 5000);
                } else if (retorno != null) {
                    this.fireMensagemEnviada(retorno, 0, 10000);
                }
            } else {
                this.aguardarProximoFrame();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            try {
                this.fireMensagemEnviada("Erro ao receber dados do equipamento.", 1, 5000);
                Conexao.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void dataChanged(String message) {
        try {
            int posStx = message.indexOf(this.getMsgStart());
            if (this.configuracao.getTratarBlocosExtensos() && posStx > -1) {
                String numberBlocks = message.substring(0, posStx);
                if (Funcoes.isNumeric(numberBlocks)) {
                    this.numeroBlocos = numberBlocks;
                }
                if (message.substring(posStx, posStx + 2).equalsIgnoreCase("01")) {
                    this.blocos.clear();
                }
                this.blocos.add(message);
                if (message.substring(posStx + 1, posStx + 3).equalsIgnoreCase(this.numeroBlocos)) {
                    message = "";
                    for (String b : this.blocos) {
                        message = message + b;
                    }
                } else {
                    message = "";
                }
            }
            if (!message.equals("")) {
                String retorno = this.parse(message);
                this.blocos.clear();
                this.numeroBlocos = "";
                if (retorno != null && retorno.startsWith("Erro")) {
                    this.fireMensagemEnviada(retorno, 1, 5000);
                } else if (retorno != null) {
                    this.fireMensagemEnviada(retorno, 0, 10000);
                }
            } else {
                this.aguardarProximoFrame();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            try {
                this.fireMensagemEnviada("Erro ao receber dados do equipamento.", 1, 5000);
                Conexao.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void handShakeCharReceived(char c) {
        this.retorno = this.retorno + String.valueOf(c);
    }

    @Override
    public String getMsgEnd() {
        return String.valueOf('\u0003');
    }

    @Override
    public String getMsgStart() {
        return String.valueOf('\u0002');
    }

    @Override
    public synchronized String parse(String message) {
        try {
            this.remain = this.remain + message;
            boolean blocoExtenso = false;
            if (this.configuracao.getTratarBlocosExtensos() && this.remain.contains(String.valueOf("\u0003\u0002"))) {
                blocoExtenso = this.tratarBlocoExtenso(this.remain);
            }
            if (!message.contains(this.PREAMBLE) && message.contains(this.POSTAMBLE) || blocoExtenso) {
                String[] messages = this.remain.split(String.valueOf('\u0003'));
                this.remain = "";
                message = "";
                for (String s : messages) {
                    if (!this.checkCRC(s.substring(5, s.length() - 4), s.substring(s.length() - 4, s.length()))) {
                        return "CRC Inv\u00e1lido para bloco recebido";
                    }
                    if (s.length() <= 3) continue;
                    message = message + s.substring(3, s.length() - 4);
                }
            }
            if (!message.equals("")) {
                try {
                    this.recordFound(message);
                    Conexao.arquivaSQL();
                    this.fireAtualizarTabela();
                    this.setIdle();
                    return "Resultados recebidos com sucesso";
                }
                catch (SQLException ex) {
                    ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
                    Funcoes.showErro(null, "Erro ao inserir resultados recebidos ao banco de dados.\n" + ex.getMessage() + "\nA opera\u00e7\u00e3o foi desfeita.");
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (SQLException e) {
                        ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ErrorLogger.mostraMensagem(null, e.toString() + "\n" + e.getMessage(), e.getStackTrace());
                }
            });
            this.fireExcecaoEncontrada("Os dados recebidos est\u00e3o corrompidos");
            return "Os dados recebidos est\u00e3o corrompidos";
        }
        this.setIdle();
        return "Erro ao processar resultados";
    }

    public boolean tratarBlocoExtenso(String message) {
        StringBuilder msg = new StringBuilder(message);
        int p = msg.indexOf(String.valueOf("\u0003\u0002"));
        while (p > -1) {
            msg.replace(p - 4, p + 4, "");
            p = msg.indexOf(String.valueOf("\u0003\u0002"), p + 4);
        }
        return msg.toString().contains(this.PREAMBLE) && msg.toString().contains(this.POSTAMBLE);
    }

    public boolean checkCRC(String message, String sCrc) {
        return true;
    }

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
        this.retorno = "erro";
    }

    private void aguardarProximoFrame() throws Exception {
        this.setRX(500);
        this.fireMensagemEnviada("Recebendo dados...", 0, 10000);
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        try {
            Statement st = Conexao.getStatement();
            if (Funcoes.textoVazio(rackposition)) {
                Funcoes.showErro(null, "Requisi\u00e7\u00e3o sem rack definida!");
                return "Erro: Requisi\u00e7\u00e3o sem rack definida!";
            }
            this.getPortaCOM().clearInputString();
            this.setTX(1000);
            StringBuilder worklist = new StringBuilder();
            worklist.append(String.valueOf('\u0001'));
            worklist.append("05");
            worklist.append(String.valueOf(this.CR));
            worklist.append(String.valueOf(this.LF));
            worklist.append("WLAD");
            worklist.append(String.valueOf(this.CR));
            worklist.append(String.valueOf(this.LF));
            worklist.append("SMP");
            worklist.append(String.valueOf(this.CR));
            worklist.append(String.valueOf(this.LF));
            worklist.append("CP");
            worklist.append(StringUtil.preencheString(rackposition, 6, '0', 1));
            worklist.append(String.valueOf(this.CR));
            worklist.append(String.valueOf(this.LF));
            worklist.append("I1");
            worklist.append(Funcoes.preencheZero(fil_codigo, ParametrosGerais.getDigitosTuboFilial()));
            worklist.append(Funcoes.preencheZero(req_codigo, ParametrosGerais.getDigitosTuboRequisicao()));
            worklist.append(Funcoes.preencheZero(rec_codigo, ParametrosGerais.getDigitosTuboTubo()));
            worklist.append(String.valueOf(this.CR));
            worklist.append(String.valueOf(this.LF));
            worklist.append("I2");
            worklist.append(Funcoes.preencheZero(fil_codigo, ParametrosGerais.getDigitosTuboFilial()));
            worklist.append(Funcoes.preencheZero(req_codigo, ParametrosGerais.getDigitosTuboRequisicao()));
            worklist.append(Funcoes.preencheZero(rec_codigo, ParametrosGerais.getDigitosTuboTubo()));
            worklist.append(String.valueOf(this.CR));
            worklist.append(String.valueOf(this.LF));
            worklist.append(StringUtil.preencheString("", 256 - worklist.toString().length(), this.SP, 0));
            worklist.append(StringUtil.preencheString(Checksum.getCRC16CCITT(worklist.toString()), 4, '0', 1));
            worklist.append(String.valueOf('\u0003'));
            worklist.insert(0, "01");
            worklist.insert(0, this.getMsgStart());
            this.retorno = "";
            this.getPortaCOM().write(String.valueOf('\u0005'));
            Thread.sleep(100L);
            if (this.retorno.indexOf(String.valueOf('\u0005')) > 0) {
                return "Aparelho ocupado ";
            }
            this.getPortaCOM().write("01");
            Thread.sleep(100L);
            if (this.retorno.indexOf(String.valueOf('\u0015')) > 0) {
                return "Aparelho n\u00e3o responde ";
            }
            this.getPortaCOM().write(worklist.toString());
            Thread.sleep(100L);
            if (this.retorno.indexOf(String.valueOf('\u0015')) > 0) {
                return "Erro ao enviar requisi\u00e7\u00e3o para o paciente " + pac_nome;
            }
            Thread.sleep(4000L);
            this.getPortaCOM().write(String.valueOf('\u0005'));
            Thread.sleep(400L);
            if (this.retorno.indexOf(String.valueOf('\u0010') + "A") < 0) {
                return "Erro ao enviar requisi\u00e7\u00e3o para o paciente " + pac_nome;
            }
            this.atualizarSituacaoRackTubo(st, fil_codigo, req_codigo, rec_codigo, mco_codigo, int_codigo, acao.equals("N") ? 1 : 3, rackposition);
            Conexao.arquivaSQL();
            return "Requisi\u00e7\u00e3o enviada para " + pac_nome;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
            return null;
        }
    }

    public void recordFound(String record) throws Exception {
        StringTokenizer stks = new StringTokenizer(record, this.LINE);
        HashMap<String, Object> lines = new HashMap<String, Object>();
        while (stks.hasMoreTokens()) {
            String token = stks.nextToken();
            int indexSP = token.indexOf(String.valueOf(this.SP));
            if (indexSP <= 0) continue;
            String cmd = token.substring(0, indexSP).trim();
            String value = "";
            if (token.length() > 0) {
                value = token.substring(token.indexOf(String.valueOf(this.SP)), token.length()).trim();
            }
            lines.put(cmd, value);
        }
        this.trataResultado(lines);
    }

    protected void trataResultado(HashMap<String, Object> lines) throws Exception {
        Statement st = Conexao.getStatement();
        String req_codigo = ((String)lines.get("ID1")).trim();
        if (req_codigo.indexOf("-") >= 0) {
            req_codigo = ((String)lines.get("ID2")).trim();
        }
        String codigoEquipamento = req_codigo;
        String fil_codigo = codigoEquipamento.substring(0, ParametrosGerais.getDigitosTuboFilial());
        req_codigo = codigoEquipamento.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboFilial());
        String rec_codigo = codigoEquipamento.substring(codigoEquipamento.length() - ParametrosGerais.getDigitosTuboTubo());
        HashMap<String, Object> dados = new HashMap<String, Object>();
        dados.put("leucocitos", this.parseValor(lines.get("WBC")));
        dados.put("hemacias", this.parseValor(lines.get("RBC")));
        dados.put("hgb", this.parseValor(lines.get("HGB")));
        dados.put("hct", this.parseValor(lines.get("HCT")));
        dados.put("vcm", this.parseValor(lines.get("MCV")));
        dados.put("hcm", this.parseValor(lines.get("MCH")));
        dados.put("chcm", this.parseValor(lines.get("MCHC")));
        dados.put("rdw", this.parseValor(lines.get("RDW")));
        dados.put("plaquetas", this.parseValor(lines.get("PLT")));
        dados.put("pct", this.parseValor(lines.get("PCT")));
        dados.put("vpm", this.parseValor(lines.get("MPV")));
        dados.put("pdw", this.parseValor(lines.get("PDW")));
        dados.put("linfocitos_tipicos_contagem", this.parseValor(lines.get("LY#")));
        dados.put("monocitos_contagem", this.parseValor(lines.get("MO#")));
        dados.put("segmentados_contagem", this.parseValor(lines.get("NE#")));
        dados.put("eosinofilos_contagem", this.parseValor(lines.get("EO#")));
        dados.put("basofilos_contagem", this.parseValor(lines.get("BA#")));
        dados.put("linfocitos_tipicos_percentual", this.parseValor(lines.get("LY%")));
        dados.put("monocitos_percentual", this.parseValor(lines.get("MO%")));
        dados.put("segmentados_percentual", this.parseValor(lines.get("NE%")));
        dados.put("eosinofilos_percentual", this.parseValor(lines.get("EO%")));
        dados.put("basofilos_percentual", this.parseValor(lines.get("BA%")));
        dados.put("linfocitos_atipicos_percentual", this.parseValor(lines.get("LY%")));
        String int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, this.EXAME_PADRAO);
        ExameMaterial exame = this.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, this.EXAME_PADRAO);
        if (exame == null) {
            this.fireExcecaoEncontrada(fil_codigo + " " + req_codigo + " " + rec_codigo + " " + "N\u00e3o foi encontrada");
            return;
        }
        List<BDExame> exames = BDUtil.getReqExamesMultGuia(fil_codigo, int_codigo, req_codigo, rec_codigo);
        for (BDExame ex : exames) {
            this.atualizarDadosExame(st, fil_codigo, ex.getRequisicao(), ex.getRecipiente(), ex.getExame(), ex.getMaterial(), int_codigo, dados);
        }
    }

    protected Object parseValor(Object valor) {
        if (valor == null) {
            return new String("");
        }
        String value = valor.toString();
        int idx = value.indexOf(this.NUL);
        if (idx > 0) {
            value = value.substring(0, idx);
        }
        if (value.indexOf(".") > 0) {
            value = value.replaceFirst("\\.", ",");
        }
        if (!Funcoes.textoVazio(this.configuracao.getCaracteresParaRemocaoDoCampoDeResultado())) {
            String tmp;
            String regex = this.configuracao.getCaracteresParaRemocaoDoCampoDeResultado();
            if (!regex.startsWith("[") || !regex.endsWith("]")) {
                regex = String.format("[%s]", this.configuracao.getCaracteresParaRemocaoDoCampoDeResultado());
            }
            if (!Funcoes.textoVazio(tmp = value.replaceAll(regex, ""))) {
                value = tmp.trim();
            }
        }
        return value;
    }
}

