/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.spd20a;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.padroes.arquivo.InterfaceArquivoListener;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.io.File;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashMap;
import javax.swing.JFileChooser;

public class InterfaceListener
extends InterfaceArquivoListener {
    private String DIRETORIO_IMPORTACAO = "";
    private static final String DELIMITADOR = "\t";
    private static final String SECTION_RESULT = "[Compound Results(Detector A)]";
    private static final String SECTION_SAMPLE = "[Sample Information]";
    private static final String SAMPLE_ID = "Sample ID";
    private static final String ALTERNATIVO = "Name";
    private static final String RESULTADO = "Conc.";

    public InterfaceListener() {
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        this.DIRETORIO_IMPORTACAO = c.getDiretorioImportacao();
    }

    @Override
    public void buscarResultados(Date inicio, Date termino) {
        try {
            JFileChooser chooser = ComponenteFactory.novoJFileChooser("Arquivo para importa\u00e7\u00e3o", this.DIRETORIO_IMPORTACAO);
            chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
            chooser.setMultiSelectionEnabled(true);
            chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo de Resultado do Shimadzu SPD-20A (*.txt)", "txt"));
            if (chooser.showOpenDialog(null) == 0) {
                for (File file : chooser.getSelectedFiles()) {
                    String path = file.getPath();
                    String buf = StringUtil.lerArquivoTexto(path);
                    this.parse(buf);
                }
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
        }
    }

    @Override
    public String parse(String message) {
        String[] lines = message.split(LINE);
        Object alternativo = null;
        String sampleId = null;
        Object resultado = null;
        int posAlt = -1;
        int posRes = -1;
        boolean secaoAmostra = false;
        boolean secaoResultado = false;
        int lin = 0;
        for (String line : lines) {
            if (line.startsWith("[") && line.endsWith("]")) {
                secaoAmostra = false;
                secaoResultado = false;
                if (line.equalsIgnoreCase(SECTION_SAMPLE)) {
                    secaoAmostra = true;
                }
                if (line.equalsIgnoreCase(SECTION_RESULT)) {
                    secaoResultado = true;
                }
            }
            if (secaoAmostra) {
                String[] sampleInformation = line.split(DELIMITADOR);
                if (sampleInformation.length == 2 && sampleInformation[0].equalsIgnoreCase(SAMPLE_ID)) {
                    sampleId = sampleInformation[1];
                }
            } else if (secaoResultado) {
                Object[] sampleResults = line.split(DELIMITADOR);
                if (posAlt == -1 && posRes == -1) {
                    posAlt = ArraysUtil.indice(sampleResults, ALTERNATIVO);
                    posRes = ArraysUtil.indice(sampleResults, RESULTADO);
                    continue;
                }
                if (posAlt > -1 && posRes > -1 && sampleResults.length > posRes && Funcoes.isNumeric((String)sampleResults[posRes])) {
                    alternativo = sampleResults[posAlt];
                    resultado = sampleResults[posRes];
                    try {
                        if (Funcoes.isNumeric(sampleId) && sampleId.length() == ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                            this.parseResult(sampleId, (String)alternativo, (String)resultado);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        ErrorLogger.mostraMensagem(null, e.toString(), e.getStackTrace(), "AbstractASTMInterfaceamento: parse");
                        this.interromperTimer();
                        this.setIdle();
                        try {
                            Conexao.anulaSQL();
                            return "Erro ao analisar dados recebidos do equipamento.";
                        }
                        catch (SQLException ex) {
                            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "Exce\u00e7\u00e3o SQL em parse");
                            return "Erro ao analisar dados recebidos do equipamento. Podem haver dados inconsistentes no BD.";
                        }
                    }
                }
            }
            ++lin;
        }
        return null;
    }

    private String parseResult(String sampleId, String alternativo, String resultado) throws Exception {
        String fil_codigo = sampleId.substring(0, ParametrosGerais.getDigitosTuboFilial());
        String rec_codigo = sampleId.substring(sampleId.length() - ParametrosGerais.getDigitosTuboTubo());
        String req_codigo = sampleId.substring(ParametrosGerais.getDigitosTuboFilial(), sampleId.length() - ParametrosGerais.getDigitosTuboTubo());
        String int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, alternativo);
        ExameMaterial exame = this.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, alternativo);
        resultado = resultado.replaceAll("\\.", ",");
        if (exame != null) {
            Statement st = Conexao.getStatement();
            int sit = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), rec_codigo);
            String campo = sit < 3 ? "resultado_quantitativo" : "repeticao_quantitativo";
            HashMap<String, Object> dados = new HashMap<String, Object>();
            dados.put(campo, resultado);
            this.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo, dados);
        }
        return null;
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        try {
            String[] exms;
            Statement st = Conexao.getStatement();
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(exames.split(" ", 0), mco_codigo);
            for (String s : exms = exames.split(" ", 0)) {
                this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, s, mco_codigo, int_codigo, null, 1);
            }
            Conexao.arquivaSQL();
            this.fireMensagemEnviada("Pedido(s) enviado(s) com sucesso para " + pac_nome, 0, 10000);
            this.equipamento.atualizarTabela(0);
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
            return "";
        }
    }
}

