/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.smart300;

import jalis.laboratorio.interfaceamento.padroes.hl7.message.Message;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.MessageSegment;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.MessageType;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentDsc;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentDsp;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentErr;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentMsa;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentMsh;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentQak;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentQrd;
import java.util.ArrayList;
import java.util.List;

public class MessageDsrQ03
implements Message {
    private MessageSegmentMsh msh = new MessageSegmentMsh();
    private MessageSegmentMsa msa = new MessageSegmentMsa();
    private MessageSegmentErr err = new MessageSegmentErr();
    private MessageSegmentQak qak = new MessageSegmentQak();
    private MessageSegmentQrd qrd = new MessageSegmentQrd();
    private List<MessageSegmentDsp> dspList = new ArrayList<MessageSegmentDsp>();
    private MessageSegmentDsc dsc = new MessageSegmentDsc();
    private String id;
    private int dspId = 1;

    public MessageDsrQ03() {
        this.msh.setMessageType(this.getType());
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.msh.setMessageControlId(id);
        this.msa.setMessageControlId(id);
        this.id = id;
    }

    @Override
    public MessageSegmentMsh getMsh() {
        return this.msh;
    }

    public MessageSegmentMsa getMsa() {
        return this.msa;
    }

    public MessageSegmentErr getErr() {
        return this.err;
    }

    public MessageSegmentQak getQak() {
        return this.qak;
    }

    public MessageSegmentQrd getQrd() {
        return this.qrd;
    }

    public MessageSegmentDsc getDsc() {
        return this.dsc;
    }

    public void addDsp(MessageSegmentDsp dsp) {
        dsp.setId(this.dspId);
        this.dspList.add(dsp);
        ++this.dspId;
    }

    public List<MessageSegmentDsp> getDspList() {
        return this.dspList;
    }

    @Override
    public MessageType getType() {
        return MessageType.DSR_Q03;
    }

    @Override
    public List<MessageSegment> getMessageSegments() {
        ArrayList<MessageSegment> messageSegments = new ArrayList<MessageSegment>();
        messageSegments.add(this.msh);
        messageSegments.add(this.msa);
        messageSegments.add(this.err);
        messageSegments.add(this.qak);
        messageSegments.add(this.qrd);
        messageSegments.addAll(this.dspList);
        messageSegments.add(this.dsc);
        return messageSegments;
    }

    @Override
    public void setMessageSegments(List<MessageSegment> messageSegments) {
        block9: for (MessageSegment messageSegment : messageSegments) {
            switch (messageSegment.getType()) {
                case MSH: {
                    this.msh = (MessageSegmentMsh)messageSegment;
                    continue block9;
                }
                case MSA: {
                    this.msa = (MessageSegmentMsa)messageSegment;
                    continue block9;
                }
                case ERR: {
                    this.err = (MessageSegmentErr)messageSegment;
                    continue block9;
                }
                case QAK: {
                    this.qak = (MessageSegmentQak)messageSegment;
                    continue block9;
                }
                case QRD: {
                    this.qrd = (MessageSegmentQrd)messageSegment;
                    continue block9;
                }
                case DSP: {
                    this.addDsp((MessageSegmentDsp)messageSegment);
                    continue block9;
                }
                case DSC: {
                    this.dsc = (MessageSegmentDsc)messageSegment;
                    continue block9;
                }
            }
            return;
        }
    }
}

