/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.smart300;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.comunicacao.AbstractPort;
import jalis.laboratorio.interfaceamento.comunicacao.PortaSocketServer;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.InfoExameRequisicao;
import jalis.laboratorio.interfaceamento.interfaces.smart300.MessageDsrQ03;
import jalis.laboratorio.interfaceamento.padroes.hl7.InterfaceHl7Listener;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.EncodingCharacters;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.ErrorCondition;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.Message;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.MessageSegment;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.MessageType;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageAckQ03;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageAckR01;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageOruR01;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageQckQ02;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageQryQ02;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentDsp;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentMsa;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentMsh;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentObx;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentQak;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.interfaceamento.util.TestesInterface;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.TempoUtil;
import jalis.util.logger.ErrorLogger;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.swing.JOptionPane;

public class InterfaceListener
extends InterfaceHl7Listener {
    private static final String MENSAGEM_ACEITA = "Message accepted";

    public InterfaceListener() {
        super("");
    }

    @Override
    public void setPortaCOM(AbstractPort portaCOM) {
        if (portaCOM instanceof PortaSocketServer) {
            ((PortaSocketServer)portaCOM).setEscreverEmBytes(true);
        }
        super.setPortaCOM(portaCOM);
    }

    @Override
    protected void messageAckQ03Recebida(MessageAckQ03 ackQ03) {
        if (this.ultimaMensagemEnviada != null && this.ultimaMensagemEnviada.getType() == MessageType.DSR_Q03) {
            MessageDsrQ03 dsrQ03 = (MessageDsrQ03)this.ultimaMensagemEnviada;
            String tuboId = dsrQ03.getDspList().get(20).getDataLine();
            this.alteraSituacaoParaPendentes((InfoExameRequisicao)this.examesEnviadosPorSid.get(tuboId));
            this.examesEnviadosPorSid.remove(tuboId);
        }
    }

    @Override
    protected void messageOruR01Recebida(MessageOruR01 oruR01) {
        MessageAckR01 ackR01 = new MessageAckR01();
        ackR01.getMsh().setApplicationAckType(oruR01.getMsh().getApplicationAckType());
        ackR01.getMsa().setAckCode(MessageSegmentMsa.AckCode.ACCEPTED);
        ackR01.getMsa().setTextMessage(MENSAGEM_ACEITA);
        ackR01.getMsa().setErrorCondition(ErrorCondition.MESSAGE_ACCEPTED);
        try {
            int digitosCodigoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
            String tuboId = oruR01.getObr().getPlacerOrderNumber();
            if (tuboId != null && tuboId.length() == digitosCodigoTubo && Funcoes.isNumeric(tuboId)) {
                Statement st = Conexao.getStatement();
                String filCodigo = tuboId.substring(0, ParametrosGerais.getDigitosTuboFilial());
                String reqCodigo = tuboId.substring(ParametrosGerais.getDigitosTuboFilial());
                String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
                for (MessageSegmentObx obx : oruR01.getObxList()) {
                    String emiAlternativo = String.valueOf(obx.getObservationSubId());
                    String intCodigo = this.getIntCodigo(filCodigo, reqCodigo, recCodigo, emiAlternativo);
                    ExameMaterial exame = this.getReqExameLIS(filCodigo, intCodigo, reqCodigo, recCodigo, emiAlternativo);
                    if (exame != null) {
                        HashMap<String, Object> dados = new HashMap<String, Object>();
                        ArrayList<String> flags = new ArrayList<String>();
                        if (obx.getAbnormalFlag() != null) {
                            flags.add(obx.getAbnormalFlag().toString());
                        }
                        int sit = this.getExameSituacao(st, filCodigo, intCodigo, reqCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), recCodigo);
                        String campo = "resultado_quantitativo";
                        String resultado = "";
                        if (obx.getValueType().equals((Object)MessageSegmentObx.ValueType.NUMERIC)) {
                            campo = sit < 3 ? "resultado_quantitativo" : "repeticao_quantitativo";
                            resultado = obx.getObservationValue();
                            resultado = this.arrendondaValor(resultado, filCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), intCodigo, reqCodigo);
                        } else if (obx.getValueType().equals((Object)MessageSegmentObx.ValueType.STRING)) {
                            campo = sit < 3 ? "resultado_qualitativo" : "repeticao_qualitativo";
                            resultado = obx.getObservationValue();
                        }
                        dados.put(campo, resultado.replaceAll("\\.", ","));
                        this.atualizarDadosExame(st, filCodigo, reqCodigo, recCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), intCodigo, dados, flags);
                        continue;
                    }
                    this.fireExcecaoEncontrada("Exame n\u00e3o encontrado. Filial: " + filCodigo + ", Req: " + reqCodigo + ", Rec: " + recCodigo + ", Alternativo: " + emiAlternativo);
                }
                Conexao.arquivaSQL();
                this.fireAtualizarTabela();
            }
        }
        catch (Exception e) {
            try {
                Conexao.anulaSQL();
            }
            catch (Exception e2) {
                ErrorLogger.mostraMensagem(null, e2.getMessage(), e2.getStackTrace());
            }
            ackR01.getMsa().setAckCode(MessageSegmentMsa.AckCode.REJECTED);
            ackR01.getMsa().setTextMessage("Erro ao receber a mensagem");
            ackR01.getMsa().setErrorCondition(ErrorCondition.APPLICATION_INTERNAL_ERROR);
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
        this.enviaMensagem(oruR01.getMsh().getMessageControlId(), ackR01);
    }

    @Override
    public String enviarRequisicao(String pacNome, String pacSexo, String pacIdade, String data, String hora, String rackposition, String prioridade, String filCodigo, String intCodigo, String reqCodigo, String mcoCodigo, String recCodigo, String pacExames, String acao) {
        return this.enviarRequisicao(pacNome, pacSexo, pacIdade, data, hora, rackposition, prioridade, filCodigo, intCodigo, reqCodigo, mcoCodigo, recCodigo, pacExames, acao, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String enviarRequisicao(String pacNome, String pacSexo, String pacIdade, String data, String hora, String rackposition, String prioridade, String filCodigo, String intCodigo, String reqCodigo, String mcoCodigo, String recCodigo, String exames, String acao, HashMap<String, String> mapaParametros) {
        if (acao.equals("A")) {
            Statement st = Conexao.getStatement();
            boolean curva = false;
            try {
                for (String exame : exames.split(" ")) {
                    Integer recKodigo;
                    int situacao = this.getExameSituacao(st, filCodigo, intCodigo, reqCodigo, exame, mcoCodigo, recCodigo);
                    if (situacao == -1 && (recKodigo = BDUtil.getTuboFilho(filCodigo, reqCodigo, recCodigo, intCodigo, exame, mcoCodigo)) != null && BDUtil.existeDesmembramento(filCodigo, intCodigo, reqCodigo, recKodigo.toString(), exame, mcoCodigo)) {
                        curva = true;
                        ExameMaterial[] exaPai = BDUtil.getDesmExamesPai(filCodigo, intCodigo, reqCodigo, recKodigo.toString(), exame, mcoCodigo);
                        if (exaPai != null && exaPai.length > 0) {
                            situacao = BDUtil.getExmSituacao(filCodigo, intCodigo, reqCodigo, exaPai[0].getNomeExame(), mcoCodigo, recCodigo);
                            recCodigo = recKodigo.toString();
                        }
                    }
                    this.atualizarSituacaoExame(st, filCodigo, reqCodigo, recCodigo, exame, mcoCodigo, intCodigo, null, situacao < 2 ? 1 : 3, curva);
                }
                Conexao.arquivaSQL();
                this.fireAtualizarTabela();
            }
            catch (Exception e) {
                try {
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (SQLException e1) {
                        ErrorLogger.mostraMensagem(null, e1.getMessage(), e1.getStackTrace());
                    }
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
        }
        return null;
    }

    @Override
    protected void enviaMensagem(String id, Message mensagem) {
        try {
            mensagem.getMsh().setEncodingCharacters(new EncodingCharacters('^', '~', '\\', '&'));
            mensagem.getMsh().setSendingApplication("smart");
            mensagem.getMsh().setSendingFacility("300");
            mensagem.getMsh().setDateTime(new Date());
            mensagem.getMsh().setProcessingId("P");
            mensagem.getMsh().setVersionId("2.3.1");
            mensagem.getMsh().setApplicationAckType(MessageSegmentMsh.ApplicationAckType.SAMPLE_RESULT);
            mensagem.getMsh().setCharacterSet("ASCII");
            mensagem.setId(id);
            this.ultimaMensagemEnviada = mensagem;
            ++this.tentativasEnvio;
            String msg = this.messageParser.messageToText(mensagem, this.fieldSeparator);
            this.getPortaCOM().write(msg);
        }
        catch (IOException e) {
            ErrorLogger.mostraMensagem(null, "Falha na comunica\u00e7\u00e3o com o equipamento.", e.getStackTrace());
        }
    }

    public final void messageSegmentToText(MessageSegment messageSegment, char fieldSeparator, StringBuilder text) {
        String[] fields = messageSegment.getFields();
        text.append(messageSegment.getType().toString());
        for (int i = 0; i < fields.length; ++i) {
            text.append(fieldSeparator);
            if (fields[i] == null) continue;
            text.append(fields[i]);
        }
        text.append(fieldSeparator);
    }

    public final void messageToText(Message message, char fieldSeparator, StringBuilder builder) {
        builder.append('\n');
        for (MessageSegment messageSegment : message.getMessageSegments()) {
            this.messageSegmentToText(messageSegment, fieldSeparator, builder);
            builder.append('\r');
        }
    }

    public final String messageToText(Message message, char fieldSeparator) {
        StringBuilder builder = new StringBuilder();
        this.messageToText(message, fieldSeparator, builder);
        return builder.toString();
    }

    @Override
    public void messageQryQ02Recebida(MessageQryQ02 qryQ02) {
        block22: {
            String messageId = qryQ02.getMsh().getMessageControlId();
            MessageQckQ02 qckQ02 = new MessageQckQ02();
            qckQ02.getMsa().setAckCode(MessageSegmentMsa.AckCode.ACCEPTED);
            qckQ02.getMsa().setTextMessage(MENSAGEM_ACEITA);
            qckQ02.getMsa().setErrorCondition(ErrorCondition.MESSAGE_ACCEPTED);
            qckQ02.getErr().setErrorCode(0);
            qckQ02.getQak().setQueryTag("SR");
            try {
                if (Funcoes.textoVazio(qryQ02.getQrd().getWhoSubjectFilter())) {
                    this.fireExcecaoEncontrada("Mensagem recebida pelo aparelho n\u00e3o possui ID do tubo.");
                }
                String tuboId = qryQ02.getQrd().getWhoSubjectFilter().trim();
                int digitosCodigoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
                if (tuboId != null && !tuboId.trim().isEmpty() && !tuboId.equals("null") && Funcoes.isNumeric(tuboId) && tuboId.length() == digitosCodigoTubo) {
                    String filCodigo = tuboId.substring(0, ParametrosGerais.getDigitosTuboFilial());
                    String reqCodigo = tuboId.substring(ParametrosGerais.getDigitosTuboFilial());
                    String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                    reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
                    Object[] req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 0);
                    PanelAbaAbstrata aba = this.equipamento.getTab(0);
                    String exames = "";
                    StringBuilder examesFilho = new StringBuilder();
                    if (req != null) {
                        exames = (String)req[aba.getColIndice("Exame")];
                    }
                    if (req == null && Funcoes.textoVazio(exames = this.getExames(filCodigo, reqCodigo, recCodigo, req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 1), aba = this.equipamento.getTab(1), exames, 1)) && req != null && !Funcoes.preencheZero((String)req[aba.getColIndice("Tubo")], ParametrosGerais.getDigitosTuboFilial()).equals(recCodigo)) {
                        exames = this.getExames(filCodigo, reqCodigo, (String)req[aba.getColIndice("Tubo")], req, aba, exames, 1);
                    }
                    if (req == null && Funcoes.textoVazio(exames = this.getExames(filCodigo, reqCodigo, recCodigo, req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 2), aba = this.equipamento.getTab(2), exames, 2)) && req != null && !Funcoes.preencheZero((String)req[aba.getColIndice("Tubo")], ParametrosGerais.getDigitosTuboFilial()).equals(recCodigo)) {
                        exames = this.getExames(filCodigo, reqCodigo, (String)req[aba.getColIndice("Tubo")], req, aba, exames, 2);
                    }
                    if (req == null) {
                        qckQ02.getQak().setQueryResponseStatus(MessageSegmentQak.QueryResponseStatus.NO_DATA_FOUND);
                        this.enviaMensagem(messageId, qckQ02);
                        return;
                    }
                    String mcoCodigo = (String)req[aba.getColIndice("C\u00f3d. Mat.")];
                    String intCodigo = (String)req[aba.getColIndice("Interface")];
                    String pacNome = (String)req[aba.getColIndice("Paciente")];
                    String pacIdade = (String)req[aba.getColIndice("Ide")];
                    String pacSexo = (String)req[aba.getColIndice("S")];
                    String recTuboPai = (String)req[aba.getColIndice("Tubo")];
                    String data = TempoUtil.getCurrentDateBr();
                    String hora = TempoUtil.getCurrentTime();
                    ArrayList<ExameMaterial> examesDaRequisicao = new ArrayList<ExameMaterial>();
                    for (String string : exames.trim().split(" ", 0)) {
                        examesDaRequisicao.add(new ExameMaterial(string, new Integer(mcoCodigo)));
                    }
                    Date dataColeta = null;
                    ArrayList<ExameMaterial> examesParaEnviar = new ArrayList<ExameMaterial>();
                    for (ExameMaterial exameMaterial : examesDaRequisicao) {
                        if (dataColeta == null) {
                            dataColeta = BDUtil.getExmColeta(filCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial());
                        }
                        int n = this.getExameSituacao(Conexao.getStatement(), filCodigo, intCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial(), recCodigo);
                        boolean curva = BDUtil.isExameCurva(filCodigo, intCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial());
                        if (BDUtil.isExameDesmembrado(filCodigo, intCodigo, exameMaterial.getString(), mcoCodigo)) {
                            int sitFilho;
                            List<ExameMaterial> examesFilhos = Arrays.asList(BDUtil.getExamesFilhos(filCodigo, intCodigo, exameMaterial.getString(), mcoCodigo));
                            if (!(n != 0 && n != 1 || curva)) {
                                examesParaEnviar.addAll(examesFilhos);
                                continue;
                            }
                            if (curva) {
                                for (ExameMaterial exameFilho : examesFilhos) {
                                    sitFilho = BDUtil.getDesmSituacao(filCodigo, intCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial(), recTuboPai, exameFilho.getNomeExame(), exameFilho.getCodigoMaterial());
                                    String tuboFilho = BDUtil.getExameDesmembradoTubo(filCodigo, reqCodigo, recTuboPai, intCodigo, exameFilho.getNomeExame(), exameFilho.getCodigoMaterial());
                                    if (sitFilho != 0 && sitFilho != 1 && sitFilho != 3 || !Funcoes.preencheZero(tuboFilho, ParametrosGerais.getDigitosTuboTubo()).equals(recCodigo)) continue;
                                    examesFilho.append(exameFilho.getNomeExame()).append(" ");
                                    examesParaEnviar.add(exameFilho);
                                }
                                continue;
                            }
                            for (ExameMaterial exameFilho : examesFilhos) {
                                sitFilho = BDUtil.getDesmSituacao(filCodigo, intCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial(), recCodigo, exameFilho.getNomeExame(), exameFilho.getCodigoMaterial());
                                if (sitFilho != 3) continue;
                                examesParaEnviar.add(exameFilho);
                            }
                            continue;
                        }
                        if (n != 0 && n != 1 && n != 3) continue;
                        examesParaEnviar.add(exameMaterial);
                    }
                    HashSet<String> tests = new HashSet<String>();
                    for (ExameMaterial exameMaterial : examesParaEnviar) {
                        String test = BDUtil.getExmCodigoAlternativo(filCodigo, exameMaterial.getNomeExame(), mcoCodigo, intCodigo);
                        if (test == null || test.trim().isEmpty()) continue;
                        tests.add(test);
                    }
                    if (tests.isEmpty()) {
                        qckQ02.getQak().setQueryResponseStatus(MessageSegmentQak.QueryResponseStatus.NO_DATA_FOUND);
                        this.enviaMensagem(messageId, qckQ02);
                        this.fireExcecaoEncontrada(tuboId + " - Nenhum exame enviado.");
                    } else {
                        InfoExameRequisicao infoExameRequisicao = new InfoExameRequisicao(filCodigo, reqCodigo, mcoCodigo, recCodigo, pacNome, pacIdade, pacSexo, data, hora, exames);
                        infoExameRequisicao.setInterface(intCodigo);
                        if (!Funcoes.preencheZero(recTuboPai, ParametrosGerais.getDigitosTuboTubo()).equals(recCodigo) && !Funcoes.textoVazio(examesFilho.toString().trim())) {
                            infoExameRequisicao.setTuboPai(recTuboPai);
                            infoExameRequisicao.setExamesFilho(examesFilho.toString().trim());
                            infoExameRequisicao.setCurva(true);
                        }
                        this.examesEnviadosPorSid.put(tuboId, infoExameRequisicao);
                        this.examesEnviadosPorMid.put(messageId, infoExameRequisicao);
                        pacNome = StringUtil.removerAcentos(pacNome);
                        if (!Funcoes.textoVazio(pacNome) && pacNome.length() > 30) {
                            pacNome = pacNome.substring(0, 30);
                        }
                        MessageDsrQ03 messageDsrQ03 = new MessageDsrQ03();
                        messageDsrQ03.getMsa().setAckCode(MessageSegmentMsa.AckCode.ACCEPTED);
                        messageDsrQ03.getMsa().setTextMessage(MENSAGEM_ACEITA);
                        messageDsrQ03.getMsa().setErrorCondition(ErrorCondition.MESSAGE_ACCEPTED);
                        messageDsrQ03.getMsa().setMessageControlId("");
                        messageDsrQ03.getMsh().setSequenceNumber("");
                        messageDsrQ03.getErr().setErrorCode(0);
                        messageDsrQ03.getQak().setQueryResponseStatus(MessageSegmentQak.QueryResponseStatus.DATA_FOUND);
                        messageDsrQ03.getQak().setQueryTag("SR");
                        messageDsrQ03.getQrd().setQueryDate(new Date());
                        messageDsrQ03.getQrd().setQueryFormatCode("R");
                        messageDsrQ03.getQrd().setQueryPriority("D");
                        messageDsrQ03.getQrd().setQuantityLimitedRequest("RD");
                        messageDsrQ03.getQrd().setWhoSubjectFilter("");
                        messageDsrQ03.getQrd().setWhatSubjectFilter("OTH");
                        messageDsrQ03.getQrd().setQueryResultsLevel("T");
                        messageDsrQ03.addDsp(new MessageSegmentDsp(""));
                        messageDsrQ03.addDsp(new MessageSegmentDsp(""));
                        messageDsrQ03.addDsp(new MessageSegmentDsp(pacNome));
                        messageDsrQ03.addDsp(new MessageSegmentDsp(pacSexo));
                        messageDsrQ03.addDsp(new MessageSegmentDsp(""));
                        messageDsrQ03.addDsp(new MessageSegmentDsp(""));
                        messageDsrQ03.addDsp(new MessageSegmentDsp(""));
                        messageDsrQ03.addDsp(new MessageSegmentDsp(""));
                        messageDsrQ03.addDsp(new MessageSegmentDsp(""));
                        messageDsrQ03.addDsp(new MessageSegmentDsp(""));
                        messageDsrQ03.addDsp(new MessageSegmentDsp(""));
                        messageDsrQ03.addDsp(new MessageSegmentDsp(""));
                        messageDsrQ03.addDsp(new MessageSegmentDsp(""));
                        messageDsrQ03.addDsp(new MessageSegmentDsp(""));
                        messageDsrQ03.addDsp(new MessageSegmentDsp(Funcoes.formataData("yyyy-MM-dd", new Date())));
                        messageDsrQ03.addDsp(new MessageSegmentDsp("N"));
                        messageDsrQ03.addDsp(new MessageSegmentDsp(String.valueOf(tests.size())));
                        messageDsrQ03.addDsp(new MessageSegmentDsp(""));
                        messageDsrQ03.addDsp(new MessageSegmentDsp(""));
                        messageDsrQ03.addDsp(new MessageSegmentDsp(""));
                        messageDsrQ03.addDsp(new MessageSegmentDsp(tuboId));
                        messageDsrQ03.addDsp(new MessageSegmentDsp(""));
                        messageDsrQ03.addDsp(new MessageSegmentDsp(""));
                        messageDsrQ03.addDsp(new MessageSegmentDsp(""));
                        messageDsrQ03.addDsp(new MessageSegmentDsp(""));
                        messageDsrQ03.addDsp(new MessageSegmentDsp(""));
                        messageDsrQ03.addDsp(new MessageSegmentDsp(""));
                        messageDsrQ03.addDsp(new MessageSegmentDsp(""));
                        StringBuilder tmp = null;
                        for (String test : tests) {
                            tmp = new StringBuilder();
                            tmp.append("^");
                            tmp.append(test).append("^^");
                            messageDsrQ03.addDsp(new MessageSegmentDsp(tmp.toString()));
                        }
                        this.enviaMensagem(messageId, messageDsrQ03);
                    }
                    break block22;
                }
                qckQ02.getQak().setQueryResponseStatus(MessageSegmentQak.QueryResponseStatus.NO_DATA_FOUND);
                this.enviaMensagem(messageId, qckQ02);
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
            }
        }
    }

    @Override
    public void teste() {
        int op = JOptionPane.showOptionDialog(null, "Op\u00e7\u00e3o", "Tipo teste", 0, 0, null, new String[]{"Query", "ACK", "Resultado", "EOT", "ENK"}, null);
        if (op == 0) {
            this.query();
        } else if (op == 1) {
            try {
                this.getPortaCOM().write(String.valueOf('\u0005'));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (op == 2) {
            this.resultado();
        } else if (op == 3) {
            try {
                this.getPortaCOM().write(String.valueOf('\u0005'));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (op == 4) {
            try {
                this.getPortaCOM().write(String.valueOf('\u0005'));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void query() {
        StringBuilder tmp = new StringBuilder();
        tmp.append("[SB]MSH|^~\\&| | |||20240419154954||QRY^Q02|2|P|2.3.1||||||ASCII|||[CR]");
        tmp.append("QRD|20240419154954|R|D|1|||RD|010000011904|OTH|||T|[CR]");
        tmp.append("[EB][CR]");
        this.parse(TestesInterface.arruma(tmp.toString()));
    }

    private void resultado() {
        StringBuilder tmp = new StringBuilder();
        tmp.append("[SB]MSH|^~\\&|urit|8030|||20150813101730||ORU^R01|201508130001|P|2.3.1||||0||ASCII|||[CR]");
        tmp.append("PID|1||010000001174||||0|||||0|||||||||||||||||||[CR]");
        tmp.append("OBR|1||201508130001|smart^300|N||2015-08-13|||||||||||||||||||||||||||||||||||||||[CR]");
        tmp.append("OBX|1|NM|1|CREAT_K|0.27|mg/dL|0.70-1.30|N|||F||0.0024|2015-08-13||Server||[CR]");
        tmp.append("[EB][CR]");
        tmp.setLength(0);
        tmp.append("[SB]MSH|^~\\&|smart|300|||20120830103931||ORU^R01|1|P|2.3.1||||0||ASCII|||[CR]");
        tmp.append("PID|1||||null||0|M|||||||||||||||||||||||[CR]");
        tmp.append("OBR|1|null|201208290001|smart^300|N||2012-08-29||||||||other0|||||||||||||||||||||||||||||||[CR]");
        tmp.append("OBX|1|NM|1|ALB|11.8|g/l|35.0-55.0|N|||F||0.3279|2012-08-29||Server||[CR]");
        tmp.append("OBX|2|NM|2|APOA_1|1.43|g/L|0.73-1.69|N|||F||0.3767|2012-08-29||Server||[CR]");
        tmp.append("OBX|3|NM|3|LDL_C|4.47|mmol/L|2.07-3.10|N|||F||0.7833|2012-08-29||Server||[CR]");
        tmp.append("OBX|4|NM|4|GGT|7939|U/L|0-50|N|||F||-7.0474|2012-08-29||Server||[CR]");
        tmp.append("[EB][CR]");
        this.parse(TestesInterface.arruma(tmp.toString()));
    }
}

