/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.smart200plus;

import jalis.comum.Conexao;
import jalis.laboratorio.interfaceamento.abas.RefreshTimer;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.interfaces.smart200plus.RecordParser;
import jalis.util.Funcoes;
import jalis.util.ListUtil;
import jalis.util.MemoryList;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class InterfaceListener
extends jalis.laboratorio.interfaceamento.interfaces.smart200.InterfaceListener {
    public InterfaceListener() {
        RecordParser record = new RecordParser();
        record.setInterfaceASTMListener(this);
        super.setASTMRecordParser(record);
    }

    private String getTerminationRecord() {
        StringBuilder record = new StringBuilder("L|1N");
        record.append('\r');
        return record.toString();
    }

    @Override
    protected String getOrderRecord(int order_sequence, String sampleId, String sampleTray, String samplePos, String codBarra, ExameMaterial[] alternativos, String prioridade, String tipoAmostra, String reportType) {
        StringBuilder record = new StringBuilder("O|");
        record.append(order_sequence).append("|");
        record.append(sampleId).append("^");
        record.append(sampleTray).append("^");
        record.append(samplePos).append("|");
        record.append(codBarra).append("|");
        if (alternativos != null && alternativos[0] != null) {
            for (int i = 0; i < alternativos.length; ++i) {
                if (alternativos[i] == null) continue;
                record.append(i);
                record.append("^");
                record.append(alternativos[i].getNomeExame()).append("^");
            }
        }
        record.append("|");
        record.append(prioridade).append("|");
        record.append(InterfaceListener.getCurrentMoment()).append("|");
        record.append(InterfaceListener.getCurrentMoment()).append("|");
        record.append(StringUtil.repeteCaractere('|', 7));
        record.append(tipoAmostra).append("|");
        record.append(StringUtil.repeteCaractere('|', 9));
        record.append(reportType).append("|");
        record.append(StringUtil.repeteCaractere('|', 4));
        record.append('\r');
        return record.toString();
    }

    public static String getCurrentMoment() {
        return new SimpleDateFormat("yyyyddMMHHmmss").format(new Date(System.currentTimeMillis()));
    }

    @Override
    protected String getPatientRecord(int patient_sequence, String patient_id, String pac_nome, String pac_nome2, String pac_nome3, String pac_sexo, Date dataNasc) {
        StringBuilder record = new StringBuilder("P|");
        record.append(patient_sequence).append("|");
        record.append(patient_id == null ? "" : patient_id);
        record.append("||");
        record.append(pac_nome.trim()).append("^").append(pac_nome2.trim()).append("^").append(pac_nome3.trim()).append("||");
        record.append(dataNasc == null ? "" : Funcoes.formataData("yyyyMMdd", dataNasc)).append("|");
        record.append(pac_sexo).append("||||||||||||||||||||||||||");
        record.append('\r');
        return record.toString();
    }

    @Override
    public Map<Integer, String> parseResultTestIDField(String test_id_field) {
        try {
            StringBuilder temp = StringUtil.preencheStringOcorrencias(new StringBuilder(test_id_field), 5, '^', 0);
            HashMap<Integer, String> components = new HashMap<Integer, String>();
            String[] tokens = temp.toString().split("\\^", -1);
            components.put(this.TEST_ID, tokens[0]);
            components.put(this.TEST_NAME, tokens[3]);
            components.put(this.TEST_TYPE, tokens[2]);
            components.put(this.TEST_ITEM_NUMBER, tokens[1]);
            components.put(this.TEST_ITEM_NAME, tokens[4]);
            components.put(this.TEST_DILUTION, tokens[5]);
            return components;
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: parse de Test ID Field (Result Frame)");
            return null;
        }
    }

    @Override
    public void dataChanged() {
        try {
            String message = this.getPortaCOM().getInputString();
            if (message.length() >= 2 && message.equals(String.valueOf('\u0005') + String.valueOf('\u0000'))) {
                this.getPortaCOM().write(String.valueOf('\u0006'));
            } else if (message.length() >= 1 && message.equals(String.valueOf('\u0005'))) {
                this.getPortaCOM().write(String.valueOf('\u0006'));
            }
            message = this.getPortaCOM().removeInputString(this.getMsgEnd());
            if (!message.equals("")) {
                String retorno = this.parse(message);
                this.getPortaCOM().write(retorno.startsWith("Erro") ? String.valueOf('\u0015') : String.valueOf('\u0006'));
                if (this.isRX()) {
                    this.aguardarProximoFrame();
                }
            } else if (this.isRX()) {
                this.aguardarProximoFrame();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: evento de dados recebidos");
            this.fireMensagemEnviada("Erro ao receber dados do equipamento: " + ex.getMessage(), 1, 5000);
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public String parse(String message) {
        try {
            String checksum = null;
            String termination = null;
            int stx_index = message.indexOf(this.getMsgStart());
            if (stx_index >= 0 && message.length() > 5) {
                if (stx_index > 0) {
                    message = message.substring(stx_index);
                } else if (stx_index < 0) {
                    return "Erro no bloco enviado pelo equipamento";
                }
            } else {
                return "Erro no bloco enviado pelo equipamento";
            }
            message = message.substring(1, message.length() - 2);
            checksum = message.substring(message.length() - 2);
            termination = message.substring(message.length() - 3, message.length() - 2);
            message = message.substring(0, message.length() - 2);
            if (this.checkCRC(message, checksum)) {
                if (this.middleFrame && this.rx_list.getUltimoInserido() <= this.rx_list.size()) {
                    message = (String)this.rx_list.get(this.rx_list.getUltimoInserido()) + message;
                    this.rx_list.remove(this.rx_list.getUltimoInserido());
                    this.middleFrame = false;
                }
                this.rx_list.add(message);
                if (termination.equalsIgnoreCase(this.getMiddleFrameEnd())) {
                    this.middleFrame = true;
                    return "";
                }
                this.rx_list = (MemoryList)ListUtil.removeItemIgual(this.rx_list);
                while (!this.rx_list.isEmpty()) {
                    int index;
                    String s = (String)this.rx_list.remove(0);
                    for (int i = 0; i < s.length() && (index = s.indexOf("\r", i + 1)) != -1; ++i) {
                        String sub = s.substring(i, index);
                        this.recordParser.recordFound(sub.trim());
                        i = index - 1;
                    }
                }
                Conexao.arquivaSQL();
                RefreshTimer.waitAndRefresh(this, this.TIME_TO_REFRESH);
                return "";
            }
            this.rx_list.clear();
            return "Erro ao receber bloco de dados: CRC incompat\u00edvel!";
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(null, ex.toString(), ex.getStackTrace(), "AbstractASTMInterfaceamento: parse");
            this.rx_list.clear();
            this.interromperTimer();
            this.setIdle();
            try {
                Conexao.anulaSQL();
                return "Erro ao analisar dados recebidos do equipamento.";
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o SQL em parse");
                return "Erro ao analisar dados recebidos do equipamento. Podem haver dados inconsistentes no BD.";
            }
        }
    }

    @Override
    public void teste() {
        this.parse(this.equipamento.arruma("[ENQ]"));
        this.parse(this.equipamento.arruma("[ACK]"));
        this.parse(this.equipamento.arruma("[STX]1H|\\^&|||^[SP]^|||||||PR|1397-97|20220420155715[CR]P|8|[SP]|[SP]||BEATRIZ[SP]TESTE|||||||||||||[SP]|||||||[SP]|[SP]||||||||[CR]O|8|77585^^|010007758504|1^CREAbt^^^\\2^TGObt^^^\\3^TGPbt^^^\\4^COLbt^^^\\5^UREIAbt^^^\\6^FALbt^^^\\7^BTObt^^^\\8^BDIbt^^^\\9^GLICbt^^^\b^ACUbt^^^\t^TRIGbt^^^\n^LDHbt^^^\u000b^PROTTbt^^^\f^AMIbt^^^\r^ALBbt^^^\u000e^GGTbt^^^||||||||||29/04/2022||[SP]|[SP]||Admin||||||F|||||[CR]R|1|1^CREAbt^1^F|0.82|mg/dL|[SP]^[SP]||[SP]||F|||||[CR]R|2|2^TGObt^1^F|88.6|u/L|[SP]^[SP]||[SP]||F|||||[CR]R|3|3^TGPbt^1^F|69.1|u/L|[SP]^[SP]||[SP]||F|||||[CR]R|4|4^COLbt^1^F|107.0|mg/dL|[SP]^[SP]||[SP]||F|||||[CR]R|5|5^UREIAbt^1^F|27|mg/dL|[SP]^[SP]||[SP]||F|||||[CR]R|6|6^FALbt^1^F|54.2|u/L|[SP]^[SP]||[SP]||F|||||[CR]R|4|4^BTObt^1^F|0.37|mg/dL|[SP]^[SP]||[SP]||F|||||[CR]R|5|5^BDIbt^1^F|0.20|mg/dL|[SP]^[SP]||[SP]||F|||||[CR]R|9|9^GLICbt^1^F|92|mg/dL|[SP]^[SP]||[SP]||F|||||[CR]R|10|10^ACUbt^1^F|4.6|mg/dL|[SP]^[SP]||[SP]||F|||||[CR]R|11|11^TRIGbt^1^F|128|mg/dL|[SP]^[SP]||[SP]||F|||||[CR]R|12|12^LDHbt^1^F|602|u/L|[SP]^[SP]||[SP]||F|||||[CR]R|13|13^PROTTbt^1^F|6.62|g/dL|[SP]^[SP]||[SP]||F|||||[CR]R|14|14^AMIbt^1^F|21|u/L|[SP]^[SP]||[SP]||F|||||[CR]R|15|15^ALBbt^1^F|3.20|g/dL|[SP]^[SP]||[SP]||F|||||[CR]R|16|16^GGTbt^1^F|201.1|u/L|[SP]^[SP]||[SP]||F|||||[CR]L|8|N[CR][ETX]08[LINE]"));
    }
}

