/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.smart200;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public class RecordParser
extends jalis.laboratorio.interfaceamento.interfaces.smartprime.RecordParser {
    public static final int ABA_NAOENVIADOS = 0;
    public static final int ABA_PENDENTES = 1;
    public static final int ABA_PRONTOS = 2;
    public static final int ABA_EXCECOES = 3;
    private String fil_codigo;
    private String req_codigo;

    @Override
    protected void trataOrderRecord(String record) throws Exception {
        String codigo_barra;
        String[] splitted_record = record.split("\\|");
        String recipiente_record = splitted_record[2];
        String[] splitted_recipiente = recipiente_record.split("\\^");
        String recipiente = splitted_recipiente[1].substring(1);
        String filial = splitted_recipiente[0].substring(0, 2);
        String requisicao = splitted_recipiente[0].substring(2);
        splitted_record[2] = codigo_barra = splitted_recipiente[0] + recipiente;
        this.exame_atual = new HashMap();
        Hashtable<Integer, String> order_fields = ASTMStandard.parseDefaultOrderRecord(record);
        this.exame_atual.put(ACTION_CODE, order_fields.get(ASTMStandard.ORDER_FIELD_SAMPLE_ID));
        this.exame_atual.put(REPORT_TYPE, order_fields.get(ASTMStandard.ORDER_FIELD_REPORT_TYPE));
        this.req_codigo = (String)order_fields.get(ASTMStandard.PATIENT_FIELD_PATIENT_ID);
        DescritorCodigoEtiqueta etiqueta = DescritorCodigoEtiqueta.getDescritor(this.req_codigo);
        if (Funcoes.textoVazio(this.req_codigo)) {
            this.req_codigo = (String)order_fields.get(this.equip.ORDER_SYS_SAMPLE_ID);
        }
        if (!Funcoes.textoVazio(this.req_codigo) && this.req_codigo.contains("^")) {
            this.req_codigo = StringUtil.limpaString(this.req_codigo, new String[]{"^"});
        }
        String instSID = (String)order_fields.get(ASTMStandard.ORDER_FIELD_SYSTEM_SID);
        Map<Integer, String> sys_sample_id = this.equip.parseOrderSystemSID(instSID);
        this.exame_atual.put(FIL_CODIGO, filial);
        this.exame_atual.put(REQ_CODIGO, requisicao);
        this.exame_atual.put(REC_CODIGO, recipiente);
        this.req_codigo = Funcoes.textoVazio(this.exame_atual.get(REQ_CODIGO).toString()) ? (String)order_fields.get(ASTMStandard.ORDER_FIELD_SYSTEM_SID) : this.exame_atual.get(FIL_CODIGO).toString() + this.exame_atual.get(REQ_CODIGO).toString() + this.exame_atual.get(REC_CODIGO);
        if (this.req_codigo == null || this.req_codigo.equals("")) {
            this.req_codigo = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_ID);
        }
        if (!Funcoes.textoVazio(this.req_codigo) && this.req_codigo.contains("^")) {
            this.req_codigo = StringUtil.limpaString(this.req_codigo, new String[]{"^"});
        }
        try {
            Long.parseLong(this.req_codigo);
        }
        catch (Exception ex) {
            StringBuilder msg = new StringBuilder();
            msg.append("Resultados recebidos para requisi\u00e7\u00e3o n\u00e3o existente ou n\u00e3o interfaceada: ");
            msg.append(this.req_codigo);
            this.equip.fireExcecaoEncontrada(msg.toString());
            this.exame_atual = null;
            return;
        }
        int qtde = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
        this.req_codigo = Funcoes.preencheZero(this.req_codigo, qtde);
        String rack_id = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_RACK_ID);
        String rack_pos = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_RACK_POS);
        this.exame_atual.put("rack_position", rack_id != null ? rack_id + (rack_pos != null ? "-" + rack_pos : "") : rack_pos);
        this.fil_codigo = this.req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
        String rec_codigo = this.req_codigo.substring(this.req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
        this.req_codigo = this.req_codigo.substring(ParametrosGerais.getDigitosTuboFilial(), this.req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
        Map<Integer, String> components = this.equip.parseOrderTestIDField((String)order_fields.get(ASTMStandard.ORDER_FIELD_TEST_ID));
        Statement st = Conexao.getStatement();
        this.fil_codigo = Funcoes.preencheZero(this.fil_codigo, ParametrosGerais.getDigitosTuboFilial());
        this.req_codigo = Funcoes.preencheZero(this.req_codigo, ParametrosGerais.getDigitosTuboRequisicao());
        rec_codigo = Funcoes.preencheZero(rec_codigo, ParametrosGerais.getDigitosTuboTubo());
        this.exame_atual.put(FIL_CODIGO, this.fil_codigo);
        this.exame_atual.put(REC_CODIGO, rec_codigo);
        this.exame_atual.put(REQ_CODIGO, this.req_codigo);
    }

    @Override
    protected void trataPatientRecord(String record) throws Exception {
        if (this.exame_atual != null) {
            this.salvaExame(this.exame_atual);
            this.exame_atual = null;
        }
        this.exame_atual = new HashMap();
        Hashtable order_fields = ASTMStandard.parseDefaultPatientRecord(record);
        String req_codigo = (String)order_fields.get(ASTMStandard.PATIENT_FIELD_LABORATORY_PID);
        DescritorCodigoEtiqueta etiqueta = DescritorCodigoEtiqueta.getDescritor(req_codigo);
        if (Funcoes.textoVazio(req_codigo)) {
            req_codigo = (String)order_fields.get(this.equip.ORDER_SYS_SAMPLE_ID);
        }
        if (!Funcoes.textoVazio(req_codigo) && req_codigo.contains("^")) {
            req_codigo = StringUtil.limpaString(req_codigo, new String[]{"^"});
        }
        try {
            Long.parseLong(req_codigo);
        }
        catch (Exception ex) {
            StringBuilder msg = new StringBuilder();
            msg.append("Resultados recebidos para requisi\u00e7\u00e3o n\u00e3o existente ou n\u00e3o interfaceada: ");
            msg.append(req_codigo);
            this.equip.fireExcecaoEncontrada(msg.toString());
            this.exame_atual = null;
            return;
        }
        int qtde = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
        req_codigo = Funcoes.preencheZero(req_codigo, qtde);
        String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
        String rec_codigo = req_codigo.substring(req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
        req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial(), req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
        this.exame_atual.put(FIL_CODIGO, fil_codigo);
        this.exame_atual.put(REC_CODIGO, rec_codigo);
        this.exame_atual.put(REQ_CODIGO, req_codigo);
    }

    @Override
    protected void salvaExame(Map<String, Object> dados) throws Exception {
        String fil_codigo = (String)dados.remove(FIL_CODIGO);
        String int_codigo = (String)dados.remove(INT_CODIGO);
        String req_codigo = (String)dados.remove(REQ_CODIGO);
        String exa_codigo = (String)dados.remove(EXA_CODIGO);
        String mco_codigo = (String)dados.remove(MCO_CODIGO);
        String rec_codigo = (String)dados.remove(REC_CODIGO);
        String flag = (String)dados.remove("flag_alerta");
        ArrayList<String> flags = null;
        if (!Funcoes.textoVazio(flag) && !flag.equalsIgnoreCase("N")) {
            flags = new ArrayList<String>();
            if (flag.equalsIgnoreCase("L")) {
                flags.add("Baixo");
            } else if (flag.equalsIgnoreCase("H")) {
                flags.add("Alto");
            }
        }
        dados.remove(ACTION_CODE);
        dados.remove(REPORT_TYPE);
        Statement st = Conexao.getStatement();
        this.equip.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, exa_codigo, mco_codigo, int_codigo, dados, flags);
        Conexao.arquivaSQL();
    }

    @Override
    protected void trataResultRecord(String record) throws SQLException {
        Map<Integer, String> components;
        String emi_alternativo;
        Registro registro;
        if (this.exame_atual == null) {
            return;
        }
        String[] splitted_record = record.split("\\|");
        String alternativo = splitted_record[2];
        alternativo = alternativo.replaceAll("\\^", "");
        if (!this.exame_atual.containsKey(EXA_ALTERNATIVO)) {
            this.exame_atual.put(EXA_ALTERNATIVO, alternativo);
        }
        Hashtable result_fields = ASTMStandard.parseDefaultResultRecord(record);
        String exa_codigo = (String)this.exame_atual.get(EXA_CODIGO);
        String mco_codigo = (String)this.exame_atual.get(MCO_CODIGO);
        String rec_codigo = (String)this.exame_atual.get(REC_CODIGO);
        String resultado = (String)result_fields.get(ASTMStandard.RESULT_FIELD_MEASUREMENT_VALUE);
        if ((resultado = resultado.replaceAll("\\.", ",")).startsWith(",")) {
            resultado = "0" + resultado;
        }
        if (resultado.charAt(resultado.length() - 1) == ',') {
            resultado = resultado + "0";
        }
        if (resultado.charAt(resultado.length() - 1) == '^') {
            resultado = resultado.substring(0, resultado.length() - 1);
        }
        if ((registro = BDUtil.getCodigoExame(this.fil_codigo, emi_alternativo = (components = this.equip.parseResultTestIDField((String)result_fields.get(ASTMStandard.RESULT_FIELD_TEST_ID))).get(this.equip.TEST_NAME), this.req_codigo)) != null) {
            String flags;
            ExameMaterial exame;
            String codigoExame = registro.getString("exa_codigo");
            String codigoMaterial = registro.getString("mco_codigo");
            rec_codigo = registro.getString("rec_codigo");
            String int_codigo = this.equip.getIntCodigo(this.fil_codigo, this.req_codigo, rec_codigo, emi_alternativo);
            this.exame_atual.put(INT_CODIGO, int_codigo);
            this.exame_atual.put(FIL_CODIGO, this.fil_codigo);
            this.exame_atual.put(REC_CODIGO, rec_codigo);
            this.exame_atual.put(REQ_CODIGO, this.req_codigo);
            if (int_codigo == null) {
                this.equip.fireExcecaoEncontrada("C\u00f3digo da interface n\u00e3o encontrado na interface para requisi\u00e7\u00e3o " + this.fil_codigo + " " + this.req_codigo + " " + rec_codigo + " exame " + emi_alternativo);
            }
            if ((exame = this.equip.getReqExameLIS(this.fil_codigo, int_codigo, this.req_codigo, rec_codigo, emi_alternativo)) == null) {
                this.equip.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + this.fil_codigo + " " + this.req_codigo + " " + rec_codigo);
                return;
            }
            this.exame_atual.put(EXA_CODIGO, exame.getNomeExame());
            this.exame_atual.put(MCO_CODIGO, exame.getCodigoMaterial());
            Statement st = Conexao.getStatement();
            int sit = this.equip.getExameSituacao(st, this.fil_codigo, int_codigo, this.req_codigo, exa_codigo, mco_codigo, rec_codigo);
            String campo = sit < 3 ? "resultado_quantitativo" : "repeticao_quantitativo";
            this.exame_atual.put(campo, resultado);
            if (this.exame_atual != null) {
                try {
                    String filial = (String)this.exame_atual.get(FIL_CODIGO);
                    String requisicao = (String)this.exame_atual.get(REQ_CODIGO);
                    String tubo = (String)this.exame_atual.get(REC_CODIGO);
                    this.exame_atual.put(FIL_CODIGO, filial);
                    this.exame_atual.put(REQ_CODIGO, requisicao);
                    this.exame_atual.put(REC_CODIGO, tubo);
                }
                catch (Exception e) {
                    StringBuilder msg = new StringBuilder(e.getMessage());
                    msg.append("\n").append("Erro ao receber resultado ");
                    msg.append("\n").append(this.fil_codigo).append(" ").append(this.req_codigo).append(" ").append(rec_codigo);
                    msg.append("\n").append(record);
                    ErrorLogger.mostraMensagem(null, msg.toString(), e.getStackTrace());
                }
            }
            if ((flags = (String)result_fields.get(ASTMStandard.RESULT_FIELD_CAUSE_OF_ABNORMALITY)) != null && !flags.equals("")) {
                this.exame_atual.put("flag_alerta", flags);
                return;
            }
            try {
                this.salvaExame(this.exame_atual);
                this.exame_atual.remove(campo);
            }
            catch (Exception e) {
                StringBuilder msg = new StringBuilder(e.getMessage());
                msg.append("\n").append("Erro ao salvar resultado ");
                msg.append("\n").append(this.fil_codigo).append(" ").append(this.req_codigo).append(" ").append(rec_codigo).append(" ").append(exame.getNomeExame());
                msg.append("\n").append(record);
                ErrorLogger.mostraMensagem(null, msg.toString(), e.getStackTrace());
            }
        }
    }
}

