/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.smart200;

import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.interfaces.smart200.RecordParser;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class InterfaceListener
extends jalis.laboratorio.interfaceamento.interfaces.smartprime.InterfaceListener {
    public InterfaceListener() {
        RecordParser record = new RecordParser();
        record.setInterfaceASTMListener(this);
        super.setASTMRecordParser(record);
    }

    @Override
    protected String getOrderRecord(int order_sequence, String sampleId, String sampleTray, String samplePos, String codBarra, ExameMaterial[] alternativos, String prioridade, String tipoAmostra, String reportType) {
        StringBuilder record = new StringBuilder("O|");
        record.append(order_sequence).append("|");
        record.append(sampleId).append("^");
        record.append(sampleTray).append("^");
        record.append(samplePos).append("|");
        record.append(codBarra).append("|");
        if (alternativos != null && alternativos[0] != null) {
            for (int i = 0; i < alternativos.length; ++i) {
                if (alternativos[i] == null) continue;
                record.append(i);
                record.append("^");
                record.append(alternativos[i].getNomeExame()).append("^");
            }
        }
        record.append("|");
        record.append(prioridade).append("|");
        record.append(InterfaceListener.getCurrentMoment()).append("|");
        record.append(InterfaceListener.getCurrentMoment()).append("|");
        record.append(StringUtil.repeteCaractere('|', 7));
        record.append(tipoAmostra).append("|");
        record.append(StringUtil.repeteCaractere('|', 9));
        record.append(reportType).append("|");
        record.append(StringUtil.repeteCaractere('|', 4));
        record.append('\r');
        return record.toString();
    }

    public static String getCurrentMoment() {
        return new SimpleDateFormat("yyyyddMMHHmmss").format(new Date(System.currentTimeMillis()));
    }

    @Override
    protected String getPatientRecord(int patient_sequence, String patient_id, String pac_nome, String pac_nome2, String pac_nome3, String pac_sexo, Date dataNasc) {
        StringBuilder record = new StringBuilder("P|");
        record.append(patient_sequence).append("|");
        record.append(patient_id == null ? "" : patient_id);
        record.append("||");
        record.append(pac_nome.trim()).append("^").append(pac_nome2.trim()).append("^").append(pac_nome3.trim()).append("||");
        record.append(dataNasc == null ? "" : Funcoes.formataData("yyyyMMdd", dataNasc)).append("|");
        record.append(pac_sexo).append("||||||||||||||||||||||||||");
        record.append('\r');
        return record.toString();
    }

    @Override
    public Map<Integer, String> parseResultTestIDField(String test_id_field) {
        try {
            StringBuilder temp = StringUtil.preencheStringOcorrencias(new StringBuilder(test_id_field), 5, '^', 0);
            HashMap<Integer, String> components = new HashMap<Integer, String>();
            String[] tokens = temp.toString().split("\\^", -1);
            components.put(this.TEST_ID, tokens[0]);
            components.put(this.TEST_NAME, tokens[3]);
            components.put(this.TEST_TYPE, tokens[2]);
            components.put(this.TEST_ITEM_NUMBER, tokens[1]);
            components.put(this.TEST_ITEM_NAME, tokens[4]);
            components.put(this.TEST_DILUTION, tokens[5]);
            return components;
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: parse de Test ID Field (Result Frame)");
            return null;
        }
    }

    @Override
    public void teste() {
        this.parse(this.equipamento.arruma("[STX]1H|\\^&|||Tecom^3.6^11052213||||||||E-1394-97|20180706130217[CR][ETX]35[LINE]"));
        this.parse(this.equipamento.arruma("[STX]2P|1||0100041879||RENATA^OGUSUCU^|||F||||||41^Y[CR][ETX]8D[LINE]"));
        this.parse(this.equipamento.arruma("[STX]3O|1|0100054900^002^^^|Tecom[SP]100^||S|20180607130217|||||||||1||||||||||O[CR][ETX]87[LINE]"));
        this.parse(this.equipamento.arruma("[STX]4R|1|^^^CreaBI|0.60|mg/dL|0.00^100.00|N||F||||20180706130217[CR][ETX]C3[LINE]"));
        this.parse(this.equipamento.arruma("[STX]5R|2|^^^COLbt|69.38|mg/dL|0.00^100.00|N||F||||20180706130217[CR][ETX]B5[LINE]"));
        this.parse(this.equipamento.arruma("[STX]6L|1|N[CR][ETX]09[LINE]"));
    }
}

