/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.sismexxs1000i;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.interfaces.sismexxs1000i.InterfaceListener;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMRecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class RecordParser
extends ASTMRecordParser {
    @Override
    protected void trataOrderRecord(String record) throws Exception {
        if (this.exame_atual != null) {
            this.salvaExame(this.exame_atual);
        }
        this.exame_atual = new HashMap();
        Hashtable<Integer, String> order_fields = ASTMStandard.parseDefaultOrderRecord(record);
        this.exame_atual.put(ACTION_CODE, order_fields.get(ASTMStandard.ORDER_FIELD_ACTION_CODE));
        this.exame_atual.put(REPORT_TYPE, order_fields.get(ASTMStandard.ORDER_FIELD_REPORT_TYPE));
        String instSID = (String)order_fields.get(ASTMStandard.ORDER_FIELD_SYSTEM_SID);
        Map<Integer, String> sys_sample_id = this.equip.parseOrderSystemSID(instSID);
        String req_codigo = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_RACK_POS);
        System.out.println(req_codigo);
        if (!Funcoes.textoVazio(req_codigo)) {
            req_codigo = req_codigo.trim();
        }
        System.out.println(req_codigo);
        try {
            Long.parseLong(req_codigo);
        }
        catch (Exception ex) {
            StringBuilder msg = new StringBuilder();
            msg.append("Resultados recebidos para requisi\u00e7\u00e3o n\u00e3o existente ou n\u00e3o interfaceada: ");
            msg.append(req_codigo);
            this.equip.fireExcecaoEncontrada(msg.toString());
            this.exame_atual = null;
            return;
        }
        int qtde = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
        req_codigo = Funcoes.preencheZero(req_codigo, qtde);
        String rack_id = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_RACK_ID);
        String rack_pos = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_RACK_POS);
        this.exame_atual.put("rack_position", rack_id != null ? rack_id + (rack_pos != null ? "-" + rack_pos : "") : rack_pos);
        String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
        String rec_codigo = req_codigo.substring(req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
        req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial(), req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
        String emi_alternativo = ((InterfaceListener)this.equip).NOME_EXAME;
        Statement st = Conexao.getStatement();
        String int_codigo = this.equip.getIntCodigo(fil_codigo, req_codigo, rec_codigo, emi_alternativo);
        ExameMaterial exame = this.equip.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo);
        this.exame_atual.put(INT_CODIGO, int_codigo);
        this.exame_atual.put(FIL_CODIGO, fil_codigo);
        this.exame_atual.put(REC_CODIGO, rec_codigo);
        this.exame_atual.put(REQ_CODIGO, req_codigo);
        if (exame == null) {
            this.equip.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
            this.exame_atual = null;
            return;
        }
        this.exame_atual.put(EXA_CODIGO, exame.getNomeExame());
        this.exame_atual.put(MCO_CODIGO, exame.getCodigoMaterial());
    }

    @Override
    protected void trataResultRecord(String record) throws SQLException {
        if (this.exame_atual == null) {
            return;
        }
        String action_code = (String)this.exame_atual.get(ACTION_CODE);
        String report_type = (String)this.exame_atual.get(REPORT_TYPE);
        if (action_code != null) {
            this.equip.getClass();
            if (action_code.equals("Q")) {
                this.exame_atual = null;
                return;
            }
        }
        if (report_type != null) {
            this.equip.getClass();
            if (report_type.equals("X")) {
                this.exame_atual = null;
                return;
            }
        }
        Hashtable result_fields = ASTMStandard.parseDefaultResultRecord(record);
        String fil_codigo = (String)this.exame_atual.get(FIL_CODIGO);
        String int_codigo = (String)this.exame_atual.get(INT_CODIGO);
        String req_codigo = (String)this.exame_atual.get(REQ_CODIGO);
        String exa_codigo = (String)this.exame_atual.get(EXA_CODIGO);
        String mco_codigo = (String)this.exame_atual.get(MCO_CODIGO);
        String rec_codigo = (String)this.exame_atual.get(REC_CODIGO);
        String campoHemog = (String)result_fields.get(3);
        String resultado = (String)result_fields.get(4);
        campoHemog = this.parseCampoHemograma(campoHemog);
        if ((resultado = resultado.replaceAll("\\.", ",")).startsWith(",")) {
            resultado = "0" + resultado;
        }
        if (resultado.length() >= 1 && resultado.charAt(resultado.length() - 1) == ',') {
            resultado = resultado + "0";
        }
        Statement st = Conexao.getStatement();
        this.exame_atual.put(campoHemog, resultado);
        String flags = (String)result_fields.get(ASTMStandard.RESULT_FIELD_ABNORMAL_FLAGS);
        if (flags != null && !flags.equals("") && !Funcoes.textoVazio(campoHemog)) {
            this.exame_atual.put("flag_alerta", flags);
        }
    }

    private String parseCampoHemograma(String campo) {
        System.out.println(campo);
        campo = campo.replaceAll("\\^1", "");
        System.out.println(campo);
        campo = campo.replaceAll("\\^", "");
        System.out.println(campo);
        if (campo.equalsIgnoreCase("WBC")) {
            return "leucocitos";
        }
        if (campo.equalsIgnoreCase("RBC")) {
            return "hemacias";
        }
        if (campo.equalsIgnoreCase("HGB")) {
            return "hgb";
        }
        if (campo.equalsIgnoreCase("HCT")) {
            return "hct";
        }
        if (campo.equalsIgnoreCase("MCV")) {
            return "vcm";
        }
        if (campo.equalsIgnoreCase("MCH")) {
            return "hcm";
        }
        if (campo.equalsIgnoreCase("MCHC")) {
            return "chcm";
        }
        if (campo.equalsIgnoreCase("PLT")) {
            return "plaquetas";
        }
        if (campo.equalsIgnoreCase("NEUT%")) {
            return "neutrofilo_percentual";
        }
        if (campo.equalsIgnoreCase("LYMPH%")) {
            return "linfocitos_tipicos_percentual";
        }
        if (campo.equalsIgnoreCase("MONO%")) {
            return "monocitos_percentual";
        }
        if (campo.equalsIgnoreCase("EO%")) {
            return "eosinofilos_percentual";
        }
        if (campo.equalsIgnoreCase("BASO%")) {
            return "basofilos_percentual";
        }
        if (campo.equalsIgnoreCase("NEUT#")) {
            return "neutrofilo_contagem";
        }
        if (campo.equalsIgnoreCase("LYMPH#")) {
            return "linfocitos_tipicos_contagem";
        }
        if (campo.equalsIgnoreCase("EO#")) {
            return "eosinofilos_contagem";
        }
        if (campo.equalsIgnoreCase("BASO#")) {
            return "basofilos_contagem";
        }
        if (campo.equalsIgnoreCase("RDW-SD")) {
            return "rdw_sd";
        }
        if (campo.equalsIgnoreCase("RDW-CV")) {
            return "rdw_cv";
        }
        if (campo.equalsIgnoreCase("MPV")) {
            return "vpm";
        }
        return "";
    }

    @Override
    protected void salvaExame(Map<String, Object> dados) throws Exception {
        String fil_codigo = (String)dados.remove(FIL_CODIGO);
        String int_codigo = (String)dados.remove(INT_CODIGO);
        String req_codigo = (String)dados.remove(REQ_CODIGO);
        String exa_codigo = (String)dados.remove(EXA_CODIGO);
        String mco_codigo = (String)dados.remove(MCO_CODIGO);
        String rec_codigo = (String)dados.remove(REC_CODIGO);
        dados.remove(ACTION_CODE);
        dados.remove(REPORT_TYPE);
        Statement st = Conexao.getStatement();
        List<BDExame> exames = BDUtil.getReqExamesMultGuia(fil_codigo, int_codigo, req_codigo, rec_codigo);
        for (BDExame exame : exames) {
            this.equip.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, exame.getExame(), exame.getMaterial(), int_codigo, dados);
        }
    }
}

