/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.selectraxl;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.exames.InfoExameRequisicao;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.SwingUtilities;

public class InterfaceListener
extends jalis.laboratorio.interfaceamento.interfaces.selectra2.InterfaceListener {
    ArrayList<String> testesEsquerda = new ArrayList();
    ArrayList<String> testesDireita = new ArrayList();

    public InterfaceListener() {
        super(false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        try {
            this.getPortaCOM().clearInputString();
            this.setTX(6000);
            Statement st = Conexao.getStatement();
            if (acao.equals("C")) {
                this.requestSampleDeletion(fil_codigo, req_codigo, exames, mco_codigo, rec_codigo);
                return "Requisi\u00e7\u00e3o de cancelamento/exclus\u00e3o enviada ao equipamento";
            }
            if (acao.equals("R")) {
                this.requestSampleResult(fil_codigo, req_codigo, rec_codigo);
                return "Requisi\u00e7\u00e3o de resultado enviada ao equipamento";
            }
            fil_codigo = Funcoes.preencheZero(fil_codigo, ParametrosGerais.getDigitosTuboFilial());
            req_codigo = Funcoes.preencheZero(req_codigo, ParametrosGerais.getDigitosTuboRequisicao());
            StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo);
            rec_codigo = Funcoes.preencheZero(rec_codigo, ParametrosGerais.getDigitosTuboTubo());
            codigo.append(rec_codigo);
            String[] temp = exames.split(" ", 0);
            ExameMaterial[] exa_lista = new ExameMaterial[temp.length];
            int i = -1;
            for (String t : temp) {
                exa_lista[++i] = new ExameMaterial(t, new Integer(mco_codigo));
            }
            exa_lista = ExamesUtil.anexarCodigoMaterial(temp, mco_codigo);
            String req_data = data;
            String req_hora = hora;
            String short_name = StringUtil.removerAcentos(pac_nome);
            if (short_name.length() > 20) {
                short_name = short_name.substring(0, 20);
            }
            if (!Funcoes.textoVazio(this.configuracao.getSolicitarReagentesEnvio()) && this.configuracao.getSolicitarReagentesEnvio().equalsIgnoreCase("1")) {
                this.requestReagentInstallation();
                this.setRX(2000);
                if (SwingUtilities.isEventDispatchThread()) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                } else {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
            }
            if (this.testesEsquerda != null && (this.testesEsquerda.size() == 32 || this.testesDireita != null) && this.testesDireita.size() == 32) {
                void var29_35;
                ArrayList<String> listaEsquerda = new ArrayList<String>();
                ArrayList<String> listaDireita = new ArrayList<String>();
                for (i = 0; i < 32; ++i) {
                    listaEsquerda.add("0");
                    listaDireita.add("0");
                }
                HashSet<ExameMaterial> examesEnviados = new HashSet<ExameMaterial>();
                HashSet<ExameMaterial> examesNaoEnviados = new HashSet<ExameMaterial>();
                ExameMaterial[] exameMaterialArray = exa_lista;
                int n = exameMaterialArray.length;
                boolean bl = false;
                while (var29_35 < n) {
                    int index;
                    String exa_alternativo;
                    ExameMaterial exameMaterial = exameMaterialArray[var29_35];
                    ExameMaterial[] exas = null;
                    exas = BDUtil.isExameDesmembrado(fil_codigo, int_codigo, exameMaterial.getString(), mco_codigo) ? BDUtil.getExamesFilhos(fil_codigo, int_codigo, exameMaterial.getString(), mco_codigo) : new ExameMaterial[]{new ExameMaterial(exameMaterial.getString(), Integer.parseInt(mco_codigo))};
                    boolean todos = true;
                    for (ExameMaterial exa : exas) {
                        exa_alternativo = BDUtil.getExmCodigoAlternativo(fil_codigo, exa.getNomeExame(), mco_codigo, int_codigo);
                        if (exa_alternativo != null || this.testesEsquerda.contains(exa_alternativo) || this.testesDireita.contains(exa_alternativo)) {
                            if (this.testesEsquerda.contains(exa_alternativo)) {
                                index = this.testesEsquerda.indexOf(exa_alternativo);
                                listaEsquerda.set(index, "1");
                                examesEnviados.add(exameMaterial);
                                continue;
                            }
                            if (!this.testesDireita.contains(exa_alternativo)) continue;
                            index = this.testesDireita.indexOf(exa_alternativo);
                            listaDireita.set(index, "1");
                            examesEnviados.add(exameMaterial);
                            continue;
                        }
                        todos = false;
                        if (!this.configuracao.getIgnorarExameSemReagente().equalsIgnoreCase("0")) continue;
                        this.fireExcecaoEncontrada(String.valueOf(req_codigo) + " - Exame " + exameMaterial.getString() + " requisitado, mas seu c\u00f3digo alternativo n\u00e3o est\u00e1 configurado no Jalis");
                        return "Erro: exame pode n\u00e3o estar cadastrado no Jalis";
                    }
                    if (!todos) {
                        for (ExameMaterial exa : exas) {
                            exa_alternativo = BDUtil.getExmCodigoAlternativo(fil_codigo, exa.getNomeExame(), mco_codigo, int_codigo);
                            if (exa_alternativo == null) continue;
                            if (this.testesEsquerda.contains(exa_alternativo)) {
                                index = this.testesEsquerda.indexOf(exa_alternativo);
                                listaEsquerda.set(index, "0");
                                examesNaoEnviados.add(exa);
                                examesEnviados.remove(exameMaterial);
                                continue;
                            }
                            if (!this.testesDireita.contains(exa_alternativo)) continue;
                            index = this.testesDireita.indexOf(exa_alternativo);
                            listaEsquerda.set(index, "0");
                            examesNaoEnviados.add(exa);
                            examesEnviados.remove(exameMaterial);
                        }
                    }
                    ++var29_35;
                }
                if (listaEsquerda.indexOf("1") < 0 && listaDireita.indexOf("1") < 0) {
                    return "Erro: exame(s) n\u00e3o cadastrado(s)";
                }
                StringBuilder exaEnviados = new StringBuilder();
                for (ExameMaterial exameMaterial : examesEnviados) {
                    exaEnviados.append(exameMaterial.getNomeExame()).append(" ");
                }
                this.ultimo_enviado = new InfoExameRequisicao(fil_codigo, req_codigo, mco_codigo, rec_codigo, pac_nome, pac_idade, pac_sexo, req_data, req_hora, exaEnviados.toString().trim());
                this.ultimo_enviado_acao = acao;
                if (Funcoes.textoVazio(examesNaoEnviados.toString().trim()) && this.configuracao.getIgnorarExameSemReagente().equalsIgnoreCase("1")) {
                    this.equipamento.addLinhaErro(codigo.toString(), examesNaoEnviados.toString().trim());
                }
                StringBuilder lista_exames_esquerda = new StringBuilder();
                StringBuilder stringBuilder = new StringBuilder();
                for (String exame : listaEsquerda) {
                    lista_exames_esquerda.append(exame);
                }
                for (String exame : listaDireita) {
                    stringBuilder.append(exame);
                }
                StringBuilder stringBuilder2 = new StringBuilder(this.getMsgStart());
                stringBuilder2.append("{");
                stringBuilder2.append('Q');
                stringBuilder2.append(";");
                stringBuilder2.append((CharSequence)codigo);
                stringBuilder2.append(";");
                stringBuilder2.append('N');
                stringBuilder2.append(";");
                stringBuilder2.append(short_name);
                stringBuilder2.append(";");
                stringBuilder2.append("");
                stringBuilder2.append(";");
                stringBuilder2.append(pac_sexo);
                stringBuilder2.append(";");
                stringBuilder2.append("");
                stringBuilder2.append(";");
                stringBuilder2.append(lista_exames_esquerda.toString());
                stringBuilder2.append(";");
                stringBuilder2.append(stringBuilder.toString());
                stringBuilder2.append(";");
                stringBuilder2.append("}");
                stringBuilder2.append(this.getMsgEnd());
                this.getPortaCOM().write(stringBuilder2.toString());
                return "Enviando " + pac_nome + " para o equipamento";
            }
            this.requestReagentInstallation();
            this.setRX(2000);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
        }
        return null;
    }

    @Override
    protected void parseFlagsExcecoes(String req_codigo, String exa_codigo, String flags) {
        char[] array;
        StringBuilder prefixo = new StringBuilder(req_codigo).append("(").append(exa_codigo).append(") - ");
        for (char c : array = flags.trim().toCharArray()) {
            String flag = null;
            switch (c) {
                case 'G': {
                    flag = "Erro de hardware";
                    break;
                }
                case 'R': {
                    flag = "Reagente insuficiente";
                    break;
                }
                case '#': {
                    flag = "Amostra insuficiente";
                    break;
                }
                case 'L': {
                    flag = "Erro de l\u00e2mpada/eletrodo ISE n\u00e3o calibrado";
                    break;
                }
                case 'U': {
                    flag = "Valor/eletrodo ISE abaixo do esperado";
                    break;
                }
                case 'O': {
                    flag = "Valor/eletrodo ISE acima do esperado";
                    break;
                }
                case 'u': {
                    flag = "Refer\u00eancia de contador/elotrodo ISE abaixo do esperado";
                    break;
                }
                case 'o': {
                    flag = "Refer\u00eancia de contador/elotrodo ISE acima do esperado";
                    break;
                }
                case 'T': {
                    flag = "Erro de temperatura de cubeta/ISE";
                    break;
                }
                case 'r': {
                    flag = "Repeti\u00e7\u00e3o";
                    break;
                }
                case '*': {
                    flag = "Erro alinear";
                    break;
                }
                case 'M': {
                    flag = "Viola\u00e7\u00e3o do limite de absor\u00e7\u00e3o";
                    break;
                }
                case 'D': {
                    flag = "Erro de desvio de absor\u00e7\u00e3o de reagente";
                    break;
                }
                case 'W': {
                    flag = "Viola\u00e7\u00e3o de Westgard";
                    break;
                }
                case 'A': {
                    flag = "Viola\u00e7\u00e3o do limite de calibra\u00e7\u00e3o";
                    break;
                }
                case 'C': {
                    flag = "Viola\u00e7\u00e3o do limite de controle";
                    break;
                }
                case 'N': {
                    flag = "Viola\u00e7\u00e3o do limite de refer\u00eancia";
                    break;
                }
                case 'a': {
                    flag = "Viola\u00e7\u00e3o do limite de absor\u00e7\u00e3o do reagente";
                    break;
                }
                case 'I': {
                    flag = "Erro da unidade ISE";
                    break;
                }
                case 'X': {
                    flag = "Erro de limite de concentra\u00e7\u00e3o";
                    break;
                }
                case 'P': {
                    flag = "Erro de prozone";
                    break;
                }
                case 'E': {
                    flag = "Resultado pr\u00f3ximo ao valor-limite";
                    break;
                }
                case 'F': {
                    flag = "Teste n\u00e3o executado devido a op\u00e7\u00e3o desabilitada";
                }
            }
            if (flag == null) continue;
            this.fireExcecaoEncontrada(prefixo.toString().concat(flag));
        }
    }

    protected void parseFlagsExcecoesLimite(String req_codigo, String exa_codigo, String flags) {
        char[] array;
        StringBuilder prefixo = new StringBuilder(req_codigo).append("(").append(exa_codigo).append(") - ");
        for (char c : array = flags.trim().toCharArray()) {
            String flag = null;
            switch (c) {
                case '+': {
                    flag = "Reference high error";
                    break;
                }
                case '-': {
                    flag = "Reference low error";
                    break;
                }
                case 'Y': {
                    flag = "Reference panic hight error";
                    break;
                }
                case 'y': {
                    flag = "Reference panic low error";
                    break;
                }
                case 'V': {
                    flag = "Cutoff positve";
                    break;
                }
                case 'v': {
                    flag = "Cutoff negative";
                    break;
                }
                case 'K': {
                    flag = "Calibration out of high range";
                    break;
                }
                case 'k': {
                    flag = "Calibration out of low range";
                    break;
                }
                case 'Z': {
                    flag = "Dup-diff error";
                    break;
                }
                case 'B': {
                    flag = "Barcode not matching";
                    break;
                }
                case 'b': {
                    flag = "Barcode not scanned";
                    break;
                }
                case 'H': {
                    flag = "Calculation result division by zero";
                    break;
                }
                case 'h': {
                    flag = "Calculation result condition not satisfied";
                    break;
                }
                case 'm': {
                    flag = "Absorbance low limit error";
                }
            }
            if (flag == null) continue;
            this.fireExcecaoEncontrada(prefixo.toString().concat(flag));
        }
    }

    @Override
    protected String parseShortResult(ArrayList<String> campos) {
        String retorno = null;
        try {
            Statement st = Conexao.getStatement();
            String device_id = campos.remove(0).trim();
            String tipo_result = campos.remove(0).trim();
            switch (tipo_result.charAt(0)) {
                case 'B': 
                case 'C': 
                case 'S': {
                    return null;
                }
            }
            String req_codigo = campos.remove(0).trim();
            String pac_nome = campos.remove(0).trim();
            String pac_datanasc = campos.remove(0).trim();
            String pac_sexo = campos.remove(0).trim();
            String pac_nomecompleto = campos.remove(0).trim();
            String req_data = campos.remove(0).trim();
            String req_time = campos.remove(0).trim();
            try {
                Long.parseLong(req_codigo);
            }
            catch (Exception ex) {
                StringBuilder msg = new StringBuilder();
                msg.append("Resultados recebidos para requisi\u00e7\u00e3o n\u00e3o existente ou n\u00e3o interfaceada: ");
                msg.append(req_codigo);
                this.fireExcecaoEncontrada(msg.toString());
                return null;
            }
            if (req_codigo.length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                StringBuilder msg = new StringBuilder();
                msg.append("Resultados recebidos para requisi\u00e7\u00e3o n\u00e3o existente ou n\u00e3o interfaceada: ");
                msg.append(req_codigo);
                this.fireExcecaoEncontrada(msg.toString());
                return null;
            }
            String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
            String rec_codigo = req_codigo.substring(req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
            req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial(), req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
            if (fil_codigo.equals("00") || rec_codigo.equals("00")) {
                return null;
            }
            for (int num_testes = Integer.parseInt(campos.remove(0).trim()); num_testes > 0; --num_testes) {
                ExameMaterial exame;
                campos.remove(0);
                String emi_alternativo = campos.remove(0).trim().toUpperCase();
                campos.remove(0);
                campos.remove(0);
                String ers_resultado = campos.remove(0).trim();
                String flags = campos.remove(0).trim();
                String limitFlags = campos.remove(0).trim();
                String unidades = campos.remove(0).trim();
                this.parseFlagsExcecoes(req_codigo, emi_alternativo, flags.trim());
                this.parseFlagsExcecoesLimite(req_codigo, emi_alternativo, limitFlags.trim());
                String int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, emi_alternativo);
                if (int_codigo == null) {
                    this.fireExcecaoEncontrada("Interfaceamento do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                }
                if ((exame = this.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo)) == null) {
                    this.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                    continue;
                }
                this.atualizarResultadoExame(st, fil_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo, ers_resultado.replaceAll("\\.", ","));
            }
            Conexao.arquivaSQL();
            this.fireAtualizarTabela();
            return retorno;
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return "Erro ao realizar parse de dados recebidos do equipamento";
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            return "Erro ao realizar parse de dados recebidos do equipamento";
        }
    }

    @Override
    protected String parseExtendedResult(ArrayList<String> campos) {
        String retorno = null;
        try {
            Statement st = Conexao.getStatement();
            String device_id = campos.remove(0).trim();
            String tipo_result = campos.remove(0).trim();
            switch (tipo_result.charAt(0)) {
                case 'B': 
                case 'C': 
                case 'S': {
                    return null;
                }
            }
            String req_codigo = campos.remove(0).trim();
            String pac_nome = campos.remove(0).trim();
            String pac_datanasc = campos.remove(0).trim();
            String pac_sexo = campos.remove(0).trim();
            String pac_nomecompleto = campos.remove(0).trim();
            String req_data = campos.remove(0).trim();
            String req_time = campos.remove(0).trim();
            try {
                Long.parseLong(req_codigo);
            }
            catch (Exception ex) {
                StringBuilder msg = new StringBuilder();
                msg.append("Resultados recebidos para requisi\u00e7\u00e3o n\u00e3o existente ou n\u00e3o interfaceada: ");
                msg.append(req_codigo);
                this.fireExcecaoEncontrada(msg.toString());
                return msg.toString();
            }
            if (req_codigo.length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                StringBuilder msg = new StringBuilder();
                msg.append("Resultados recebidos para requisi\u00e7\u00e3o n\u00e3o existente ou n\u00e3o interfaceada: ");
                msg.append(req_codigo);
                this.fireExcecaoEncontrada(msg.toString());
                return null;
            }
            String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
            String rec_codigo = req_codigo.substring(req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
            req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial(), req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
            if (fil_codigo.equals("00") || rec_codigo.equals("00")) {
                return null;
            }
            for (int num_testes = Integer.parseInt(campos.remove(0).trim()); num_testes > 0; --num_testes) {
                campos.remove(0);
                String emi_alternativo = campos.remove(0).trim().toUpperCase();
                campos.remove(0);
                campos.remove(0);
                String ers_resultado = campos.remove(0).trim();
                String flags = campos.remove(0).trim();
                String limitFlags = campos.remove(0).trim();
                String unidades = campos.remove(0).trim();
                String reag_abs = campos.remove(0).trim();
                String raw_result = campos.remove(0).trim();
                String raw_units = campos.remove(0).trim();
                for (int i = 0; i < 45; ++i) {
                    campos.remove(0);
                }
                this.parseFlagsExcecoes(req_codigo, emi_alternativo, flags.trim());
                this.parseFlagsExcecoesLimite(req_codigo, emi_alternativo, limitFlags.trim());
                String int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, emi_alternativo);
                ExameMaterial exame = this.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo);
                if (exame == null) {
                    exame = BDUtil.getReqExameFilhoLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo);
                }
                if (exame == null) {
                    this.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                    continue;
                }
                this.atualizarResultadoExame(st, fil_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo, ers_resultado.replaceAll("\\.", ","));
            }
            Conexao.arquivaSQL();
            this.fireAtualizarTabela();
            return retorno;
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return "Erro ao realizar parse de dados recebidos do equipamento";
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            return "Erro ao realizar parse de dados recebidos do equipamento";
        }
    }

    @Override
    protected String parseResultAnswer(ArrayList<String> campos) {
        try {
            String retorno = null;
            Statement st = Conexao.getStatement();
            String device_id = campos.remove(0).trim();
            String status = campos.remove(0).trim();
            String req_codigo = campos.remove(0).trim();
            try {
                Long.parseLong(req_codigo);
            }
            catch (Exception ex) {
                StringBuilder msg = new StringBuilder();
                msg.append("Resultados recebidos para requisi\u00e7\u00e3o n\u00e3o existente ou n\u00e3o interfaceada: ");
                msg.append(req_codigo);
                this.fireExcecaoEncontrada(msg.toString());
                return msg.toString();
            }
            if (req_codigo.length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                StringBuilder msg = new StringBuilder();
                msg.append("Resultados recebidos para requisi\u00e7\u00e3o n\u00e3o existente ou n\u00e3o interfaceada: ");
                msg.append(req_codigo);
                this.fireExcecaoEncontrada(msg.toString());
                return null;
            }
            String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
            String rec_codigo = req_codigo.substring(req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
            req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial(), req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
            if (fil_codigo.equals("00") || rec_codigo.equals("00")) {
                return null;
            }
            if (status != null && !status.equals("0") && !status.equals("1")) {
                StringBuilder excecao = new StringBuilder(req_codigo).append(" - ");
                if (status.equals("2")) {
                    excecao.append("Erro: amostra ainda se encontra na fila de espera");
                } else if (status.equals("3")) {
                    excecao.append("Erro: amostra n\u00e3o encontrada");
                } else if (status.equals("7")) {
                    excecao.append("Erro nos dados requisitados ao equipamento");
                } else if (status.equals("8")) {
                    excecao.append("Erro de dados sobrepostos (velocidade)");
                } else if (status.equals("9")) {
                    excecao.append("Erro de paridade, bloco ou interrup\u00e7\u00e3o dos dados");
                }
                if (!excecao.equals(new StringBuilder(req_codigo).append(" - "))) {
                    this.fireExcecaoEncontrada(excecao.toString());
                }
                return excecao.toString();
            }
            String prioridade = campos.remove(0).trim();
            String pac_nome = campos.remove(0).trim();
            String pac_datanasc = campos.remove(0).trim();
            String pac_sexo = campos.remove(0).trim();
            for (int num_testes = Integer.parseInt(campos.remove(0).trim()); num_testes > 0; --num_testes) {
                String emi_alternativo = campos.remove(0).trim().toUpperCase();
                String ers_resultado = campos.remove(0).trim();
                String flags = campos.remove(0).trim();
                String limitFlags = campos.remove(0).trim();
                String unidades = campos.remove(0).trim();
                this.parseFlagsExcecoes(req_codigo, emi_alternativo, flags.trim());
                this.parseFlagsExcecoesLimite(req_codigo, emi_alternativo, limitFlags.trim());
                String int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, emi_alternativo);
                ExameMaterial exame = this.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo);
                if (exame == null) {
                    this.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                    continue;
                }
                if (!ers_resultado.equals("-------")) {
                    this.atualizarResultadoExame(st, fil_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo, ers_resultado.replaceAll("\\.", ","));
                    continue;
                }
                retorno = "O exame " + exame + " para " + pac_nome + " ainda n\u00e3o possui resultado";
            }
            Conexao.arquivaSQL();
            this.fireAtualizarTabela();
            return retorno;
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return "Erro ao realizar parse de resultado recebido";
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            return "Erro ao realizar parse de resultado de recebido";
        }
    }

    @Override
    protected String parseReagentAnswer(ArrayList<String> campos) {
        try {
            int i;
            String device_id = campos.remove(0).trim();
            String status = null;
            if (campos.get(0).length() == 1 && !campos.get(0).equalsIgnoreCase("L") && !campos.get(0).equalsIgnoreCase("R")) {
                status = campos.remove(0).trim();
            }
            if (status != null && !status.equals("0")) {
                if (status.equals("7")) {
                    this.fireExcecaoEncontrada("Erro nos dados requisitados ao equipamento");
                } else if (status.equals("8")) {
                    this.fireExcecaoEncontrada("Erro de dados sobrepostos (velocidade)");
                } else if (status.equals("9")) {
                    this.fireExcecaoEncontrada("Erro de paridade, bloco ou interrup\u00e7\u00e3o dos dados");
                }
                return null;
            }
            this.testesEsquerda.clear();
            String teste = campos.remove(0);
            for (i = 0; i < 96; i += 3) {
                this.testesEsquerda.add(campos.remove(0).trim().toUpperCase());
                campos.remove(0);
                campos.remove(0);
            }
            this.testesDireita.clear();
            teste = campos.remove(0);
            for (i = 0; i < 96; i += 3) {
                this.testesDireita.add(campos.remove(0).trim().toUpperCase());
                campos.remove(0);
                campos.remove(0);
            }
        }
        catch (IndexOutOfBoundsException e) {
            this.fireExcecaoEncontrada("Mensagem recebida est\u00e1 em desacordo com equipamento configurado.");
        }
        return "Lista de testes/reagentes atualizada";
    }
}

