/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.selectraflexor;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.abas.RefreshTimer;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.exames.InfoExameRequisicao;
import jalis.laboratorio.interfaceamento.interfaces.selectraflexor.InterfaceConfiguracao;
import jalis.laboratorio.interfaceamento.interfaces.selectraflexor.RecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.interfaceamento.padroes.astm.InterfaceASTMListener;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.ListUtil;
import jalis.util.MemoryList;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class InterfaceListener
extends InterfaceASTMListener {
    protected String host_fil_codigo = null;
    protected String host_req_codigo = null;
    protected String host_rec_codigo = null;
    protected boolean hostQuery = false;
    protected List<InfoExameRequisicao> examesEnviados = new ArrayList<InfoExameRequisicao>();
    private List<String> tubos = new ArrayList<String>();
    private InterfaceConfiguracao configuracao = new InterfaceConfiguracao();
    private ThreadRecebimento threadRecebimento = new ThreadRecebimento();

    public InterfaceListener() {
        RecordParser record = new RecordParser();
        record.setInterfaceASTMListener(this);
        super.setASTMRecordParser(record);
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        this.configuracao.setXmlVariaveis(c.getVariaveisConfiguracao());
    }

    @Override
    public String getErroTraduzido(String erro) {
        return erro;
    }

    @Override
    public void responderRequest(String starting_range, String ending_range, String test_id) {
        try {
            if (starting_range.indexOf("^") >= 0) {
                starting_range = starting_range.substring(starting_range.indexOf("^") + 1);
            }
            this.hostQuery = true;
            if (Funcoes.textoVazio(starting_range)) {
                this.fireExcecaoEncontrada(String.format("Amostra com o c\u00f3digo fora do padr\u00e3o %s ", starting_range));
                return;
            }
            if (starting_range.length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                this.fireExcecaoEncontrada(String.format("Amostra com o c\u00f3digo fora do padr\u00e3o %s ", starting_range));
                return;
            }
            this.tubos.add(starting_range);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Selectra Flexor: Host Query Response");
        }
    }

    private void enviaProximaAmostra() {
        String amostra = this.tubos.remove(0);
        this.host_fil_codigo = amostra.substring(0, ParametrosGerais.getDigitosTuboFilial());
        amostra = amostra.substring(ParametrosGerais.getDigitosTuboFilial());
        this.host_req_codigo = amostra.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
        this.host_rec_codigo = amostra.substring(ParametrosGerais.getDigitosTuboRequisicao());
        this.hostQuery = true;
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao, HashMap<String, String> mapaParametros) {
        return this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rackposition, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames, acao);
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao) {
        try {
            this.tx_list.clear();
            this.rx_list.clear();
            this.req_codigo = req_codigo;
            this.fil_codigo = fil_codigo;
            this.int_codigo = int_codigo;
            this.pac_nome = pac_nome;
            this.pac_sexo = pac_sexo;
            this.req_idade = pac_idade;
            this.req_data = data;
            this.req_hora = hora;
            this.mco_codigo = mco_codigo;
            this.rec_codigo = rec_codigo;
            this.pac_exames = pac_exames;
            this.exames = pac_exames.split(" ", 0);
            this.ultima_acao = acao;
            this.curva = false;
            this.rec_tuboPai = "";
            this.examesFilho = new LinkedList();
            ExameMaterial[] alternativos = null;
            Object listaCurva = null;
            Map<String, List<ExameMaterial>> alternativosCurva = null;
            String short_name = StringUtil.removerAcentos(pac_nome);
            if (short_name.length() > this.MAX_PATIENT_NAME_CHARS) {
                short_name = short_name.substring(0, this.MAX_PATIENT_NAME_CHARS);
            }
            Date dateNascPac = BDUtil.getDataNacimentoPaciente(fil_codigo, req_codigo);
            String dtNascPac = "";
            if (dateNascPac != null) {
                dtNascPac = Funcoes.formataData("yyyyMMdd", dateNascPac);
            }
            fil_codigo = StringUtil.preencheString(fil_codigo, ParametrosGerais.getDigitosTuboFilial(), '0', 1);
            StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo);
            rec_codigo = StringUtil.preencheString(rec_codigo, ParametrosGerais.getDigitosTuboTubo(), '0', 1);
            codigo.append(rec_codigo);
            StringBuilder sample_id = new StringBuilder(fil_codigo).append(req_codigo);
            Statement st = Conexao.getStatement();
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(this.exames, mco_codigo);
            String tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, exa_lista[0].getString(), exa_lista[0].getCodigo().toString(), int_codigo);
            ArrayList<ExameMaterial> exa_listaCurva = new ArrayList<ExameMaterial>();
            exa_lista = ExamesUtil.separaExamesCurva(fil_codigo, int_codigo, mco_codigo, exa_lista, exa_listaCurva);
            if (exa_lista != null) {
                exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_lista);
            } else {
                exa_lista = ExamesUtil.anexarCodigoMaterial(this.exames, mco_codigo);
                if (this.hostQuery) {
                    this.rec_tuboPai = BDUtil.getExameDesmembradoTuboPai(fil_codigo, req_codigo, rec_codigo, int_codigo, exa_lista[0].getNomeExame(), mco_codigo);
                }
                exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_listaCurva.toArray(new ExameMaterial[exa_listaCurva.size()]));
            }
            alternativos = ExamesUtil.getAlternativos(st, fil_codigo, int_codigo, exa_lista);
            alternativos = ExamesUtil.removeDuplicados(alternativos);
            if (!exa_listaCurva.isEmpty()) {
                if (alternativos != null && alternativos.length == 1) {
                    alternativos = null;
                }
                alternativosCurva = ExamesUtil.getAlternativosCurva(fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, st, exa_listaCurva, this.rec_tuboPai, this.hostQuery, this.examesFilho);
            }
            String nome = short_name;
            StringBuilder frame = new StringBuilder();
            String t = "";
            if (alternativos != null && alternativos.length > 0) {
                frame.append(ASTMStandard.getDefaultHeaderRecord(this.DELIMITERS, this.PASSWORD, this.HOST_NAME, this.HOST_SYSTEM_VERSION, null, this.INSTRUMENT_NAME, this.INSTRUMENT_SYSTEM_VERSION));
                t = ASTMStandard.getDefaultPatientRecord(1, "", "", nome, "", pac_sexo, dtNascPac, "");
                frame.append(t);
                int seq = 0;
                if (alternativos != null && alternativos.length > 0) {
                    t = this.getOrderRecord(++seq, codigo.toString(), rackposition, alternativos, "R", "N", tipo_amostra, "O");
                    frame.append(t);
                }
                t = "L|1\r";
                frame.append(t);
            } else if (alternativosCurva != null && alternativosCurva.size() > 0) {
                for (String key : alternativosCurva.keySet()) {
                    frame.append(ASTMStandard.getDefaultHeaderRecord(this.DELIMITERS, this.PASSWORD, this.HOST_NAME, this.HOST_SYSTEM_VERSION, null, this.INSTRUMENT_NAME, this.INSTRUMENT_SYSTEM_VERSION));
                    t = ASTMStandard.getDefaultPatientRecord(1, "", "", nome, "", pac_sexo, dtNascPac, "");
                    frame.append(t);
                    int seq = 0;
                    String cod = fil_codigo + req_codigo;
                    this.curva = true;
                    sample_id.setLength(0);
                    sample_id.append(cod);
                    String tubo = Funcoes.preencheZero(key, ParametrosGerais.getDigitosTuboTubo());
                    t = this.getOrderRecord(++seq, sample_id.append(tubo).toString(), rackposition, alternativosCurva.get(key).toArray(new ExameMaterial[alternativosCurva.get(key).size()]), "R", "N", tipo_amostra, "O");
                    frame.append(t);
                    t = "L|1\r";
                    frame.append(t);
                }
            }
            this.tx_list.add(frame.toString());
            this.tx_list = this.makeFrames(this.tx_list);
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            this.getPortaCOM().write(String.valueOf('\u0005'));
            this.hostQuery = false;
            InfoExameRequisicao infoExame = new InfoExameRequisicao(fil_codigo, req_codigo, mco_codigo, rec_codigo, pac_nome, pac_idade, pac_sexo, data, hora, pac_exames);
            infoExame.setInterface(int_codigo);
            infoExame.setTuboPai(this.rec_tuboPai);
            infoExame.setExamesFilho(StringUtil.implode(this.examesFilho, " "));
            infoExame.setCurva(this.curva);
            this.examesEnviados.add(infoExame);
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            this.hostQuery = false;
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    @Override
    protected void tratarEndOfTX() throws Exception {
        super.tratarEndOfTX();
        if (this.hostQuery && this.tubos.size() == 0) {
            this.enviarRequisicaoSemExame("", "");
            this.hostQuery = false;
        }
        if (this.hostQuery && this.tubos.size() > 0) {
            this.enviaProximaAmostra();
            this.responseHostQuery();
        }
    }

    @Override
    protected void tratarAcknowledge() throws Exception {
        if (this.isTX()) {
            if (!this.tx_list.isEmpty() && this.tx_list.getUltimoLido() == this.tx_list.size() - 1) {
                this.encerrarTransmissao();
                if (this.tubos.size() > 0) {
                    this.enviaProximaAmostra();
                    this.responseHostQuery();
                }
            } else {
                this.enviarProximoFrame();
            }
        } else if (!this.isRX()) {
            this.caracterNaoEsperado();
        } else {
            this.caracterNaoEsperado();
        }
    }

    @Override
    public String parse(String message) {
        try {
            String checksum = null;
            String termination = null;
            int stx_index = message.indexOf(this.getMsgStart());
            if (stx_index >= 0 && message.length() > 5) {
                if (stx_index > 0) {
                    message = message.substring(stx_index);
                } else if (stx_index < 0) {
                    return "Erro no bloco enviado pelo equipamento";
                }
            } else {
                return "Erro no bloco enviado pelo equipamento";
            }
            message = message.substring(1, message.length() - 2);
            checksum = message.substring(message.length() - 2);
            termination = message.substring(message.length() - 3, message.length() - 2);
            message = message.substring(0, message.length() - 2);
            if (this.checkCRC(message, checksum)) {
                if (this.middleFrame && this.rx_list.getUltimoInserido() <= this.rx_list.size()) {
                    message = (String)this.rx_list.get(this.rx_list.getUltimoInserido()) + message;
                    this.rx_list.remove(this.rx_list.getUltimoInserido());
                    this.middleFrame = false;
                }
                if (message.contains(String.valueOf('\r'))) {
                    String[] tmp;
                    for (String s : tmp = message.split(String.format("[%s]", Character.valueOf('\r')))) {
                        if (s.length() <= 1) continue;
                        this.rx_list.add(s);
                    }
                } else {
                    this.rx_list.add(message);
                }
                if (termination.equalsIgnoreCase(this.getMiddleFrameEnd())) {
                    this.middleFrame = true;
                    return "";
                }
                this.rx_list = (MemoryList)ListUtil.removeItemIgual(this.rx_list);
                while (!this.rx_list.isEmpty()) {
                    String s = (String)this.rx_list.remove(0);
                    this.recordParser.recordFound(s);
                }
                Conexao.arquivaSQL();
                RefreshTimer.waitAndRefresh(this, this.TIME_TO_REFRESH);
                return "";
            }
            this.rx_list.clear();
            return "Erro ao receber bloco de dados: CRC incompat\u00edvel!";
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(null, ex.toString(), ex.getStackTrace(), "AbstractASTMInterfaceamento: parse");
            this.rx_list.clear();
            this.interromperTimer();
            this.setIdle();
            try {
                Conexao.anulaSQL();
                return "Erro ao analisar dados recebidos do equipamento.";
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o SQL em parse");
                return "Erro ao analisar dados recebidos do equipamento. Podem haver dados inconsistentes no BD.";
            }
        }
    }

    public void responseHostQuery() {
        try {
            List<Object[]> reqs;
            String fil_codigo = this.host_fil_codigo;
            String req_codigo = this.host_req_codigo;
            String rec_codigo = this.host_rec_codigo;
            String pac_nome = null;
            String pac_sexo = null;
            String pac_idade = null;
            String data = null;
            String hora = null;
            String rack = null;
            String prioridade = null;
            String int_codigo = null;
            String mco_codigo = null;
            String pac_exames = null;
            String acao = "A";
            Object[] req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 0);
            PanelAbaAbstrata aba = this.equipamento.getTab(0);
            if (req != null) {
                pac_exames = (String)req[aba.getColIndice("Exame")];
            }
            if (req == null) {
                req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                aba = this.equipamento.getTab(1);
                if (Funcoes.textoVazio(pac_exames) && req != null && aba != null) {
                    pac_exames = (String)req[aba.getColIndice("Exame")];
                }
                if (req != null) {
                    pac_exames = pac_exames + " ";
                    reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                    for (Object[] r : reqs) {
                        pac_exames = pac_exames + (String)r[aba.getColIndice("Exame")] + " ";
                    }
                    pac_exames = pac_exames.trim();
                }
            }
            if (req == null && (req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2)) != null) {
                aba = this.equipamento.getTab(2);
                if (Funcoes.textoVazio(pac_exames)) {
                    pac_exames = (String)req[aba.getColIndice("Exame")];
                }
                if (req != null) {
                    pac_exames = pac_exames + " ";
                    reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2);
                    for (Object[] r : reqs) {
                        pac_exames = pac_exames + (String)r[aba.getColIndice("Exame")] + " ";
                    }
                    pac_exames = pac_exames.trim();
                }
            }
            this.host_fil_codigo = null;
            this.host_req_codigo = null;
            this.host_rec_codigo = null;
            if (req != null) {
                pac_nome = aba.getColIndice("Paciente") >= 0 ? (String)req[aba.getColIndice("Paciente")] : null;
                pac_sexo = aba.getColIndice("S") >= 0 ? (String)req[aba.getColIndice("S")] : null;
                data = aba.getColIndice("Data") >= 0 ? (String)req[aba.getColIndice("Data")] : null;
                hora = aba.getColIndice("Hora") >= 0 ? (String)req[aba.getColIndice("Hora")] : null;
                rack = aba.getColIndice("Rack") >= 0 ? (String)req[aba.getColIndice("Rack")] : null;
                int_codigo = aba.getColIndice("Interface") >= 0 ? (String)req[aba.getColIndice("Interface")] : null;
                mco_codigo = aba.getColIndice("C\u00f3d. Mat.") >= 0 ? (String)req[aba.getColIndice("C\u00f3d. Mat.")] : null;
                this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rack, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames, acao);
            } else {
                this.tx_list.add(ASTMStandard.getDefaultHeaderRecord(this.DELIMITERS, this.PASSWORD, this.HOST_NAME, this.HOST_SYSTEM_VERSION, null, this.INSTRUMENT_NAME, this.INSTRUMENT_SYSTEM_VERSION));
                this.tx_list.add(ASTMStandard.getDefaultTerminationRecord("I"));
                this.tx_list = this.makeFrames(this.tx_list);
                this.tx_list.resetUltimoLido();
                this.setTX(this.TIME_TX);
                this.tx_counter = 0;
                this.getPortaCOM().write(String.valueOf('\u0005'));
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Selectra Flexor: Host Query Response");
        }
    }

    private void enviarRequisicaoSemExame(String fil_codigo, String req_codigo) {
        try {
            if (this.tx_list == null) {
                this.tx_list = new MemoryList();
            }
            if (this.rx_list == null) {
                this.rx_list = new MemoryList();
            }
            this.tx_list.add(ASTMStandard.getDefaultHeaderRecord(this.DELIMITERS, this.PASSWORD, this.HOST_NAME, this.HOST_SYSTEM_VERSION, null, this.INSTRUMENT_NAME, this.INSTRUMENT_SYSTEM_VERSION));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o cabe\u00e7alho de envio");
            }
            this.tx_list.add(ASTMStandard.getDefaultTerminationRecord("I"));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o rodap\u00e9 de envio");
            }
            this.tx_list = this.makeFrames(this.tx_list);
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            this.getPortaCOM().write(String.valueOf('\u0005'));
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: envio de requisi\u00e7\u00e3o");
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o em envio de requisi\u00e7\u00e3o");
            }
        }
    }

    @Override
    protected void encerrarTransmissao() throws Exception {
        while (!this.examesEnviados.isEmpty()) {
            this.encerrarTransmissao(this.examesEnviados.remove(0));
        }
        this.interromperTimer();
        this.getPortaCOM().write(String.valueOf('\u0004'));
        this.getPortaCOM().clearInputString();
        if (this.ultima_acao.equals("N")) {
            this.firePacienteEnviado(this.req_codigo, this.pac_nome, this.pac_sexo, this.req_idade, this.req_data, this.req_hora, this.pac_exames);
        }
        this.limpaDadosRequisicao();
        this.fireAtualizarTabela(0);
        this.setIdle();
    }

    private void encerrarTransmissao(InfoExameRequisicao infoExame) throws Exception {
        Statement st = Conexao.getStatement();
        if (infoExame != null) {
            String[] exames = infoExame.getExames().split(" ");
            String fil_codigo = infoExame.getFilial();
            String int_codigo = infoExame.getInterface();
            String req_codigo = infoExame.getCodigo();
            String mco_codigo = infoExame.getMaterial();
            String rec_tuboPai = infoExame.getTuboPai();
            String rec_codigo = infoExame.getRecipiente();
            boolean curva = infoExame.isCurva();
            for (int i = 0; i < exames.length; ++i) {
                int situacao;
                String[] examesFilho = infoExame.getExamesFilho().split(" ");
                if (!Funcoes.textoVazio(rec_tuboPai) && curva && examesFilho != null && examesFilho.length > 0) {
                    for (String exame : examesFilho) {
                        int situacao2 = BDUtil.getDesmSituacao(fil_codigo, int_codigo, req_codigo, exames[i], mco_codigo, rec_tuboPai, exame, mco_codigo);
                        BDUtil.setExmSituacaoFilho(st, fil_codigo, int_codigo, req_codigo, exames[i], mco_codigo, exame, mco_codigo, rec_tuboPai, situacao2 < 2 ? 1 : 3);
                    }
                    situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exames[i], mco_codigo, rec_codigo);
                    if (!BDUtil.isGrupoInteiroPendente(fil_codigo, int_codigo, req_codigo, exames[i], mco_codigo, rec_tuboPai)) continue;
                    this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_tuboPai, exames[i], mco_codigo, int_codigo, null, situacao < 2 ? 1 : 3);
                    continue;
                }
                if (examesFilho != null && examesFilho.length > 0) {
                    situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exames[i], mco_codigo, rec_codigo);
                    this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exames[i], mco_codigo, int_codigo, null, situacao < 2 ? 1 : 3);
                    BDUtil.setExmSituacaoTodosFilhos(st, fil_codigo, int_codigo, req_codigo, exames[i], mco_codigo, rec_codigo, situacao < 2 ? 1 : 3);
                    continue;
                }
                situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exames[i], mco_codigo, rec_codigo);
                this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exames[i], mco_codigo, int_codigo, null, situacao < 2 ? 1 : 3);
            }
            Conexao.arquivaSQL();
            String acao = this.ultima_acao.equals("C") ? "excluido(s)" : "enviado(s)";
            this.fireMensagemEnviada("Exame(s) " + acao + " com sucesso para " + this.pac_nome, 0, 10000);
        } else {
            this.fireMensagemEnviada("Nenhum exame localizado para encerrar para " + this.pac_nome, 0, 10000);
        }
        if (this.ultima_acao.equals("N")) {
            this.firePacienteEnviado(infoExame.getCodigo(), infoExame.getNome(), infoExame.getSexo(), infoExame.getIdade(), infoExame.getData(), infoExame.getHora(), infoExame.getExames());
        }
    }

    protected String getOrderRecord(int order_sequence, String sample_id, String sample_id_type, ExameMaterial[] test_item_numbers, String priority, String action_code, String sample_type, String report_type) {
        StringBuilder record = new StringBuilder("O|");
        record.append(order_sequence);
        record.append("|");
        record.append(sample_id == null ? "" : sample_id);
        record.append("|");
        record.append(sample_id_type == null ? "" : sample_id_type);
        record.append("|");
        if (test_item_numbers != null && test_item_numbers[0] != null) {
            record.append("^^^");
            record.append(test_item_numbers[0].getNomeExame());
            for (int i = 1; i < test_item_numbers.length; ++i) {
                if (test_item_numbers[i] == null) continue;
                record.append("\\^^^");
                record.append(test_item_numbers[i].getNomeExame());
            }
        }
        record.append("|");
        record.append(priority == null ? "" : priority);
        record.append("|").append(ASTMStandard.getCurrentMoment());
        record.append("|||||");
        record.append(action_code == null ? "" : action_code);
        record.append("||||");
        record.append(sample_type == null ? "" : sample_type);
        record.append("||||||||||");
        record.append(report_type == null ? "" : report_type);
        record.append("|");
        record.append('\r');
        return record.toString();
    }

    @Override
    public void dataChanged() {
        try {
            String message = this.getPortaCOM().getInputString();
            if (message.length() == 2 && message.equals(String.valueOf('\u0004') + String.valueOf('\u0005'))) {
                if (this.hostQuery) {
                    this.handShakeCharReceived('\u0004');
                    return;
                }
                this.getPortaCOM().write(String.valueOf('\u0006'));
            }
            if (!(message = this.getPortaCOM().removeInputString(this.getMsgEnd())).equals("")) {
                this.addListaRecebimento(message);
                this.restartThreadRecebimento();
                this.getPortaCOM().write(String.valueOf('\u0006'));
                if (this.isRX()) {
                    this.aguardarProximoFrame();
                }
            } else if (this.isRX()) {
                this.aguardarProximoFrame();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: evento de dados recebidos");
            this.fireMensagemEnviada("Erro ao receber dados do equipamento: " + ex.getMessage(), 1, 5000);
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private void addListaRecebimento(String message) {
        this.threadRecebimento.addListaRecebimento(message);
        this.restartThreadRecebimento();
    }

    private void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            ArrayList<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento();
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        if (this.threadRecebimento != null) {
            this.threadRecebimento.start();
        }
    }

    @Override
    public void teste() {
        String req = "010000250104";
        this.handShakeCharReceived('\u0006');
        this.handShakeCharReceived('\u0006');
        this.handShakeCharReceived('\u0006');
        this.handShakeCharReceived('\u0006');
        this.handShakeCharReceived('\u0006');
        this.handShakeCharReceived('\u0006');
        this.handShakeCharReceived('\u0006');
        this.handShakeCharReceived('\u0006');
    }

    class ThreadRecebimento
    extends Thread {
        private ArrayList<String> listaRecebimento = new ArrayList();

        ThreadRecebimento() {
        }

        public ArrayList<String> getListaRecebimento() {
            return this.listaRecebimento;
        }

        public void addListaRecebimento(String message) {
            this.listaRecebimento.add(message);
        }

        public void addListaRecebimentos(ArrayList<String> messages) {
            this.listaRecebimento.addAll(messages);
        }

        @Override
        public void run() {
            try {
                while (this.listaRecebimento.size() > 0) {
                    String message = this.listaRecebimento.remove(0);
                    String resultado = InterfaceListener.this.parse(message);
                    if (resultado != null) {
                        InterfaceListener.this.fireMensagemEnviada(resultado, 0, 10000);
                    }
                    ThreadRecebimento.sleep(1000L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

