/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.selectrae;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.exames.InfoExameRequisicao;
import jalis.laboratorio.interfaceamento.interfaces.selectrae.InterfaceConfiguracao;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.util.ArraysUtil;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    protected static final int MAX_PATIENT_NAME_CHARS = 20;
    static final int TEMPO_PAUSA = 1000;
    public static final char MSG_TYPE_SHORT_RESULT = 'R';
    public static final char MSG_TYPE_EXTENDED_RESULT = 'X';
    public static final char MSG_TYPE_BLANK_RESULT = 'B';
    public static final char MSG_TYPE_ECHO_REQUEST = 'E';
    public static final char MSG_TYPE_ECHO_ANSWER = 'e';
    public static final char MSG_TYPE_VERSION_REQUEST = 'V';
    public static final char MSG_TYPE_VERSION_ANSWER = 'v';
    public static final char MSG_TYPE_REAGENT_INSTALL = 'I';
    public static final char MSG_TYPE_REAGENT_REQUEST = 'I';
    public static final char MSG_TYPE_REAGENT_ANSWER = 'i';
    public static final char MSG_TYPE_SAMPLE_REQUEST = 'Q';
    public static final char MSG_TYPE_SAMPLE_ANSWER = 'q';
    public static final char MSG_TYPE_DELETE_REQUEST = 'D';
    public static final char MSG_TYPE_DELETE_ANSWER = 'd';
    public static final char MSG_TYPE_RESULT_REQUEST = 'R';
    public static final char MSG_TYPE_RESULT_ANSWER = 'r';
    public static final char MSG_TYPE_REAGENT_COUNTERS_REQUEST = 'N';
    public static final char MSG_TYPE_REAGENT_COUNTERS_ANSWER = 'n';
    public static final char PRIORIDADE_NORMAL = 'N';
    public static final char PRIORIDADE_STAT = 'E';
    public static final char PRIORIDADE_PEDIATRIC = 'P';
    public static final char RESULT_TYPE_NORMAL = 'N';
    public static final char RESULT_TYPE_STAT = 'E';
    public static final char RESULT_TYPE_PEDIATRIC = 'P';
    public static final char RESULT_TYPE_CONTROL = 'C';
    public static final char RESULT_TYPE_CALIBRATOR = 'S';
    public static final char RESULT_TYPE_BLANK = 'B';
    public static final String STATUS_SUCCESS = "0";
    public static final String STATUS_SUCCESS_READY = "0";
    public static final String STATUS_SUCCESS_LOADED = "1";
    public static final String STATUS_SAMPLE_MISMATCH = "1";
    public static final String STATUS_STILL_IN_BUFFER = "2";
    public static final String STATUS_WORKLIST_IS_FULL = "2";
    public static final String STATUS_TEST_UNAVAILABLE = "3";
    public static final String STATUS_SAMPLE_NOT_FOUND = "3";
    public static final String STATUS_MSG_LENGTH_ERROR = "7";
    public static final String STATUS_OVERRUN_ERROR = "8";
    public static final String STATUS_FRAMING_ERROR = "9";
    ArrayList<String> testes = new ArrayList();
    ArrayList<Integer> reagentes = new ArrayList();
    protected InfoExameRequisicao ultimoEnviado = new InfoExameRequisicao(null, null, null, null, null, null, null, null, null, null);
    InfoExameRequisicao ultimoAExcluir = new InfoExameRequisicao(null, null, null, null, null, null, null, null, null, null);
    protected String ultimoEnviadoAcao = null;
    protected String[] pacExames;
    private ThreadRecebimento threadRecebimento = new ThreadRecebimento();
    protected InterfaceConfiguracao configuracao = new InterfaceConfiguracao();

    public InterfaceListener() {
        this(false);
    }

    public InterfaceListener(boolean requestReagente) {
        try {
            ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
            this.configuracao.setXmlVariaveis(c.getVariaveisConfiguracao());
            if (requestReagente) {
                this.requestReagentInstallation();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getMsgEnd() {
        return String.valueOf(String.valueOf('\u0003') + LINE);
    }

    @Override
    public String getMsgStart() {
        return String.valueOf('\u0002');
    }

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
        if (this.isTX()) {
            this.fireMensagemEnviada("Tempo esgotado ao enviar requisi\u00e7\u00e3o ao equipamento", 1, 5000);
        }
        this.getPortaCOM().flush();
        this.getPortaCOM().clearInputString();
        this.setIdle();
    }

    private void enviaBloco(StringBuilder message) throws IOException {
        this.getPortaCOM().write(message.toString());
    }

    private StringBuilder montaBlocoPadrao(char tipoDoBloco) {
        StringBuilder message = new StringBuilder(this.getMsgStart());
        message.append("{");
        message.append(tipoDoBloco);
        message.append(";}");
        message.append(String.valueOf('\u0003'));
        return message;
    }

    public void requestEcho() throws Exception {
        StringBuilder message = this.montaBlocoPadrao('E');
        this.enviaBloco(message);
    }

    public void requestSoftwareVersion() throws Exception {
        StringBuilder message = this.montaBlocoPadrao('V');
        this.enviaBloco(message);
    }

    public void requestReagentInstallation() throws Exception {
        StringBuilder message = this.montaBlocoPadrao('I');
        this.enviaBloco(message);
    }

    public void requestReagentTestCounters() throws Exception {
        StringBuilder message = this.montaBlocoPadrao('N');
        this.enviaBloco(message);
    }

    /*
     * Exception decompiling
     */
    @Override
    public String enviarRequisicao(String pacNome, String pacSexo, String pacIdade, String data, String hora, String rackposition, String prioridade, String filCodigo, String intCodigo, String reqCodigo, String mcoCodigo, String recCodigo, String exames, String acao) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 17[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ArrayList<String> retornaReagentesExame(ArrayList<String> testes, ArrayList<String> listaReagentes, int i, String filCodigo, String exame, String mcoCodigo, String intCodigo) throws SQLException {
        String exaAlternativo;
        if (testes != null && testes.size() == 32) {
            for (i = 0; i < 32; ++i) {
                listaReagentes.add("0");
            }
        }
        if ((exaAlternativo = BDUtil.getExmCodigoAlternativo(filCodigo, exame, mcoCodigo, intCodigo)) != null && testes != null && testes.contains(exaAlternativo)) {
            int index = testes.indexOf(exaAlternativo);
            listaReagentes.set(index, "1");
        }
        return listaReagentes;
    }

    private boolean existeExames() {
        return this.pacExames != null && this.pacExames.length > 0;
    }

    private boolean validaExameCurva(Map<String, BDExame> examesCurva) {
        return !examesCurva.isEmpty();
    }

    protected boolean validaListaExames(ExameMaterial[] exaLista) {
        return exaLista.length <= 0;
    }

    private boolean verificaExames() {
        return this.pacExames != null;
    }

    private void enviaMessagemEquipamento(String codigo, String shortName, String pacSexo, StringBuilder listaExames, String filCodigo, String reqCodigo) throws SQLException, IOException {
        StringBuilder message = new StringBuilder(this.getMsgStart());
        message.append("{");
        message.append('Q');
        message.append(";");
        message.append(codigo);
        message.append(";");
        message.append('N');
        message.append(";");
        message.append(shortName);
        message.append(";");
        message.append("");
        message.append(";");
        message.append(pacSexo);
        message.append(";");
        if (this.validaNomeMedico()) {
            message.append(BDUtil.buscaMedicoRequisicao(filCodigo, reqCodigo));
            message.append(";");
        }
        message.append(listaExames.toString());
        message.append(";");
        message.append("}");
        message.append(this.getMsgEnd());
        this.getPortaCOM().write(message.toString());
    }

    private boolean validaNomeMedico() {
        return !Funcoes.textoVazio(this.configuracao.getInformarNomeMedico()) && this.configuracao.getInformarNomeMedico().equalsIgnoreCase("1");
    }

    protected Integer[] verificaAgrupaMultiguias(String filCodigo, String reqCodigo) throws SQLException {
        Integer[] multiguias = null;
        multiguias = RecepcaoUtil.verificaMultiGuias(filCodigo, reqCodigo, true);
        boolean agruparMultiguias = this.isAgruparMultiguias(filCodigo, multiguias);
        if (!agruparMultiguias) {
            multiguias = new Integer[]{Integer.parseInt(reqCodigo)};
        }
        return multiguias;
    }

    private boolean isAgruparMultiguias(String filCodigo, Integer[] multiguias) throws SQLException {
        Statement st = Conexao.getStatement();
        boolean agrupaMultiguias = DBUtil.requisicaoAgrupaMultiguiasLabExterno(st, filCodigo, multiguias);
        Conexao.fecharStatement(st);
        return ParametrosGerais.isAgruparGuiasInterface() || agrupaMultiguias;
    }

    public static synchronized ExameMaterial[] getDesmExamesPai(String filCodigo, String intCodigo, String reqCodigo, String exaKodigo, String mcoKodigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select exa_codigo, mco_codigo from ");
        query.append("interfaceexamerequisicaodesm where fil_codigo = ");
        query.append(filCodigo);
        query.append(" and int_codigo = ").append(intCodigo);
        query.append(" and req_codigo = ").append(reqCodigo);
        query.append(" and exa_kodigo = ").append(DBUtil.bdText(exaKodigo));
        query.append(" and mco_codigo = ").append(mcoKodigo);
        query.append(" order by exa_codigo desc");
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        int i = DBUtil.qtdeRegistros(rs);
        ExameMaterial[] pais = new ExameMaterial[i];
        while (rs != null && rs.next()) {
            pais[--i] = new ExameMaterial(rs.getString("exa_codigo"), rs.getInt("mco_codigo"));
        }
        ps.close();
        return pais;
    }

    protected Map<String, BDExame> obtemExamesCurva(String filCodigo, String intCodigo, String reqCodigo, String mcoCodigo, String recCodigo, String codigo, ExameMaterial[] exaLista, Map<String, BDExame> examesCurva) throws SQLException {
        StringBuilder curva = new StringBuilder();
        for (ExameMaterial exa : exaLista) {
            BDExame[] filhos;
            if (!BDUtil.isExameCurva(filCodigo, intCodigo, exa.getNomeExame(), mcoCodigo)) continue;
            curva.append(exa).append(" ");
            for (BDExame bdExame : filhos = BDUtil.getDesmExamesFilhos(filCodigo, intCodigo, reqCodigo, exa.getNomeExame(), mcoCodigo, recCodigo)) {
                String tubo = BDUtil.getExameDesmembradoTubo(filCodigo, reqCodigo, bdExame.getRecipiente(), intCodigo, bdExame.getExame(), mcoCodigo);
                if (!this.validaTubo(tubo)) continue;
                String filialRequisicao = filCodigo + codigo;
                String etiqueta = String.format("%s%s", filialRequisicao, StringUtil.preencheString(tubo, ParametrosGerais.getDigitosTuboTubo(), '0', 1));
                examesCurva.put(etiqueta, new BDExame(reqCodigo, bdExame.getExame(), mcoCodigo, tubo, null));
            }
        }
        if (!Funcoes.textoVazio(curva.toString()) && this.validaExameCurva(examesCurva)) {
            for (String ex : curva.toString().split(" ")) {
                int p = ArraysUtil.indice((Object[])this.pacExames, ex);
                this.pacExames = ArraysUtil.remover(this.pacExames, p);
            }
        }
        return examesCurva;
    }

    private boolean validaTubo(String tubo) {
        return tubo != null;
    }

    public void requestSampleDeletion(String filCodigo, String reqCodigo, String exaCodigo, String mcoCodigo, String recCodigo) throws Exception {
        this.ultimoAExcluir = new InfoExameRequisicao(filCodigo, reqCodigo, mcoCodigo, recCodigo, null, null, null, null, null, exaCodigo);
        filCodigo = StringUtil.preencheString(filCodigo, 2, '0', 1);
        StringBuilder codigo = new StringBuilder(filCodigo).append(reqCodigo);
        recCodigo = StringUtil.preencheString(recCodigo, 2, '0', 1);
        codigo.append(recCodigo);
        reqCodigo = filCodigo + reqCodigo + recCodigo;
        StringBuilder message = new StringBuilder(this.getMsgStart());
        message.append("{");
        message.append('D');
        message.append(";");
        message.append(reqCodigo);
        message.append(";");
        message.append("}");
        message.append(String.valueOf('\u0003'));
        this.getPortaCOM().write(message.toString());
    }

    public void requestSampleResult(String filCodigo, String reqCodigo, String recCodigo) throws Exception {
        filCodigo = StringUtil.preencheString(filCodigo, 2, '0', 1);
        StringBuilder codigo = new StringBuilder(filCodigo).append(reqCodigo);
        recCodigo = StringUtil.preencheString(recCodigo, 2, '0', 1);
        codigo.append(recCodigo);
        reqCodigo = filCodigo + reqCodigo + recCodigo;
        StringBuilder message = new StringBuilder(this.getMsgStart());
        message.append("{");
        message.append('R');
        message.append(";");
        message.append(reqCodigo);
        message.append(";");
        message.append("}");
        message.append(String.valueOf('\u0003'));
        this.getPortaCOM().write(message.toString());
    }

    @Override
    public String parse(String message) {
        this.setRX(2000);
        String retorno = null;
        if (message.startsWith(this.getMsgStart()) && message.endsWith(this.getMsgEnd())) {
            String conteudo = message.substring(2, message.lastIndexOf(";"));
            String[] temp = conteudo.split(";", -1);
            ArrayList<String> campos = new ArrayList<String>();
            Collections.addAll(campos, temp);
            char tipo = ((String)campos.remove(0)).charAt(0);
            switch (tipo) {
                case 'R': {
                    retorno = this.parseShortResult(campos);
                    break;
                }
                case 'X': {
                    retorno = this.parseExtendedResult(campos);
                    break;
                }
                case 'B': {
                    retorno = this.parseBlankResult(campos);
                    break;
                }
                case 'e': {
                    retorno = this.parseEchoAnswer(campos);
                    break;
                }
                case 'v': {
                    retorno = this.parseVersionAnswer(campos);
                    break;
                }
                case 'I': 
                case 'i': {
                    retorno = this.parseReagentAnswer(campos);
                    break;
                }
                case 'q': {
                    retorno = this.parseSampleAnswer(campos);
                    break;
                }
                case 'd': {
                    retorno = this.parseDeleteAnswer(campos);
                    break;
                }
                case 'r': {
                    retorno = this.parseResultAnswer(campos);
                    break;
                }
                case 'n': {
                    retorno = this.parseReagentCountersAnswer(campos);
                    break;
                }
                default: {
                    retorno = null;
                }
            }
        }
        this.setPausa(1000);
        return retorno;
    }

    /*
     * Exception decompiling
     */
    protected String parseShortResult(ArrayList<String> campos) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 11[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    protected String parseExtendedResult(ArrayList<String> campos) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 10[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected String parseBlankResult(ArrayList<String> campos) {
        return null;
    }

    protected String parseEchoAnswer(ArrayList<String> campos) {
        this.fireMensagemEnviada("Resposta de eco recebida com sucesso", 0, 10000);
        return null;
    }

    protected String parseVersionAnswer(ArrayList<String> campos) {
        return null;
    }

    protected String parseReagentAnswer(ArrayList<String> campos) {
        String device_id = campos.remove(0).trim();
        String status = null;
        if (campos.get(0).length() == 1) {
            status = campos.remove(0).trim();
        }
        if (status != null && !status.equals("0")) {
            if (status.equals(STATUS_MSG_LENGTH_ERROR)) {
                this.fireExcecaoEncontrada("Erro nos dados requisitados ao equipamento");
            } else if (status.equals(STATUS_OVERRUN_ERROR)) {
                this.fireExcecaoEncontrada("Erro de dados sobrepostos (velocidade)");
            } else if (status.equals(STATUS_FRAMING_ERROR)) {
                this.fireExcecaoEncontrada("Erro de paridade, bloco ou interrup\u00e7\u00e3o dos dados");
            }
            return null;
        }
        this.testes.clear();
        for (String t : campos) {
            this.testes.add(t.trim());
        }
        return "Lista de testes/reagentes atualizada";
    }

    protected String parseReagentCountersAnswer(ArrayList<String> campos) {
        return null;
    }

    protected String parseDeleteAnswer(ArrayList<String> campos) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private String parseSampleAnswer(ArrayList<String> campos) {
        block37: {
            block34: {
                block36: {
                    block35: {
                        block38: {
                            block33: {
                                st = Conexao.getStatement();
                                examesCurva /* !! */  = null;
                                recTuboPai = "";
                                deviceId = campos.remove(0).trim();
                                status = campos.remove(0).trim();
                                requisicao = campos.remove(0).trim();
                                recCodigo = "";
                                if (requisicao.length() == ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) break block33;
                                this.fireExcecaoEncontrada(String.format("Amostra com o c\u00f3digo fora do padr\u00e3o %s ", new Object[]{requisicao}));
                                var9_11 = "Erro ao receber dados do equipamento";
                                Conexao.fecharStatement(new Statement[]{st});
                                return var9_11;
                            }
                            recCodigo = requisicao.substring(ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
                            if (status == null || status.equalsIgnoreCase("0")) break block34;
                            v0 = excecao = this.ultimoEnviado != null ? new StringBuilder(this.ultimoEnviado.getCodigo()).append("(").append(this.ultimoEnviado.getExames()).append(") - ") : new StringBuilder("Erro: ");
                            if (!status.equals("1")) break block38;
                            excecao.append("Erro: amostra j\u00e1 existe mas dados demogr\u00e1ficos n\u00e3o conferem, ou amostra sendo usada pelo operador!");
                            ** GOTO lbl45
                        }
                        if (!status.equals("2")) break block35;
                        var10_14 = "Worklist se encontra cheio no momento";
                        Conexao.fecharStatement(new Statement[]{st});
                        return var10_14;
                    }
                    if (status.equals("3")) {
                        excecao.append("Erro: teste pedido n\u00e3o se encontra instalado no equipamento");
                    } else if (status.equals("7")) {
                        excecao.append("Erro nos dados requisitados ao equipamento");
                    } else if (status.equals("8")) {
                        excecao.append("Erro de dados sobrepostos (velocidade)");
                    } else if (status.equals("9")) {
                        excecao.append("Erro de paridade, bloco ou interrup\u00e7\u00e3o dos dados");
                    }
lbl45:
                    // 7 sources

                    if (excecao.indexOf("Erro") < 0) break block36;
                    this.fireExcecaoEncontrada(excecao.toString());
                    var10_15 = excecao.toString();
                    Conexao.fecharStatement(new Statement[]{st});
                    return var10_15;
                }
                var10_16 = null;
                Conexao.fecharStatement(new Statement[]{st});
                return var10_16;
            }
            if (this.ultimoEnviado != null) {
                exames = this.ultimoEnviado.getExames().split(" ", 0);
                break block37;
            }
            var10_17 = "Erro ao receber resposta do equipamento";
            Conexao.fecharStatement(new Statement[]{st});
            return var10_17;
        }
        try {
            recTuboPai = this.ultimoEnviado.getRecipiente();
            this.pacExames = exames;
            temp = exames;
            exa_lista = new ExameMaterial[temp.length];
            i = -1;
            for (String t : temp) {
                exa_lista[++i] = new ExameMaterial(t, new Integer(this.ultimoEnviado.getMaterial()));
            }
            multiguias = this.verificaAgrupaMultiguias(this.ultimoEnviado.getFilial(), this.ultimoEnviado.getCodigo());
            examesCurva /* !! */  = new HashMap<String, BDExame>();
            intCodigo = this.getIntCodigo(this.ultimoEnviado.getFilial(), this.ultimoEnviado.getCodigo(), this.ultimoEnviado.getRecipiente(), exames[0]);
            for (Integer multiguia : multiguias) {
                if (exames == null) continue;
                exa_lista = InterfaceListener.getDesmExamesPai(this.ultimoEnviado.getFilial(), intCodigo, multiguia.toString(), exames[0], this.ultimoEnviado.getMaterial());
                if (this.validaListaExames(exa_lista)) {
                    exa_lista = ExamesUtil.anexarCodigoMaterial(exames, this.ultimoEnviado.getMaterial());
                }
                codigo = new StringBuilder(this.ultimoEnviado.getFilial()).append(this.ultimoEnviado.getCodigo());
                examesCurva /* !! */  = this.obtemExamesCurva(this.ultimoEnviado.getFilial(), intCodigo, multiguia.toString(), this.ultimoEnviado.getMaterial(), this.ultimoEnviado.getRecipiente(), codigo.toString(), exa_lista, examesCurva /* !! */ );
            }
            for (String exame : exames) {
                filCodigo = this.ultimoEnviado.getFilial();
                reqCodigo = this.ultimoEnviado.getCodigo();
                mcoCodigo = this.ultimoEnviado.getMaterial();
                codRequisicao = this.ultimoEnviado.getRecipiente();
                if (Funcoes.textoVazio(intCodigo)) {
                    intCodigo = this.getIntCodigo(filCodigo, reqCodigo, codRequisicao, exame, mcoCodigo);
                }
                if (!examesCurva /* !! */ .isEmpty()) {
                    for (String key : examesCurva /* !! */ .keySet()) {
                        bdExame = (BDExame)examesCurva /* !! */ .get(key);
                        if (!Funcoes.textoVazio(bdExame.getExame()) && !Funcoes.textoVazio(bdExame.getMaterial())) {
                            situacao = BDUtil.getDesmSituacao(filCodigo, intCodigo, reqCodigo, exame, mcoCodigo, recTuboPai, bdExame.getExame(), bdExame.getMaterial());
                            if (Funcoes.preencheZero(bdExame.getRecipiente(), ParametrosGerais.getDigitosTuboTubo()).equals(recCodigo)) {
                                BDUtil.setExmSituacaoFilho(st, filCodigo, intCodigo, reqCodigo, exame, mcoCodigo, bdExame.getExame(), bdExame.getMaterial(), recTuboPai, situacao < 2 ? 1 : 3);
                            }
                            atual = this.getExameSituacao(st, filCodigo, intCodigo, reqCodigo, exame, mcoCodigo, codRequisicao);
                            this.atualizarSituacaoExame(st, filCodigo, reqCodigo, recCodigo, bdExame.getExame(), bdExame.getMaterial(), intCodigo, null, atual < 2 ? 1 : 3);
                            if (situacao > 2) {
                                this.fireAtualizarTabela(2);
                            }
                        }
                        situacao = this.getExameSituacao(st, filCodigo, intCodigo, reqCodigo, exame, mcoCodigo, codRequisicao);
                        if (!BDUtil.isGrupoInteiroPendente(filCodigo, intCodigo, reqCodigo, exame, mcoCodigo, recTuboPai)) continue;
                        this.atualizarSituacaoExame(st, filCodigo, reqCodigo, recTuboPai, exame, mcoCodigo, intCodigo, null, situacao < 2 ? 1 : 3, true);
                        if (situacao <= 2) continue;
                        this.fireAtualizarTabela(2);
                    }
                } else {
                    atual = this.getExameSituacao(st, filCodigo, intCodigo, reqCodigo, exame, mcoCodigo, codRequisicao);
                    this.atualizarSituacaoExame(st, filCodigo, reqCodigo, codRequisicao, exame, mcoCodigo, intCodigo, null, atual < 2 ? 1 : 3);
                    if (atual > 2) {
                        this.fireAtualizarTabela(2);
                    }
                }
                if (BDUtil.isGrupoInteiroPendente(filCodigo, intCodigo, reqCodigo, exame, mcoCodigo, recTuboPai)) {
                    atual = this.getExameSituacao(st, filCodigo, intCodigo, reqCodigo, exame, mcoCodigo, codRequisicao);
                    this.atualizarSituacaoExame(st, filCodigo, reqCodigo, codRequisicao, exame, mcoCodigo, intCodigo, null, atual < 2 ? 1 : 3);
                    if (atual > 2) {
                        this.fireAtualizarTabela(2);
                    }
                }
                if (!reqCodigo.equals(this.ultimoEnviado.getCodigo()) || !this.ultimoEnviadoAcao.equals("N")) continue;
                this.firePacienteEnviado(this.ultimoEnviado.getCodigo(), this.ultimoEnviado.getNome(), this.ultimoEnviado.getSexo(), this.ultimoEnviado.getIdade(), this.ultimoEnviado.getData(), this.ultimoEnviado.getHora(), this.ultimoEnviado.getExames());
            }
            Conexao.arquivaSQL();
            this.fireAtualizarTabela(0);
            var15_25 /* !! */  = "Exame enviado com sucesso para " + this.ultimoEnviado.getNome();
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            this.anularSQL();
            var4_6 = "Erro ao analisar resposta de exame requisitado";
            Conexao.fecharStatement(new Statement[]{st});
            return var4_6;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            var4_6 = "Erro ao analisar resposta de exame requisitado";
            {
                catch (Throwable var28_41) {
                    Conexao.fecharStatement(new Statement[]{st});
                    throw var28_41;
                }
            }
            Conexao.fecharStatement(new Statement[]{st});
            return var4_6;
        }
        Conexao.fecharStatement(new Statement[]{st});
        return var15_25 /* !! */ ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected String parseResultAnswer(ArrayList<String> campos) {
        String string;
        String string2;
        String codRequisicao;
        String filCodigo;
        String reqCodigo;
        String retorno;
        Statement st;
        block27: {
            String status;
            block26: {
                block25: {
                    st = Conexao.getStatement();
                    retorno = null;
                    String deviceId = campos.remove(0).trim();
                    status = campos.remove(0).trim();
                    reqCodigo = campos.remove(0).trim();
                    try {
                        Long.parseLong(reqCodigo);
                    }
                    catch (Exception ex) {
                        StringBuilder msg2 = new StringBuilder();
                        msg2.append("Resultados recebidos para requisi\u00e7\u00e3o n\u00e3o existente ou n\u00e3o interfaceada: ");
                        msg2.append(reqCodigo);
                        this.fireExcecaoEncontrada(msg2.toString());
                        String string3 = msg2.toString();
                        Conexao.fecharStatement(st);
                        return string3;
                    }
                    if (reqCodigo.length() == ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) break block25;
                    StringBuilder msg = new StringBuilder();
                    msg.append("Resultados recebidos para requisi\u00e7\u00e3o n\u00e3o existente ou n\u00e3o interfaceada: ");
                    msg.append(reqCodigo);
                    this.fireExcecaoEncontrada(msg.toString());
                    String msg2 = null;
                    Conexao.fecharStatement(st);
                    return msg2;
                }
                filCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
                codRequisicao = reqCodigo.substring(reqCodigo.length() - ParametrosGerais.getDigitosTuboTubo());
                reqCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboFilial(), reqCodigo.length() - ParametrosGerais.getDigitosTuboTubo());
                if (!filCodigo.equals("00") && !codRequisicao.equals("00")) break block26;
                String string4 = null;
                Conexao.fecharStatement(st);
                return string4;
            }
            if (status == null || status.equals("0") || status.equals("1")) break block27;
            StringBuilder excecao = new StringBuilder(reqCodigo).append(" - ");
            if (status.equals("2")) {
                excecao.append("Erro: amostra ainda se encontra na fila de espera");
            } else if (status.equals("3")) {
                excecao.append("Erro: amostra n\u00e3o encontrada");
            } else if (status.equals(STATUS_MSG_LENGTH_ERROR)) {
                excecao.append("Erro nos dados requisitados ao equipamento");
            } else if (status.equals(STATUS_OVERRUN_ERROR)) {
                excecao.append("Erro de dados sobrepostos (velocidade)");
            } else if (status.equals(STATUS_FRAMING_ERROR)) {
                excecao.append("Erro de paridade, bloco ou interrup\u00e7\u00e3o dos dados");
            }
            if (!excecao.equals(new StringBuilder(reqCodigo).append(" - "))) {
                this.fireExcecaoEncontrada(excecao.toString());
            }
            String string5 = excecao.toString();
            Conexao.fecharStatement(st);
            return string5;
        }
        try {
            String prioridade = campos.remove(0).trim();
            String pacNome = campos.remove(0).trim();
            String pacDatanasc = campos.remove(0).trim();
            String pacSexo = campos.remove(0).trim();
            for (int numTestes = Integer.parseInt(campos.remove(0).trim()); numTestes > 0; --numTestes) {
                String emiAlternativo = campos.remove(0).trim().toUpperCase();
                String ersResultado = campos.remove(0).trim();
                String flags = campos.remove(0).trim();
                String unidades = campos.remove(0).trim();
                this.parseFlagsExcecoes(reqCodigo, emiAlternativo, flags.trim());
                String intCodigo = this.getIntCodigo(filCodigo, reqCodigo, codRequisicao, emiAlternativo);
                ExameMaterial exame = this.getReqExameLIS(filCodigo, intCodigo, reqCodigo, codRequisicao, emiAlternativo);
                if (exame == null) {
                    this.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emiAlternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + filCodigo + " " + reqCodigo + " " + codRequisicao);
                    continue;
                }
                if (!ersResultado.equals("-------")) {
                    this.atualizarResultadoExame(st, filCodigo, reqCodigo, codRequisicao, exame.getNomeExame(), exame.getCodigoMaterial(), intCodigo, ersResultado.replaceAll("\\.", ","));
                    continue;
                }
                retorno = "O exame " + exame + " para " + pacNome + " ainda n\u00e3o possui resultado";
            }
            Conexao.arquivaSQL();
            this.fireAtualizarTabela();
            string2 = retorno;
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            this.anularSQL();
            string = "Erro ao realizar parse de resultado recebido";
            Conexao.fecharStatement(st);
            return string;
        }
        catch (Exception ex2) {
            ErrorLogger.mostraMensagem(null, ex2.getMessage(), ex2.getStackTrace());
            string = "Erro ao realizar parse de resultado de recebido";
            {
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
            }
            Conexao.fecharStatement(st);
            return string;
        }
        Conexao.fecharStatement(st);
        return string2;
    }

    protected void parseFlagsExcecoes(String reqCodigo, String exaCodigo, String flags) {
        char[] array;
        StringBuilder prefixo = new StringBuilder(reqCodigo).append("(").append(exaCodigo).append(") - ");
        for (char c : array = flags.trim().toCharArray()) {
            String flag = null;
            switch (c) {
                case 'G': {
                    flag = "Erro de hardware";
                    break;
                }
                case 'R': {
                    flag = "Reagente insuficiente";
                    break;
                }
                case '#': {
                    flag = "Amostra insuficiente";
                    break;
                }
                case 'L': {
                    flag = "Erro de l\u00e2mpada/eletrodo ISE n\u00e3o calibrado";
                    break;
                }
                case 'U': {
                    flag = "Valor/eletrodo ISE abaixo do esperado";
                    break;
                }
                case 'O': {
                    flag = "Valor/eletrodo ISE acima do esperado";
                    break;
                }
                case 'u': {
                    flag = "Refer\u00eancia de contador/elotrodo ISE abaixo do esperado";
                    break;
                }
                case 'o': {
                    flag = "Refer\u00eancia de contador/elotrodo ISE acima do esperado";
                    break;
                }
                case 'T': {
                    flag = "Erro de temperatura de cubeta/ISE";
                    break;
                }
                case 'r': {
                    flag = "Repeti\u00e7\u00e3o";
                    break;
                }
                case '*': {
                    flag = "Erro alinear";
                    break;
                }
                case 'M': {
                    flag = "Viola\u00e7\u00e3o do limite de absor\u00e7\u00e3o";
                    break;
                }
                case 'D': {
                    flag = "Erro de desvio de absor\u00e7\u00e3o de reagente";
                    break;
                }
                case 'W': {
                    flag = "Viola\u00e7\u00e3o de Westgard";
                    break;
                }
                case 'A': {
                    flag = "Viola\u00e7\u00e3o do limite de calibra\u00e7\u00e3o";
                    break;
                }
                case 'C': {
                    flag = "Viola\u00e7\u00e3o do limite de controle";
                    break;
                }
                case 'N': {
                    flag = "Viola\u00e7\u00e3o do limite de refer\u00eancia";
                    break;
                }
                case 'a': {
                    flag = "Viola\u00e7\u00e3o do limite de absor\u00e7\u00e3o do reagente";
                    break;
                }
                case 'I': {
                    flag = "Erro da unidade ISE";
                    break;
                }
                case 'X': {
                    flag = "Erro de limite de concentra\u00e7\u00e3o";
                    break;
                }
                case 'P': {
                    flag = "Erro de prozone";
                    break;
                }
                case 'E': {
                    flag = "Resultado pr\u00f3ximo ao valor-limite";
                }
            }
            if (flag == null) continue;
            this.fireExcecaoEncontrada(prefixo.toString().concat(flag));
        }
    }

    @Override
    public void dataChanged() {
        Runnable run = () -> {
            try {
                String message = this.getPortaCOM().getInputString();
                if (!message.equals("") && message.indexOf(this.getMsgEnd()) >= 0) {
                    message = this.getPortaCOM().removeInputString(this.getMsgEnd());
                    this.addListaRecebimento(message);
                    this.restartThreadRecebimento();
                }
                this.setRX(500);
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
                this.fireMensagemEnviada("Erro ao receber dados do equipamento.", 1, 5000);
                this.anularSQL();
            }
        };
        SwingUtilities.invokeLater(run);
    }

    private void anularSQL() {
        try {
            Conexao.anulaSQL();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public void handShakeCharReceived(char c) {
    }

    private void addListaRecebimento(String message) {
        this.threadRecebimento.addListaRecebimento(message);
        this.restartThreadRecebimento();
    }

    private void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            List<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento();
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        if (this.threadRecebimento != null) {
            this.threadRecebimento.start();
        }
    }

    @Override
    public void teste() {
        StringBuilder tmp = new StringBuilder();
        String requisicao = JOptionPane.showInputDialog("Informe o tubo: ");
        int op = JOptionPane.showOptionDialog(null, "Op\u00e7\u00e3o", "Tipo teste", 0, 0, null, new String[]{"Enviar Reagente", "Enviar Confirmacao", "Resultado", "query"}, null);
        if (op == 0) {
            tmp.delete(0, tmp.length());
            tmp.append("[STX]");
            tmp.append("{i;JALIS[SP];0;AUR[SP];ALB[SP];TGP[SP];TGO[SP];AMI[SP];BILD;BILT;COL[SP];HDL[SP];CREA[SP];FER[SP];FAL[SP];GGT[SP];GLI[SP];MAG[SP];PT[SP]");
            tmp.append("[SP];TRIG;URE[SP];CA[SP][SP];CK[SP][SP];CKMB;PCR[SP];LDH[SP];LIP[SP];[SP][SP][SP][SP];[SP][SP][SP][SP];[SP][SP]");
            tmp.append("[SP][SP];[SP][SP][SP][SP];[SP][SP][SP][SP];[SP][SP][SP][SP];[SP][SP][SP][SP];[SP][SP][SP][SP];}[ETX][LINE]");
        } else if (op == 1) {
            tmp.delete(0, tmp.length());
            tmp.append("[STX]{q;JALIS[SP];0;");
            tmp.append(requisicao);
            tmp.append(";N;teste[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP];[SP][SP][SP][SP][SP][SP][SP]");
            tmp.append("[SP][SP][SP][SP];F;00001000000000000000000000000000;}[ETX][LINE]");
        } else if (op == 2) {
            tmp.delete(0, tmp.length());
            tmp.append("[STX]{R;JALIS[SP];N;");
            tmp.append(requisicao);
            tmp.append(";teste[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP];[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP]");
            tmp.append("[SP];F;[SP]1;AUR;0,94[SP][SP][SP];[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP]");
            tmp.append("[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP];mg/dl[SP];}[ETX][LINE]");
        } else if (op == 3) {
            tmp.delete(0, tmp.length());
            tmp.append("[STX]{q;JALIS[SP];0;").append(requisicao).append("[SP][SP];N;MARIO[SP]DALTRO[SP]BARNECH;[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP];F;10010000100000000000000000000000;}[ETX][LINE]");
        }
        this.parse(this.equipamento.arruma(tmp.toString()));
    }

    class ThreadRecebimento
    extends Thread {
        private List<String> listaRecebimento = new ArrayList<String>();

        ThreadRecebimento() {
        }

        public List<String> getListaRecebimento() {
            return this.listaRecebimento;
        }

        public void addListaRecebimento(String message) {
            this.listaRecebimento.add(message);
        }

        public void addListaRecebimentos(List<String> messages) {
            this.listaRecebimento.addAll(messages);
        }

        @Override
        public void run() {
            try {
                while (!this.listaRecebimento.isEmpty()) {
                    String message = this.listaRecebimento.remove(0);
                    String resultado = InterfaceListener.this.parse(message);
                    if (resultado != null) {
                        InterfaceListener.this.fireMensagemEnviada(resultado, 0, 10000);
                    }
                    ThreadRecebimento.sleep(450L);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

