/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.selectra2;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.exames.InfoExameRequisicao;
import jalis.laboratorio.interfaceamento.interfaces.selectra2.InterfaceConfiguracao;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.util.ArraysUtil;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.SwingUtilities;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    protected static final int MAX_PATIENT_NAME_CHARS = 20;
    static final int TEMPO_PAUSA = 1000;
    public static final char MSG_TYPE_SHORT_RESULT = 'R';
    public static final char MSG_TYPE_EXTENDED_RESULT = 'X';
    public static final char MSG_TYPE_BLANK_RESULT = 'B';
    public static final char MSG_TYPE_ECHO_REQUEST = 'E';
    public static final char MSG_TYPE_ECHO_ANSWER = 'e';
    public static final char MSG_TYPE_VERSION_REQUEST = 'V';
    public static final char MSG_TYPE_VERSION_ANSWER = 'v';
    public static final char MSG_TYPE_REAGENT_INSTALL = 'I';
    public static final char MSG_TYPE_REAGENT_REQUEST = 'I';
    public static final char MSG_TYPE_REAGENT_ANSWER = 'i';
    public static final char MSG_TYPE_SAMPLE_REQUEST = 'Q';
    public static final char MSG_TYPE_SAMPLE_ANSWER = 'q';
    public static final char MSG_TYPE_DELETE_REQUEST = 'D';
    public static final char MSG_TYPE_DELETE_ANSWER = 'd';
    public static final char MSG_TYPE_RESULT_REQUEST = 'R';
    public static final char MSG_TYPE_RESULT_ANSWER = 'r';
    public static final char MSG_TYPE_REAGENT_COUNTERS_REQUEST = 'N';
    public static final char MSG_TYPE_REAGENT_COUNTERS_ANSWER = 'n';
    public static final char PRIORIDADE_NORMAL = 'N';
    public static final char PRIORIDADE_STAT = 'E';
    public static final char PRIORIDADE_PEDIATRIC = 'P';
    public static final char RESULT_TYPE_NORMAL = 'N';
    public static final char RESULT_TYPE_STAT = 'E';
    public static final char RESULT_TYPE_PEDIATRIC = 'P';
    public static final char RESULT_TYPE_CONTROL = 'C';
    public static final char RESULT_TYPE_CALIBRATOR = 'S';
    public static final char RESULT_TYPE_BLANK = 'B';
    public static final String STATUS_SUCCESS = "0";
    public static final String STATUS_SUCCESS_READY = "0";
    public static final String STATUS_SUCCESS_LOADED = "1";
    public static final String STATUS_SAMPLE_MISMATCH = "1";
    public static final String STATUS_STILL_IN_BUFFER = "2";
    public static final String STATUS_WORKLIST_IS_FULL = "2";
    public static final String STATUS_TEST_UNAVAILABLE = "3";
    public static final String STATUS_SAMPLE_NOT_FOUND = "3";
    public static final String STATUS_MSG_LENGTH_ERROR = "7";
    public static final String STATUS_OVERRUN_ERROR = "8";
    public static final String STATUS_FRAMING_ERROR = "9";
    ArrayList<String> testes = new ArrayList();
    ArrayList<Integer> reagentes = new ArrayList();
    protected InfoExameRequisicao ultimo_enviado = new InfoExameRequisicao(null, null, null, null, null, null, null, null, null, null);
    InfoExameRequisicao ultimo_a_excluir = new InfoExameRequisicao(null, null, null, null, null, null, null, null, null, null);
    protected String ultimo_enviado_acao = null;
    protected String[] pac_exames;
    private ThreadRecebimento threadRecebimento = new ThreadRecebimento();
    protected InterfaceConfiguracao configuracao = new InterfaceConfiguracao();

    public InterfaceListener() {
        this(false);
    }

    public InterfaceListener(boolean requestReagente) {
        try {
            ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
            this.configuracao.setXmlVariaveis(c.getVariaveisConfiguracao());
            if (requestReagente) {
                this.requestReagentInstallation();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getMsgEnd() {
        return String.valueOf(String.valueOf('\u0003') + LINE);
    }

    @Override
    public String getMsgStart() {
        return String.valueOf('\u0002');
    }

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
        if (this.isTX()) {
            this.fireMensagemEnviada("Tempo esgotado ao enviar requisi\u00e7\u00e3o ao equipamento", 1, 5000);
        } else if (this.isRX()) {
            // empty if block
        }
        this.getPortaCOM().flush();
        this.getPortaCOM().clearInputString();
        this.setIdle();
    }

    private void enviaBloco(StringBuilder message) throws IOException {
        this.getPortaCOM().write(message.toString());
    }

    private StringBuilder montaBlocoPadrao(char tipo_do_bloco) {
        StringBuilder message = new StringBuilder(this.getMsgStart());
        message.append("{");
        message.append(tipo_do_bloco);
        message.append(";}");
        message.append(String.valueOf('\u0003'));
        return message;
    }

    public void requestEcho() throws Exception {
        StringBuilder message = this.montaBlocoPadrao('E');
        this.enviaBloco(message);
    }

    public void requestSoftwareVersion() throws Exception {
        StringBuilder message = this.montaBlocoPadrao('V');
        this.enviaBloco(message);
    }

    public void requestReagentInstallation() throws Exception {
        StringBuilder message = this.montaBlocoPadrao('I');
        this.enviaBloco(message);
    }

    public void requestReagentTestCounters() throws Exception {
        StringBuilder message = this.montaBlocoPadrao('N');
        this.enviaBloco(message);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        try {
            this.pac_exames = exames.trim().split(" ", 0);
            this.getPortaCOM().clearInputString();
            this.setTX(6000);
            Statement st = Conexao.getStatement();
            if (acao.equals("C")) {
                this.requestSampleDeletion(fil_codigo, req_codigo, exames, mco_codigo, rec_codigo);
                return "Requisi\u00e7\u00e3o de cancelamento/exclus\u00e3o enviada ao equipamento";
            }
            if (acao.equals("R")) {
                this.requestSampleResult(fil_codigo, req_codigo, rec_codigo);
                return "Requisi\u00e7\u00e3o de resultado enviada ao equipamento";
            }
            ExameMaterial[] alternativos = null;
            fil_codigo = Funcoes.preencheZero(fil_codigo, ParametrosGerais.getDigitosTuboFilial());
            req_codigo = Funcoes.preencheZero(req_codigo, ParametrosGerais.getDigitosTuboRequisicao());
            StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo);
            rec_codigo = Funcoes.preencheZero(rec_codigo, ParametrosGerais.getDigitosTuboTubo());
            codigo.append(rec_codigo);
            String[] temp = exames.split(" ", 0);
            ExameMaterial[] exa_lista = new ExameMaterial[temp.length];
            int i = -1;
            for (String t : temp) {
                exa_lista[++i] = new ExameMaterial(t, new Integer(mco_codigo));
            }
            exa_lista = ExamesUtil.anexarCodigoMaterial(temp, mco_codigo);
            String req_data = data;
            String req_hora = hora;
            String short_name = StringUtil.removerAcentos(pac_nome);
            if (short_name.length() > 20) {
                short_name = short_name.substring(0, 20);
            }
            Integer[] multiguias = this.verificaAgrupaMultiguias(fil_codigo, req_codigo);
            Map<String, BDExame> exames_curva = new HashMap<String, BDExame>();
            for (Integer multiguia : multiguias) {
                if (!this.verificaExames()) continue;
                exa_lista = InterfaceListener.getDesmExamesPai(fil_codigo, int_codigo, multiguia.toString(), this.pac_exames[0], mco_codigo);
                if (this.validaListaExames(exa_lista)) {
                    exa_lista = ExamesUtil.anexarCodigoMaterial(this.pac_exames, mco_codigo);
                }
                exames_curva = this.obtemExamesCurva(fil_codigo, int_codigo, multiguia.toString(), mco_codigo, rec_codigo, req_codigo, exa_lista, exames_curva);
            }
            String tipo_amostra = null;
            if (this.existeExames()) {
                exa_lista = ExamesUtil.anexarCodigoMaterial(this.pac_exames, mco_codigo);
                tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, exa_lista[0].getString(), exa_lista[0].getCodigo().toString(), int_codigo);
                exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_lista);
                alternativos = ExamesUtil.getAlternativos(st, fil_codigo, int_codigo, exa_lista);
                ArrayList<ExameMaterial> temporario = new ArrayList<ExameMaterial>();
                for (ExameMaterial e : alternativos) {
                    if (temporario.contains(e)) continue;
                    temporario.add(e);
                }
                alternativos = new ExameMaterial[temporario.size()];
                for (int j = 0; j < temporario.size(); ++j) {
                    alternativos[j] = (ExameMaterial)temporario.get(j);
                }
            }
            if (!Funcoes.textoVazio(this.configuracao.getSolicitarReagentesEnvio()) && this.configuracao.getSolicitarReagentesEnvio().equalsIgnoreCase("1")) {
                this.requestReagentInstallation();
                this.setRX(2000);
                Thread.sleep(1000L);
            }
            if (this.testes != null && this.testes.size() == 32) {
                void var32_45;
                ArrayList<String> lista = new ArrayList<String>();
                for (i = 0; i < 32; ++i) {
                    lista.add("0");
                }
                HashSet<ExameMaterial> examesEnviados = new HashSet<ExameMaterial>();
                HashSet<ExameMaterial> examesNaoEnviados = new HashSet<ExameMaterial>();
                ExameMaterial[] exameMaterialArray = exa_lista;
                int e = exameMaterialArray.length;
                boolean bl = false;
                while (var32_45 < e) {
                    int index;
                    String exa_alternativo;
                    ExameMaterial exameMaterial = exameMaterialArray[var32_45];
                    ExameMaterial[] exas = null;
                    exas = BDUtil.isExameDesmembrado(fil_codigo, int_codigo, exameMaterial.getString(), mco_codigo) ? BDUtil.getExamesFilhos(fil_codigo, int_codigo, exameMaterial.getString(), mco_codigo) : new ExameMaterial[]{new ExameMaterial(exameMaterial.getString(), Integer.parseInt(mco_codigo))};
                    boolean todos = true;
                    for (ExameMaterial exa : exas) {
                        exa_alternativo = BDUtil.getExmCodigoAlternativo(fil_codigo, exa.getNomeExame(), mco_codigo, int_codigo);
                        if (exa_alternativo != null && this.testes.contains(exa_alternativo)) {
                            index = this.testes.indexOf(exa_alternativo);
                            lista.set(index, "1");
                            examesEnviados.add(exameMaterial);
                            continue;
                        }
                        todos = false;
                        if (!Funcoes.textoVazio(this.configuracao.getIgnorarExameSemReagente()) || !this.configuracao.getIgnorarExameSemReagente().equalsIgnoreCase("0")) continue;
                        this.fireExcecaoEncontrada(String.valueOf(req_codigo) + " - Exame " + exa.getNomeExame() + " requisitado, mas seu c\u00f3digo alternativo n\u00e3o est\u00e1 configurado no Jalis");
                        return "Erro: exame pode n\u00e3o estar cadastrado no Jalis";
                    }
                    if (!todos) {
                        for (ExameMaterial exa : exas) {
                            exa_alternativo = BDUtil.getExmCodigoAlternativo(fil_codigo, exa.getNomeExame(), mco_codigo, int_codigo);
                            if (exa_alternativo == null || !this.testes.contains(exa_alternativo)) continue;
                            index = this.testes.indexOf(exa_alternativo);
                            lista.set(index, "0");
                            examesNaoEnviados.add(exa);
                            examesEnviados.add(exa);
                        }
                    }
                    ++var32_45;
                }
                if (lista.indexOf("1") < 0) {
                    return "Erro: exame(s) n\u00e3o cadastrado(s)";
                }
                StringBuilder exaEnviados = new StringBuilder();
                for (ExameMaterial exameMaterial : examesEnviados) {
                    exaEnviados.append(exameMaterial.getNomeExame()).append(" ");
                }
                this.ultimo_enviado = new InfoExameRequisicao(fil_codigo, req_codigo, mco_codigo, rec_codigo, pac_nome, pac_idade, pac_sexo, req_data, req_hora, exaEnviados.toString().trim());
                this.ultimo_enviado_acao = acao;
                if (Funcoes.textoVazio(examesNaoEnviados.toString()) && !Funcoes.textoVazio(this.configuracao.getIgnorarExameSemReagente()) && this.configuracao.getIgnorarExameSemReagente().equalsIgnoreCase("1")) {
                    this.equipamento.addLinhaErro(codigo.toString(), examesNaoEnviados.toString().trim());
                }
                StringBuilder lista_exames = new StringBuilder();
                for (String string : lista) {
                    lista_exames.append(string);
                }
                StringBuilder stringBuilder = new StringBuilder(this.getMsgStart());
                String string = codigo.toString();
                if (this.validaExameCurva(exames_curva)) {
                    for (String key : exames_curva.keySet()) {
                        StringBuilder lista_exames_curva = new StringBuilder();
                        ArrayList<String> lista_reagentes = new ArrayList<String>();
                        lista_reagentes = this.retornaReagentesExame(this.testes, lista_reagentes, i, fil_codigo, exames_curva.get(key).getExame(), mco_codigo, int_codigo);
                        if (Funcoes.textoVazio(this.configuracao.getIgnorarExameSemReagente()) && this.configuracao.getIgnorarExameSemReagente().equalsIgnoreCase("0")) {
                            this.fireExcecaoEncontrada(String.valueOf(req_codigo) + " - Exame " + exames_curva.get(key).getExame() + " requisitado, mas seu c\u00f3digo alternativo n\u00e3o est\u00e1 configurado no Jalis");
                            return "Erro: exame pode n\u00e3o estar cadastrado no Jalis";
                        }
                        if (lista_reagentes.indexOf("1") < 0) {
                            return "Erro: exame(s) n\u00e3o cadastrado(s)";
                        }
                        for (String exame : lista_reagentes) {
                            lista_exames_curva.append(exame);
                        }
                        this.enviaMessagemEquipamento(key, short_name, pac_sexo, lista_exames_curva, fil_codigo, req_codigo);
                    }
                } else {
                    this.enviaMessagemEquipamento(string, short_name, pac_sexo, lista_exames, fil_codigo, req_codigo);
                }
                return "Enviando " + pac_nome + " para o equipamento";
            }
            this.requestReagentInstallation();
            this.setRX(2000);
            return null;
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
            return null;
        }
    }

    private ArrayList<String> retornaReagentesExame(ArrayList<String> testes, ArrayList<String> lista_reagentes, int i, String fil_codigo, String exame, String mco_codigo, String int_codigo) throws SQLException {
        String exa_alternativo;
        if (testes != null && testes.size() == 32) {
            for (i = 0; i < 32; ++i) {
                lista_reagentes.add("0");
            }
        }
        if ((exa_alternativo = BDUtil.getExmCodigoAlternativo(fil_codigo, exame, mco_codigo, int_codigo)) != null && testes.contains(exa_alternativo)) {
            int index = testes.indexOf(exa_alternativo);
            lista_reagentes.set(index, "1");
        }
        return lista_reagentes;
    }

    private boolean existeExames() {
        return this.pac_exames != null && this.pac_exames.length > 0;
    }

    private boolean validaExameCurva(Map<String, BDExame> exames_curva) {
        return !exames_curva.isEmpty();
    }

    protected boolean validaListaExames(ExameMaterial[] exa_lista) {
        return exa_lista.length <= 0;
    }

    private boolean verificaExames() {
        return this.pac_exames != null;
    }

    private void enviaMessagemEquipamento(String codigo, String short_name, String pac_sexo, StringBuilder lista_exames, String fil_codigo, String req_codigo) throws SQLException, IOException {
        StringBuilder message = new StringBuilder(this.getMsgStart());
        message.append("{");
        message.append('Q');
        message.append(";");
        message.append(codigo);
        message.append(";");
        message.append('N');
        message.append(";");
        message.append(short_name);
        message.append(";");
        message.append("");
        message.append(";");
        message.append(pac_sexo);
        message.append(";");
        if (this.validaNomeMedico()) {
            message.append(BDUtil.buscaMedicoRequisicao(fil_codigo, req_codigo));
            message.append(";");
        }
        message.append(lista_exames.toString());
        message.append(";");
        message.append("}");
        message.append(this.getMsgEnd());
        this.getPortaCOM().write(message.toString());
    }

    private boolean validaNomeMedico() {
        return !Funcoes.textoVazio(this.configuracao.getInformarNomeMedico()) && this.configuracao.getInformarNomeMedico().equalsIgnoreCase("1");
    }

    protected Integer[] verificaAgrupaMultiguias(String fil_codigo, String req_codigo) throws SQLException {
        Integer[] multiguias = null;
        multiguias = RecepcaoUtil.verificaMultiGuias(fil_codigo, req_codigo, true);
        boolean agruparMultiguias = this.isAgruparMultiguias(fil_codigo, multiguias);
        if (!agruparMultiguias) {
            multiguias = new Integer[]{Integer.parseInt(req_codigo)};
        }
        return multiguias;
    }

    private boolean isAgruparMultiguias(String fil_codigo, Integer[] multiguias) throws SQLException {
        return ParametrosGerais.isAgruparGuiasInterface() || DBUtil.requisicaoAgrupaMultiguiasLabExterno(Conexao.getStatement(), fil_codigo, multiguias);
    }

    public static synchronized ExameMaterial[] getDesmExamesPai(String fil_codigo, String int_codigo, String req_codigo, String exa_kodigo, String mco_kodigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select exa_codigo, mco_codigo from ");
        query.append("interfaceexamerequisicaodesm where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and int_codigo = ").append(int_codigo);
        query.append(" and req_codigo = ").append(req_codigo);
        query.append(" and exa_kodigo = ").append(DBUtil.bdText(exa_kodigo));
        query.append(" and mco_codigo = ").append(mco_kodigo);
        query.append(" order by exa_codigo desc");
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        int i = DBUtil.qtdeRegistros(rs);
        ExameMaterial[] pais = new ExameMaterial[i];
        while (rs != null && rs.next()) {
            pais[--i] = new ExameMaterial(rs.getString("exa_codigo"), rs.getInt("mco_codigo"));
        }
        ps.close();
        return pais;
    }

    protected Map<String, BDExame> obtemExamesCurva(String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String codigo, ExameMaterial[] exa_lista, Map<String, BDExame> exames_curva) throws SQLException {
        StringBuilder curva = new StringBuilder();
        for (ExameMaterial exa : exa_lista) {
            BDExame[] filhos;
            if (!BDUtil.isExameCurva(fil_codigo, int_codigo, exa.getNomeExame(), mco_codigo)) continue;
            curva.append(exa).append(" ");
            for (BDExame bdExame : filhos = BDUtil.getDesmExamesFilhos(fil_codigo, int_codigo, req_codigo, exa.getNomeExame(), mco_codigo, rec_codigo)) {
                String tubo = BDUtil.getExameDesmembradoTubo(fil_codigo, req_codigo, bdExame.getRecipiente(), int_codigo, bdExame.getExame(), mco_codigo);
                if (!this.validaTubo(tubo)) continue;
                String filialRequisicao = fil_codigo + codigo;
                String etiqueta = String.format("%s%s", filialRequisicao, StringUtil.preencheString(tubo, ParametrosGerais.getDigitosTuboTubo(), '0', 1));
                exames_curva.put(etiqueta, new BDExame(req_codigo, bdExame.getExame(), mco_codigo, tubo, null));
            }
        }
        if (!Funcoes.textoVazio(curva.toString()) && this.validaExameCurva(exames_curva)) {
            for (String ex : curva.toString().split(" ")) {
                int p = ArraysUtil.indice((Object[])this.pac_exames, ex);
                this.pac_exames = ArraysUtil.remover(this.pac_exames, p);
            }
        }
        return exames_curva;
    }

    private boolean validaTubo(String tubo) {
        return tubo != null;
    }

    public void requestSampleDeletion(String fil_codigo, String req_codigo, String exa_codigo, String mco_codigo, String rec_codigo) throws Exception {
        this.ultimo_a_excluir = new InfoExameRequisicao(fil_codigo, req_codigo, mco_codigo, rec_codigo, null, null, null, null, null, exa_codigo);
        fil_codigo = StringUtil.preencheString(fil_codigo, 2, '0', 1);
        StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo);
        rec_codigo = StringUtil.preencheString(rec_codigo, 2, '0', 1);
        codigo.append(rec_codigo);
        req_codigo = fil_codigo + req_codigo + rec_codigo;
        StringBuilder message = new StringBuilder(this.getMsgStart());
        message.append("{");
        message.append('D');
        message.append(";");
        message.append(req_codigo);
        message.append(";");
        message.append("}");
        message.append(String.valueOf('\u0003'));
        this.getPortaCOM().write(message.toString());
    }

    public void requestSampleResult(String fil_codigo, String req_codigo, String rec_codigo) throws Exception {
        fil_codigo = StringUtil.preencheString(fil_codigo, 2, '0', 1);
        StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo);
        rec_codigo = StringUtil.preencheString(rec_codigo, 2, '0', 1);
        codigo.append(rec_codigo);
        req_codigo = fil_codigo + req_codigo + rec_codigo;
        StringBuilder message = new StringBuilder(this.getMsgStart());
        message.append("{");
        message.append('R');
        message.append(";");
        message.append(req_codigo);
        message.append(";");
        message.append("}");
        message.append(String.valueOf('\u0003'));
        this.getPortaCOM().write(message.toString());
    }

    @Override
    public String parse(String message) {
        this.setRX(2000);
        String retorno = null;
        if (message.startsWith(this.getMsgStart()) && message.endsWith(this.getMsgEnd())) {
            String conteudo = message.substring(2, message.lastIndexOf(";"));
            String[] temp = conteudo.split(";", -1);
            ArrayList<String> campos = new ArrayList<String>();
            for (String t : temp) {
                campos.add(t);
            }
            char tipo = ((String)campos.remove(0)).charAt(0);
            switch (tipo) {
                case 'R': {
                    retorno = this.parseShortResult(campos);
                    break;
                }
                case 'X': {
                    retorno = this.parseExtendedResult(campos);
                    break;
                }
                case 'B': {
                    retorno = this.parseBlankResult(campos);
                    break;
                }
                case 'e': {
                    retorno = this.parseEchoAnswer(campos);
                    break;
                }
                case 'v': {
                    retorno = this.parseVersionAnswer(campos);
                    break;
                }
                case 'I': 
                case 'i': {
                    retorno = this.parseReagentAnswer(campos);
                    break;
                }
                case 'q': {
                    retorno = this.parseSampleAnswer(campos);
                    break;
                }
                case 'd': {
                    retorno = this.parseDeleteAnswer(campos);
                    break;
                }
                case 'r': {
                    retorno = this.parseResultAnswer(campos);
                    break;
                }
                case 'n': {
                    retorno = this.parseReagentCountersAnswer(campos);
                    break;
                }
                default: {
                    retorno = null;
                }
            }
        }
        this.setPausa(1000);
        return retorno;
    }

    protected String parseShortResult(ArrayList<String> campos) {
        String retorno = null;
        try {
            int num_testes;
            Statement st = Conexao.getStatement();
            String device_id = campos.remove(0).trim();
            String tipo_result = campos.remove(0).trim();
            switch (tipo_result.charAt(0)) {
                case 'B': 
                case 'C': 
                case 'S': {
                    return null;
                }
            }
            String req_codigo = campos.remove(0).trim();
            String pac_nome = campos.remove(0).trim();
            String pac_datanasc = campos.remove(0).trim();
            String pac_sexo = campos.remove(0).trim();
            if (this.configuracao.getInformarNomeMedico().equalsIgnoreCase("1")) {
                String string = campos.remove(0).trim();
            }
            try {
                num_testes = Integer.parseInt(campos.remove(0).trim());
            }
            catch (Exception e) {
                this.fireExcecaoEncontrada("N\u00e3o foi poss\u00edvel identificar a quantidade de exames na mensagem recebida do equipamento: " + req_codigo + "verifique as configura\u00e7\u00f5es");
                return null;
            }
            try {
                Long.parseLong(req_codigo);
            }
            catch (Exception ex) {
                StringBuilder msg = new StringBuilder();
                msg.append("Resultados recebidos para requisi\u00e7\u00e3o n\u00e3o existente ou n\u00e3o interfaceada: ");
                msg.append(req_codigo);
                this.fireExcecaoEncontrada(msg.toString());
                return null;
            }
            if (req_codigo.length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                StringBuilder msg = new StringBuilder();
                msg.append("Resultados recebidos para requisi\u00e7\u00e3o n\u00e3o existente ou n\u00e3o interfaceada: ");
                msg.append(req_codigo);
                this.fireExcecaoEncontrada(msg.toString());
                return null;
            }
            String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
            String rec_codigo = req_codigo.substring(req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
            req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial(), req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
            if (fil_codigo.equals("00") || rec_codigo.equals("00")) {
                return null;
            }
            while (num_testes > 0) {
                String emi_alternativo = campos.remove(0).trim();
                String ers_resultado = campos.remove(0).trim();
                String flags = campos.remove(0).trim();
                String unidades = campos.remove(0).trim();
                this.parseFlagsExcecoes(req_codigo, emi_alternativo, flags.trim());
                String int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, emi_alternativo);
                if (int_codigo == null) {
                    this.fireExcecaoEncontrada("Interfaceamento do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                    --num_testes;
                    continue;
                }
                ExameMaterial exame = this.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo);
                if (exame == null) {
                    this.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                } else {
                    this.atualizarResultadoExame(st, fil_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo, ers_resultado.replaceAll("\\.", ","));
                }
                --num_testes;
            }
            Conexao.arquivaSQL();
            this.fireAtualizarTabela();
            return retorno;
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return "Erro ao realizar parse de dados recebidos do equipamento";
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            return "Erro ao realizar parse de dados recebidos do equipamento";
        }
    }

    protected String parseExtendedResult(ArrayList<String> campos) {
        String retorno = null;
        try {
            Statement st = Conexao.getStatement();
            String device_id = campos.remove(0).trim();
            String tipo_result = campos.remove(0).trim();
            switch (tipo_result.charAt(0)) {
                case 'B': 
                case 'C': 
                case 'S': {
                    return null;
                }
            }
            String req_codigo = campos.remove(0).trim();
            String pac_nome = campos.remove(0).trim();
            String pac_datanasc = campos.remove(0).trim();
            String pac_sexo = campos.remove(0).trim();
            try {
                Long.parseLong(req_codigo);
            }
            catch (Exception ex) {
                StringBuilder msg = new StringBuilder();
                msg.append("Resultados recebidos para requisi\u00e7\u00e3o n\u00e3o existente ou n\u00e3o interfaceada: ");
                msg.append(req_codigo);
                this.fireExcecaoEncontrada(msg.toString());
                return msg.toString();
            }
            if (req_codigo.length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                StringBuilder msg = new StringBuilder();
                msg.append("Resultados recebidos para requisi\u00e7\u00e3o n\u00e3o existente ou n\u00e3o interfaceada: ");
                msg.append(req_codigo);
                this.fireExcecaoEncontrada(msg.toString());
                return null;
            }
            String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
            String rec_codigo = req_codigo.substring(req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
            req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial(), req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
            if (fil_codigo.equals("00") || rec_codigo.equals("00")) {
                return null;
            }
            for (int num_testes = Integer.parseInt(campos.remove(0).trim()); num_testes > 0; --num_testes) {
                String emi_alternativo = campos.remove(0).trim().toUpperCase();
                String ers_resultado = campos.remove(0).trim();
                String flags = campos.remove(0).trim();
                String unidades = campos.remove(0).trim();
                String reag_abs = campos.remove(0).trim();
                String raw_result = campos.remove(0).trim();
                String raw_units = campos.remove(0).trim();
                for (int i = 0; i < 45 && campos.size() > 0; ++i) {
                    campos.remove(0);
                }
                while (campos.size() > 0 && Funcoes.textoVazio(campos.get(0))) {
                    campos.remove(0);
                }
                this.parseFlagsExcecoes(req_codigo, emi_alternativo, flags.trim());
                String int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, emi_alternativo);
                if (int_codigo == null) {
                    this.fireExcecaoEncontrada(String.format("C\u00f3digo LIS do exame %s n\u00e3o encontrado no interfaceamento para requisi\u00e7\u00e3o %s %s %s", emi_alternativo, fil_codigo, req_codigo, rec_codigo));
                    return "";
                }
                ExameMaterial exame = this.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo);
                if (exame == null) {
                    this.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                    continue;
                }
                this.atualizarResultadoExame(st, fil_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo, ers_resultado.replaceAll("\\.", ","));
            }
            Conexao.arquivaSQL();
            this.fireAtualizarTabela();
            return retorno;
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return "Erro ao realizar parse de dados recebidos do equipamento";
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            return "Erro ao realizar parse de dados recebidos do equipamento";
        }
    }

    protected String parseBlankResult(ArrayList<String> campos) {
        return null;
    }

    protected String parseEchoAnswer(ArrayList<String> campos) {
        this.fireMensagemEnviada("Resposta de eco recebida com sucesso", 0, 10000);
        return null;
    }

    protected String parseVersionAnswer(ArrayList<String> campos) {
        return null;
    }

    protected String parseReagentAnswer(ArrayList<String> campos) {
        String device_id = campos.remove(0).trim();
        String status = null;
        if (campos.get(0).length() == 1) {
            status = campos.remove(0).trim();
        }
        if (status != null && !status.equals("0")) {
            if (status.equals(STATUS_MSG_LENGTH_ERROR)) {
                this.fireExcecaoEncontrada("Erro nos dados requisitados ao equipamento");
            } else if (status.equals(STATUS_OVERRUN_ERROR)) {
                this.fireExcecaoEncontrada("Erro de dados sobrepostos (velocidade)");
            } else if (status.equals(STATUS_FRAMING_ERROR)) {
                this.fireExcecaoEncontrada("Erro de paridade, bloco ou interrup\u00e7\u00e3o dos dados");
            }
            return null;
        }
        this.testes.clear();
        for (String t : campos) {
            this.testes.add(t.trim());
        }
        return "Lista de testes/reagentes atualizada";
    }

    protected String parseReagentCountersAnswer(ArrayList<String> campos) {
        return null;
    }

    protected String parseDeleteAnswer(ArrayList<String> campos) {
        return null;
    }

    private String parseSampleAnswer(ArrayList<String> campos) {
        try {
            Statement st = Conexao.getStatement();
            Map<String, BDExame> exames_curva = null;
            String rec_tuboPai = "";
            String device_id = campos.remove(0).trim();
            String status = campos.remove(0).trim();
            String requisicao = campos.remove(0).trim();
            String recCodigo = "";
            if (requisicao.length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                this.fireExcecaoEncontrada(String.format("Amostra com o c\u00f3digo fora do padr\u00e3o %s ", requisicao));
                return "Erro ao receber dados do equipamento";
            }
            recCodigo = requisicao.substring(ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
            if (status != null && !status.equalsIgnoreCase("0")) {
                StringBuilder excecao;
                StringBuilder stringBuilder = excecao = this.ultimo_enviado != null ? new StringBuilder(this.ultimo_enviado.getCodigo()).append("(").append(this.ultimo_enviado.getExames()).append(") - ") : new StringBuilder("Erro: ");
                if (status.equals("1")) {
                    excecao.append("Erro: amostra j\u00e1 existe mas dados demogr\u00e1ficos n\u00e3o conferem, ou amostra sendo usada pelo operador!");
                } else {
                    if (status.equals("2")) {
                        return "Worklist se encontra cheio no momento";
                    }
                    if (status.equals("3")) {
                        excecao.append("Erro: teste pedido n\u00e3o se encontra instalado no equipamento");
                    } else if (status.equals(STATUS_MSG_LENGTH_ERROR)) {
                        excecao.append("Erro nos dados requisitados ao equipamento");
                    } else if (status.equals(STATUS_OVERRUN_ERROR)) {
                        excecao.append("Erro de dados sobrepostos (velocidade)");
                    } else if (status.equals(STATUS_FRAMING_ERROR)) {
                        excecao.append("Erro de paridade, bloco ou interrup\u00e7\u00e3o dos dados");
                    }
                }
                if (excecao.indexOf("Erro") >= 0) {
                    this.fireExcecaoEncontrada(excecao.toString());
                    return excecao.toString();
                }
                return null;
            }
            if (this.ultimo_enviado == null) {
                return "Erro ao receber resposta do equipamento";
            }
            String[] exames = this.ultimo_enviado.getExames().split(" ", 0);
            StringBuilder codigo = new StringBuilder(this.ultimo_enviado.getFilial()).append(this.ultimo_enviado.getCodigo());
            String codigo_int = this.getIntCodigo(this.ultimo_enviado.getFilial(), this.ultimo_enviado.getCodigo(), this.ultimo_enviado.getRecipiente(), exames[0], this.ultimo_enviado.getMaterial());
            rec_tuboPai = this.ultimo_enviado.getRecipiente();
            this.pac_exames = exames;
            String[] temp = exames;
            ExameMaterial[] exa_lista = new ExameMaterial[temp.length];
            int i = -1;
            for (String t : temp) {
                exa_lista[++i] = new ExameMaterial(t, new Integer(this.ultimo_enviado.getMaterial()));
            }
            Integer[] multiguias = this.verificaAgrupaMultiguias(this.ultimo_enviado.getFilial(), this.ultimo_enviado.getCodigo());
            exames_curva = new HashMap<String, BDExame>();
            for (Integer multiguia : multiguias) {
                if (exames == null) continue;
                exa_lista = InterfaceListener.getDesmExamesPai(this.ultimo_enviado.getFilial(), this.ultimo_enviado.getCodigo(), multiguia.toString(), exames[0], this.ultimo_enviado.getMaterial());
                if (this.validaListaExames(exa_lista)) {
                    exa_lista = ExamesUtil.anexarCodigoMaterial(exames, this.ultimo_enviado.getMaterial());
                }
                exames_curva = this.obtemExamesCurva(this.ultimo_enviado.getFilial(), codigo_int, multiguia.toString(), this.ultimo_enviado.getMaterial(), this.ultimo_enviado.getRecipiente(), codigo.toString(), exa_lista, exames_curva);
            }
            for (String exame : exames) {
                String fil_codigo = this.ultimo_enviado.getFilial();
                String req_codigo = this.ultimo_enviado.getCodigo();
                String mco_codigo = this.ultimo_enviado.getMaterial();
                String rec_codigo = this.ultimo_enviado.getRecipiente();
                String int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, exame, mco_codigo);
                if (!exames_curva.isEmpty()) {
                    for (String key : exames_curva.keySet()) {
                        int situacao;
                        BDExame bdExame = exames_curva.get(key);
                        if (!Funcoes.textoVazio(bdExame.getExame()) && !Funcoes.textoVazio(bdExame.getMaterial())) {
                            situacao = BDUtil.getDesmSituacao(fil_codigo, int_codigo, req_codigo, exame, mco_codigo, rec_tuboPai, bdExame.getExame(), bdExame.getMaterial());
                            if (Funcoes.preencheZero(bdExame.getRecipiente(), ParametrosGerais.getDigitosTuboTubo()).equals(recCodigo)) {
                                BDUtil.setExmSituacaoFilho(st, fil_codigo, int_codigo, req_codigo, exame, mco_codigo, bdExame.getExame(), bdExame.getMaterial(), rec_tuboPai, situacao < 2 ? 1 : 3);
                            }
                            int atual = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exame, mco_codigo, rec_codigo);
                            this.atualizarSituacaoExame(st, fil_codigo, req_codigo, recCodigo, bdExame.getExame(), bdExame.getMaterial(), int_codigo, null, atual < 2 ? 1 : 3);
                            if (situacao > 2) {
                                this.fireAtualizarTabela(2);
                            }
                        }
                        situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exame, mco_codigo, rec_codigo);
                        if (!BDUtil.isGrupoInteiroPendente(fil_codigo, int_codigo, req_codigo, exame, mco_codigo, rec_tuboPai)) continue;
                        this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_tuboPai, exame, mco_codigo, int_codigo, null, situacao < 2 ? 1 : 3, true);
                        if (situacao <= 2) continue;
                        this.fireAtualizarTabela(2);
                    }
                } else {
                    int atual = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exame, mco_codigo, rec_codigo);
                    this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exame, mco_codigo, int_codigo, null, atual < 2 ? 1 : 3);
                    if (atual > 2) {
                        this.fireAtualizarTabela(2);
                    }
                }
                if (BDUtil.isGrupoInteiroPendente(fil_codigo, int_codigo, req_codigo, exame, mco_codigo, rec_tuboPai)) {
                    int atual = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exame, mco_codigo, rec_codigo);
                    this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exame, mco_codigo, int_codigo, null, atual < 2 ? 1 : 3);
                    if (atual > 2) {
                        this.fireAtualizarTabela(2);
                    }
                }
                if (!req_codigo.equals(this.ultimo_enviado.getCodigo()) || !this.ultimo_enviado_acao.equals("N")) continue;
                this.firePacienteEnviado(this.ultimo_enviado.getCodigo(), this.ultimo_enviado.getNome(), this.ultimo_enviado.getSexo(), this.ultimo_enviado.getIdade(), this.ultimo_enviado.getData(), this.ultimo_enviado.getHora(), this.ultimo_enviado.getExames());
            }
            Conexao.arquivaSQL();
            this.fireAtualizarTabela(0);
            return "Exame enviado com sucesso para " + this.ultimo_enviado.getNome();
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return "Erro ao analisar resposta de exame requisitado";
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            return "Erro ao analisar resposta de exame requisitado";
        }
    }

    protected String parseResultAnswer(ArrayList<String> campos) {
        try {
            String retorno = null;
            Statement st = Conexao.getStatement();
            String device_id = campos.remove(0).trim();
            String status = campos.remove(0).trim();
            String req_codigo = campos.remove(0).trim();
            try {
                Long.parseLong(req_codigo);
            }
            catch (Exception ex) {
                StringBuilder msg = new StringBuilder();
                msg.append("Resultados recebidos para requisi\u00e7\u00e3o n\u00e3o existente ou n\u00e3o interfaceada: ");
                msg.append(req_codigo);
                this.fireExcecaoEncontrada(msg.toString());
                return msg.toString();
            }
            if (req_codigo.length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                StringBuilder msg = new StringBuilder();
                msg.append("Resultados recebidos para requisi\u00e7\u00e3o n\u00e3o existente ou n\u00e3o interfaceada: ");
                msg.append(req_codigo);
                this.fireExcecaoEncontrada(msg.toString());
                return null;
            }
            String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
            String rec_codigo = req_codigo.substring(req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
            req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial(), req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
            if (fil_codigo.equals("00") || rec_codigo.equals("00")) {
                return null;
            }
            if (status != null && !status.equals("0") && !status.equals("1")) {
                StringBuilder excecao = new StringBuilder(req_codigo).append(" - ");
                if (status.equals("2")) {
                    excecao.append("Erro: amostra ainda se encontra na fila de espera");
                } else if (status.equals("3")) {
                    excecao.append("Erro: amostra n\u00e3o encontrada");
                } else if (status.equals(STATUS_MSG_LENGTH_ERROR)) {
                    excecao.append("Erro nos dados requisitados ao equipamento");
                } else if (status.equals(STATUS_OVERRUN_ERROR)) {
                    excecao.append("Erro de dados sobrepostos (velocidade)");
                } else if (status.equals(STATUS_FRAMING_ERROR)) {
                    excecao.append("Erro de paridade, bloco ou interrup\u00e7\u00e3o dos dados");
                }
                if (!excecao.equals(new StringBuilder(req_codigo).append(" - "))) {
                    this.fireExcecaoEncontrada(excecao.toString());
                }
                return excecao.toString();
            }
            String prioridade = campos.remove(0).trim();
            String pac_nome = campos.remove(0).trim();
            String pac_datanasc = campos.remove(0).trim();
            String pac_sexo = campos.remove(0).trim();
            for (int num_testes = Integer.parseInt(campos.remove(0).trim()); num_testes > 0; --num_testes) {
                String emi_alternativo = campos.remove(0).trim().toUpperCase();
                String ers_resultado = campos.remove(0).trim();
                String flags = campos.remove(0).trim();
                String unidades = campos.remove(0).trim();
                this.parseFlagsExcecoes(req_codigo, emi_alternativo, flags.trim());
                String int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, emi_alternativo);
                ExameMaterial exame = this.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo);
                if (exame == null) {
                    this.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                    continue;
                }
                if (!ers_resultado.equals("-------")) {
                    this.atualizarResultadoExame(st, fil_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo, ers_resultado.replaceAll("\\.", ","));
                    continue;
                }
                retorno = "O exame " + exame + " para " + pac_nome + " ainda n\u00e3o possui resultado";
            }
            Conexao.arquivaSQL();
            this.fireAtualizarTabela();
            return retorno;
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return "Erro ao realizar parse de resultado recebido";
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            return "Erro ao realizar parse de resultado de recebido";
        }
    }

    protected void parseFlagsExcecoes(String req_codigo, String exa_codigo, String flags) {
        char[] array;
        StringBuilder prefixo = new StringBuilder(req_codigo).append("(").append(exa_codigo).append(") - ");
        for (char c : array = flags.trim().toCharArray()) {
            String flag = null;
            switch (c) {
                case 'G': {
                    flag = "Erro de hardware";
                    break;
                }
                case 'R': {
                    flag = "Reagente insuficiente";
                    break;
                }
                case '#': {
                    flag = "Amostra insuficiente";
                    break;
                }
                case 'L': {
                    flag = "Erro de l\u00e2mpada/eletrodo ISE n\u00e3o calibrado";
                    break;
                }
                case 'U': {
                    flag = "Valor/eletrodo ISE abaixo do esperado";
                    break;
                }
                case 'O': {
                    flag = "Valor/eletrodo ISE acima do esperado";
                    break;
                }
                case 'u': {
                    flag = "Refer\u00eancia de contador/elotrodo ISE abaixo do esperado";
                    break;
                }
                case 'o': {
                    flag = "Refer\u00eancia de contador/elotrodo ISE acima do esperado";
                    break;
                }
                case 'T': {
                    flag = "Erro de temperatura de cubeta/ISE";
                    break;
                }
                case 'r': {
                    flag = "Repeti\u00e7\u00e3o";
                    break;
                }
                case '*': {
                    flag = "Erro alinear";
                    break;
                }
                case 'M': {
                    flag = "Viola\u00e7\u00e3o do limite de absor\u00e7\u00e3o";
                    break;
                }
                case 'D': {
                    flag = "Erro de desvio de absor\u00e7\u00e3o de reagente";
                    break;
                }
                case 'W': {
                    flag = "Viola\u00e7\u00e3o de Westgard";
                    break;
                }
                case 'A': {
                    flag = "Viola\u00e7\u00e3o do limite de calibra\u00e7\u00e3o";
                    break;
                }
                case 'C': {
                    flag = "Viola\u00e7\u00e3o do limite de controle";
                    break;
                }
                case 'N': {
                    flag = "Viola\u00e7\u00e3o do limite de refer\u00eancia";
                    break;
                }
                case 'a': {
                    flag = "Viola\u00e7\u00e3o do limite de absor\u00e7\u00e3o do reagente";
                    break;
                }
                case 'I': {
                    flag = "Erro da unidade ISE";
                    break;
                }
                case 'X': {
                    flag = "Erro de limite de concentra\u00e7\u00e3o";
                    break;
                }
                case 'P': {
                    flag = "Erro de prozone";
                    break;
                }
                case 'E': {
                    flag = "Resultado pr\u00f3ximo ao valor-limite";
                }
            }
            if (flag == null) continue;
            this.fireExcecaoEncontrada(prefixo.toString().concat(flag));
        }
    }

    @Override
    public void dataChanged() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    String message = InterfaceListener.this.getPortaCOM().getInputString();
                    if (!message.equals("") && message.indexOf(InterfaceListener.this.getMsgEnd()) >= 0) {
                        message = InterfaceListener.this.getPortaCOM().removeInputString(InterfaceListener.this.getMsgEnd());
                        InterfaceListener.this.addListaRecebimento(message);
                        InterfaceListener.this.restartThreadRecebimento();
                    }
                    InterfaceListener.this.setRX(500);
                }
                catch (Exception ex) {
                    ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
                    InterfaceListener.this.fireMensagemEnviada("Erro ao receber dados do equipamento.", 1, 5000);
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
            }
        };
        SwingUtilities.invokeLater(run);
    }

    @Override
    public void handShakeCharReceived(char c) {
    }

    private void addListaRecebimento(String message) {
        this.threadRecebimento.addListaRecebimento(message);
        this.restartThreadRecebimento();
    }

    private void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            ArrayList<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento();
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        if (this.threadRecebimento != null) {
            this.threadRecebimento.start();
        }
    }

    class ThreadRecebimento
    extends Thread {
        private ArrayList<String> listaRecebimento = new ArrayList();

        ThreadRecebimento() {
        }

        public ArrayList<String> getListaRecebimento() {
            return this.listaRecebimento;
        }

        public void addListaRecebimento(String message) {
            this.listaRecebimento.add(message);
        }

        public void addListaRecebimentos(ArrayList<String> messages) {
            this.listaRecebimento.addAll(messages);
        }

        @Override
        public void run() {
            try {
                while (this.listaRecebimento.size() > 0) {
                    String message = this.listaRecebimento.remove(0);
                    String resultado = InterfaceListener.this.parse(message);
                    if (resultado != null) {
                        InterfaceListener.this.fireMensagemEnviada(resultado, 0, 10000);
                    }
                    ThreadRecebimento.sleep(450L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

