/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.sebia;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.interfaces.sebia.InterfaceConfiguracao;
import jalis.laboratorio.interfaceamento.padroes.arquivo.InterfaceArquivoListener;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import org.apache.commons.codec.binary.Base64;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.CategoryTableXYDataset;
import org.jfree.data.xy.XYDataset;

public class InterfaceListener
extends InterfaceArquivoListener {
    private static final int POSICAO_INI_END_PEAK4 = 826;
    private static final int POSICAO_INI_END_PEAK3 = 818;
    private static final int POSICAO_INI_END_PEAK2 = 810;
    private static final int POSICAO_INI_END_PEAK1 = 802;
    private static final int POSICAO_INI_START_PEAK4 = 822;
    private static final int POSICAO_INI_START_PEAK3 = 814;
    private static final int POSICAO_INI_START_PEAK2 = 806;
    private static final int POSICAO_INI_START_PEAK1 = 798;
    private static final int POSICAO_INI_VALOR_FRACOES = 416;
    private static final int POSICAO_INI_PERCENTUAL_FRACOES = 366;
    private static final int POSICAO_INI_NOME_FRACOES = 266;
    private static final int POSICAO_INI_QTDE_FRACOES = 264;
    private static final String POSICAO_PONTO_SEPARADOR = "8";
    private static final String POSICAO_PONTO_SEPARADOR_MANUAL = "C";
    private static final String POSICAO_PONTO_SEPARADOR_X = "X";
    private static final String POSICAO_PONTO_FRACAO_DELETADA = "1";
    private static final int POSICAO_INI_CURVA = 830;
    private static final int BORDA_HORIZONTAL = 5;
    private static final int BORDA_VERTICAL = 5;
    private InterfaceConfiguracao configuracao = null;
    private String DIRETORIO_EXPORTACAO = "";
    private String DIRETORIO_IMPORTACAO = "";
    private String ARQUIVO_LOCK_EXPORTACAO = "toSebia.dat";
    private String ARQUIVO_LOCK_IMPORTACAO = "toJalis.dat";
    private String ARQUIVO_EXPORTACAO = "IN.DAT";
    private String ARQUIVO_IMPORTACAO = "OUT.DAT";
    private final Color[] CORES_RACHURA = new Color[]{ScreenUtil.clarearCor(Color.CYAN, 100), ScreenUtil.clarearCor(Color.GREEN, 100), ScreenUtil.clarearCor(Color.YELLOW, 100), ScreenUtil.clarearCor(Color.MAGENTA, 100)};
    private final Color[] CORES_RACHURA_PRETO = new Color[]{new Color(77, 77, 77, 255), new Color(100, 100, 100, 255), new Color(133, 133, 133, 255), new Color(166, 166, 166, 255)};
    private ThreadRecebimento threadRecebimento = new ThreadRecebimento();

    public InterfaceListener() {
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        this.configuracao = new InterfaceConfiguracao();
        this.configuracao.setDiretorioExportacao(c.getDiretorioExportacao());
        this.configuracao.setDiretorioImportacao(c.getDiretorioImportacao());
        this.configuracao.setXmlVariaveis(c.getVariaveisConfiguracao());
        this.DIRETORIO_EXPORTACAO = c.getDiretorioExportacao();
        this.DIRETORIO_IMPORTACAO = c.getDiretorioImportacao();
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        try {
            String[] stringArray;
            Statement st = Conexao.getStatement();
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(exames.split(" ", 0), mco_codigo);
            exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_lista);
            ExameMaterial[] alternativos = ExamesUtil.getAlternativos(st, fil_codigo, int_codigo, exa_lista);
            StringBuilder file = new StringBuilder();
            file.append(this.DIRETORIO_EXPORTACAO);
            file.append("/");
            file.append(this.ARQUIVO_LOCK_EXPORTACAO);
            File fLock = new File(file.toString());
            file = new StringBuilder();
            file.setLength(0);
            file.append(this.DIRETORIO_EXPORTACAO);
            file.append("/");
            file.append(this.ARQUIVO_EXPORTACAO);
            File fWorklist = new File(file.toString());
            if (fLock.exists()) {
                if (fWorklist.exists()) {
                    return "Aparelho est\u00e1 importando a atual worklist";
                }
                fLock.delete();
                fWorklist = null;
            }
            fLock.createNewFile();
            StringBuilder codigo = new StringBuilder();
            codigo.append(Funcoes.preencheZero(fil_codigo, ParametrosGerais.getDigitosTuboFilial()));
            codigo.append(Funcoes.preencheZero(req_codigo, ParametrosGerais.getDigitosTuboRequisicao()));
            codigo.append(Funcoes.preencheZero(rec_codigo, ParametrosGerais.getDigitosTuboTubo()));
            String[] idade = BDUtil.getIdadeNacimentoPaciente(fil_codigo, req_codigo);
            String dataNasc = "";
            String idadeAno = "";
            if (idade != null && idade.length == 3) {
                dataNasc = idade[2];
                idadeAno = idade[0];
            }
            data = data.replaceAll("\\/", "");
            dataNasc = dataNasc.replaceAll("\\/", "");
            StringBuilder nome = new StringBuilder();
            for (char c : pac_nome.toCharArray()) {
                if (!String.valueOf(c).matches("[a-zA-Z0-9 ]")) continue;
                nome.append(c);
            }
            pac_nome = nome.toString();
            if (pac_nome.length() > 30) {
                pac_nome = pac_nome.substring(0, 29);
            }
            for (ExameMaterial e : alternativos) {
                StringBuilder linha = new StringBuilder();
                linha.append(e.getNomeExame());
                linha.append("0000");
                linha.append(Funcoes.preencheVazio(codigo.toString(), 15, 2));
                linha.append(Funcoes.preencheVazio(pac_nome, 30, 2));
                linha.append(Funcoes.preencheVazio(dataNasc, 8, 2));
                linha.append(pac_sexo.substring(0, 1));
                linha.append(Funcoes.preencheVazio(idadeAno, 3, 2));
                linha.append(Funcoes.preencheVazio("", 20, 2));
                linha.append(data);
                linha.append("     ");
                linha.append(Funcoes.preencheVazio("", 30, 2));
                linha.append(Funcoes.preencheVazio("", 30, 2));
                linha.append(Funcoes.preencheVazio("", 30, 2));
                linha.append(Funcoes.preencheVazio("", 30, 2));
                linha.append(Funcoes.preencheVazio("", 30, 2));
                linha.append('\r').append('\n');
                StringUtil.escreverArquivoTexto(file.toString(), linha.toString(), true);
            }
            for (String s : stringArray = exames.split(" ", 0)) {
                this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, s, mco_codigo, int_codigo, null, 1);
            }
            Conexao.arquivaSQL();
            this.fireMensagemEnviada("Pedido(s) enviado(s) com sucesso para " + pac_nome, 0, 10000);
            this.equipamento.atualizarTabela(0);
            fLock.delete();
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
            return "";
        }
    }

    @Override
    public String getMsgEnd() {
        return String.valueOf(String.valueOf('\u0003'));
    }

    @Override
    public String getMsgStart() {
        return String.valueOf(String.valueOf('\u0002'));
    }

    @Override
    public String parse(String message) {
        this.setRX(2000);
        String retorno = null;
        if (message.trim().length() == 2031) {
            String req_codigo = message.substring(5, 20).trim();
            try {
                Long.parseLong(req_codigo);
            }
            catch (Exception ex) {
                StringBuilder msg = new StringBuilder();
                msg.append("Resultados recebidos para requisi\u00e7\u00e3o n\u00e3o existente ou n\u00e3o interfaceada: ");
                msg.append(req_codigo);
                this.fireExcecaoEncontrada(msg.toString());
                return msg.toString();
            }
            if (req_codigo.length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                StringBuilder msg = new StringBuilder();
                msg.append("Resultados recebidos para requisi\u00e7\u00e3o n\u00e3o existente ou n\u00e3o interfaceada: ");
                msg.append(req_codigo);
                this.fireExcecaoEncontrada(msg.toString());
                return null;
            }
            try {
                String comentario;
                String emi_alternativo = message.substring(0, 1);
                String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
                String rec_codigo = req_codigo.substring(req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
                req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial(), req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
                if (fil_codigo.equals("00") || rec_codigo.equals("00")) {
                    return null;
                }
                String int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, emi_alternativo);
                if (int_codigo == null) {
                    this.fireExcecaoEncontrada("Interfaceamento do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                    return "Erro ao processar resultado";
                }
                ExameMaterial exame = this.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo);
                if (exame == null) {
                    this.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                    return null;
                }
                HashMap<String, Object> dados = new HashMap<String, Object>();
                String proteina = message.substring(90, 95);
                dados.put("proteinas_totais", proteina.replaceAll("\\.", ","));
                int qtdeFracoes = Integer.parseInt(message.substring(264, 266));
                String nomeFracoes = message.substring(266, 366);
                String percFracoes = message.substring(366, 416);
                String vlrFracoes = message.substring(416, 466);
                this.parseFracoes(qtdeFracoes, nomeFracoes, percFracoes, vlrFracoes, dados);
                int larguraDisponivel = 0;
                int alturaDisponivel = 0;
                try {
                    larguraDisponivel = Funcoes.textoVazio(this.configuracao.getLarguraGrafico()) ? 500 : Integer.parseInt(this.configuracao.getLarguraGrafico());
                    alturaDisponivel = Funcoes.textoVazio(this.configuracao.getAlturaGrafico()) ? 400 : Integer.parseInt(this.configuracao.getAlturaGrafico());
                }
                catch (Exception e) {
                    larguraDisponivel = 300;
                    larguraDisponivel = 216;
                }
                this.parseCurva(message, dados, larguraDisponivel, alturaDisponivel, nomeFracoes, qtdeFracoes);
                StringBuilder nomeFita = new StringBuilder();
                nomeFita.append(this.DIRETORIO_IMPORTACAO);
                nomeFita.append("/");
                File fDir = new File(nomeFita.toString());
                FilenameFilter filter = new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith(".jpeg");
                    }
                };
                File[] imgs = fDir.listFiles(filter);
                if (imgs != null) {
                    for (File f : imgs) {
                        String s = f.getName();
                        if (!(s = s.substring(s.length() - 17, s.length() - 5)).equalsIgnoreCase(fil_codigo + req_codigo + rec_codigo)) continue;
                        BufferedImage image = ImageIO.read(f);
                        ImageIcon ib = new ImageIcon(image);
                        String foto64 = new Base64().encodeAsString(ImagemUtils.imageToByte(ib.getImage()));
                        dados.put("eforese_curva", foto64);
                        f.delete();
                        break;
                    }
                }
                if (!Funcoes.textoVazio(comentario = message.substring(557, 787))) {
                    dados.put("observacao_01", comentario.trim());
                }
                if (exame != null) {
                    Statement st = Conexao.getStatement();
                    this.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo, dados);
                    Conexao.fecharStatement(st);
                }
                Conexao.arquivaSQL();
                this.fireAtualizarTabela();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return "Erro ao realizar parse de dados recebidos do equipamento";
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
                return "Erro ao realizar parse de dados recebidos do equipamento";
            }
        }
        return retorno;
    }

    private int[] obtemPosicaoRachurasGrafico(String message, int qtdePontos) {
        int area1Start = Integer.parseInt(message.substring(798, 802));
        int area1End = Integer.parseInt(message.substring(802, 806));
        int area2Start = Integer.parseInt(message.substring(806, 810));
        int area2End = Integer.parseInt(message.substring(810, 814));
        int area3Start = Integer.parseInt(message.substring(814, 818));
        int area3End = Integer.parseInt(message.substring(818, 822));
        int area4Start = Integer.parseInt(message.substring(822, 826));
        int area4End = Integer.parseInt(message.substring(826, 830));
        int[] posicaoRachuras = new int[]{qtdePontos - area1End, qtdePontos - area1Start, qtdePontos - area2End, qtdePontos - area2Start, qtdePontos - area3End, qtdePontos - area3Start, qtdePontos - area4End, qtdePontos - area4Start};
        return posicaoRachuras;
    }

    private void parseFracoes(int qtdeFracoes, String fracoes, String percentuais, String valores, Map<String, Object> dados) {
        for (int i = 0; i < qtdeFracoes; ++i) {
            String nome = fracoes.substring(10 * i, 10 * i + 10).trim();
            if (Funcoes.textoVazio(nome)) continue;
            String campo = "fracao" + (i + 1);
            String campoPerc = campo + "_porcentagem";
            String campoValor = campo + "_contagem";
            String perc = percentuais.substring(5 * i, 5 * i + 5);
            String vlr = valores.substring(5 * i, 5 * i + 5);
            perc = perc.replaceAll("\\.", ",");
            vlr = vlr.replaceAll("\\.", ",");
            dados.put(campoPerc.toLowerCase(), perc);
            dados.put(campoValor.toLowerCase(), vlr);
        }
    }

    private void parseCurva(String mensagem, Map<String, Object> dados, int larguraDisponivel, int alturaDisponivel, String nomeFracoes, int qtdeFracoes) {
        int x;
        int qtdePontos = Integer.parseInt(mensagem.substring(789, 793));
        int[] rachuras = this.obtemPosicaoRachurasGrafico(mensagem, qtdePontos);
        String[] nomesFracoes = new String[qtdeFracoes];
        for (int i = 0; i < qtdeFracoes; ++i) {
            nomesFracoes[i] = nomeFracoes.substring(10 * i, 10 * i + 10).trim();
        }
        String[] pontosTipo = new String[qtdePontos];
        int[] posicoesFracoes = new int[qtdeFracoes + 1];
        String pontos = mensagem.substring(830, mensagem.indexOf("|"));
        CategoryTableXYDataset dt = new CategoryTableXYDataset();
        int altura = 0;
        for (int i = 0; i < qtdePontos; ++i) {
            String ponto = pontos.substring(4 * i, 4 * i + 4);
            pontosTipo[i] = ponto.substring(0, 1);
            altura = 0;
            if (!pontosTipo[i].equalsIgnoreCase(POSICAO_PONTO_FRACAO_DELETADA)) {
                altura = Integer.parseInt(ponto.substring(1, ponto.length()), 16);
            }
            if (altura < 1) {
                altura = 1;
            }
            dt.add((double)i, (double)altura, "");
        }
        JFreeChart chart = ChartFactory.createXYLineChart((String)"", (String)"", (String)"", (XYDataset)dt, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
        XYPlot plt = chart.getXYPlot();
        plt.setRangeGridlinesVisible(false);
        plt.setDomainGridlinesVisible(false);
        plt.setOutlinePaint((Paint)Color.WHITE);
        plt.setDomainTickBandPaint((Paint)Color.WHITE);
        plt.getDomainAxis().setRange(0.0, (double)qtdePontos);
        plt.getDomainAxis().setTickLabelsVisible(false);
        plt.getDomainAxis().setTickMarksVisible(false);
        plt.getRangeAxis().setTickLabelsVisible(false);
        plt.getRangeAxis().setTickMarksVisible(false);
        plt.setInsets(new Insets(0, 0, 0, 0));
        XYItemRenderer lineRenderer = plt.getRenderer();
        lineRenderer.setSeriesPaint(0, (Paint)Color.BLACK);
        plt.setRenderer(lineRenderer);
        int width = larguraDisponivel;
        int height = alturaDisponivel;
        int bordaHorizontal = 5;
        int bordaVertical = 5;
        bordaHorizontal = bordaHorizontal * larguraDisponivel / qtdePontos;
        bordaVertical = bordaVertical * alturaDisponivel / 216;
        BufferedImage imgGrafico = chart.createBufferedImage(width, height);
        BufferedImage imgFinal = new BufferedImage(width + 2 * bordaHorizontal, height + 2 * bordaVertical, 1);
        Graphics g = imgFinal.getGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, width + 2 * bordaHorizontal, height + 2 * bordaVertical);
        g.setColor(Color.BLACK);
        g.drawImage(imgGrafico, bordaHorizontal, bordaVertical, null);
        g.setColor(this.configuracao.getGraficoPreto() != false ? Color.BLACK : Color.BLUE);
        g.drawLine(bordaHorizontal, height + bordaVertical, width + bordaHorizontal, height + bordaVertical);
        int pos = 0;
        block2: for (x = 0; x < qtdePontos; ++x) {
            if (!pontosTipo[x].equalsIgnoreCase(POSICAO_PONTO_SEPARADOR) && !pontosTipo[x].equalsIgnoreCase(POSICAO_PONTO_SEPARADOR_MANUAL) && !pontosTipo[x].equalsIgnoreCase(POSICAO_PONTO_SEPARADOR_X)) continue;
            for (int y = height + bordaVertical - 1; y > 0; --y) {
                if (imgFinal.getRGB(this.calculaPosicaoDoEixoX(larguraDisponivel, qtdePontos, bordaHorizontal, x), y) == -1) continue;
                posicoesFracoes[pos++] = this.calculaPosicaoDoEixoX(larguraDisponivel, qtdePontos, bordaHorizontal, x);
                g.setColor(this.configuracao.getGraficoPreto() != false ? Color.BLACK : Color.ORANGE);
                g.drawLine(this.calculaPosicaoDoEixoX(larguraDisponivel, qtdePontos, bordaHorizontal, x), height + 2 * bordaVertical, this.calculaPosicaoDoEixoX(larguraDisponivel, qtdePontos, bordaHorizontal, x), y + 1);
                continue block2;
            }
        }
        block4: for (x = 0; x < qtdePontos; ++x) {
            Color cor = this.getCorPontoRachura(rachuras, x);
            if (cor == null) continue;
            g.setColor(cor);
            for (int y = height + bordaVertical - 1; y > 0; --y) {
                if (imgFinal.getRGB(this.calculaPosicaoDoEixoX(larguraDisponivel, qtdePontos, bordaHorizontal, x), y) == -1) continue;
                g.drawLine(this.calculaPosicaoDoEixoX(larguraDisponivel, qtdePontos, bordaHorizontal, x), height + bordaVertical - 1, this.calculaPosicaoDoEixoX(larguraDisponivel, qtdePontos, bordaHorizontal, x), y);
                continue block4;
            }
        }
        JLabel label = new JLabel();
        Font fonte = new Font(label.getFont().getName(), label.getFont().getStyle(), this.calculaTamanhoFonte(larguraDisponivel));
        g.setFont(fonte);
        FontMetrics metrica = g.getFontMetrics(fonte);
        g.setColor(Color.BLACK);
        for (int i = 0; i < posicoesFracoes.length - 1; ++i) {
            int posicaoX = 0;
            int posicaoY = Integer.MAX_VALUE;
            block7: for (int x2 = posicoesFracoes[i]; x2 < posicoesFracoes[i + 1]; ++x2) {
                for (int y = height + bordaVertical - 1; y > 0; --y) {
                    if (imgFinal.getRGB(x2, y) == -1) continue;
                    if (posicaoY <= y) continue block7;
                    posicaoY = y;
                    posicaoX = x2;
                    continue block7;
                }
            }
            int posicaoXCalculada = (int)((double)posicaoX - metrica.getStringBounds(nomesFracoes[i], g).getWidth() / 2.0);
            g.drawString(nomesFracoes[i], posicaoXCalculada < posicoesFracoes[i] ? posicoesFracoes[i] : posicaoXCalculada, height + 2 * bordaVertical);
        }
        Image i = Toolkit.getDefaultToolkit().createImage(imgFinal.getSource());
        String foto64 = new Base64().encodeAsString(ImagemUtils.imageToByte(i));
        dados.put("eforese_grafico", foto64);
    }

    private int calculaTamanhoFonte(int larguraDisponivel) {
        return (5 * larguraDisponivel + 2740) / 524;
    }

    private int calculaPosicaoDoEixoX(int larguraDisponivel, int qtdePontos, int bordaHorizontal, int x) {
        return x * larguraDisponivel / qtdePontos + bordaHorizontal;
    }

    private Color getCorPontoRachura(int[] rachuras, int posicaoNoEixoX) {
        if (posicaoNoEixoX > rachuras[7] && posicaoNoEixoX < rachuras[6]) {
            return this.configuracao.getGraficoPreto() != false ? this.CORES_RACHURA_PRETO[0] : this.CORES_RACHURA[0];
        }
        if (posicaoNoEixoX > rachuras[5] && posicaoNoEixoX < rachuras[4]) {
            return this.configuracao.getGraficoPreto() != false ? this.CORES_RACHURA_PRETO[1] : this.CORES_RACHURA[1];
        }
        if (posicaoNoEixoX > rachuras[3] && posicaoNoEixoX < rachuras[2]) {
            return this.configuracao.getGraficoPreto() != false ? this.CORES_RACHURA_PRETO[2] : this.CORES_RACHURA[2];
        }
        if (posicaoNoEixoX > rachuras[1] && posicaoNoEixoX < rachuras[0]) {
            return this.configuracao.getGraficoPreto() != false ? this.CORES_RACHURA_PRETO[3] : this.CORES_RACHURA[3];
        }
        return null;
    }

    private void geraImagemCurva(BufferedImage image, String name) throws IOException {
        File img = new File("/home/alex/sebia/" + name + ".png");
        ImageIO.write((RenderedImage)image, "png", img);
    }

    private void addListaRecebimento(String message) {
        this.threadRecebimento.addListaRecebimento(message);
        this.restartThreadRecebimento();
    }

    private void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            ArrayList<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento();
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        if (this.threadRecebimento != null) {
            this.threadRecebimento.start();
        }
    }

    @Override
    public void buscarResultados(Date inicio, Date termino) {
        try {
            StringBuilder file = new StringBuilder();
            file.append(this.DIRETORIO_IMPORTACAO);
            file.append("/");
            file.append(this.ARQUIVO_LOCK_IMPORTACAO);
            File fLock = new File(file.toString());
            if (fLock.exists()) {
                return;
            }
            fLock.createNewFile();
            file.setLength(0);
            file.append(this.DIRETORIO_IMPORTACAO);
            file.append("/");
            file.append(this.ARQUIVO_IMPORTACAO);
            File fOUT = new File(file.toString());
            if (fOUT.exists()) {
                String[] linhas;
                for (String l : linhas = StringUtil.lerArquivoTexto(fOUT).split("\n")) {
                    this.addListaRecebimento(l);
                    this.restartThreadRecebimento();
                }
            }
            String nomeOriginal = fOUT.getName().substring(0, fOUT.getName().indexOf(".")) + "_" + Funcoes.formataData("dd-MM-yyyy_HH_mm_ss", Calendar.getInstance().getTime()) + ".DAT";
            File dir = new File(this.DIRETORIO_IMPORTACAO + File.separator + "importados");
            if (!dir.exists()) {
                dir.mkdir();
                dir.setWritable(true);
            }
            File renomeado = new File(dir.getAbsolutePath() + File.separator + nomeOriginal);
            fOUT.renameTo(renomeado);
            fLock.delete();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "InterfaceListener - Sebia: 395");
        }
    }

    class ThreadRecebimento
    extends Thread {
        private ArrayList<String> listaRecebimento = new ArrayList();

        ThreadRecebimento() {
        }

        public ArrayList<String> getListaRecebimento() {
            return this.listaRecebimento;
        }

        public void addListaRecebimento(String message) {
            this.listaRecebimento.add(message);
        }

        public void addListaRecebimentos(ArrayList<String> messages) {
            this.listaRecebimento.addAll(messages);
        }

        @Override
        public void run() {
            try {
                while (this.listaRecebimento.size() > 0) {
                    String message = this.listaRecebimento.remove(0);
                    String resultado = InterfaceListener.this.parse(message);
                    if (resultado != null) {
                        InterfaceListener.this.fireMensagemEnviada(resultado, 0, 10000);
                    }
                    ThreadRecebimento.sleep(450L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

