/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.sds7500;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.padroes.arquivo.InterfaceArquivoListener;
import jalis.util.Funcoes;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JFileChooser;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class InterfaceListener
extends InterfaceArquivoListener {
    ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
    private static final String WELL = "well";
    private static final String SAMPLENAME = "Sample Name";
    private static final String TARGETNAME = "Target Name";
    private static final String TASK = "Task";
    private static final String REPORTER = "Reporter";
    private static final String QUENCHER = "Quencher";
    private static final String CT = "C?";
    private static final String CTMEAN = "C? Mean";
    private static final String CTSD = "C? SD";
    private static final String QUANTITY = "Quantity";
    private static final String QUANTITYMEAN = "Quantity Mean";
    private static final String QUANTITYSD = "Quantity SD";
    private static final String AUTOMATICCTTHRESHOLD = "Automatic Ct Threshold";
    private static final String CTTHRESHOLD = "Ct Threshold";
    private static final String AUTOMATICBASELINE = "Automatic Baseline";
    private static final String BASELINESTART = "Baseline Start";
    private static final String BASELINEEND = "Baseline End";
    private static final String COMMENTS = "Comments";
    private static final String EXPFAIL = "EXPFAIL";

    @Override
    public void buscarResultados(Date inicio, Date termino) {
        JFileChooser chooser = ComponenteFactory.novoJFileChooser("Arquivo para importa\u00e7\u00e3o", this.c.getDiretorioImportacao());
        if (chooser.showOpenDialog(null) == 0) {
            String path = chooser.getSelectedFile().getPath();
            this.parse(path);
        }
    }

    @Override
    public String parse(String path) {
        File file = new File(path);
        if (file.isFile() && (file.getName().substring(file.getName().lastIndexOf(".") + 1).toUpperCase().equals("XLSX") || file.getName().substring(file.getName().lastIndexOf(".") + 1).toUpperCase().equals("XLS"))) {
            try {
                Statement st = Conexao.getStatement();
                HashMap<String, Integer> listaIndex = new HashMap<String, Integer>();
                List<List<Object>> planilhaResultado = this.lerXls(file, "", true, listaIndex);
                for (int i = 0; i < planilhaResultado.size(); ++i) {
                    ExameMaterial exame;
                    String rec_codigo;
                    String req_codigo;
                    List<Object> cabecalho = planilhaResultado.get(0);
                    List<Object> retorno = planilhaResultado.get(i);
                    String amostra = retorno.get(listaIndex.get(SAMPLENAME)).toString().replaceAll("-", "").trim();
                    if (amostra.isEmpty()) continue;
                    if (amostra.trim().length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                        this.fireExcecaoEncontrada(String.format("Amostra n\u00e3o localizada %s.", amostra));
                        continue;
                    }
                    String fil_codigo = amostra.substring(0, ParametrosGerais.getDigitosTuboFilial());
                    Object[] req = this.getRequisicaoAba(fil_codigo, req_codigo = amostra.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao()), rec_codigo = amostra.substring(ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao()), 1);
                    if (null == req) {
                        this.fireExcecaoEncontrada(String.format("Amostra n\u00e3o localizada %s %s %s.", fil_codigo, req_codigo, rec_codigo));
                        continue;
                    }
                    String alternativo = (String)req[15];
                    String int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, alternativo);
                    if (int_codigo == null) {
                        this.fireExcecaoEncontrada(String.format("Amostra n\u00e3o localizada %s %s %s.", fil_codigo, req_codigo, rec_codigo));
                        continue;
                    }
                    HashMap<String, Object> resultadosMap = new HashMap<String, Object>();
                    if (retorno.get(listaIndex.get(TARGETNAME)).toString().equalsIgnoreCase("MS2")) {
                        resultadosMap.putAll(this.getMS2(retorno, listaIndex));
                    }
                    if (retorno.get(listaIndex.get(TARGETNAME)).toString().equalsIgnoreCase("N gene")) {
                        resultadosMap.putAll(this.getNGene(retorno, listaIndex));
                    }
                    if (retorno.get(listaIndex.get(TARGETNAME)).toString().equalsIgnoreCase("ORF1ab")) {
                        resultadosMap.putAll(this.getOrf1ab(retorno, listaIndex));
                    }
                    if (retorno.get(listaIndex.get(TARGETNAME)).toString().equalsIgnoreCase("S gene")) {
                        resultadosMap.putAll(this.getSGene(retorno, listaIndex));
                    }
                    if ((exame = this.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, alternativo)) != null) {
                        this.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo, resultadosMap);
                        Conexao.arquivaSQL();
                        continue;
                    }
                    this.fireExcecaoEncontrada(String.format("Amostra n\u00e3o localizada para o exame SALIVA %s %s %s.", fil_codigo, req_codigo, rec_codigo));
                }
                this.fireAtualizarTabela();
            }
            catch (IOException e) {
                this.fireExcecaoEncontrada("Resultado n\u00e3o encontrado no arquivo " + file.getName() + e.getMessage());
            }
            catch (SQLException e) {
                this.fireExcecaoEncontrada("Resultado n\u00e3o encontrado no arquivo " + file.getName() + e.getMessage());
            }
            catch (Exception e) {
                this.fireExcecaoEncontrada("Resultado n\u00e3o encontrado no arquivo " + file.getName() + e.getMessage());
            }
        }
        return null;
    }

    private Map<String, Object> getOrf1ab(List<Object> retorno, HashMap<String, Integer> listaIndex) {
        HashMap<String, Object> resultadosMap = new HashMap<String, Object>();
        resultadosMap.put("orf1abtask", this.trataValorNumerico(retorno.get(listaIndex.get(TASK))));
        resultadosMap.put("orf1abreporter", this.trataValorNumerico(retorno.get(listaIndex.get(REPORTER))));
        resultadosMap.put("orf1abquencher", this.trataValorNumerico(retorno.get(listaIndex.get(QUENCHER))));
        resultadosMap.put("orf1abct", this.trataValorNumerico(retorno.get(listaIndex.get(CT))));
        resultadosMap.put("orf1abctmean", this.trataValorNumerico(retorno.get(listaIndex.get(CTMEAN))));
        resultadosMap.put("orf1abctsd", this.trataValorNumerico(retorno.get(listaIndex.get(CTSD))));
        resultadosMap.put("orf1abquantity", this.trataValorNumerico(retorno.get(listaIndex.get(QUANTITY))));
        resultadosMap.put("orf1abquantitymean", this.trataValorNumerico(retorno.get(listaIndex.get(QUANTITYMEAN))));
        resultadosMap.put("orf1abquantitysd", this.trataValorNumerico(retorno.get(listaIndex.get(QUANTITYSD))));
        resultadosMap.put("orf1abautomaticcdthreshold", this.trataValorNumerico(retorno.get(listaIndex.get(AUTOMATICCTTHRESHOLD))));
        resultadosMap.put("orf1abctthreshold", this.trataValorNumerico(retorno.get(listaIndex.get(CTTHRESHOLD))));
        resultadosMap.put("orf1abautomaticbaseline", this.trataValorNumerico(retorno.get(listaIndex.get(AUTOMATICBASELINE))));
        resultadosMap.put("orf1abbaselinestart", this.trataValorNumerico(retorno.get(listaIndex.get(BASELINESTART))));
        resultadosMap.put("orf1abbaselineend", this.trataValorNumerico(retorno.get(listaIndex.get(BASELINEEND))));
        resultadosMap.put("orf1abcomments", this.trataValorNumerico(retorno.get(listaIndex.get(COMMENTS))));
        resultadosMap.put("orf1abexpfail", this.trataValorNumerico(retorno.get(listaIndex.get(EXPFAIL))));
        return resultadosMap;
    }

    private Map<String, Object> getSGene(List<Object> retorno, HashMap<String, Integer> listaIndex) {
        HashMap<String, Object> resultadosMap = new HashMap<String, Object>();
        resultadosMap.put("sgenetask", this.trataValorNumerico(retorno.get(listaIndex.get(TASK))));
        resultadosMap.put("sgenereporter", this.trataValorNumerico(retorno.get(listaIndex.get(REPORTER))));
        resultadosMap.put("sgenequencher", this.trataValorNumerico(retorno.get(listaIndex.get(QUENCHER))));
        resultadosMap.put("sgenect", this.trataValorNumerico(retorno.get(listaIndex.get(CT))));
        resultadosMap.put("sgenectmean", this.trataValorNumerico(retorno.get(listaIndex.get(CTMEAN))));
        resultadosMap.put("sgenectsd", this.trataValorNumerico(retorno.get(listaIndex.get(CTSD))));
        resultadosMap.put("sgenequantity", this.trataValorNumerico(retorno.get(listaIndex.get(QUANTITY))));
        resultadosMap.put("sgenequantitymean", this.trataValorNumerico(retorno.get(listaIndex.get(QUANTITYMEAN))));
        resultadosMap.put("sgenequantitysd", this.trataValorNumerico(retorno.get(listaIndex.get(QUANTITYSD))));
        resultadosMap.put("sgeneautomaticcdthreshold", this.trataValorNumerico(retorno.get(listaIndex.get(AUTOMATICCTTHRESHOLD))));
        resultadosMap.put("sgenectthreshold", this.trataValorNumerico(retorno.get(listaIndex.get(CTTHRESHOLD))));
        resultadosMap.put("sgeneautomaticbaseline", this.trataValorNumerico(retorno.get(listaIndex.get(AUTOMATICBASELINE))));
        resultadosMap.put("sgenebaselinestart", this.trataValorNumerico(retorno.get(listaIndex.get(BASELINESTART))));
        resultadosMap.put("sgenebaselineend", this.trataValorNumerico(retorno.get(listaIndex.get(BASELINEEND))));
        resultadosMap.put("sgenecomments", this.trataValorNumerico(retorno.get(listaIndex.get(COMMENTS))));
        resultadosMap.put("sgeneexpfail", this.trataValorNumerico(retorno.get(listaIndex.get(EXPFAIL))));
        return resultadosMap;
    }

    private Map<String, Object> getNGene(List<Object> retorno, HashMap<String, Integer> listaIndex) {
        HashMap<String, Object> resultadosMap = new HashMap<String, Object>();
        resultadosMap.put("ngenetask", this.trataValorNumerico(retorno.get(listaIndex.get(TASK))));
        resultadosMap.put("ngenereporter", this.trataValorNumerico(retorno.get(listaIndex.get(REPORTER))));
        resultadosMap.put("ngenequencher", this.trataValorNumerico(retorno.get(listaIndex.get(QUENCHER))));
        resultadosMap.put("ngenect", this.trataValorNumerico(retorno.get(listaIndex.get(CT))));
        resultadosMap.put("ngenectmean", this.trataValorNumerico(retorno.get(listaIndex.get(CTMEAN))));
        resultadosMap.put("ngenectsd", this.trataValorNumerico(retorno.get(listaIndex.get(CTSD))));
        resultadosMap.put("ngenequantity", this.trataValorNumerico(retorno.get(listaIndex.get(QUANTITY))));
        resultadosMap.put("ngenequantitymean", this.trataValorNumerico(retorno.get(listaIndex.get(QUANTITYMEAN))));
        resultadosMap.put("ngenequantitysd", this.trataValorNumerico(retorno.get(listaIndex.get(QUANTITYSD))));
        resultadosMap.put("ngeneautomaticcdthreshold", this.trataValorNumerico(retorno.get(listaIndex.get(AUTOMATICCTTHRESHOLD))));
        resultadosMap.put("ngenectthreshold", this.trataValorNumerico(retorno.get(listaIndex.get(CTTHRESHOLD))));
        resultadosMap.put("ngeneautomaticbaseline", this.trataValorNumerico(retorno.get(listaIndex.get(AUTOMATICBASELINE))));
        resultadosMap.put("ngenebaselinestart", this.trataValorNumerico(retorno.get(listaIndex.get(BASELINESTART))));
        resultadosMap.put("ngenebaselineend", this.trataValorNumerico(retorno.get(listaIndex.get(BASELINEEND))));
        resultadosMap.put("ngenecomments", this.trataValorNumerico(retorno.get(listaIndex.get(COMMENTS))));
        resultadosMap.put("ngeneexpfail", this.trataValorNumerico(retorno.get(listaIndex.get(EXPFAIL))));
        return resultadosMap;
    }

    private Map<String, Object> getMS2(List<Object> retorno, HashMap<String, Integer> listaIndex) {
        HashMap<String, Object> resultadosMap = new HashMap<String, Object>();
        resultadosMap.put("ms2task", this.trataValorNumerico(retorno.get(listaIndex.get(TASK))));
        resultadosMap.put("ms2reporter", this.trataValorNumerico(retorno.get(listaIndex.get(REPORTER))));
        resultadosMap.put("ms2quencher", this.trataValorNumerico(retorno.get(listaIndex.get(QUENCHER))));
        resultadosMap.put("ms2ct", this.trataValorNumerico(retorno.get(listaIndex.get(CT))));
        resultadosMap.put("ms2ctmean", this.trataValorNumerico(retorno.get(listaIndex.get(CTMEAN))));
        resultadosMap.put("ms2ctsd", this.trataValorNumerico(retorno.get(listaIndex.get(CTSD))));
        resultadosMap.put("ms2quantity", this.trataValorNumerico(retorno.get(listaIndex.get(QUANTITY))));
        resultadosMap.put("ms2quantitymean", this.trataValorNumerico(retorno.get(listaIndex.get(QUANTITYMEAN))));
        resultadosMap.put("ms2quantitysd", this.trataValorNumerico(retorno.get(listaIndex.get(QUANTITYSD))));
        resultadosMap.put("ms2automaticcdthreshold", this.trataValorNumerico(retorno.get(listaIndex.get(AUTOMATICCTTHRESHOLD))));
        resultadosMap.put("ms2ctthreshold", this.trataValorNumerico(retorno.get(listaIndex.get(CTTHRESHOLD))));
        resultadosMap.put("ms2automaticbaseline", this.trataValorNumerico(retorno.get(listaIndex.get(AUTOMATICBASELINE))));
        resultadosMap.put("ms2baselinestart", this.trataValorNumerico(retorno.get(listaIndex.get(BASELINESTART))));
        resultadosMap.put("ms2baselineend", this.trataValorNumerico(retorno.get(listaIndex.get(BASELINEEND))));
        resultadosMap.put("ms2comments", this.trataValorNumerico(retorno.get(listaIndex.get(COMMENTS))));
        resultadosMap.put("ms2expfail", this.trataValorNumerico(retorno.get(listaIndex.get(EXPFAIL))));
        return resultadosMap;
    }

    private Object trataValorNumerico(Object object) {
        if (Funcoes.isNumeric(object.toString())) {
            return object.toString().replace(".", ",");
        }
        return object;
    }

    private List<List<Object>> lerXls(File file, String string, boolean retornaValor, HashMap<String, Integer> listaIndex) throws Exception {
        ArrayList<List<Object>> linhas = new ArrayList<List<Object>>();
        Workbook workbook = WorkbookFactory.create((InputStream)new FileInputStream(file));
        Sheet plan1 = workbook.getSheetAt(0);
        this.processaLinha(linhas, listaIndex, plan1.getRow(7).cellIterator(), plan1.iterator(), retornaValor);
        return linhas;
    }

    private void processaLinha(List<List<Object>> linhas, HashMap<String, Integer> listaIndex, Iterator<Cell> iteratorCelulaIndex, Iterator<Row> iteratorLinhas, boolean retornaValor) {
        int registroAtual = 0;
        this.preencheIndexInformacoes(listaIndex, iteratorCelulaIndex);
        while (iteratorLinhas.hasNext()) {
            Row linha = iteratorLinhas.next();
            if (!Funcoes.objectIsNull(linha) && registroAtual >= 7) {
                linhas.add(this.getCelulaValor(linha, retornaValor));
            }
            ++registroAtual;
        }
    }

    private void preencheIndexInformacoes(HashMap<String, Integer> listaIndex, Iterator<Cell> iterator) {
        int posicao = 0;
        while (iterator.hasNext()) {
            Cell celula = iterator.next();
            if (Funcoes.objectIsNull(celula)) continue;
            try {
                byte[] text = celula.getStringCellValue().getBytes("ISO-8859-1");
                listaIndex.put(new String(text, "ISO-8859-1"), posicao);
                ++posicao;
            }
            catch (UnsupportedEncodingException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            }
        }
    }

    private List<Object> getCelulaValor(Row linha, boolean retornaValor) {
        ArrayList<Object> colunas = new ArrayList<Object>();
        for (Cell cell : linha) {
            try {
                switch (cell.getCellType()) {
                    case 3: {
                        colunas.add("");
                        break;
                    }
                    case 4: {
                        colunas.add(new Boolean(cell.getBooleanCellValue()));
                        break;
                    }
                    case 5: {
                        colunas.add(cell.getErrorCellValue());
                        break;
                    }
                    case 2: {
                        colunas.add(retornaValor ? Double.valueOf(cell.getNumericCellValue()) : cell.getCellFormula());
                        break;
                    }
                    case 0: {
                        Double valor = cell.getNumericCellValue();
                        String valorFormatado = new BigDecimal(valor).toString();
                        colunas.add(valorFormatado);
                        break;
                    }
                    case 1: {
                        colunas.add(cell.getStringCellValue());
                        break;
                    }
                    default: {
                        colunas.add(cell.getStringCellValue());
                        break;
                    }
                }
            }
            catch (Exception e) {
                colunas.add("");
            }
        }
        return colunas;
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        try {
            Statement st = Conexao.getStatement();
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(exames.split(" ", 0), mco_codigo);
            String[] stringArray = exames.split(" ", 0);
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String s;
                int situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, s = stringArray[i], mco_codigo, rec_codigo);
                this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, s, mco_codigo, int_codigo, null, situacao < 2 ? 1 : 3);
            }
            Conexao.arquivaSQL();
            this.fireMensagemEnviada("Pedido(s) enviado(s) com sucesso para " + pac_nome, 0, 10000);
            this.equipamento.atualizarTabela(0);
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
            return "";
        }
    }
}

