/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.sdh20;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.InterfaceamentoConfiguracao;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLUtil;
import java.io.ByteArrayInputStream;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    private static final String VALOR = "v";
    private static final String TOKEN_MSG_BEGIN = "<!--:Begin:Msg:";
    private static final String TOKEN_MSG_END = "<!--:End:Msg:";
    private static final String TOKEN_CHKSUM_BEGIN = "<!--:Begin:Chksum:";
    private static final String TOKEN_CHKSUM_END = "<!--:End:Chksum:";
    private String NOME_EXAME = "HEMOG";
    InterfaceamentoConfiguracao configuracao;
    private ThreadRecebimento threadRecebimento = new ThreadRecebimento();
    public static final int EQUIP_TIMEOUT = 5000;
    public static final int MAX_TENTATIVAS = 2;
    String int_codigo;
    String fil_codigo;
    String req_codigo;
    String mco_codigo;
    String rec_codigo;
    String pac_nome;
    String pac_exames;
    String pac_sexo;
    String req_idade;
    String req_data;
    String req_hora;
    String acao;
    private static String RBC = "RBC";
    private static String MCV = "MCV";
    private static String HCT = "HCT";
    private static String MCH = "MCH";
    private static String MCHC = "MCHC";
    private static String RDWR = "RDWR";
    private static String RDWA = "RDWA";
    private static String PLT = "PLT";
    private static String MPV = "MPV";
    private static String PCT = "PCT";
    private static String PDW = "PDW";
    private static String LPCR = "LPCR";
    private static String HGB = "HGB";
    private static String WBC = "WBC";
    private static String LA = "LA";
    private static String MA = "MA";
    private static String GA = "GA";
    private static String LR = "LR";
    private static String MR = "MR";
    private static String GR = "GR";
    private String restoMsgAnterior = "";

    public InterfaceListener() {
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        this.configuracao = new InterfaceamentoConfiguracao();
        this.configuracao.setXmlVariaveis(c.getVariaveisConfiguracao());
    }

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
        try {
            if (this.isTX()) {
                this.abortarTransmissao();
            } else if (!this.isRX()) {
                this.setIdle();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            this.limpaDadosRequisicao();
            this.setIdle();
        }
    }

    @Override
    public void dataChanged() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    String message = InterfaceListener.this.getPortaCOM().getInputString();
                    if (InterfaceListener.this.validaFinalMsg(message)) {
                        InterfaceListener.this.addListaRecebimento(message);
                        InterfaceListener.this.restartThreadRecebimento();
                        InterfaceListener.this.getPortaCOM().clearInputString();
                        if (InterfaceListener.this.isRX()) {
                            InterfaceListener.this.aguardarProximoFrame();
                        }
                    } else if (InterfaceListener.this.isRX()) {
                        InterfaceListener.this.aguardarProximoFrame();
                    }
                }
                catch (Exception ex) {
                    ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
                    InterfaceListener.this.fireMensagemEnviada("Erro ao receber dados do equipamento.", 1, 5000);
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
            }
        };
        SwingUtilities.invokeLater(run);
    }

    protected boolean validaFinalMsg(String message) {
        String bufferMessage;
        message = this.restoMsgAnterior + message;
        StringBuilder bui = new StringBuilder();
        boolean endBlock = false;
        String endCheckSum = ":muskhC:dnE:--!<";
        for (int i = message.length() - 1; i > 0; --i) {
            if (String.valueOf(message.charAt(i)).equals(String.valueOf('\n')) || String.valueOf(message.charAt(i)).equals(String.valueOf('\r'))) continue;
            bui.append(message.charAt(i));
            if (!bui.toString().contains(endCheckSum)) continue;
            endBlock = true;
            break;
        }
        bui.reverse();
        int pos = bui.indexOf("-->") + 3;
        if (pos > bui.length()) {
            pos = bui.length();
        }
        if (!(bufferMessage = bui.substring(0, pos)).contains(this.getMsgEnd())) {
            return false;
        }
        if (!bufferMessage.substring(bufferMessage.indexOf(this.getMsgEnd()) + this.getMsgEnd().length()).contains(":-->")) {
            return false;
        }
        String check = bufferMessage.substring(bufferMessage.indexOf(this.getMsgEnd()) + this.getMsgEnd().length());
        this.restoMsgAnterior = bui.substring(bui.indexOf("-->") + 3);
        return check.substring(0, check.indexOf(":-->")).split(":").length == 3;
    }

    @Override
    public void handShakeCharReceived(final char c) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    switch (c) {
                        case '\u0006': {
                            InterfaceListener.this.tratarAcknowledge();
                            break;
                        }
                        case '\u0015': {
                            InterfaceListener.this.tratarNegativeAck();
                            break;
                        }
                        case '\u0018': {
                            InterfaceListener.this.tratarCancel();
                            break;
                        }
                        case '\u007f': {
                            InterfaceListener.this.tratarDelete();
                            break;
                        }
                        default: {
                            InterfaceListener.this.caracterNaoEsperado();
                            break;
                        }
                    }
                }
                catch (Exception ex) {
                    ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
                    InterfaceListener.this.fireMensagemEnviada("Erro ao estabelecer comunica\u00e7\u00e3o com o equipamento.", 1, 5000);
                    InterfaceListener.this.setIdle();
                }
            }
        };
        SwingUtilities.invokeLater(run);
    }

    @Override
    public String getMsgStart() {
        return TOKEN_CHKSUM_BEGIN;
    }

    @Override
    public String getMsgEnd() {
        return TOKEN_CHKSUM_END;
    }

    @Override
    public String parse(String message) {
        String retorno = null;
        List<String> messages = this.checksum(message);
        if (!messages.isEmpty()) {
            try {
                for (String msg : messages) {
                    retorno = this.parseResults(msg);
                }
                return retorno;
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, "Erro ao inserir resultados recebidos ao banco de dados.\n" + ex.getMessage(), ex.getStackTrace());
                try {
                    Conexao.anulaSQL();
                    return "Erro ao inserir resultados recebidos ao banco de dados";
                }
                catch (SQLException e) {
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                    return "Erro ao inserir resultados recebidos ao banco de dados";
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.toString() + "\n" + e.getMessage(), e.getStackTrace());
                return "Erro ao realizar parse dos dados recebidos";
            }
        }
        return "Erro ao receber resultado: CheckSum inv\u00e1lidos!";
    }

    private String parseResults(String message) throws Exception {
        Document doc = XMLUtil.analisarXML(new ByteArrayInputStream(message.getBytes()));
        Element raiz = doc.getDocumentElement();
        Map<String, String> instrinfo = null;
        Map<String, String> smpinfo = null;
        Map<String, Map<String, String>> smpresults = null;
        Map<String, Map<String, Object>> hgrams = null;
        if (raiz.getNodeName().equalsIgnoreCase("sample")) {
            List<Element> entidades = XMLUtil.getElementosFilhos(raiz);
            for (Element entidade : entidades) {
                if (entidade.getNodeName().equalsIgnoreCase("ver")) {
                    String string = entidade.getTextContent();
                    continue;
                }
                if (entidade.getNodeName().equalsIgnoreCase("instrinfo")) {
                    instrinfo = this.parseParameter(entidade);
                    continue;
                }
                if (entidade.getNodeName().equalsIgnoreCase("smpinfo")) {
                    smpinfo = this.parseParameter(entidade);
                    continue;
                }
                if (entidade.getNodeName().equalsIgnoreCase("smpresults")) {
                    smpresults = this.parseMultiParameter(entidade);
                    continue;
                }
                if (entidade.getNodeName().equalsIgnoreCase("tparams")) continue;
                if (entidade.getNodeName().equalsIgnoreCase("hgrams")) {
                    hgrams = this.parseHistograms(entidade);
                    continue;
                }
                if (!entidade.getNodeName().equalsIgnoreCase("rawdata")) continue;
            }
        }
        if (smpresults != null && smpinfo != null) {
            String id = (String)smpinfo.get("ID");
            String id2 = (String)smpinfo.get("ID2");
            if (Funcoes.textoVazio(id)) {
                id = id2;
            }
            if (Funcoes.textoVazio(id) || id.length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                this.fireExcecaoEncontrada("Resultados recebidos para requisi\u00e7\u00e3o inv\u00e1lida ou n\u00e3o interfaceada: " + id);
                return null;
            }
            this.fil_codigo = id.substring(0, ParametrosGerais.getDigitosTuboFilial());
            this.rec_codigo = id.substring(id.length() - ParametrosGerais.getDigitosTuboTubo());
            this.req_codigo = id.substring(ParametrosGerais.getDigitosTuboFilial(), id.length() - ParametrosGerais.getDigitosTuboTubo());
            this.int_codigo = this.getIntCodigo(this.fil_codigo, this.req_codigo, this.rec_codigo, this.NOME_EXAME);
            Statement st = Conexao.getStatement();
            if (this.int_codigo == null) {
                int situacao = this.getExameSituacao(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.NOME_EXAME, this.mco_codigo, this.rec_codigo);
                StringBuilder s = new StringBuilder();
                s.append("N\u00e3o foi poss\u00edvel encontrar o exame! O exame encontra-se ");
                if (situacao == 8) {
                    s.append("exportado!");
                } else {
                    s.append("sem situa\u00e7\u00e3o!");
                }
                s.append("(").append(id).append(")");
                this.fireExcecaoEncontrada(s.toString());
                return null;
            }
            String[][] parametrosDePara = new String[][]{{RBC, "hemacias"}, {MCV, "celulas_media_contagem"}, {HCT, "hct"}, {MCH, "hcm"}, {MCHC, "mchc"}, {RDWR, "rdw"}, {RDWA, "rdwa"}, {PLT, "plaquetas"}, {MPV, "vpm"}, {PCT, "pct"}, {PDW, "pdw"}, {LPCR, "lpcr"}, {HGB, "hgb"}, {WBC, "leucocitos"}, {LA, "linfocitos_tipicos_contagem"}, {MA, "ma"}, {GA, "granulocitos_contagem"}, {LR, "linfocitos_tipicos_percentual"}, {MR, "mr"}, {GR, "granulocitos_percentual"}};
            HashMap<String, Object> hemograma = new HashMap<String, Object>();
            for (String[] param : parametrosDePara) {
                this.parseParameter(smpresults, hemograma, param[0], param[1]);
            }
            List<BDExame> exames = BDUtil.getReqExamesMultGuia(this.fil_codigo, this.int_codigo, this.req_codigo, this.rec_codigo);
            for (BDExame exame : exames) {
                this.atualizarDadosExame(st, this.fil_codigo, exame.getRequisicao(), exame.getRecipiente(), exame.getExame(), exame.getMaterial(), this.int_codigo, hemograma);
            }
            Conexao.arquivaSQL();
        }
        return "";
    }

    private void parseParameter(Map<String, Map<String, String>> smpresults, Map<String, Object> hemograma, String parametroInterface, String parametroJalis) {
        if (smpresults.containsKey(parametroInterface) && smpresults.get(parametroInterface).containsKey(VALOR)) {
            hemograma.put(parametroJalis, smpresults.get(parametroInterface).get(VALOR).replace('.', ','));
        }
    }

    private void geraHistogramas(Map<String, String> smpinfo, Map<String, Map<String, Object>> hgrams) {
        for (String key : hgrams.keySet()) {
            int rangeMin = 0;
            int rangeMax = 0;
            int numberOfBins = 0;
            int filterFactor = 0;
            int discriminatorIndex = 0;
            int escala = 0;
            if (hgrams.get(key).containsKey("hgdata")) {
                if (hgrams.get(key).containsKey("min")) {
                    rangeMin = Integer.parseInt(String.valueOf(hgrams.get(key).get("min")));
                }
                if (hgrams.get(key).containsKey("m")) {
                    rangeMax = Integer.parseInt(String.valueOf(hgrams.get(key).get("m")));
                }
                if (hgrams.get(key).containsKey("k")) {
                    numberOfBins = Integer.parseInt(String.valueOf(hgrams.get(key).get("k")));
                }
                if (hgrams.get(key).containsKey("w")) {
                    filterFactor = Integer.parseInt(String.valueOf(hgrams.get(key).get("w")));
                }
                if (!hgrams.get(key).containsKey("histogram") || !(hgrams.get(key).get("histogram") instanceof Map)) continue;
                Map histogram = (Map)hgrams.get(key).get("histogram");
                for (String string : histogram.keySet()) {
                }
                continue;
            }
            if (hgrams.get(key).containsKey("min")) {
                rangeMin = Integer.parseInt(String.valueOf(hgrams.get(key).get("min")));
            }
            if (hgrams.get(key).containsKey("m")) {
                rangeMax = Integer.parseInt(String.valueOf(hgrams.get(key).get("m")));
            }
            if (hgrams.get(key).containsKey("k")) {
                numberOfBins = Integer.parseInt(String.valueOf(hgrams.get(key).get("k")));
            }
            if (hgrams.get(key).containsKey("w")) {
                filterFactor = Integer.parseInt(String.valueOf(hgrams.get(key).get("w")));
            }
            if (!hgrams.get(key).containsKey("d")) continue;
            discriminatorIndex = Integer.parseInt(String.valueOf(hgrams.get(key).get("d")));
            escala = discriminatorIndex * (rangeMax / numberOfBins);
        }
    }

    private Map<String, Map<String, Object>> parseHistograms(Element entidade) {
        List<Element> filhos = XMLUtil.getElementosFilhos(entidade);
        HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>();
        for (Element e : filhos) {
            if (!e.getNodeName().equals("hgram")) continue;
            List<Element> hgram = XMLUtil.getElementosFilhos(e);
            String name = null;
            HashMap<String, Object> param = new HashMap<String, Object>();
            HashMap<String, String> histogram = new HashMap<String, String>();
            for (Element ele : hgram) {
                if (ele.getNodeName().equals("n")) {
                    name = ele.getTextContent();
                    continue;
                }
                if (ele.getNodeName().equals("hgdata")) {
                    List<Element> hgdata = XMLUtil.getElementosFilhos(ele);
                    String nameHg = "hgdata";
                    String value = null;
                    for (Element element : hgdata) {
                        if (element.getNodeName().equals("n")) {
                            nameHg = element.getTextContent();
                            continue;
                        }
                        if (!element.getNodeName().equals(VALOR)) continue;
                        value = element.getTextContent();
                    }
                    if (Funcoes.textoVazio(value)) continue;
                    histogram.put(nameHg, value);
                    continue;
                }
                param.put(ele.getNodeName(), ele.getTextContent());
            }
            if (!histogram.isEmpty()) {
                param.put("histogram", histogram);
            }
            if (Funcoes.textoVazio(name)) continue;
            map.put(name, param);
        }
        return map;
    }

    private Map<String, String> parseParameter(Element entidade) {
        List<Element> filhos = XMLUtil.getElementosFilhos(entidade);
        HashMap<String, String> map = new HashMap<String, String>();
        for (Element e : filhos) {
            if (!e.getNodeName().equals("p")) continue;
            this.addParameter(e, map);
        }
        return map;
    }

    private Map<String, Map<String, String>> parseMultiParameter(Element entidade) {
        List<Element> filhos = XMLUtil.getElementosFilhos(entidade);
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        for (Element e : filhos) {
            if (!e.getNodeName().equals("p")) continue;
            InterfaceListener.addMultiParameter(e, map);
        }
        return map;
    }

    private void addParameter(Element entidade, Map<String, String> map) throws DOMException {
        List<Element> parametro = XMLUtil.getElementosFilhos(entidade);
        String name = null;
        String value = null;
        for (Element p : parametro) {
            if (p.getNodeName().equals("n")) {
                name = p.getTextContent();
                continue;
            }
            if (!p.getNodeName().equals(VALOR)) continue;
            value = p.getTextContent();
        }
        if (!Funcoes.textoVazio(name) && !Funcoes.textoVazio(value)) {
            map.put(name, value);
        }
    }

    private static void addMultiParameter(Element entidade, Map<String, Map<String, String>> map) throws DOMException {
        List<Element> parametro = XMLUtil.getElementosFilhos(entidade);
        String name = null;
        HashMap<String, String> parameter = new HashMap<String, String>();
        for (Element p : parametro) {
            if (p.getNodeName().equals("n")) {
                name = p.getTextContent();
                continue;
            }
            parameter.put(p.getNodeName(), p.getTextContent());
        }
        if (!Funcoes.textoVazio(name) && !parameter.isEmpty()) {
            map.put(name, parameter);
        }
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        try {
            String[] exms;
            Statement st = Conexao.getStatement();
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(exames.split(" ", 0), mco_codigo);
            for (String s : exms = exames.split(" ", 0)) {
                this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, s, mco_codigo, int_codigo, null, 1);
            }
            Conexao.arquivaSQL();
            this.fireMensagemEnviada("Pedido(s) enviado(s) com sucesso para " + pac_nome, 0, 10000);
            this.equipamento.atualizarTabela(0);
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
            return "";
        }
    }

    private void abortarTransmissao() throws Exception {
        this.limpaDadosRequisicao();
        this.setPausa(5000);
        this.fireMensagemEnviada("Tempo esgotado ao transmitir dados ao equipamento", 1, 5000);
    }

    private void abortarRecepcao() throws Exception {
        this.limpaDadosRequisicao();
        this.setPausa(3000);
    }

    void limpaDadosRequisicao() {
        this.req_codigo = null;
        this.mco_codigo = null;
        this.rec_codigo = null;
        this.pac_nome = null;
        this.pac_sexo = null;
        this.req_idade = null;
        this.req_data = null;
        this.req_hora = null;
    }

    private void addListaRecebimento(String message) {
        this.threadRecebimento.addListaRecebimento(message);
        this.restartThreadRecebimento();
    }

    private void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            ArrayList<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento();
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        if (this.threadRecebimento != null) {
            this.threadRecebimento.start();
        }
    }

    private void aguardarProximoFrame() throws Exception {
        this.setRX(5000);
        this.fireMensagemEnviada("Recebendo dados...", 0, 10000);
    }

    public void caracterNaoEsperado() throws Exception {
    }

    private void tratarAcknowledge() throws Exception {
        if (!this.isTX()) {
            this.caracterNaoEsperado();
        }
    }

    private void tratarNegativeAck() throws Exception {
        if (!this.isTX()) {
            this.caracterNaoEsperado();
        }
    }

    private void tratarCancel() throws Exception {
        if (!this.isTX()) {
            this.caracterNaoEsperado();
        }
    }

    private void tratarDelete() throws Exception {
        if (!this.isTX()) {
            this.caracterNaoEsperado();
        }
    }

    public List<String> checksum(String bufferMessage) {
        ArrayList<String> msgValidas = new ArrayList<String>();
        ArrayList<String> messages = new ArrayList<String>();
        ArrayList<String> listIdMsg = new ArrayList<String>();
        bufferMessage = bufferMessage.replaceAll(String.valueOf('\n'), "");
        bufferMessage = bufferMessage.replaceAll(LINE, String.valueOf('\n'));
        bufferMessage = bufferMessage.replaceAll(String.valueOf('\r'), String.valueOf('\n'));
        for (String str : bufferMessage.split(this.getMsgStart())) {
            if (Funcoes.textoVazio(str) || !str.contains(this.getMsgEnd())) continue;
            messages.add(String.format("%s%s", this.getMsgStart(), str));
        }
        for (String message : messages) {
            byte cs1 = 0;
            byte cs2 = 0;
            int posBegin = message.indexOf(this.getMsgStart());
            String[] beginToken = message.substring(posBegin + this.getMsgStart().length(), posBegin + this.getMsgStart().length() + 5).split(":");
            if (beginToken.length >= 1 && beginToken[0].equals("0")) {
                msgValidas.add(message.substring(posBegin + 23, message.indexOf(this.getMsgEnd())));
                continue;
            }
            int posEnd = message.indexOf(this.getMsgEnd());
            String[] checkSumTransferred = message.substring(posEnd + 16).split(":");
            if (checkSumTransferred.length < 3 || !checkSumTransferred[0].equals("1")) continue;
            byte checkSumTransferred1 = (byte)Integer.parseInt(checkSumTransferred[1]);
            byte checkSumTransferred2 = (byte)Integer.parseInt(checkSumTransferred[2]);
            String msg = message.substring(posBegin + 23, posEnd);
            for (byte b : msg.getBytes()) {
                cs1 = (byte)(cs1 + b);
                cs2 = (byte)(cs2 + cs1);
            }
            cs1 = (byte)(cs1 + checkSumTransferred1);
            cs2 = (byte)(cs2 + cs1);
            cs1 = (byte)(cs1 + checkSumTransferred2);
            cs2 = (byte)(cs2 + cs2);
            String idMsg = "";
            if (cs1 != 0 || cs2 != 0 || listIdMsg.contains(idMsg = this.verificaMensagem(msg))) continue;
            listIdMsg.add(idMsg);
            msgValidas.add(msg);
        }
        return msgValidas;
    }

    private String verificaMensagem(String message) {
        int posBegin = message.indexOf(TOKEN_MSG_BEGIN);
        int posEnd = message.indexOf(TOKEN_MSG_END);
        String[] beginToken = message.substring(posBegin + TOKEN_MSG_BEGIN.length(), posBegin + TOKEN_MSG_BEGIN.length() + 7).split(":");
        String[] endToken = message.substring(posEnd + TOKEN_MSG_END.length(), posEnd + TOKEN_MSG_END.length() + 7).split(":");
        if (beginToken.length >= 2 && endToken.length >= 2 && beginToken[0].equals(endToken[0])) {
            if (beginToken[1].equals("1")) {
                return beginToken[0];
            }
            if (beginToken[1].equals("2")) {
                return "";
            }
        } else {
            return "";
        }
        return beginToken[0];
    }

    class ThreadRecebimento
    extends Thread {
        private ArrayList<String> listaRecebimento = new ArrayList();

        ThreadRecebimento() {
        }

        public ArrayList<String> getListaRecebimento() {
            return this.listaRecebimento;
        }

        public void addListaRecebimento(String message) {
            this.listaRecebimento.add(message);
        }

        public void addListaRecebimentos(ArrayList<String> messages) {
            this.listaRecebimento.addAll(messages);
        }

        @Override
        public void run() {
            try {
                while (this.listaRecebimento.size() > 0) {
                    String message = this.listaRecebimento.remove(0);
                    String resultado = InterfaceListener.this.parse(message);
                    if (resultado != null) {
                        InterfaceListener.this.fireMensagemEnviada(resultado, 0, 10000);
                    }
                    ThreadRecebimento.sleep(450L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

