/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.response920Socket;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public class RecordParser
extends jalis.laboratorio.interfaceamento.interfaces.response920.RecordParser {
    public synchronized Map<String, Object> recordFound(String record, Map<String, Object> exame_atual) throws Exception {
        return this.recFound(record, exame_atual);
    }

    public Map<String, Object> recFound(String record, Map<String, Object> exame_atual) throws Exception {
        String record_type;
        int pos = 0;
        if (Funcoes.isNumeric(String.valueOf(record.charAt(0)))) {
            pos = 1;
        }
        if ((record_type = ASTMStandard.getRecordTypeIdentifier(record = record.substring(pos, record.length() - 1))) != null) {
            if (record_type.equals(ASTMStandard.RECORD_TYPE_HEADER)) {
                this.trataHeaderRecord(record);
                return exame_atual;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_PATIENT)) {
                this.trataPatientRecord(record);
                return exame_atual;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_ORDER)) {
                exame_atual = this.trataOrderRecord(record, exame_atual);
                return exame_atual;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_RESULT)) {
                exame_atual = this.trataResultRecord(record, exame_atual);
                return exame_atual;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_COMMENT)) {
                this.trataCommentRecord(record);
                return exame_atual;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_REQUEST)) {
                this.trataRequestRecord(record);
                return exame_atual;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_TERMINATION)) {
                this.trataTerminationRecord();
                return exame_atual;
            }
        }
        return null;
    }

    protected Map<String, Object> trataResultRecord(String record, Map<String, Object> exame_atual) throws SQLException {
        String flags;
        String emi_alternativo;
        Hashtable result_fields;
        String result_status;
        if (exame_atual == null) {
            return null;
        }
        String action_code = (String)exame_atual.get(ACTION_CODE);
        String report_type = (String)exame_atual.get(REPORT_TYPE);
        if (action_code != null) {
            this.equip.getClass();
            if (action_code.equals("Q")) {
                return exame_atual;
            }
        }
        if (report_type != null) {
            this.equip.getClass();
            if (report_type.equals("X")) {
                return exame_atual;
            }
        }
        if ((result_status = (String)(result_fields = ASTMStandard.parseDefaultResultRecord(record)).get(ASTMStandard.RESULT_FIELD_RESULT_STATUS)) != null) {
            this.equip.getClass();
            if (!result_status.equals("F")) {
                this.equip.getClass();
                if (!result_status.equals("R")) {
                    return exame_atual;
                }
            }
        }
        String fil_codigo = (String)exame_atual.get(FIL_CODIGO);
        String req_codigo = (String)exame_atual.get(REQ_CODIGO);
        String exa_codigo = (String)exame_atual.get(EXA_CODIGO);
        String mco_codigo = (String)exame_atual.get(MCO_CODIGO);
        String rec_codigo = (String)exame_atual.get(REC_CODIGO);
        String resultado = (String)result_fields.get(ASTMStandard.RESULT_FIELD_MEASUREMENT_VALUE);
        this.equip.getClass();
        if (result_status.equals("F")) {
            resultado = resultado.replaceAll("\\.", ",");
        }
        if (resultado.startsWith(",")) {
            resultado = "0" + resultado;
        }
        if (resultado.charAt(resultado.length() - 1) == ',') {
            resultado = resultado + "0";
        }
        if ((emi_alternativo = (String)result_fields.get(ASTMStandard.RESULT_FIELD_TEST_ID)).contains("^")) {
            emi_alternativo = StringUtil.limpaString(emi_alternativo, new String[]{"^"});
        }
        String int_codigo = this.equip.getIntCodigo(fil_codigo, req_codigo, rec_codigo, emi_alternativo);
        exame_atual.put(INT_CODIGO, int_codigo);
        exame_atual.put(FIL_CODIGO, fil_codigo);
        exame_atual.put(REC_CODIGO, rec_codigo);
        exame_atual.put(REQ_CODIGO, req_codigo);
        if (int_codigo == null) {
            this.equip.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado na interface para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
            return exame_atual;
        }
        ExameMaterial exame = this.equip.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo);
        if (exame == null) {
            this.equip.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
            return exame_atual;
        }
        exame_atual.put(EXA_CODIGO, exame.getNomeExame());
        exame_atual.put(MCO_CODIGO, exame.getCodigoMaterial());
        Statement st = Conexao.getStatement();
        int sit = this.equip.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo);
        String campo = sit < 3 ? "resultado_quantitativo" : "repeticao_quantitativo";
        exame_atual.put(campo, resultado);
        if (exame_atual != null) {
            try {
                String filial = (String)exame_atual.get(FIL_CODIGO);
                String requisicao = (String)exame_atual.get(REQ_CODIGO);
                String tubo = (String)exame_atual.get(REC_CODIGO);
                this.salvaExame(exame_atual);
                exame_atual.put(FIL_CODIGO, filial);
                exame_atual.put(REQ_CODIGO, requisicao);
                exame_atual.put(REC_CODIGO, tubo);
                exame_atual.remove(campo);
            }
            catch (Exception e) {
                StringBuilder msg = new StringBuilder(e.getMessage());
                msg.append("\n").append("Erro ao receber resultado ");
                msg.append("\n").append(fil_codigo).append(" ").append(req_codigo).append(" ").append(rec_codigo);
                msg.append("\n").append(record);
                ErrorLogger.mostraMensagem(null, msg.toString(), e.getStackTrace());
            }
        }
        if ((flags = (String)result_fields.get(ASTMStandard.RESULT_FIELD_ABNORMAL_FLAGS)) != null && !flags.equals("")) {
            exame_atual.put("flag_alerta", flags);
            return exame_atual;
        }
        return exame_atual;
    }

    protected Map<String, Object> trataOrderRecord(String record, Map<String, Object> exame_atual) throws Exception {
        if (exame_atual != null) {
            this.salvaExame(exame_atual);
        }
        exame_atual = new HashMap<String, Object>();
        Hashtable<Integer, String> order_fields = ASTMStandard.parseDefaultOrderRecord(record);
        exame_atual.put(ACTION_CODE, order_fields.get(ASTMStandard.ORDER_FIELD_ACTION_CODE));
        exame_atual.put(REPORT_TYPE, order_fields.get(ASTMStandard.ORDER_FIELD_REPORT_TYPE));
        String instSID = (String)order_fields.get(ASTMStandard.ORDER_FIELD_SYSTEM_SID);
        Map<Integer, String> sys_sample_id = this.equip.parseOrderSystemSID(instSID);
        String req_codigo = (String)order_fields.get(ASTMStandard.ORDER_FIELD_SAMPLE_ID);
        DescritorCodigoEtiqueta etiqueta = DescritorCodigoEtiqueta.getDescritor(req_codigo);
        if (req_codigo == null || req_codigo.equals("")) {
            req_codigo = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_ID);
        }
        if (!Funcoes.textoVazio(req_codigo) && req_codigo.contains("^")) {
            req_codigo = StringUtil.limpaString(req_codigo, new String[]{"^"});
        }
        try {
            Long.parseLong(req_codigo);
        }
        catch (Exception ex) {
            StringBuilder msg = new StringBuilder();
            msg.append("Resultados recebidos para requisi\u00e7\u00e3o n\u00e3o existente ou n\u00e3o interfaceada: ");
            msg.append(req_codigo);
            this.equip.fireExcecaoEncontrada(msg.toString());
            exame_atual = null;
            return exame_atual;
        }
        int qtde = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
        req_codigo = Funcoes.preencheZero(req_codigo, qtde);
        String rack_id = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_RACK_ID);
        String rack_pos = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_RACK_POS);
        exame_atual.put("rack_position", rack_id != null ? rack_id + (rack_pos != null ? "-" + rack_pos : "") : rack_pos);
        String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
        String rec_codigo = req_codigo.substring(req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
        req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial(), req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
        Map<Integer, String> components = this.equip.parseOrderTestIDField((String)order_fields.get(ASTMStandard.ORDER_FIELD_TEST_ID));
        if (etiqueta != null) {
            fil_codigo = Funcoes.preencheZero(etiqueta.getFilial(), ParametrosGerais.getDigitosTuboFilial());
            req_codigo = Funcoes.preencheZero(etiqueta.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao());
            rec_codigo = Funcoes.preencheZero(etiqueta.getTubo(), ParametrosGerais.getDigitosTuboTubo());
        }
        exame_atual.put(FIL_CODIGO, fil_codigo);
        exame_atual.put(REC_CODIGO, rec_codigo);
        exame_atual.put(REQ_CODIGO, req_codigo);
        return exame_atual;
    }
}

