/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.response920Socket;

import jalis.comum.Conexao;
import jalis.laboratorio.interfaceamento.abas.RefreshTimer;
import jalis.laboratorio.interfaceamento.comunicacao.AbstractPort;
import jalis.laboratorio.interfaceamento.comunicacao.PortaSocketServer;
import jalis.laboratorio.interfaceamento.interfaces.response920Socket.RecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.util.ListUtil;
import jalis.util.MemoryList;
import jalis.util.logger.ErrorLogger;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Timer;

public class InterfaceListener
extends jalis.laboratorio.interfaceamento.interfaces.response920.InterfaceListener {
    private Timer porta = null;
    private boolean heartbit = false;

    public InterfaceListener() {
        RecordParser record = new RecordParser();
        record.setInterfaceASTMListener(this);
        super.setASTMRecordParser(record);
        this.porta = new Timer(10000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (InterfaceListener.this.getPortaCOM() != null && !InterfaceListener.this.isTX() && !InterfaceListener.this.isRX() || InterfaceListener.this.getPortaCOM() != null && InterfaceListener.this.isRX()) {
                    try {
                        if (!InterfaceListener.this.heartbit) {
                            InterfaceListener.this.setTX(InterfaceListener.this.TIME_TX);
                            InterfaceListener.this.getPortaCOM().write(String.valueOf('\u0005'));
                            InterfaceListener.this.heartbit = true;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        this.porta.start();
    }

    @Override
    public void fcTimedOut(EventObject e) {
        super.fcTimedOut(e);
        if (this.heartbit) {
            this.heartbit = false;
        }
    }

    @Override
    public void handShakeCharReceived(char c) {
        try {
            switch (c) {
                case '\u0005': {
                    if (this.isTX() || this.tx_list.size() > 0 && this.rx_counter < this.MAX_TENTATIVAS_RX) {
                        this.getPortaCOM().write(String.valueOf('\u0015'));
                        ++this.rx_counter;
                        break;
                    }
                    this.rx_counter = 0;
                    this.tratarEnquiry();
                    break;
                }
                case '\u0006': {
                    if (this.heartbit) {
                        this.getPortaCOM().write(String.valueOf('\u0004'));
                        this.setIdle();
                        this.heartbit = false;
                        this.porta.stop();
                        this.porta.setDelay(180000);
                        this.porta.start();
                    }
                    this.tratarAcknowledge();
                    break;
                }
                case '\u0015': {
                    this.tratarNegativeAck();
                    break;
                }
                case '\u0004': {
                    if (this.heartbit) {
                        this.heartbit = false;
                    }
                    this.tratarEndOfTX();
                    break;
                }
                default: {
                    this.caracterNaoEsperado();
                    break;
                }
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: evento de caracter de handshake recebido");
            this.fireMensagemEnviada("Erro ao estabelecer comunica\u00e7\u00e3o com o equipamento: " + ex.getMessage(), 1, 5000);
            if (this.tx_list.size() > 0) {
                this.limpaDadosRequisicao();
            }
            this.setIdle();
        }
    }

    @Override
    public String parse(String message) {
        try {
            String checksum = null;
            String termination = null;
            int stx_index = message.indexOf(this.getMsgStart());
            if (stx_index >= 0 && message.length() > 5) {
                if (stx_index > 0) {
                    message = message.substring(stx_index);
                } else if (stx_index < 0) {
                    return "Erro no bloco enviado pelo equipamento";
                }
            } else {
                return "Erro no bloco enviado pelo equipamento";
            }
            message = message.substring(1, message.length() - 2);
            checksum = message.substring(message.length() - 2);
            termination = message.substring(message.length() - 3, message.length() - 2);
            message = message.substring(0, message.length() - 2);
            if (this.checkCRC(message, checksum)) {
                if (this.middleFrame && this.rx_list.getUltimoInserido() <= this.rx_list.size()) {
                    message = (String)this.rx_list.get(this.rx_list.getUltimoInserido()) + message;
                    this.rx_list.remove(this.rx_list.getUltimoInserido());
                    this.middleFrame = false;
                }
                for (String msg : message.split(String.valueOf('\r'))) {
                    if (msg.length() <= 1 || !msg.contains("|")) continue;
                    this.rx_list.add(msg);
                }
                if (termination.equalsIgnoreCase(this.getMiddleFrameEnd())) {
                    this.middleFrame = true;
                    return "";
                }
                this.rx_list = (MemoryList)ListUtil.removeItemIgual(this.rx_list);
                ArrayList<String> msgResultado = new ArrayList<String>();
                while (!this.rx_list.isEmpty()) {
                    String s = (String)this.rx_list.remove(0);
                    String record = s.substring(0, s.length() - 1);
                    String record_type = ASTMStandard.getRecordTypeIdentifier(record);
                    if (record_type == null) continue;
                    if (record_type.equals(ASTMStandard.RECORD_TYPE_TERMINATION)) {
                        msgResultado.add(s);
                        ArrayList<String> resultado = new ArrayList<String>(msgResultado);
                        this.parseRes(resultado);
                        msgResultado.clear();
                        continue;
                    }
                    msgResultado.add(s);
                }
                Conexao.arquivaSQL();
                RefreshTimer.waitAndRefresh(this, this.TIME_TO_REFRESH);
                return "";
            }
            this.rx_list.clear();
            return "Erro ao receber bloco de dados: CRC incompat\u00edvel!";
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(null, ex.toString(), ex.getStackTrace(), "AbstractASTMInterfaceamento: parse");
            this.rx_list.clear();
            this.interromperTimer();
            this.setIdle();
            try {
                Conexao.anulaSQL();
                return "Erro ao analisar dados recebidos do equipamento.";
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o SQL em parse");
                return "Erro ao analisar dados recebidos do equipamento. Podem haver dados inconsistentes no BD.";
            }
        }
    }

    private synchronized void parseRes(List<String> resultado) throws Exception {
        RecordParser recordParser = new RecordParser();
        recordParser.setInterfaceASTMListener(this);
        Map<String, Object> exameAtual = new HashMap<String, Object>();
        boolean isOrdem = false;
        for (String s : resultado) {
            exameAtual = recordParser.recordFound(s, exameAtual);
        }
        Conexao.arquivaSQL();
        RefreshTimer.waitAndRefresh(this, this.TIME_TO_REFRESH);
    }

    @Override
    protected void encerrar() {
        if (this.porta != null) {
            this.porta.stop();
        }
    }

    @Override
    public void setPortaCOM(AbstractPort portaCOM) {
        if (portaCOM instanceof PortaSocketServer) {
            ((PortaSocketServer)portaCOM).setEscreverEmBytes(true);
        }
        super.setPortaCOM(portaCOM);
    }

    @Override
    public void teste() {
        StringBuilder bf = new StringBuilder();
        bf.append("[STX]1H|\\^&||||||||||P|E[SP]1394-97|20170524121815[CR]");
        bf.append("P|1|00067276|||BENEDETTI[SP]ANTENOR|||M||||||||0|0[CR]");
        bf.append("O|1|010006727604||^^^CREA\\^^^UREA\\^^^GLUC\\^^^HDLC|||||||||||SERUM[CR]");
        bf.append("R|2|^^^CREA|1.58|mg/dL|^DEFAULT|A|N|F||||20170524120905[CR]");
        bf.append("C|1|I|Instrument[SP]Flag[SP]A,HH[CR]");
        bf.append("R|3|^^^UREA|75.3|mg/dL|^DEFAULT|A|N|F||||20170524120923[CR]");
        bf.append("C|1|I|Instrument[SP]Flag[SP]A,HH[CR]");
        bf.append("R|1|^^^GLUC|103.1|mg/dL|^DEFAULT|H|N|F||||20170524111009[CR]");
        bf.append("C|1|I|Instrument[SP]Flag[SP]H[CR]");
        bf.append("R|4|^^^HDLC|43.0|mg/dL|^DEFAULT|N|N|F||||20170524115757[CR]");
        bf.append("C|1|I|Instrument[SP]Flag[SP]N[CR]");
        bf.append("L|1|N[CR]");
        bf.append("[ETX]53[LINE]");
        this.parse(this.equipamento.arruma(bf.toString()));
    }
}

