/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.rapidlab348;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.exames.InfoExameRequisicao;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.interfaceamento.util.Checksum;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    public static final char FS = '\u001c';
    public static final char GS = '\u001d';
    public static final char RS = '\u001e';
    public static final char XON = '\u0011';
    public static final char XOFF = '\u0013';
    private static final int TIME_TX = 10000;
    private static final String NOME_EXAME = "GASO";
    private static final String SAMPLE_INITIATED = "SMP_START";
    private static final String ACKNOWLEDGE = String.valueOf('\u0002') + String.valueOf('\u0006') + String.valueOf('\u0003') + "0B" + String.valueOf('\u0004');
    private static final String ASSAY_COMPLETE = "SMP_NEW_AV";
    private static final String REQUEST_SAMPLE_DATA = "SMP_REQ";
    private static final String SAMPLE_DATA = "SMP_NEW_DATA";
    private static final String SAMPLE_EDIT_DATA = "SMP_EDIT_DATA";
    private static final String SAMPLE_NOT_AVAILABLE = "SMP_NOT_AV";
    private static final String R_SEQ = "rSEQ";
    private static final String I_PID = "iPID";
    private static final String R_TYPE = "rTYPE";
    private static final String R_DATE = "rDate";
    private static final String R_TIME = "rTIME";
    private static final String R_DEVICE = "rDEVICE";
    private static final String I_OID = "iOID";
    private static final String AI_IID = "aiIID";
    private InfoExameRequisicao ultimo_enviado = new InfoExameRequisicao(null, null, null, null, null, null, null, null, null, null);
    private static final String M_PH = "mpH";
    private static final String M_H = "mH+";
    private static final String M_PO2 = "mPO2";
    private static final String C_PCO2 = "mPCO2";
    private static final String CP_H = "cpH";
    private static final String C_H = "cH+";
    private static final String I_TEMP = "iTEMP";
    private static final String IT_HB = "itHB";
    private static final String I_FIO2 = "iFIO2";
    private static final String C_HCO3_ACT = "cHCO3act";
    private static final String C_HCO3_STD = "cHCO3std";
    private static final String C_O2 = "cO2(CT)";
    private static final String CT_CO2 = "ctCO2";
    private static final String C_BE_VT = "cBE(vt)";
    private static final String C_BE_VV = "cBE(vv)";
    private static final String C_O2SAT = "cO2SAT";
    private static final String C_A_ADO2 = "cA-aDO2";
    private static final String CA_A = "ca/A";
    private static final String M_BP = "mBP";
    private static final String M_CA = "mCa++";
    private static final String A_MOD = "aMOD";
    private static final String I_IID = "iIID";
    private static final String I_QLEV = "iQLEV";
    private static final String I_QLOT = "iQLOT";
    private static final String S_LQ_MPH = "sLQmpH";
    private static final String S_HQ_MPH = "sHQmpH";
    private static final String S_LQ_MPO2 = "sLQmPO2";
    private static final String S_HQ_MPO2 = "sHQmPO2";
    private static final String S_LQ_MPCO2 = "sLQmPCO2";
    private static final String S_HQ_MPCO2 = "sHQmPCO2";
    private static final String MK = "mK+";
    private static final String MNA = "mNa+";
    private Map<String, String> fields = this.fields();
    private ThreadRecebimento threadRecebimento = new ThreadRecebimento();

    @Override
    public void dataChanged() {
        try {
            this.dataChanged(this.getPortaCOM().removeInputString(this.getMsgEnd()));
        }
        catch (IOException e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
    }

    public synchronized void dataChanged(String msg) throws IOException {
        if (this.mensagemEhValida(msg)) {
            if (!this.checkSumValido(msg)) {
                return;
            }
            String parseMsg = msg.substring(1, msg.indexOf(3));
            if (this.isAck(msg)) {
                if (this.isTX()) {
                    this.setIdle();
                }
                return;
            }
            if (parseMsg.startsWith(SAMPLE_INITIATED) || parseMsg.startsWith(SAMPLE_NOT_AVAILABLE)) {
                this.enviarAck();
                return;
            }
            if (parseMsg.startsWith(ASSAY_COMPLETE)) {
                this.enviarAck();
                this.responderRequest(parseMsg);
            } else if (parseMsg.startsWith(String.format("<%s>", String.valueOf('\u0006')))) {
                this.alteraSituacaoParaPendente();
            } else if (parseMsg.startsWith(SAMPLE_DATA) || parseMsg.startsWith(SAMPLE_EDIT_DATA)) {
                this.enviarAck();
                this.addListaRecebimento(parseMsg);
                this.restartThreadRecebimento();
            } else {
                this.enviarAck();
            }
        } else {
            this.setRX(10000);
            this.fireMensagemEnviada("Recebendo dados...", 0, 10000);
        }
    }

    private void enviarAck() throws IOException {
        this.getPortaCOM().write(ACKNOWLEDGE);
    }

    private boolean isAck(String msg) {
        return msg.equals(ACKNOWLEDGE);
    }

    private boolean mensagemEhValida(String msg) {
        return msg.startsWith(this.getMsgStart()) && msg.endsWith(this.getMsgEnd());
    }

    private void alteraSituacaoParaPendente() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                if (InterfaceListener.this.ultimo_enviado != null && InterfaceListener.this.ultimo_enviado.getExames() != null) {
                    InterfaceListener.this.enviarRequisicao(InterfaceListener.this.ultimo_enviado.getNome(), InterfaceListener.this.ultimo_enviado.getSexo(), InterfaceListener.this.ultimo_enviado.getIdade(), InterfaceListener.this.ultimo_enviado.getData(), InterfaceListener.this.ultimo_enviado.getHora(), InterfaceListener.this.ultimo_enviado.getRack(), null, InterfaceListener.this.ultimo_enviado.getFilial(), InterfaceListener.this.ultimo_enviado.getInterface(), InterfaceListener.this.ultimo_enviado.getCodigo(), InterfaceListener.this.ultimo_enviado.getMaterial(), InterfaceListener.this.ultimo_enviado.getRecipiente(), InterfaceListener.this.ultimo_enviado.getExames(), "A");
                }
            }
        });
        t.start();
    }

    public void responderRequest(String parseMsg) throws IOException {
        Map<String, Parametro> lista = this.obtemParametros(parseMsg);
        if (lista.containsKey(R_SEQ) && !Funcoes.textoVazio(lista.get((Object)R_SEQ).value)) {
            LinkedHashMap<String, Parametro> parametros = new LinkedHashMap<String, Parametro>();
            parametros.put(A_MOD, new Parametro(A_MOD, lista.get((Object)A_MOD).value, ""));
            parametros.put(I_IID, new Parametro(I_IID, lista.get((Object)I_IID).value, ""));
            parametros.put(R_SEQ, new Parametro(R_SEQ, lista.get((Object)R_SEQ).value, ""));
            String frame = this.montaFrame(REQUEST_SAMPLE_DATA, this.montaData(parametros));
            this.setTX(10000);
            this.getPortaCOM().write(frame);
        }
    }

    private Map<String, Parametro> obtemParametros(String mensagem) {
        HashMap<String, Parametro> lista = new HashMap<String, Parametro>();
        String[] fields = mensagem.split(String.valueOf('\u001c') + String.valueOf('\u001e'));
        if (fields.length != 2) {
            fields = mensagem.split(String.valueOf('\u001e'));
        }
        if (fields.length == 2) {
            String[] groups;
            String identifier = fields[0];
            for (String datas : groups = fields[1].split(String.valueOf('\u001c'))) {
                this.addParametro(lista, datas);
            }
        }
        return lista;
    }

    private void addParametro(Map<String, Parametro> lista, String datas) {
        String[] data = datas.split(String.valueOf('\u001d'));
        Parametro param = new Parametro(data[0], data.length == 2 ? data[1] : "", data.length == 3 ? data[2] : "");
        if (data.length == 4) {
            String[] exception = data[3].split(String.valueOf('\u0017'));
            if (exception.length >= 1 && !Funcoes.textoVazio(exception[0])) {
                param.exception[0] = exception[0];
            }
            if (exception.length == 2 && !Funcoes.textoVazio(exception[1])) {
                param.exception[1] = exception[1];
            }
        }
        if (Funcoes.textoVazio(param.value) && !Funcoes.textoVazio(data[1])) {
            param.value = data[1];
        }
        lista.put(param.name, param);
    }

    private boolean checkSumValido(String msg) {
        String crcCalc = Checksum.getChecksumMod256(msg.substring(0, msg.indexOf(3)));
        String crcRx = msg.substring(msg.indexOf(3) + 1, msg.indexOf(this.getMsgEnd()) - 1);
        if (crcRx.equalsIgnoreCase(crcCalc)) {
            this.fireExcecaoEncontrada(String.format("CheckSum inv\u00e1lido: Recebido = %s Calculado = %s!", crcRx, crcCalc));
            return false;
        }
        return true;
    }

    @Override
    public String getMsgEnd() {
        return String.valueOf('\u0004');
    }

    @Override
    public String getMsgStart() {
        return String.valueOf('\u0002');
    }

    @Override
    public String parse(String message) {
        Map<String, Parametro> lista = this.obtemParametros(message);
        if (lista.isEmpty()) {
            this.fireExcecaoEncontrada("Nenhum dado na mensagem recebida pelo aparelho");
            return null;
        }
        String id = "";
        if (lista.containsKey(I_PID)) {
            id = lista.get((Object)I_PID).value;
        }
        if (Funcoes.textoVazio(id) && lista.containsKey(I_OID)) {
            id = lista.get((Object)I_OID).value;
        }
        if (Funcoes.textoVazio(id) || id.length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
            this.fireExcecaoEncontrada("Resultados recebidos para requisi\u00e7\u00e3o inv\u00e1lida ou n\u00e3o interfaceada: " + id);
            return null;
        }
        try {
            String fil_codigo = id.substring(0, ParametrosGerais.getDigitosTuboFilial());
            String rec_codigo = id.substring(id.length() - ParametrosGerais.getDigitosTuboTubo());
            String req_codigo = id.substring(ParametrosGerais.getDigitosTuboFilial(), id.length() - ParametrosGerais.getDigitosTuboTubo());
            String int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, NOME_EXAME);
            Statement st = Conexao.getStatement();
            if (int_codigo == null) {
                ExameMaterial exame = this.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, NOME_EXAME);
                if (exame == null) {
                    this.fireExcecaoEncontrada("Exame n\u00e3o localizado para a requisi\u00e7\u00e3o: " + id);
                    return null;
                }
                int situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, NOME_EXAME, exame.getCodigoMaterial(), rec_codigo);
                StringBuilder s = new StringBuilder();
                s.append("N\u00e3o foi poss\u00edvel encontrar o exame! O exame encontra-se ");
                if (situacao == 8) {
                    s.append("exportado!");
                } else {
                    s.append("sem situa\u00e7\u00e3o!");
                }
                s.append("(").append(id).append(")");
                this.fireExcecaoEncontrada(s.toString());
                return null;
            }
            HashMap<String, Object> gaso = new HashMap<String, Object>();
            for (String key : this.fields.keySet()) {
                if (!lista.containsKey(key)) continue;
                gaso.put(this.fields.get(key), lista.get((Object)key).value.replace('.', ','));
            }
            List<BDExame> exames = BDUtil.getReqExamesMultGuia(fil_codigo, int_codigo, req_codigo, rec_codigo);
            for (BDExame exame : exames) {
                this.atualizarDadosExame(st, fil_codigo, exame.getRequisicao(), exame.getRecipiente(), exame.getExame(), exame.getMaterial(), int_codigo, gaso);
            }
            Conexao.arquivaSQL();
            this.fireAtualizarTabela();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(null, "Erro ao inserir resultados recebidos ao banco de dados.\n" + ex.getMessage(), ex.getStackTrace());
            try {
                Conexao.anulaSQL();
                return "Erro ao inserir resultados recebidos ao banco de dados";
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                return "Erro ao inserir resultados recebidos ao banco de dados";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ErrorLogger.mostraMensagem(null, e.toString() + "\n" + e.getMessage(), e.getStackTrace());
            return "Erro ao realizar parse dos dados recebidos";
        }
        return "";
    }

    private Map<String, String> fields() {
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put(M_PH, "gasometria_pht");
        fields.put(M_H, "gasometria_ph");
        fields.put(M_H, "gasometria_h+");
        fields.put(M_PO2, "gasometria_po2t");
        fields.put(C_PCO2, "gasometria_pco2t");
        fields.put(I_TEMP, "gasometria_temperature");
        fields.put(I_FIO2, "gasometria_fio2");
        fields.put(C_HCO3_ACT, "gasometria_chco3");
        fields.put(C_HCO3_STD, "gasometria_chco3st");
        fields.put(CT_CO2, "gasometria_ctco2p");
        fields.put(M_BP, "gasometria_baro");
        fields.put(CP_H, "gasometria_cph");
        fields.put(C_H, "gasometria_ch");
        fields.put(IT_HB, "gasometria_ithb");
        fields.put(C_O2, "gasometria_co2");
        fields.put(C_BE_VT, "gasometria_be");
        fields.put(C_BE_VV, "gasometria_cbevv");
        fields.put(C_O2SAT, "gasometria_so2c");
        fields.put(C_A_ADO2, "gasometria_caado2");
        fields.put(CA_A, "gasometria_caa");
        fields.put(M_CA, "gasometria_ica");
        fields.put(MNA, "gasometria_na");
        fields.put(MK, "gasometria_k");
        return fields;
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        try {
            String[] exmes;
            Statement st = Conexao.getStatement();
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(exames.split(" ", 0), mco_codigo);
            String[] stringArray = exmes = exames.split(" ", 0);
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String exame;
                int situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exame = stringArray[i], mco_codigo, rec_codigo);
                this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exame, mco_codigo, int_codigo, rackposition, situacao < 2 ? 1 : 3);
            }
            Conexao.arquivaSQL();
            this.fireMensagemEnviada("Pedido(s) enviado(s) com sucesso para " + pac_nome, 0, 10000);
            this.equipamento.atualizarTabela(0);
            this.fireAtualizarTabela();
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
            return "";
        }
    }

    private String montaFrame(String identifier, String data) {
        StringBuilder frame = new StringBuilder();
        frame.append('\u0002');
        frame.append(identifier);
        frame.append('\u001c');
        frame.append('\u001e');
        frame.append(data);
        frame.append('\u001e');
        frame.append('\u0003');
        frame.append(Checksum.getChecksumMod256(frame.toString()));
        frame.append('\u0004');
        return frame.toString();
    }

    @Override
    public void teste() {
        StringBuilder buf = new StringBuilder();
        String tubo = JOptionPane.showInputDialog("Informe o tubo: ");
        buf.append("[STX]SMP_NEW_DATA[EB]\u001eaMOD\u001d348\u001d\u001d\u001d[EB]iIID\u001d8028\u001d\u001d\u001d[EB]");
        buf.append("rTYPE\u001dSAMPLE\u001d\u001d\u001d[EB]rSEQ\u001d9547\u001d\u001d\u001d[EB]rDATE\u001d20Sep18\u001d\u001d\u001d[EB]");
        buf.append("rTIME\u001d14:46\u001d\u001d\u001d[EB]iPID\u001d" + tubo + "[EB]rDEVICE\u001dSYRINGE\u001d\u001d\u001d[EB]");
        buf.append("mpH\u001d7.541\u001d\u001dH[ETB]\u001d[EB]");
        buf.append("mPCO2\u001d29.2\u001dmmHg\u001dL[ETB]\u001d[EB]");
        buf.append("mPO2\u001d149.0\u001dmmHg\u001dH[ETB]\u001d[EB]");
        buf.append("mNa+\u001d1.48\u001dmmol/L\u001dH[ETB]\u001d[EB]");
        buf.append("mK+\u001d459.91\u001dmmol/L\u001dH[ETB]\u001d[EB]");
        buf.append("mCa++\u001d1.07\u001dmmol/L\u001dL[ETB]\u001d[EB]");
        buf.append("cHCO3act\u001d24.5\u001dmmol/L\u001d\u001d[EB]");
        buf.append("ctCO2\u001d25.4\u001dmmol/L\u001d\u001d[EB]");
        buf.append("cO2SAT\u001d99.2\u001d%\u001d\u001d[EB]");
        buf.append("cBE(vt)\u001d3.0\u001dmmol/L\u001d\u001d[EB]");
        buf.append("mBP\u001d712\u001dmmHg\u001d\u001d[EB]\u001e");
        this.parse(this.equipamento.arruma(buf.toString()));
    }

    private String montaData(Map<String, Parametro> parametro) {
        StringBuilder data = new StringBuilder();
        for (String key : parametro.keySet()) {
            data.append(parametro.get((Object)key).name);
            data.append('\u001d');
            data.append(parametro.get((Object)key).value);
            data.append('\u001d');
            data.append(parametro.get((Object)key).unit);
            data.append('\u001d');
            data.append("");
            data.append('\u001d');
            data.append('\u001c');
        }
        return data.toString();
    }

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
        try {
            if (this.isTX()) {
                this.abortarTransmissao();
            } else if (!this.isIdle() && this.isRX()) {
                this.setIdle();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "timeout no controle de fluxo");
            this.ultimo_enviado = null;
            this.setIdle();
        }
    }

    @Override
    public void handShakeCharReceived(char c) {
    }

    protected void abortarTransmissao() throws Exception {
        this.ultimo_enviado = null;
        this.setIdle();
        this.fireMensagemEnviada("Tempo esgotado ao transmitir dados ao equipamento", 1, 5000);
    }

    public void addListaRecebimento(String message) {
        this.threadRecebimento.addListaRecebimento(message);
    }

    public void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            ArrayList<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento();
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        if (this.threadRecebimento != null) {
            this.threadRecebimento.start();
        }
    }

    class ThreadRecebimento
    extends Thread {
        private ArrayList<String> listaRecebimento = new ArrayList();

        ThreadRecebimento() {
        }

        public ArrayList<String> getListaRecebimento() {
            return this.listaRecebimento;
        }

        public void addListaRecebimento(String message) {
            this.listaRecebimento.add(message);
        }

        public void addListaRecebimentos(ArrayList<String> messages) {
            this.listaRecebimento.addAll(messages);
        }

        public boolean listaDeExamesProcessando() {
            return this.listaRecebimento.size() > 0;
        }

        @Override
        public void run() {
            try {
                while (this.listaRecebimento.size() > 0) {
                    String message = this.listaRecebimento.remove(0);
                    String resultado = InterfaceListener.this.parse(message);
                    if (resultado != null) {
                        InterfaceListener.this.fireMensagemEnviada(resultado, 0, 10000);
                    }
                    ThreadRecebimento.sleep(450L);
                }
                if (!InterfaceListener.this.equipamento.getStatusFecharInterfaceamento().isExportando()) {
                    InterfaceListener.this.fireAtualizarTabela(2);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class Parametro {
        String name;
        String value;
        String unit;
        String[] exception = new String[2];

        public Parametro(String name, String value, String unit) {
            this.name = name;
            this.value = value;
            this.unit = unit;
        }

        public Parametro(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

