/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.rapidlab248;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.InfoExameRequisicao;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.interfaceamento.util.Checksum;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.TempoUtil;
import jalis.util.logger.ErrorLogger;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    public static final char FS = '\u001c';
    public static final char GS = '\u001d';
    public static final char RS = '\u001e';
    public static final char XON = '\u0011';
    public static final char XOFF = '\u0013';
    private static final int TIME_TX = 10000;
    private static final String NOME_EXAME = "GASO";
    private static final String SAMPLE_INITIATED = "SMP_START";
    private static final String ACKNOWLEDGE = "11EB\u0004";
    private static final String ASSAY_COMPLETE = "SMP_NEW_AV";
    private static final String REQUEST_SAMPLE_DATA = "SMP_REQ";
    private static final String SAMPLE_DATA = "SMP_NEW_DATA";
    private static final String R_SEQ = "rSEQ";
    private static final String I_PID = "iPID";
    private static final String R_TYPE = "rTYPE";
    private static final String R_DATE = "rDate";
    private static final String R_TIME = "rTIME";
    private static final String R_DEVICE = "rDEVICE";
    private static final String I_OID = "iOID";
    private static final String AI_IID = "aiIID";
    private InfoExameRequisicao ultimo_enviado = new InfoExameRequisicao(null, null, null, null, null, null, null, null, null, null);
    private static final String M_PH = "mpH";
    private static final String M_H = "mH+";
    private static final String M_PO2 = "mPO2";
    private static final String C_PCO2 = "mPCO2";
    private static final String CP_H = "cpH";
    private static final String C_H = "cH+";
    private static final String I_TEMP = "iTEMP";
    private static final String IT_HB = "itHB";
    private static final String I_FIO2 = "iFIO2";
    private static final String C_HCO3_ACT = "cHCO3act";
    private static final String C_HCO3_STD = "cHCO3std";
    private static final String C_O2 = "cO2(CT)";
    private static final String CT_CO2 = "ctCO2";
    private static final String C_BE_VT = "cBE(vt)";
    private static final String C_BE_VV = "cBE(vv)";
    private static final String C_O2SAT = "cO2SAT";
    private static final String C_A_ADO2 = "cA-aDO2";
    private static final String CA_A = "ca/A";
    private static final String M_BP = "mBP";
    private static final String A_MOD = "aMOD";
    private static final String I_IID = "iIID";
    private static final String I_QLEV = "iQLEV";
    private static final String I_QLOT = "iQLOT";
    private static final String S_LQ_MPH = "sLQmpH";
    private static final String S_HQ_MPH = "sHQmpH";
    private static final String S_LQ_MPO2 = "sLQmPO2";
    private static final String S_HQ_MPO2 = "sHQmPO2";
    private static final String S_LQ_MPCO2 = "sLQmPCO2";
    private static final String S_HQ_MPCO2 = "sHQmPCO2";
    private Map<String, String> fields = this.fields();

    @Override
    public void dataChanged() {
        try {
            String msg = this.getPortaCOM().getInputString();
            if (msg.startsWith(this.getMsgStart()) && msg.endsWith(this.getMsgEnd())) {
                if (!this.checkSumValido(msg)) {
                    this.getPortaCOM().clearInputString();
                    return;
                }
                String parseMsg = msg.substring(1, msg.indexOf(3));
                if (parseMsg.startsWith(SAMPLE_INITIATED)) {
                    this.getPortaCOM().clearInputString();
                    this.getPortaCOM().write(ACKNOWLEDGE);
                } else if (parseMsg.startsWith(ASSAY_COMPLETE)) {
                    this.getPortaCOM().write(ACKNOWLEDGE);
                    this.responderRequest(parseMsg);
                } else if (parseMsg.startsWith(String.format("<%s>", String.valueOf('\u0006')))) {
                    this.alteraSituacaoParaPendente();
                } else if (parseMsg.startsWith(SAMPLE_DATA)) {
                    this.parse(parseMsg);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void alteraSituacaoParaPendente() {
        if (this.ultimo_enviado != null && this.ultimo_enviado.getExames() != null) {
            this.enviarRequisicao(this.ultimo_enviado.getNome(), this.ultimo_enviado.getSexo(), this.ultimo_enviado.getIdade(), this.ultimo_enviado.getData(), this.ultimo_enviado.getHora(), this.ultimo_enviado.getRack(), null, this.ultimo_enviado.getFilial(), this.ultimo_enviado.getInterface(), this.ultimo_enviado.getCodigo(), this.ultimo_enviado.getMaterial(), this.ultimo_enviado.getRecipiente(), this.ultimo_enviado.getExames(), "A");
        }
    }

    public void responderRequest(String parseMsg) throws IOException {
        StringBuilder b = new StringBuilder();
        String gs = StringUtil.repeteCaractere('\u001d', 3);
        Map<String, Parametro> lista = this.obtemParametros(b.toString());
        if (lista.containsValue(R_SEQ) && !Funcoes.textoVazio(lista.get((Object)R_SEQ).value)) {
            String requisicao = this.getRequisicaoRack(lista.get((Object)R_SEQ).value);
            String fil_codigo = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial());
            String req_codigo = requisicao.substring(ParametrosGerais.getDigitosTuboFilial(), requisicao.length() - ParametrosGerais.getDigitosTuboTubo());
            String rec_codigo = requisicao.substring(requisicao.length() - ParametrosGerais.getDigitosTuboTubo());
            Object[] req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 0);
            PanelAbaAbstrata aba = this.getAba(0);
            if (req == null) {
                req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                aba = this.getAba(1);
            }
            String exames = (String)req[aba.getColIndice("Exame")];
            String mcoCodigo = (String)req[aba.getColIndice("C\u00f3d. Mat.")];
            String intCodigo = (String)req[aba.getColIndice("Interface")];
            String pacNome = (String)req[aba.getColIndice("Paciente")];
            String pacIdade = (String)req[aba.getColIndice("Ide")];
            String pacSexo = (String)req[aba.getColIndice("S")];
            String data = TempoUtil.getCurrentDateBr();
            String hora = TempoUtil.getCurrentTime();
            this.ultimo_enviado = new InfoExameRequisicao(fil_codigo, req_codigo, mcoCodigo, rec_codigo, pacNome, pacIdade, pacSexo, data, hora, exames);
            HashMap<String, Parametro> parametros = new HashMap<String, Parametro>();
            parametros.put(A_MOD, new Parametro(A_MOD, lista.get((Object)A_MOD).value));
            parametros.put(AI_IID, new Parametro(AI_IID, lista.get((Object)AI_IID).value));
            parametros.put(R_SEQ, new Parametro(R_SEQ, lista.get((Object)R_SEQ).value));
            String frame = this.montaFrame(REQUEST_SAMPLE_DATA, this.montaData(parametros));
            this.setTX(10000);
            this.getPortaCOM().write(frame);
        }
    }

    private Map<String, Parametro> obtemParametros(String mensagem) {
        HashMap<String, Parametro> lista = new HashMap<String, Parametro>();
        String[] fields = mensagem.split(String.valueOf('\u001c') + String.valueOf('\u001e'));
        if (fields.length == 2) {
            String[] groups;
            String identifier = fields[0];
            for (String datas : groups = fields[1].split(String.valueOf('\u001c'))) {
                this.addParametro(lista, datas);
            }
        }
        return lista;
    }

    private void addParametro(Map<String, Parametro> lista, String datas) {
        String[] data = datas.split(String.valueOf('\u001d'));
        Parametro param = new Parametro(data[0], data.length == 2 ? data[1] : "", data.length == 3 ? data[2] : "");
        if (data.length == 4) {
            String[] exception = data[3].split(String.valueOf('\u0017'));
            if (exception.length >= 1 && !Funcoes.textoVazio(exception[0])) {
                param.exception[0] = exception[0];
            }
            if (exception.length == 2 && !Funcoes.textoVazio(exception[1])) {
                param.exception[1] = exception[1];
            }
        }
        lista.put(param.name, param);
    }

    private boolean checkSumValido(String msg) {
        String crcCalc = Checksum.getChecksumMod256(msg.substring(0, msg.indexOf(3)));
        String crcRx = msg.substring(msg.indexOf(3) + 1, msg.indexOf(this.getMsgEnd()) - 1);
        if (crcRx.equalsIgnoreCase(crcCalc)) {
            this.fireExcecaoEncontrada(String.format("CheckSum inv\u00e1lido: Recebido = %s Calculado = %s!", crcRx, crcCalc));
            return false;
        }
        return true;
    }

    @Override
    public String getMsgEnd() {
        return String.valueOf('\u0004');
    }

    @Override
    public String getMsgStart() {
        return String.valueOf('\u0002');
    }

    @Override
    public String parse(String message) {
        String id;
        Map<String, Parametro> lista = this.obtemParametros(message);
        if (lista.isEmpty()) {
            this.fireExcecaoEncontrada("Nenhum dado na mensagem recebida pelo aparelho");
        }
        if (Funcoes.textoVazio(id = lista.get((Object)I_PID).value) || id.length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
            this.fireExcecaoEncontrada("Resultados recebidos para requisi\u00e7\u00e3o inv\u00e1lida ou n\u00e3o interfaceada: " + id);
            return null;
        }
        try {
            String fil_codigo = id.substring(0, ParametrosGerais.getDigitosTuboFilial());
            String rec_codigo = id.substring(id.length() - ParametrosGerais.getDigitosTuboTubo());
            String req_codigo = id.substring(ParametrosGerais.getDigitosTuboFilial(), id.length() - ParametrosGerais.getDigitosTuboTubo());
            String int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, NOME_EXAME);
            Statement st = Conexao.getStatement();
            if (int_codigo == null) {
                ExameMaterial exame = this.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, NOME_EXAME);
                int situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, NOME_EXAME, exame.getCodigoMaterial(), rec_codigo);
                StringBuilder s = new StringBuilder();
                s.append("N\u00e3o foi poss\u00edvel encontrar o exame! O exame encontra-se ");
                if (situacao == 8) {
                    s.append("exportado!");
                } else {
                    s.append("sem situa\u00e7\u00e3o!");
                }
                s.append("(").append(id).append(")");
                this.fireExcecaoEncontrada(s.toString());
                return null;
            }
            HashMap<String, Object> gaso = new HashMap<String, Object>();
            for (String key : this.fields.keySet()) {
                if (!lista.containsKey(key)) continue;
                gaso.put(this.fields.get(key), lista.get((Object)key).value);
            }
            List<BDExame> exames = BDUtil.getReqExamesMultGuia(fil_codigo, int_codigo, req_codigo, rec_codigo);
            for (BDExame exame : exames) {
                this.atualizarDadosExame(st, fil_codigo, exame.getRequisicao(), exame.getRecipiente(), exame.getExame(), exame.getMaterial(), int_codigo, gaso);
            }
            Conexao.arquivaSQL();
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(null, "Erro ao inserir resultados recebidos ao banco de dados.\n" + ex.getMessage(), ex.getStackTrace());
            try {
                Conexao.anulaSQL();
                return "Erro ao inserir resultados recebidos ao banco de dados";
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                return "Erro ao inserir resultados recebidos ao banco de dados";
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.toString() + "\n" + e.getMessage(), e.getStackTrace());
            return "Erro ao realizar parse dos dados recebidos";
        }
        return "";
    }

    private Map<String, String> fields() {
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put(M_PH, "gasometria_ph");
        fields.put(M_H, "gasometria_ph");
        fields.put(M_H, "gasometria_h+");
        fields.put(M_PO2, "gasometria_po2");
        fields.put(C_PCO2, "gasometria_pco2");
        fields.put(I_TEMP, "gasometria_temperature");
        fields.put(I_FIO2, "gasometria_fio2");
        fields.put(C_HCO3_ACT, "gasometria_chco3");
        fields.put(C_HCO3_STD, "gasometria_chco3st");
        fields.put(CT_CO2, "gasometria_cto2");
        fields.put(M_BP, "gasometria_baro");
        fields.put(CP_H, "gasometria_cph");
        fields.put(C_H, "gasometria_ch");
        fields.put(IT_HB, "gasometria_ithb");
        fields.put(C_O2, "gasometria_co2");
        fields.put(C_BE_VT, "gasometria_cbevt");
        fields.put(C_BE_VV, "gasometria_cbevv");
        fields.put(C_O2SAT, "gasometria_co2sat");
        fields.put(C_A_ADO2, "gasometria_caado2");
        fields.put(CA_A, "gasometria_caa");
        return fields;
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        return "";
    }

    private String montaFrame(String identifier, String data) {
        StringBuilder frame = new StringBuilder();
        frame.append('\u0002');
        frame.append(identifier);
        frame.append('\u001c');
        frame.append('\u001e');
        frame.append(data);
        frame.append('\u001e');
        frame.append('\u0003');
        frame.append(Checksum.getChecksumMod256(frame.toString()));
        frame.append('\u0004');
        return frame.toString();
    }

    private String montaData(Map<String, Parametro> parametro) {
        StringBuilder data = new StringBuilder();
        for (String key : parametro.keySet()) {
            data.append(parametro.get((Object)key).name);
            data.append('\u001d');
            data.append(parametro.get((Object)key).value);
            data.append('\u001d');
            data.append(parametro.get((Object)key).unit);
            data.append('\u001d');
            data.append("");
            data.append('\u001d');
            data.append('\u001c');
        }
        return data.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void fcTimedOut(EventObject e) throws Exception {
        try {
            if (this.isTX()) {
                this.abortarTransmissao();
                return;
            }
            if (!this.isIdle()) return;
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "timeout no controle de fluxo");
            this.ultimo_enviado = null;
            this.setIdle();
        }
    }

    @Override
    public void handShakeCharReceived(char c) {
    }

    protected void abortarTransmissao() throws Exception {
        this.ultimo_enviado = null;
        this.setIdle();
        this.fireMensagemEnviada("Tempo esgotado ao transmitir dados ao equipamento", 1, 5000);
    }

    class Parametro {
        String name;
        String value;
        String unit;
        String[] exception = new String[2];

        public Parametro(String name, String value, String unit) {
            this.name = name;
            this.value = value;
            this.unit = unit;
        }

        public Parametro(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

