/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.premierHB9210;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMRecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public class RecordParser
extends ASTMRecordParser {
    private String req_codigo;
    private String codigoFilial;
    private String rec_codigo;

    @Override
    protected void trataOrderRecord(String record) throws Exception {
        if (!(this.exame_atual == null || Funcoes.textoVazio(this.codigoFilial) || Funcoes.textoVazio(this.req_codigo) || Funcoes.textoVazio(this.rec_codigo))) {
            this.salvaExame(this.exame_atual);
        }
        this.exame_atual = new HashMap();
        Hashtable<Integer, String> order_fields = ASTMStandard.parseDefaultOrderRecord(record);
        this.exame_atual.put(ACTION_CODE, order_fields.get(ASTMStandard.ORDER_FIELD_ACTION_CODE));
        this.exame_atual.put(REPORT_TYPE, order_fields.get(ASTMStandard.ORDER_FIELD_REPORT_TYPE));
        String instSID = (String)order_fields.get(ASTMStandard.ORDER_FIELD_SAMPLE_ID);
        Map<Integer, String> sys_sample_id = this.equip.parseOrderSystemSID(instSID);
        String req_codigo = (String)order_fields.get(ASTMStandard.ORDER_FIELD_SYSTEM_SID);
        DescritorCodigoEtiqueta etiqueta = DescritorCodigoEtiqueta.getDescritor(req_codigo);
        if (req_codigo == null || req_codigo.equals("")) {
            req_codigo = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_ID);
        }
        if (!Funcoes.textoVazio(req_codigo) && req_codigo.contains("^")) {
            req_codigo = StringUtil.limpaString(req_codigo, new String[]{"^"});
        }
        try {
            Long.parseLong(req_codigo);
        }
        catch (Exception ex) {
            StringBuilder msg = new StringBuilder();
            msg.append("Resultados recebidos para requisi\u00e7\u00e3o n\u00e3o existente ou n\u00e3o interfaceada: ");
            msg.append(req_codigo);
            this.equip.fireExcecaoEncontrada(msg.toString());
            this.exame_atual = null;
            return;
        }
        int qtde = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
        req_codigo = Funcoes.preencheZero(req_codigo, qtde);
        String rack_id = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_RACK_ID);
        String rack_pos = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_RACK_POS);
        this.exame_atual.put("rack_position", rack_id != null ? rack_id + (rack_pos != null ? "-" + rack_pos : "") : rack_pos);
        String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
        String rec_codigo = req_codigo.substring(req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
        req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial(), req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
        Map<Integer, String> components = this.equip.parseOrderTestIDField((String)order_fields.get(ASTMStandard.ORDER_FIELD_TEST_ID));
        Statement st = Conexao.getStatement();
        if (etiqueta != null) {
            fil_codigo = Funcoes.preencheZero(etiqueta.getFilial(), ParametrosGerais.getDigitosTuboFilial());
            req_codigo = Funcoes.preencheZero(etiqueta.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao());
            rec_codigo = Funcoes.preencheZero(etiqueta.getTubo(), ParametrosGerais.getDigitosTuboTubo());
        }
        this.req_codigo = req_codigo;
        this.codigoFilial = fil_codigo;
        this.rec_codigo = rec_codigo;
        this.exame_atual.put(FIL_CODIGO, fil_codigo);
        this.exame_atual.put(REC_CODIGO, rec_codigo);
        this.exame_atual.put(REQ_CODIGO, req_codigo);
    }

    @Override
    protected void trataResultRecord(String record) throws SQLException {
        String flags;
        if (this.exame_atual == null) {
            return;
        }
        Hashtable result_fields = ASTMStandard.parseDefaultResultRecord(record);
        String fil_codigo = this.codigoFilial;
        String req_codigo = this.req_codigo;
        String rec_codigo = this.rec_codigo;
        String exa_codigo = (String)this.exame_atual.get(EXA_CODIGO);
        String mco_codigo = (String)this.exame_atual.get(MCO_CODIGO);
        String resultado = (String)result_fields.get(ASTMStandard.RESULT_FIELD_MEASUREMENT_VALUE);
        if ((resultado = resultado.replaceAll("\\.", ",")).startsWith(",")) {
            resultado = "0" + resultado;
        }
        if (!StringUtil.isEmpty(resultado)) {
            if (resultado.charAt(resultado.length() - 1) == ',') {
                resultado = resultado + "0";
            }
            if (resultado.charAt(resultado.length() - 1) == '^') {
                resultado = resultado.substring(0, resultado.length() - 1);
            }
        }
        Map<Integer, String> components = this.equip.parseResultTestIDField((String)result_fields.get(ASTMStandard.RESULT_FIELD_TEST_ID));
        String emi_alternativo = components.get(this.equip.TEST_ITEM_NUMBER);
        String int_codigo = this.equip.getIntCodigo(fil_codigo, req_codigo, rec_codigo, emi_alternativo);
        if (Funcoes.textoVazio(fil_codigo) || Funcoes.textoVazio(req_codigo) || Funcoes.textoVazio(rec_codigo)) {
            this.equip.fireExcecaoEncontrada("C\u00f3digo filial " + emi_alternativo + " n\u00e3o encontrado na interface para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
            return;
        }
        ExameMaterial exame = this.equip.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo);
        if (exame == null) {
            this.equip.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
            return;
        }
        if (int_codigo == null) {
            int_codigo = this.equip.getIntCodigo(fil_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial());
        }
        if (int_codigo == null) {
            this.equip.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado na interface para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
            return;
        }
        this.exame_atual.put(INT_CODIGO, int_codigo);
        this.exame_atual.put(FIL_CODIGO, fil_codigo);
        this.exame_atual.put(REC_CODIGO, rec_codigo);
        this.exame_atual.put(REQ_CODIGO, req_codigo);
        this.exame_atual.put(EXA_CODIGO, exame.getNomeExame());
        this.exame_atual.put(MCO_CODIGO, exame.getCodigoMaterial());
        exa_codigo = exame.getNomeExame();
        mco_codigo = exame.getCodigoMaterial();
        Statement st = Conexao.getStatement();
        int sit = this.equip.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo);
        String campo = sit < 3 ? "resultado_quantitativo" : "repeticao_quantitativo";
        this.exame_atual.put(campo, resultado);
        if (this.exame_atual != null) {
            try {
                String filial = (String)this.exame_atual.get(FIL_CODIGO);
                String requisicao = (String)this.exame_atual.get(REQ_CODIGO);
                String tubo = (String)this.exame_atual.get(REC_CODIGO);
                this.exame_atual.put(FIL_CODIGO, filial);
                this.exame_atual.put(REQ_CODIGO, requisicao);
                this.exame_atual.put(REC_CODIGO, tubo);
            }
            catch (Exception e) {
                StringBuilder msg = new StringBuilder(e.getMessage());
                msg.append("\n").append("Erro ao receber resultado ");
                msg.append("\n").append(fil_codigo).append(" ").append(req_codigo).append(" ").append(rec_codigo);
                msg.append("\n").append(record);
                ErrorLogger.mostraMensagem(null, msg.toString(), e.getStackTrace());
            }
        }
        if ((flags = (String)result_fields.get(ASTMStandard.RESULT_FIELD_CAUSE_OF_ABNORMALITY)) != null && !flags.equals("")) {
            this.exame_atual.put("flag_alerta", flags);
        }
        try {
            this.salvaExame(this.exame_atual);
            this.exame_atual.remove(campo);
            this.equip.fireAtualizarTabela();
        }
        catch (Exception e) {
            StringBuilder msg = new StringBuilder(e.getMessage());
            msg.append("\n").append("Erro ao salvar resultado ");
            msg.append("\n").append(fil_codigo).append(" ").append(req_codigo).append(" ").append(rec_codigo).append(" ").append(exame.getNomeExame());
            msg.append("\n").append(record);
            ErrorLogger.mostraMensagem(null, msg.toString(), e.getStackTrace());
        }
    }

    @Override
    public void recordFound(String record) throws Exception {
        String record_type = ASTMStandard.getRecordTypeIdentifier(record = record.substring(0, record.length() - 1));
        if (record_type != null) {
            if (record_type.equals(ASTMStandard.RECORD_TYPE_HEADER)) {
                this.trataHeaderRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_PATIENT)) {
                this.trataPatientRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_ORDER)) {
                this.trataOrderRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_RESULT)) {
                this.trataResultRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_COMMENT)) {
                this.trataCommentRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_REQUEST)) {
                this.trataRequestRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_TERMINATION)) {
                this.trataTerminationRecord();
                return;
            }
        }
    }

    @Override
    protected void trataTerminationRecord() throws Exception {
        if (this.exame_atual == null) {
            return;
        }
        if (!(this.exame_atual == null || Funcoes.textoVazio(this.codigoFilial) || Funcoes.textoVazio(this.req_codigo) || Funcoes.textoVazio(this.rec_codigo))) {
            this.salvaExame(this.exame_atual);
        }
        this.req_codigo = "";
        this.codigoFilial = "";
        this.rec_codigo = "";
    }
}

