/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.premierHB9210;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.abas.RefreshTimer;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.interfaces.premierHB9210.RecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.InterfaceASTMListener;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.interfaceamento.util.ThreadRecebimento;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;

public class InterfaceListener
extends InterfaceASTMListener {
    protected boolean hostQuery = false;
    private ThreadRecebimento threadRecebimento;

    public InterfaceListener() {
        RecordParser record = new RecordParser();
        record.setInterfaceASTMListener(this);
        super.setASTMRecordParser(record);
        this.threadRecebimento = new ThreadRecebimento(this);
    }

    @Override
    public String getErroTraduzido(String erro) {
        return null;
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao, HashMap<String, String> mapaParametros) {
        try {
            this.tx_list.clear();
            this.rx_list.clear();
            this.req_codigo = req_codigo;
            this.fil_codigo = fil_codigo;
            this.int_codigo = int_codigo;
            this.pac_nome = pac_nome;
            this.pac_sexo = pac_sexo;
            this.req_idade = pac_idade;
            this.req_data = data;
            this.req_hora = hora;
            this.mco_codigo = mco_codigo;
            this.rec_codigo = rec_codigo;
            this.pac_exames = pac_exames;
            this.exames = pac_exames.split(" ", 0);
            this.ultima_acao = acao;
            this.curva = false;
            this.rec_tuboPai = "";
            this.examesFilho = new LinkedList();
            ExameMaterial[] alternativos = null;
            ExameMaterial[] listaCurva = null;
            Map<String, List<ExameMaterial>> alternativosCurva = null;
            String short_name = StringUtil.removerAcentos(pac_nome.trim());
            fil_codigo = StringUtil.preencheString(fil_codigo, ParametrosGerais.getDigitosTuboFilial(), '0', 1);
            StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo);
            StringBuilder sample_id = new StringBuilder(fil_codigo).append(req_codigo);
            rec_codigo = StringUtil.preencheString(rec_codigo, ParametrosGerais.getDigitosTuboTubo(), '0', 1);
            codigo.append(rec_codigo);
            Statement st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder();
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(this.exames, mco_codigo);
            String exame = exa_lista[0].toString();
            String tipoAmostra = "";
            ArrayList<ExameMaterial> exa_listaCurva = new ArrayList<ExameMaterial>();
            exa_lista = ExamesUtil.separaExamesCurva(fil_codigo, int_codigo, mco_codigo, exa_lista, exa_listaCurva);
            if (exa_lista != null) {
                exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_lista);
                alternativos = ExamesUtil.getAlternativos(st, fil_codigo, int_codigo, exa_lista);
                alternativos = ExamesUtil.removeDuplicados(alternativos);
            }
            if (!exa_listaCurva.isEmpty()) {
                ArrayList<String> exameCurva = new ArrayList<String>();
                for (ExameMaterial exameMaterial : exa_listaCurva) {
                    exameCurva.add(exameMaterial.getNomeExame());
                }
                if (Funcoes.textoVazio(this.rec_tuboPai)) {
                    this.rec_tuboPai = BDUtil.getExameDesmembradoTuboPai(fil_codigo, req_codigo, rec_codigo, int_codigo, (String)exameCurva.get(0), mco_codigo);
                }
                listaCurva = ExamesUtil.anexarCodigoMaterial(exameCurva.toArray(new String[exameCurva.size()]), mco_codigo);
                listaCurva = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_listaCurva.toArray(new ExameMaterial[exa_listaCurva.size()]));
                alternativosCurva = ExamesUtil.getAlternativosCurva(fil_codigo, int_codigo, req_codigo, mco_codigo, String.valueOf(Integer.parseInt(rec_codigo)), st, exa_listaCurva, this.rec_tuboPai, true, this.examesFilho);
            }
            this.tx_list.add(this.getMsgStart());
            buf.append(this.getDefaultHeaderRecord(this.DELIMITERS, this.PASSWORD, this.HOST_NAME, this.HOST_SYSTEM_VERSION, null, this.INSTRUMENT_NAME, this.INSTRUMENT_SYSTEM_VERSION, "1394-97"));
            StringBuilder patient_id = new StringBuilder();
            patient_id.append(fil_codigo).append(req_codigo);
            Date dataNasc = BDUtil.getDataNacimentoPaciente(fil_codigo, req_codigo);
            String sex = "U";
            if (!Funcoes.textoVazio(pac_sexo) && pac_sexo.equalsIgnoreCase("M")) {
                sex = "M";
            } else if (!Funcoes.textoVazio(pac_sexo) && pac_sexo.equalsIgnoreCase("F")) {
                sex = "F";
            }
            buf.append(this.getPatientRecord(1, patient_id.toString(), short_name, sex, dataNasc));
            int seq = 0;
            if (alternativos != null) {
                for (int i = 0; i < alternativos.length; ++i) {
                    if (alternativos[i] == null) continue;
                    buf.append(this.getOrderRecord(++seq, codigo.toString(), "", "", codigo.toString(), alternativos[i], "R", tipoAmostra, this.hostQuery ? "Q" : "O"));
                }
            }
            if (alternativosCurva != null && alternativosCurva.size() > 0) {
                String cod = sample_id.toString();
                this.curva = true;
                for (String key : alternativosCurva.keySet()) {
                    sample_id.setLength(0);
                    sample_id.append(cod);
                    String tubo = Funcoes.preencheZero(key, ParametrosGerais.getDigitosTuboTubo());
                    for (ExameMaterial exameMaterial : alternativosCurva.get(key)) {
                        buf.append(this.getOrderRecord(++seq, codigo.toString(), "", "", sample_id.append(tubo).toString(), exameMaterial, "R", tipoAmostra, this.hostQuery ? "Q" : "O"));
                    }
                }
            }
            buf.append(this.getTerminationRecord());
            this.tx_list.add(buf.toString());
            this.tx_list.add(String.valueOf('\u0003'));
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            this.getPortaCOM().write(String.valueOf('\u0005'));
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    public String getDefaultHeaderRecord(String delimiters, String password, String sender_id_name, String sender_id_system, String control, String receiver_id_name, String receiver_id_system, String version_number) {
        StringBuilder record = new StringBuilder("H|");
        record.append(delimiters == null ? "" : delimiters);
        record.append("||");
        record.append(password == null ? "PSWD" : password);
        record.append("|");
        record.append("PREMIER");
        record.append("|||||");
        record.append(sender_id_name == null ? "" : "^" + sender_id_name);
        record.append("||");
        record.append("P|");
        record.append(version_number);
        record.append("|");
        record.append(InterfaceListener.getCurrentMoment());
        record.append('\r');
        return record.toString();
    }

    private String getTerminationRecord() {
        StringBuilder record = new StringBuilder("L|1|N");
        record.append('\r');
        return record.toString();
    }

    private String getOrderRecord(int order_sequence, String sampleId, String sampleTray, String samplePos, String codBarra, ExameMaterial alternativos, String prioridade, String tipoAmostra, String reportType) {
        StringBuilder record = new StringBuilder("O|");
        record.append(order_sequence).append("|");
        record.append(sampleId).append("||");
        if (alternativos != null) {
            record.append("^^^");
            record.append(alternativos.getNomeExame());
        }
        record.append("|");
        record.append(prioridade);
        record.append('\r');
        return record.toString();
    }

    private String getPatientRecord(int patient_sequence, String patient_id, String pac_nome, String pac_sexo, Date dataNasc) {
        StringBuilder record = new StringBuilder("P|");
        record.append(patient_sequence).append("||");
        record.append("||");
        record.append(pac_nome).append("|||");
        record.append(pac_sexo).append(String.valueOf('\r'));
        return record.toString();
    }

    @Override
    public String parse(String message) {
        try {
            String checksum = null;
            String termination = null;
            int stx_index = this.getMsgStart(message);
            if (stx_index >= 0 && message.length() > 5) {
                if (stx_index >= 0) {
                    message = message.substring(stx_index);
                } else if (stx_index < 0) {
                    return "Erro no bloco enviado pelo equipamento";
                }
            } else {
                return "Erro no bloco enviado pelo equipamento";
            }
            checksum = message.substring(message.length() - 2);
            termination = message.substring(message.length() - 3, message.length() - 2);
            message = message.substring(0, message.length() - 2);
            if (this.checkCRC(message, checksum)) {
                if (this.middleFrame && this.rx_list.getUltimoInserido() <= this.rx_list.size()) {
                    String last = (String)this.rx_list.get(this.rx_list.getUltimoInserido());
                    message = last.substring(0, last.length() - 1) + message;
                    this.rx_list.remove(this.rx_list.getUltimoInserido());
                    this.middleFrame = false;
                }
                if (message.contains(String.valueOf('\r'))) {
                    String[] tmp;
                    for (String s : tmp = message.split(String.format("[%s]", Character.valueOf('\r')))) {
                        if (s.length() <= 1) continue;
                        this.rx_list.add(s);
                    }
                } else {
                    this.rx_list.add(message);
                }
                if (termination.equalsIgnoreCase(this.getMiddleFrameEnd())) {
                    this.middleFrame = true;
                    return "";
                }
                ArrayList buffer = new ArrayList(this.rx_list);
                while (!buffer.isEmpty()) {
                    String buf = (String)buffer.remove(0);
                    if (buf.length() <= 1) continue;
                    this.recordParser.recordFound(buf);
                }
                Conexao.arquivaSQL();
                RefreshTimer.waitAndRefresh(this, this.TIME_TO_REFRESH);
                return "";
            }
            this.rx_list.clear();
            return "Erro ao receber bloco de dados: CRC incompat\u00edvel!";
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(null, ex.toString(), ex.getStackTrace(), "AbstractASTMInterfaceamento: parse");
            this.rx_list.clear();
            this.interromperTimer();
            this.setIdle();
            try {
                Conexao.anulaSQL();
                return "Erro ao analisar dados recebidos do equipamento.";
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o SQL em parse");
                return "Erro ao analisar dados recebidos do equipamento. Podem haver dados inconsistentes no BD.";
            }
        }
    }

    public Integer getMsgStart(String message) {
        Integer posicao = -1;
        if (message.contains("H") && message.indexOf("H") < 3) {
            posicao = message.indexOf("H");
        } else if (message.contains("Q") && message.indexOf("Q") < 3) {
            posicao = message.indexOf("Q");
        } else if (message.contains("O") && message.indexOf("O") < 3) {
            posicao = message.indexOf("O");
        } else if (message.contains("P") && message.indexOf("P") < 3) {
            posicao = message.indexOf("P");
        } else if (message.contains("L") && message.indexOf("L") < 3) {
            posicao = message.indexOf("L");
        } else if (message.contains("R") && message.indexOf("R") < 3) {
            posicao = message.indexOf("R");
        }
        return posicao;
    }

    public static String getCurrentMoment() {
        return new SimpleDateFormat("yyyyMMdd").format(new Date(System.currentTimeMillis()));
    }

    @Override
    public void teste() {
        int op = JOptionPane.showOptionDialog(null, "Op\u00e7\u00e3o", "Tipo teste", 0, 0, null, new String[]{"Query", "ACK", "Resultado", "EOT"}, null);
        switch (op) {
            case 0: {
                this.testeQuery();
                break;
            }
            case 1: {
                this.handShakeCharReceived('\u0006');
                break;
            }
            case 2: {
                this.testeResultado();
                break;
            }
            case 3: {
                this.handShakeCharReceived('\u0004');
                break;
            }
            default: {
                return;
            }
        }
    }

    private void testeQuery() {
        String idAmostra = JOptionPane.showInputDialog(null, "Informe o Id da amostra:", "01000");
        this.parse(this.equipamento.arruma("[Stx]1H|\\^&|||PREMIER^100051|||||||P|1|20090701105221[CR][Etx]FF[CR]"));
        this.parse(this.equipamento.arruma("[Stx]2Q|1|^" + idAmostra + "||ALL||||||||O[CR][Etx]44[CR]"));
        this.parse(this.equipamento.arruma("[Stx]3L|1|N[CR][Etx]00[CR]"));
        this.handShakeCharReceived('\u0004');
    }

    private void testeResultado() {
        String idAmostra = JOptionPane.showInputDialog(null, "Informe o Id da amostra:", "");
        this.parse(this.equipamento.arruma("[ENQ]"));
        this.parse(this.equipamento.arruma("[ACK]"));
        this.parse(this.equipamento.arruma("[STX]1H|\\^&|||PREMIER^201209||||||ASTM[SP]RECVR|||P|E[SP]1394-97|20230111095427[CR]"));
        this.parse(this.equipamento.arruma("[ETX]0C[LINE]"));
        this.parse(this.equipamento.arruma("[ACK]"));
        this.parse(this.equipamento.arruma("[STX]2P|1[CR]"));
        this.parse(this.equipamento.arruma("[ETX]3F[LINE]"));
        this.parse(this.equipamento.arruma("[ACK]"));
        this.parse(this.equipamento.arruma("[STX]3O|1||" + idAmostra + "|^^^PREMIER[SP]HBA1C|R|||||||||||||||||||Wy5I^001|F[CR]"));
        this.parse(this.equipamento.arruma("[ETX]54[LINE]"));
        this.parse(this.equipamento.arruma("[ACK]"));
        this.parse(this.equipamento.arruma("[STX]4R|1|^^^GHb|---|%||||F||||20230111095427||[CR]"));
        this.parse(this.equipamento.arruma("[ETX]51[LINE]"));
        this.parse(this.equipamento.arruma("[ACK]"));
        this.parse(this.equipamento.arruma("[STX]5R|2|^^^HbA1c|5.0|%||||F||||20230111095427||[CR]"));
        this.parse(this.equipamento.arruma("[ETX]ED[LINE]"));
        this.parse(this.equipamento.arruma("[ACK]"));
        this.parse(this.equipamento.arruma("[STX]6R|3|^^^AG|---|mg/dl||||F||||20230111095427||[CR]"));
        this.parse(this.equipamento.arruma("[ETX]9A[LINE]"));
        this.parse(this.equipamento.arruma("[ACK]"));
        this.parse(this.equipamento.arruma("[STX]7R|4|^^^mMA1c|31|mMol[SP]HbA1c/mol[SP]Hb||||F||||20230111095427||[CR]"));
        this.parse(this.equipamento.arruma("[ETX]22[LINE]"));
        this.parse(this.equipamento.arruma("[ACK]"));
        this.parse(this.equipamento.arruma("[STX]0R|5|^^^Code||||||F||||20230111095427||[CR]"));
        this.parse(this.equipamento.arruma("[ETX]2F[LINE]"));
        this.parse(this.equipamento.arruma("[NAK]"));
        this.parse(this.equipamento.arruma("[EOT]"));
        this.handShakeCharReceived('\u0004');
    }
}

