/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.plenno;

import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.interfaces.plenno.ExameRequisicaoArquivo;
import jalis.laboratorio.interfaceamento.interfaces.plenno.ExameRequisicaoFilhoArquivo;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

class RequisicaoArquivo {
    private String filCodigo;
    private String reqCodigo;
    private String recCodigo;
    private String mcoCodigo;
    private String intCodigo;
    private String pacNome;
    private String pacIdade;
    private String pacSexo;
    private List<ExameRequisicaoArquivo> exames;
    private boolean curva;

    public RequisicaoArquivo(String filCodigo, String reqCodigo, String recCodigo, String mcoCodigo, String intCodigo, String pacNome, String pacIdade, String pacSexo, boolean curva) {
        this.filCodigo = filCodigo;
        this.reqCodigo = reqCodigo;
        this.recCodigo = recCodigo;
        this.mcoCodigo = mcoCodigo;
        this.intCodigo = intCodigo;
        this.pacNome = pacNome;
        this.pacIdade = pacIdade;
        this.pacSexo = pacSexo;
        this.exames = new ArrayList<ExameRequisicaoArquivo>();
        this.curva = curva;
    }

    public void addExame(ExameRequisicaoArquivo exame) {
        this.exames.add(exame);
    }

    public String getTexto() throws Exception {
        ArrayList<String> itens = new ArrayList<String>();
        String pid = Funcoes.preencheVazio(this.filCodigo, "0", ParametrosGerais.getDigitosTuboFilial(), 1) + Funcoes.preencheVazio(this.reqCodigo, "0", ParametrosGerais.getDigitosTuboRequisicao(), 1) + Funcoes.preencheVazio(this.recCodigo, "0", ParametrosGerais.getDigitosTuboTubo(), 1);
        String sexo = "";
        if (this.pacSexo != null) {
            sexo = this.pacSexo.equals("M") ? "M" : "F";
        }
        itens.add("PAC");
        itens.add(pid);
        itens.add(this.pacNome);
        itens.add("");
        itens.add("");
        itens.add(sexo);
        itens.add("");
        itens.add("");
        itens.add("0");
        itens.add(pid);
        itens.add("");
        HashSet<String> examesAlterUnico = new HashSet<String>();
        for (ExameRequisicaoArquivo exame : this.exames) {
            for (ExameRequisicaoFilhoArquivo exameFilho : exame.getExamesFilhos()) {
                examesAlterUnico.add(exameFilho.getCodigoAlternativo());
            }
        }
        itens.addAll(examesAlterUnico);
        return StringUtil.implode(itens, ",");
    }

    public String getFilCodigo() {
        return this.filCodigo;
    }

    public String getReqCodigo() {
        return this.reqCodigo;
    }

    public String getRecCodigo() {
        return this.recCodigo;
    }

    public String getMcoCodigo() {
        return this.mcoCodigo;
    }

    public String getIntCodigo() {
        return this.intCodigo;
    }

    public String getPacNome() {
        return this.pacNome;
    }

    public String getPacIdade() {
        return this.pacIdade;
    }

    public String getPacSexo() {
        return this.pacSexo;
    }

    public List<ExameRequisicaoArquivo> getExames() {
        return this.exames;
    }
}

