/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.plenno;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.comunicacao.PortaFILE;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.interfaces.denscan.InterfaceConfiguracao;
import jalis.laboratorio.interfaceamento.interfaces.plenno.ExameRequisicaoArquivo;
import jalis.laboratorio.interfaceamento.interfaces.plenno.ExameRequisicaoFilhoArquivo;
import jalis.laboratorio.interfaceamento.interfaces.plenno.RequisicaoArquivo;
import jalis.laboratorio.interfaceamento.padroes.arquivo.InterfaceArquivoListener;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.io.File;
import java.io.FilenameFilter;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class InterfaceListener
extends InterfaceArquivoListener {
    private InterfaceConfiguracao configuracao;
    private String DIRETORIO_EXPORTACAO = "";
    private String DIRETORIO_IMPORTACAO = "";
    private static final int ID_AMOSTRA = 0;
    private static final int ALTERNATIVO = 1;
    private static final int RESULTADO = 2;
    private List<RequisicaoArquivo> requisicoesArquivos;
    private boolean curva = false;

    public InterfaceListener() {
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        this.configuracao = new InterfaceConfiguracao();
        this.configuracao.setDiretorioExportacao(c.getDiretorioExportacao());
        this.configuracao.setDiretorioImportacao(c.getDiretorioImportacao());
        this.configuracao.setXmlVariaveis(c.getVariaveisConfiguracao());
        this.DIRETORIO_EXPORTACAO = c.getDiretorioExportacao();
        this.DIRETORIO_IMPORTACAO = c.getDiretorioImportacao();
        this.requisicoesArquivos = new ArrayList<RequisicaoArquivo>();
    }

    @Override
    public void buscarResultados(Date inicio, Date termino) {
        File file = new File(this.DIRETORIO_IMPORTACAO);
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toUpperCase().endsWith(".CSV");
            }
        };
        File[] files = file.listFiles(filter);
        if (files != null) {
            for (File f : files) {
                try {
                    String texto = StringUtil.lerArquivoTexto(f);
                    this.parse(texto);
                    f.renameTo(new File(f.getAbsoluteFile() + "_" + Funcoes.formataData("yyyy-MM-dd_HH-mm-SSS", new Date()) + ".imp"));
                }
                catch (Exception e) {
                    this.fireMensagemEnviada("N\u00e3o foi poss\u00edvel importar o arquivo " + (null != f ? f.getName() : ""), 0, 1);
                }
            }
        }
    }

    public void setCurva(boolean curva) {
        this.curva = curva;
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        try {
            ArrayList<ExameMaterial> examesMateriais = new ArrayList<ExameMaterial>();
            Statement st = Conexao.getStatement();
            this.curva = false;
            RequisicaoArquivo requisicaoArquivo = new RequisicaoArquivo(fil_codigo, req_codigo, rec_codigo, mco_codigo, int_codigo, pac_nome, pac_idade, pac_sexo, false);
            RequisicaoArquivo requisicaoArquivoRep = new RequisicaoArquivo(fil_codigo, req_codigo, rec_codigo, mco_codigo, int_codigo, pac_nome, pac_idade, pac_sexo, false);
            for (String exame : exames.split(" ", 0)) {
                examesMateriais.add(new ExameMaterial(exame, new Integer(mco_codigo)));
            }
            for (ExameMaterial exame : examesMateriais) {
                ExameRequisicaoArquivo exameaArquivo = new ExameRequisicaoArquivo(exame.getNomeExame());
                ExameMaterial[] exameMaterialFilhos = BDUtil.isExameDesmembrado(fil_codigo, int_codigo, exame.getString(), mco_codigo) ? BDUtil.getExamesFilhos(fil_codigo, int_codigo, exame.getString(), mco_codigo) : new ExameMaterial[]{exame};
                for (ExameMaterial exameFilho : exameMaterialFilhos) {
                    String codigoAlternativo = BDUtil.getExmCodigoAlternativo(fil_codigo, exameFilho.getNomeExame(), mco_codigo, int_codigo);
                    String material = BDUtil.getExmEquipamentoMaterial(fil_codigo, exameFilho.getNomeExame(), mco_codigo, int_codigo);
                    ExameRequisicaoFilhoArquivo exameFilhoArquivo = new ExameRequisicaoFilhoArquivo(codigoAlternativo, material);
                    exameaArquivo.addExameFilho(exameFilhoArquivo);
                }
                if (this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exame.getString(), mco_codigo, rec_codigo) >= 2) {
                    requisicaoArquivoRep.addExame(exameaArquivo);
                    continue;
                }
                requisicaoArquivo.addExame(exameaArquivo);
            }
            if (requisicaoArquivoRep.getExames().size() > 0) {
                this.alteraSituacaoExame(st, requisicaoArquivoRep, fil_codigo, req_codigo, mco_codigo, rec_codigo, int_codigo);
                Conexao.arquivaSQL();
            } else {
                this.requisicoesArquivos.add(requisicaoArquivo);
            }
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
        }
        return null;
    }

    public String enviarArquivo() {
        try {
            if (this.requisicoesArquivos.isEmpty()) {
                return "";
            }
            Statement st = Conexao.getStatement();
            String arquivo = "jalis_" + Funcoes.formataData("yyyy-MM-dd_HH-mm-SSS", new Date()) + ".csv";
            arquivo = this.DIRETORIO_EXPORTACAO + "/" + arquivo;
            PortaFILE portaFile = (PortaFILE)this.getPortaCOM();
            portaFile.createFile(arquivo, true);
            for (RequisicaoArquivo requisicaoArquivo : this.requisicoesArquivos) {
                portaFile.write(requisicaoArquivo.getTexto());
                portaFile.write(LINE);
                String fil_codigo = requisicaoArquivo.getFilCodigo();
                String req_codigo = requisicaoArquivo.getReqCodigo();
                String mco_codigo = requisicaoArquivo.getMcoCodigo();
                String rec_codigo = requisicaoArquivo.getRecCodigo();
                String int_codigo = requisicaoArquivo.getIntCodigo();
                this.alteraSituacaoExame(st, requisicaoArquivo, fil_codigo, req_codigo, mco_codigo, rec_codigo, int_codigo);
            }
            portaFile.closeFile();
            this.requisicoesArquivos.clear();
            Conexao.arquivaSQL();
            this.fireMensagemEnviada("Pedido(s) enviado(s) com sucesso", 0, 10000);
            this.fireAtualizarTabela();
            return "Arquivo criado com sucesso";
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.toString() + "\n" + e.getMessage(), e.getStackTrace());
            return "Erro ao criar arquivo";
        }
    }

    private void alteraSituacaoExame(Statement st, RequisicaoArquivo requisicaoArquivo, String fil_codigo, String req_codigo, String mco_codigo, String rec_codigo, String int_codigo) throws SQLException {
        for (ExameRequisicaoArquivo exame : requisicaoArquivo.getExames()) {
            String exaCodigo = exame.getExaCodigo();
            int sitAtual = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exaCodigo, mco_codigo, rec_codigo);
            ArrayList<String> requisicoes = new ArrayList<String>();
            requisicoes.add(req_codigo);
            if (ParametrosGerais.isAgruparGuiasInterface()) {
                requisicoes = BDUtil.getReqMultiGuias(fil_codigo, req_codigo);
            }
            for (String reqCodigo : requisicoes) {
                this.atualizarSituacaoExame(st, fil_codigo, reqCodigo, rec_codigo, exaCodigo, mco_codigo, int_codigo, null, sitAtual < 2 ? 1 : 3);
            }
            if (!ParametrosGerais.isAgruparGuiasInterface()) continue;
            this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exaCodigo, mco_codigo, int_codigo, null, sitAtual < 2 ? 1 : 3);
        }
    }

    @Override
    public String parse(String message) {
        String[] linhas = message.split("\n");
        HashMap<String, String[]> resultados = new HashMap<String, String[]>();
        for (String linha : linhas) {
            String[] itens;
            if (linha.trim().isEmpty() || (itens = (linha = linha.substring(1, linha.length() - 1)).split("\",\"", -1))[0].trim().equals("TEC") || itens[0].trim().equals("TEC K") || itens[4].trim().equals("CON") || itens[4].trim().equals("CAL")) continue;
            String sampleId = itens[3].trim();
            String chave = String.format("%s%s", itens[3].trim(), itens[2].trim());
            int digitosCodigoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
            if (sampleId == null || sampleId.trim().isEmpty() || !Funcoes.isNumeric(sampleId)) {
                this.fireExcecaoEncontrada("Resultados recebidos para requisi\u00e7\u00e3o n\u00e3o existente ou n\u00e3o interfaceada: " + sampleId);
                continue;
            }
            if (sampleId.length() != digitosCodigoTubo) {
                sampleId = StringUtil.preencheString(sampleId, digitosCodigoTubo, '0', 1);
            }
            String[] fields = new String[]{itens[3].trim(), itens[2].trim(), itens[11].trim().substring(11)};
            resultados.put(chave, fields);
        }
        for (String key : resultados.keySet()) {
            try {
                Statement st = Conexao.getStatement();
                String sid = ((String[])resultados.get(key))[0];
                String emi_alternativo = ((String[])resultados.get(key))[1];
                if (Funcoes.textoVazio(sid) || sid.length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                    this.fireExcecaoEncontrada("ID da amostra incorreto para " + sid);
                    continue;
                }
                String fil_codigo = sid.substring(0, ParametrosGerais.getDigitosTuboFilial());
                String rec_codigo = sid.substring(sid.length() - ParametrosGerais.getDigitosTuboTubo());
                String req_codigo = sid.substring(ParametrosGerais.getDigitosTuboFilial(), sid.length() - ParametrosGerais.getDigitosTuboTubo());
                String int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, emi_alternativo);
                if (int_codigo == null) {
                    this.fireExcecaoEncontrada("Interfaceamento do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                    continue;
                }
                ExameMaterial exame = this.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo);
                if (exame == null) {
                    this.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                    continue;
                }
                HashMap<String, Object> dados = new HashMap<String, Object>();
                String resultado = ((String[])resultados.get(key))[2];
                StringBuilder resultadoQuant = new StringBuilder();
                for (char c : resultado.toCharArray()) {
                    if (c != '.' && !Character.isDigit(c)) break;
                    resultadoQuant.append(c);
                }
                String campoQuanti = "resultado_quantitativo";
                String campoQuali = "resultado_qualitativo";
                int situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), rec_codigo);
                if (situacao == 2 || situacao == 7 || situacao == 4) {
                    this.fireExcecaoEncontrada(String.format("Interfaceamento do exame %s para requisi\u00e7\u00e3o %s %s %s com situa\u00e7\u00e3o %s ", exame.getNomeExame(), fil_codigo, req_codigo, rec_codigo, situacao == 2 ? "pronto " : (situacao == 4 ? "j\u00e1 repetido " : "validado ")));
                    continue;
                }
                if (situacao == 3) {
                    campoQuanti = "repeticao_quantitativo";
                    campoQuali = "repeticao_qualitativo";
                }
                dados.put(campoQuanti, resultadoQuant.toString().replace('.', ','));
                dados.put(campoQuali, resultado);
                this.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo, dados);
                Conexao.arquivaSQL();
                this.fireAtualizarTabela();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return "Erro ao realizar parse de dados recebidos do equipamento";
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
                return "Erro ao realizar parse de dados recebidos do equipamento";
            }
        }
        return "Resultados recebidos com sucesso";
    }

    public void adicionarRequisicaoParaEnviar(String filial, String requisicao, String tubo, String nomePaciente, String exames, String material, String codigoInterface, String pacIdade, String pacSexo, boolean curva) {
        if (this.requisicoesArquivos != null) {
            String codigoAlternativo;
            try {
                codigoAlternativo = BDUtil.getExmCodigoAlternativo(filial, exames, material, codigoInterface);
                if (Funcoes.textoVazio(codigoAlternativo)) {
                    this.fireExcecaoEncontrada("Exame " + exames + " ");
                    return;
                }
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                return;
            }
            ExameRequisicaoFilhoArquivo exameFilhoArquivo = new ExameRequisicaoFilhoArquivo(codigoAlternativo, material);
            RequisicaoArquivo requisicaoArquivo = new RequisicaoArquivo(filial, requisicao, tubo, material, codigoInterface, nomePaciente, pacIdade, pacSexo, curva);
            ExameRequisicaoArquivo exameRequisicaoArquivo = new ExameRequisicaoArquivo(exames);
            exameRequisicaoArquivo.addExameFilho(exameFilhoArquivo);
            requisicaoArquivo.addExame(exameRequisicaoArquivo);
            this.requisicoesArquivos.add(requisicaoArquivo);
        }
    }
}

