/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.planilharesultado;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.padroes.arquivo.InterfaceArquivoListener;
import jalis.util.Funcoes;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JFileChooser;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class InterfaceListener
extends InterfaceArquivoListener {
    public static final String ABA_EXCEL_RESULTADO = "resultado";
    public static final String NOME_EXAME = "SALIVA";
    private static final String NA = "Na";
    private static final String MG = "Mg";
    private static final String AL = "Al";
    private static final String P = "P";
    private static final String S = "S";
    private static final String K = "K";
    private static final String CA = "Ca";
    private static final String TI = "Ti";
    private static final String FE = "Fe";
    private static final String NI = "Ni";
    private static final String CU = "Cu";
    private static final String ZN = "Zn";
    private static final String SR = "Sr";
    private static final String SN = "Sn";
    private static final String BA = "Ba";
    private static final String PB = "Pb";
    private static final String BI = "Bi";
    private static final String U = "U";
    private static final String LI = "Li";
    private static final String BE = "Be";
    private static final String B = "B";
    private static final String CR = "Cr";
    private static final String MN = "Mn";
    private static final String CO = "Co";
    private static final String GE = "Ge";
    private static final String AS = "As";
    private static final String SE = "Se";
    private static final String ZR = "Zr";
    private static final String AG = "Ag";
    private static final String CD = "Cd";
    private static final String SB = "Sb";
    private static final String TL = "Tl";
    private static final String HG = "Hg";
    private static final String TE = "Te";
    private static final String W = "W";
    private static final String V = "V";
    private static final String MO = "Mo";
    private static final String RB = "Rb";
    private static final String FLUORETO = "Fluoreto";
    private static final String SI = "Si";
    private static final String DUREZA = "Dureza";
    private static final String SULFATO = "Sulfato";
    private static final String CLORETO = "Cloreto";
    private static final String PRAL = "PRAL";
    private String diretorioImportacao = "";
    ConfiguracaoSerial c = Variaveis.equipamentos.get(0);

    public InterfaceListener() {
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        this.diretorioImportacao = c.getDiretorioImportacao();
    }

    @Override
    public void buscarResultados(Date inicio, Date termino) {
        try {
            JFileChooser chooser = ComponenteFactory.novoJFileChooser("Arquivo para importa\u00e7\u00e3o", this.diretorioImportacao);
            chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
            chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo de Planilha de resultado", "xlsx"));
            if (chooser.showOpenDialog(null) == 0) {
                String path = chooser.getSelectedFile().getPath();
                this.parse(path);
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
        }
    }

    @Override
    public String parse(String path) {
        File file = new File(path);
        try {
            Statement st = Conexao.getStatement();
            List<List<Object>> planilhaResultado = this.lerXlsx(file, ABA_EXCEL_RESULTADO, true);
            for (int i = 2; i < planilhaResultado.size(); ++i) {
                String rec_codigo;
                String req_codigo;
                List<Object> cabecalho = planilhaResultado.get(0);
                List<Object> retorno = planilhaResultado.get(i);
                String amostra = retorno.get(0).toString().replaceAll("-", "").trim();
                if (amostra.isEmpty()) continue;
                if (amostra.trim().length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                    this.fireExcecaoEncontrada(String.format("Amostra n\u00e3o localizada %s.", amostra));
                    continue;
                }
                String fil_codigo = amostra.substring(0, ParametrosGerais.getDigitosTuboFilial());
                String int_codigo = this.getIntCodigo(fil_codigo, req_codigo = amostra.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao()), rec_codigo = amostra.substring(ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao()), NOME_EXAME);
                if (int_codigo == null) {
                    this.fireExcecaoEncontrada(String.format("Amostra n\u00e3o localizada %s %s %s.", fil_codigo, req_codigo, rec_codigo));
                    continue;
                }
                Map<String, Object> resultadosMap = this.resultadoMap(retorno, cabecalho);
                ExameMaterial exame = this.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, NOME_EXAME);
                if (exame != null) {
                    this.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo, resultadosMap);
                    Conexao.arquivaSQL();
                    continue;
                }
                this.fireExcecaoEncontrada(String.format("Amostra n\u00e3o localizada para o exame SALIVA %s %s %s.", fil_codigo, req_codigo, rec_codigo));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            this.fireExcecaoEncontrada("Resultado n\u00e3o encontrado no arquivo " + file.getName() + e.getMessage());
        }
        return null;
    }

    private Map<String, Object> resultadoMap(List<Object> retorno, List<Object> cabecalho) {
        HashMap<String, Object> resultadosMap = new HashMap<String, Object>();
        if (cabecalho.get(1).toString().equals(NA)) {
            resultadosMap.put(NA, this.converteResultado(retorno.get(2)));
        }
        if (cabecalho.get(3).toString().equals(MG)) {
            resultadosMap.put(MG, this.converteResultado(retorno.get(4)));
        }
        if (cabecalho.get(5).toString().equals(AL)) {
            resultadosMap.put(AL, this.converteResultado(retorno.get(6)));
        }
        if (cabecalho.get(7).equals(P)) {
            resultadosMap.put(P, this.converteResultado(retorno.get(8)));
        }
        if (cabecalho.get(9).equals(S)) {
            resultadosMap.put(S, this.converteResultado(retorno.get(10)));
        }
        if (cabecalho.get(11).equals(K)) {
            resultadosMap.put(K, this.converteResultado(retorno.get(12)));
        }
        if (cabecalho.get(13).equals(CA)) {
            resultadosMap.put(CA, this.converteResultado(retorno.get(14)));
        }
        if (cabecalho.get(15).equals(TI)) {
            resultadosMap.put(TI, this.converteResultado(retorno.get(16)));
        }
        if (cabecalho.get(17).equals(FE)) {
            resultadosMap.put(FE, this.converteResultado(retorno.get(18)));
        }
        if (cabecalho.get(19).equals(NI)) {
            resultadosMap.put(NI, this.converteResultado(retorno.get(20)));
        }
        if (cabecalho.get(21).equals(CU)) {
            resultadosMap.put(CU, this.converteResultado(retorno.get(22)));
        }
        if (cabecalho.get(23).equals(ZN)) {
            resultadosMap.put(ZN, this.converteResultado(retorno.get(24)));
        }
        if (cabecalho.get(25).equals(SR)) {
            resultadosMap.put(SR, this.converteResultado(retorno.get(26)));
        }
        if (cabecalho.get(27).equals(SN)) {
            resultadosMap.put(SN, this.converteResultado(retorno.get(28)));
        }
        if (cabecalho.get(29).equals(BA)) {
            resultadosMap.put(BA, this.converteResultado(retorno.get(30)));
        }
        if (cabecalho.get(31).equals(PB)) {
            resultadosMap.put(PB, this.converteResultado(retorno.get(32)));
        }
        if (cabecalho.get(33).equals(BI)) {
            resultadosMap.put(BI, this.converteResultado(retorno.get(34)));
        }
        if (cabecalho.get(35).equals(U)) {
            resultadosMap.put(U, this.converteResultado(retorno.get(36)));
        }
        if (cabecalho.get(37).equals(LI)) {
            resultadosMap.put(LI, this.converteResultado(retorno.get(38)));
        }
        if (cabecalho.get(39).equals(BE)) {
            resultadosMap.put(BE, this.converteResultado(retorno.get(40)));
        }
        if (cabecalho.get(41).equals(B)) {
            resultadosMap.put(B, this.converteResultado(retorno.get(42)));
        }
        if (cabecalho.get(43).equals(CR)) {
            resultadosMap.put(CR, this.converteResultado(retorno.get(44)));
        }
        if (cabecalho.get(45).equals(MN)) {
            resultadosMap.put(MN, this.converteResultado(retorno.get(46)));
        }
        if (cabecalho.get(47).equals(CO)) {
            resultadosMap.put(CO, this.converteResultado(retorno.get(48)));
        }
        if (cabecalho.get(49).equals(GE)) {
            resultadosMap.put(GE, this.converteResultado(retorno.get(50)));
        }
        if (cabecalho.get(51).equals(AS)) {
            resultadosMap.put(AS, this.converteResultado(retorno.get(52)));
        }
        if (cabecalho.get(53).equals(SE)) {
            resultadosMap.put(SE, this.converteResultado(retorno.get(54)));
        }
        if (cabecalho.get(55).equals(ZR)) {
            resultadosMap.put(ZR, this.converteResultado(retorno.get(56)));
        }
        if (cabecalho.get(57).equals(AG)) {
            resultadosMap.put(AG, this.converteResultado(retorno.get(58)));
        }
        if (cabecalho.get(59).equals(CD)) {
            resultadosMap.put(CD, this.converteResultado(retorno.get(60)));
        }
        if (cabecalho.get(61).equals(SB)) {
            resultadosMap.put(SB, this.converteResultado(retorno.get(62)));
        }
        if (cabecalho.get(63).equals(TL)) {
            resultadosMap.put(TL, this.converteResultado(retorno.get(64)));
        }
        if (cabecalho.get(65).equals(HG)) {
            resultadosMap.put(HG, this.converteResultado(retorno.get(66)));
        }
        if (cabecalho.get(67).equals(TE)) {
            resultadosMap.put(TE, this.converteResultado(retorno.get(68)));
        }
        if (cabecalho.get(69).equals(W)) {
            resultadosMap.put(W, this.converteResultado(retorno.get(70)));
        }
        if (cabecalho.get(71).equals(V)) {
            resultadosMap.put(V, this.converteResultado(retorno.get(72)));
        }
        if (cabecalho.get(73).equals(MO)) {
            resultadosMap.put(MO, this.converteResultado(retorno.get(74)));
        }
        if (cabecalho.get(75).equals(RB)) {
            resultadosMap.put(RB, this.converteResultado(retorno.get(76)));
        }
        if (cabecalho.get(77).equals(SI)) {
            resultadosMap.put(SI, this.converteResultado(retorno.get(78)));
        }
        if (cabecalho.get(79).equals(FLUORETO)) {
            resultadosMap.put(FLUORETO, this.converteResultado(retorno.get(80)));
        }
        if (cabecalho.get(81).equals(DUREZA)) {
            resultadosMap.put(DUREZA, this.converteResultado(retorno.get(82)));
        }
        if (cabecalho.get(83).equals(SULFATO)) {
            resultadosMap.put(SULFATO, this.converteResultado(retorno.get(84)));
        }
        if (cabecalho.get(85).equals(CLORETO)) {
            resultadosMap.put(CLORETO, this.converteResultado(retorno.get(86)));
        }
        if (cabecalho.get(87).equals(PRAL)) {
            resultadosMap.put(PRAL, this.converteResultado(retorno.get(87)));
        }
        return resultadosMap;
    }

    private Object converteResultado(Object resultado) {
        return resultado != null && !Funcoes.textoVazio(resultado.toString()) ? resultado.toString().replaceAll("\\.", ",") : "";
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        try {
            String[] exms;
            Statement st = Conexao.getStatement();
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(exames.split(" ", 0), mco_codigo);
            for (String s : exms = exames.split(" ", 0)) {
                this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, s, mco_codigo, int_codigo, null, 1);
            }
            Conexao.arquivaSQL();
            this.fireMensagemEnviada("Pedido(s) enviado(s) com sucesso para " + pac_nome, 0, 10000);
            this.equipamento.atualizarTabela(0);
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
            return "";
        }
    }

    public List<List<Object>> lerXlsx(File file, String planilha, boolean retornaValor) throws Exception {
        ArrayList<List<Object>> linhas = new ArrayList<List<Object>>();
        XSSFWorkbook rb = new XSSFWorkbook((InputStream)new FileInputStream(file));
        XSSFSheet plan1 = rb.getSheet(planilha);
        for (int i = 0; i <= plan1.getLastRowNum(); ++i) {
            if (plan1.getRow(i) == null) continue;
            linhas.add(this.getCelulaValorXlsx(plan1.getRow(i), retornaValor));
        }
        return linhas;
    }

    public List<Object> getCelulaValorXlsx(XSSFRow xssfRow, boolean retornaValor) {
        ArrayList<Object> colunas = new ArrayList<Object>();
        for (Cell cell : xssfRow) {
            try {
                switch (cell.getCellType()) {
                    case 3: {
                        colunas.add("");
                        break;
                    }
                    case 4: {
                        colunas.add(new Boolean(cell.getBooleanCellValue()));
                        break;
                    }
                    case 5: {
                        colunas.add(cell.getErrorCellValue());
                        break;
                    }
                    case 2: {
                        colunas.add(retornaValor ? Double.valueOf(cell.getNumericCellValue()) : cell.getCellFormula());
                        break;
                    }
                    case 0: {
                        Double valor = cell.getNumericCellValue();
                        String valorFormatado = new BigDecimal(valor).setScale(8, 4).toPlainString();
                        colunas.add(valorFormatado);
                        break;
                    }
                    case 1: {
                        colunas.add(cell.getStringCellValue());
                        break;
                    }
                    default: {
                        colunas.add(cell.getStringCellValue());
                        break;
                    }
                }
            }
            catch (Exception e) {
                colunas.add("");
            }
        }
        return colunas;
    }
}

