/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.pentrac200;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.interfaces.pentrac200.RecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.interfaceamento.padroes.astm.InterfaceASTMListener;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.interfaceamento.util.TestesInterface;
import jalis.util.CodString;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class InterfaceListener
extends InterfaceASTMListener {
    protected String host_fil_codigo = null;
    protected String host_req_codigo = null;
    protected String host_rec_codigo = null;
    protected boolean hostQuery = false;

    public InterfaceListener() {
        RecordParser record = new RecordParser();
        record.setInterfaceASTMListener(this);
        super.setASTMRecordParser(record);
        this.INSTRUMENT_NAME = "Analyzer";
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao) {
        try {
            Object exameCurva;
            this.tx_list.clear();
            this.rx_list.clear();
            this.req_codigo = req_codigo;
            this.fil_codigo = fil_codigo;
            this.int_codigo = int_codigo;
            this.pac_nome = pac_nome;
            this.pac_sexo = pac_sexo;
            this.req_idade = pac_idade;
            this.req_data = data;
            this.req_hora = hora;
            this.mco_codigo = mco_codigo;
            this.rec_codigo = rec_codigo;
            this.pac_exames = pac_exames;
            this.exames = pac_exames.split(" ", 0);
            this.ultima_acao = acao;
            this.curva = false;
            this.rec_tuboPai = "";
            this.examesFilho = new LinkedList();
            ExameMaterial[] alternativos = null;
            ExameMaterial[] listaCurva = null;
            Map<String, List<ExameMaterial>> alternativosCurva = null;
            String short_name = StringUtil.removerAcentos(StringUtil.removeEspacosDuplicados(pac_nome));
            String nome = null;
            String nomeDoMeio = "";
            String ultimoNome = short_name;
            if (short_name.indexOf(" ") > 0) {
                String[] names = short_name.split(" ");
                nome = names[0];
                if (names.length <= 2) {
                    ultimoNome = names[1];
                } else {
                    ultimoNome = names[names.length - 1];
                    if (names.length > 3) {
                        nomeDoMeio = String.format("%s%s", names[1].substring(0, 1), names[2].substring(0, 1));
                    } else {
                        try {
                            nomeDoMeio = names[1].substring(0, 2);
                        }
                        catch (Exception e) {
                            nomeDoMeio = "";
                        }
                    }
                }
            }
            fil_codigo = StringUtil.preencheString(fil_codigo, ParametrosGerais.getDigitosTuboFilial(), '0', 1);
            StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo);
            StringBuilder sample_id = new StringBuilder(fil_codigo).append(req_codigo);
            rec_codigo = StringUtil.preencheString(rec_codigo, ParametrosGerais.getDigitosTuboTubo(), '0', 1);
            codigo.append(rec_codigo);
            Statement st = Conexao.getStatement();
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(this.exames, mco_codigo);
            String exame = exa_lista[0].toString();
            ArrayList<ExameMaterial> exa_listaCurva = new ArrayList<ExameMaterial>();
            exa_lista = ExamesUtil.separaExamesCurva(fil_codigo, int_codigo, mco_codigo, exa_lista, exa_listaCurva);
            String tipo_amostra = "";
            if (exa_lista != null) {
                tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, (exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_lista))[0].getString(), exa_lista[0].getCodigo().toString(), int_codigo);
                if (Funcoes.textoVazio(tipo_amostra)) {
                    tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, exame, mco_codigo, int_codigo);
                }
                alternativos = ExamesUtil.getAlternativos(st, fil_codigo, int_codigo, exa_lista);
                alternativos = ExamesUtil.removeDuplicados(alternativos);
            }
            if (!exa_listaCurva.isEmpty()) {
                exameCurva = new ArrayList();
                for (ExameMaterial exameMaterial : exa_listaCurva) {
                    exameCurva.add(exameMaterial.getNomeExame());
                }
                if (Funcoes.textoVazio(this.rec_tuboPai)) {
                    this.rec_tuboPai = BDUtil.getExameDesmembradoTuboPai(fil_codigo, req_codigo, rec_codigo, int_codigo, (String)exameCurva.get(0), mco_codigo);
                }
                if (Funcoes.textoVazio(tipo_amostra)) {
                    tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, ((ExameMaterial)exa_listaCurva.get(0)).getString(), ((ExameMaterial)exa_listaCurva.get(0)).getCodigo().toString(), int_codigo);
                }
                listaCurva = ExamesUtil.anexarCodigoMaterial(exameCurva.toArray(new String[exameCurva.size()]), mco_codigo);
                listaCurva = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_listaCurva.toArray(new ExameMaterial[exa_listaCurva.size()]));
                alternativosCurva = ExamesUtil.getAlternativosCurva(fil_codigo, int_codigo, req_codigo, mco_codigo, String.valueOf(Integer.parseInt(rec_codigo)), st, exa_listaCurva, this.rec_tuboPai, true, this.examesFilho);
            }
            if (Funcoes.textoVazio(tipo_amostra)) {
                if (exa_lista != null) {
                    Object ex;
                    exameCurva = exa_lista;
                    int n = ((ExameMaterial[])exameCurva).length;
                    for (int exameMaterial = 0; exameMaterial < n && Funcoes.textoVazio(tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, ((CodString)(ex = exameCurva[exameMaterial])).getString(), ((CodString)ex).getCodigo().toString(), int_codigo)); ++exameMaterial) {
                    }
                }
                if (Funcoes.textoVazio(tipo_amostra)) {
                    for (String exFilho : this.examesFilho) {
                        tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, exFilho, mco_codigo, int_codigo);
                    }
                }
            }
            this.tx_list.add(ASTMStandard.getDefaultHeaderRecord(this.DELIMITERS, this.PASSWORD, this.HOST_NAME, this.HOST_SYSTEM_VERSION, null, this.INSTRUMENT_NAME, this.INSTRUMENT_SYSTEM_VERSION));
            StringBuilder patient_id = new StringBuilder();
            patient_id.append(fil_codigo).append(req_codigo);
            Date dataNasc = BDUtil.getDataNacimentoPaciente(fil_codigo, req_codigo);
            String laboratory_pid = null;
            String medico = BDUtil.buscaMedicoRequisicao(fil_codigo, req_codigo) + StringUtil.repeteCaractere(' ', 32);
            medico = StringUtil.removerAcentos(medico.substring(0, 31));
            String t = this.getPatientRecord(1, patient_id.toString(), laboratory_pid, ultimoNome, nomeDoMeio, nome, pac_sexo, dataNasc, medico.trim());
            this.tx_list.add(t);
            int seq = 0;
            if (alternativos != null && alternativos.length > 0) {
                t = ASTMStandard.getDefaultOrderRecord(++seq, codigo.toString(), null, alternativos, null, null, "R", acao, tipo_amostra, "O");
                this.tx_list.add(t);
            }
            if (alternativosCurva != null && alternativosCurva.size() > 0) {
                String cod = sample_id.toString();
                this.curva = true;
                for (String key : alternativosCurva.keySet()) {
                    sample_id.setLength(0);
                    sample_id.append(cod);
                    String tubo = Funcoes.preencheZero(key, ParametrosGerais.getDigitosTuboTubo());
                    t = ASTMStandard.getDefaultOrderRecord(++seq, sample_id.append(tubo).toString(), null, alternativosCurva.get(key).toArray(new ExameMaterial[alternativosCurva.get(key).size()]), null, null, "R", acao, tipo_amostra, "O");
                    this.tx_list.add(t);
                }
            }
            t = ASTMStandard.getDefaultTerminationRecord("N");
            this.tx_list.add(t);
            this.tx_list = this.makeFrames(this.tx_list);
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            this.getPortaCOM().write(String.valueOf('\u0005'));
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: envio de requisi\u00e7\u00e3o");
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o em envio de requisi\u00e7\u00e3o");
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    @Override
    public void responderRequest(String starting_range, String ending_range, String test_id) {
        try {
            String sampleId = starting_range.trim();
            if (Funcoes.textoVazio(sampleId)) {
                this.fireExcecaoEncontrada(String.format("Amostra com o c\u00f3digo fora do padr\u00e3o %s ", sampleId));
                return;
            }
            if (!Funcoes.textoVazio(sampleId) && sampleId.contains("^")) {
                sampleId = StringUtil.limpaString(sampleId, new String[]{"^"});
            }
            if (sampleId.trim().length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                this.fireExcecaoEncontrada(String.format("Amostra com o c\u00f3digo fora do padr\u00e3o %s ", sampleId));
                return;
            }
            this.host_fil_codigo = sampleId.substring(0, ParametrosGerais.getDigitosTuboFilial());
            sampleId = sampleId.substring(ParametrosGerais.getDigitosTuboFilial());
            this.host_req_codigo = sampleId.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
            this.host_rec_codigo = sampleId.substring(ParametrosGerais.getDigitosTuboRequisicao());
            this.hostQuery = true;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Pentra C 200: Host Query Response");
        }
    }

    @Override
    protected void tratarEndOfTX() throws Exception {
        super.tratarEndOfTX();
        if (this.hostQuery) {
            this.responseHostQuery();
        }
    }

    public void responseHostQuery() {
        try {
            String fil_codigo = this.host_fil_codigo;
            String req_codigo = this.host_req_codigo;
            String rec_codigo = this.host_rec_codigo;
            String pac_nome = null;
            String pac_sexo = null;
            String pac_idade = null;
            String data = null;
            String hora = null;
            String prioridade = null;
            String int_codigo = null;
            String mco_codigo = null;
            String pac_exames = null;
            String acao = "A";
            if (Funcoes.textoVazio(fil_codigo) || Funcoes.textoVazio(req_codigo) || Funcoes.textoVazio(rec_codigo)) {
                return;
            }
            Object[] req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 0);
            PanelAbaAbstrata aba = this.equipamento.getTab(0);
            if (req != null) {
                pac_exames = (String)req[aba.getColIndice("Exame")];
            }
            if (req == null && (req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2, true)) != null) {
                aba = this.equipamento.getTab(2);
                if (req != null && Funcoes.textoVazio(pac_exames)) {
                    pac_exames = (String)req[aba.getColIndice("Exame")];
                }
                if (req != null) {
                    pac_exames = pac_exames + " ";
                    List<Object[]> reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2);
                    for (Object[] r : reqs) {
                        pac_exames = pac_exames + (String)r[aba.getColIndice("Exame")] + " ";
                    }
                    pac_exames = pac_exames.trim();
                }
            }
            this.host_fil_codigo = null;
            this.host_req_codigo = null;
            this.host_rec_codigo = null;
            if (req != null) {
                pac_nome = aba.getColIndice("Paciente") >= 0 ? (String)req[aba.getColIndice("Paciente")] : null;
                pac_sexo = aba.getColIndice("S") >= 0 ? (String)req[aba.getColIndice("S")] : null;
                data = aba.getColIndice("Data") >= 0 ? (String)req[aba.getColIndice("Data")] : null;
                hora = aba.getColIndice("Hora") >= 0 ? (String)req[aba.getColIndice("Hora")] : null;
                int_codigo = aba.getColIndice("Interface") >= 0 ? (String)req[aba.getColIndice("Interface")] : null;
                mco_codigo = aba.getColIndice("C\u00f3d. Mat.") >= 0 ? (String)req[aba.getColIndice("C\u00f3d. Mat.")] : null;
                this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, "", prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames, acao);
            } else {
                this.fireExcecaoEncontrada(String.format("Nenhum exame localizado nas abas N\u00e3o-Enviados e aba Prontos (Repeti\u00e7\u00e3o). Amostra:  %s %s %s:", fil_codigo, req_codigo, rec_codigo));
                this.tx_list.add(ASTMStandard.getDefaultHeaderRecord(this.DELIMITERS, this.PASSWORD, this.HOST_NAME, this.HOST_SYSTEM_VERSION, null, this.INSTRUMENT_NAME, this.INSTRUMENT_SYSTEM_VERSION));
                this.tx_list.add(ASTMStandard.getDefaultTerminationRecord("N"));
                this.tx_list = this.makeFrames(this.tx_list);
                this.tx_list.resetUltimoLido();
                this.setTX(this.TIME_TX);
                this.tx_counter = 0;
                this.getPortaCOM().write(String.valueOf('\u0005'));
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Labmax 400: Host Query Response");
        }
    }

    private String getPatientRecord(int patient_sequence, String patient_id, String laboratory_pid, String ultimoNome, String nomeDoMeio, String primeiroNome, String pac_sexo, Date dataNasc, String med_nome) {
        StringBuilder record = new StringBuilder("P|");
        record.append(patient_sequence);
        record.append("|");
        record.append(patient_id == null ? "" : patient_id);
        record.append("|");
        record.append(laboratory_pid == null ? "" : laboratory_pid);
        record.append("||");
        record.append(ultimoNome).append("^");
        record.append(primeiroNome).append("^");
        record.append(nomeDoMeio);
        record.append("||");
        record.append(dataNasc == null ? "" : Funcoes.formataData("yyyyMMdd", dataNasc));
        record.append("|");
        record.append(pac_sexo == null ? "" : pac_sexo);
        record.append("|||||");
        record.append(med_nome);
        record.append("||");
        record.append('\r');
        return record.toString();
    }

    @Override
    public String getErroTraduzido(String erro) {
        return null;
    }

    @Override
    public void teste() {
        this.logCliente();
    }

    public void logCliente() {
        this.handShakeCharReceived('\u0004');
        this.parse(TestesInterface.arruma("[STX]1H|\\^&|||Analyzer|||||||||20151208180550[CR][ETX]C1[LINE]"));
        this.parse(TestesInterface.arruma("[STX]2Q|1|^0101107904||||||||||N[CR][ETX]93[LINE][STX]3L|1[CR][ETX]3C[LINE]"));
        this.handShakeCharReceived('\u0004');
        this.handShakeCharReceived('\u0006');
        this.handShakeCharReceived('\u0006');
        this.handShakeCharReceived('\u0006');
        this.handShakeCharReceived('\u0006');
        this.handShakeCharReceived('\u0006');
        this.handShakeCharReceived('\u0006');
    }
}

