/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.pentra80bi;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.interfaces.pentra80bi.InterfaceConfiguracao;
import jalis.laboratorio.interfaceamento.padroes.abx.ABXStandard;
import jalis.laboratorio.interfaceamento.padroes.abx.InterfaceABXListener;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.interfaceamento.util.Checksum;
import jalis.util.Funcoes;
import jalis.util.MemoryList;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class InterfaceListener
extends InterfaceABXListener {
    private List<String> requisicoes = new ArrayList<String>();
    private boolean requisicaoAck = false;
    private boolean ackFrameEnd = false;
    private boolean recebeuENQ = false;
    private InterfaceConfiguracao configuracao = new InterfaceConfiguracao();
    private Timer porta = null;
    private boolean heartbit = false;

    public InterfaceListener() {
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        this.configuracao = new InterfaceConfiguracao();
        this.configuracao.setXmlVariaveis(c.getVariaveisConfiguracao());
        int tempo = this.configuracao.getHeartBit() * 1000;
        if (tempo > 0) {
            this.porta = new Timer(tempo, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (InterfaceListener.this.getPortaCOM() != null && !InterfaceListener.this.isTX() && !InterfaceListener.this.isRX() || InterfaceListener.this.getPortaCOM() != null && InterfaceListener.this.isRX() && InterfaceListener.this.requisicoes.size() == 0) {
                        try {
                            if (!InterfaceListener.this.ackFrameEnd && !InterfaceListener.this.heartbit) {
                                InterfaceListener.this.getPortaCOM().write(String.valueOf('\u0001'));
                                InterfaceListener.this.heartbit = true;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            });
            this.porta.start();
        }
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao) {
        try {
            if (this.ackFrameEnd) {
                return "";
            }
            this.tx_list.clear();
            this.rx_list.clear();
            this.fil_codigo = fil_codigo;
            this.acao = acao;
            this.int_codigo = int_codigo;
            this.req_codigo = req_codigo;
            this.pac_nome = pac_nome;
            this.pac_sexo = pac_sexo;
            this.req_idade = pac_idade;
            this.req_data = data;
            this.req_hora = hora;
            this.mco_codigo = mco_codigo;
            this.rec_codigo = rec_codigo;
            this.pac_exames = pac_exames;
            this.exames = pac_exames.split(" ", 0);
            StringBuilder req = new StringBuilder();
            req.append(Funcoes.preencheZero(fil_codigo, ParametrosGerais.getDigitosTuboFilial()));
            req.append(Funcoes.preencheZero(req_codigo, ParametrosGerais.getDigitosTuboRequisicao()));
            req.append(Funcoes.preencheZero(rec_codigo, ParametrosGerais.getDigitosTuboTubo()));
            if (!this.requisicoes.contains(req.toString())) {
                this.requisicoes.add(req.toString());
            }
            this.setTX(this.TIME_TX);
            this.getPortaCOM().write(String.valueOf('\u0001'));
            this.recebeuENQ = false;
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractABXInterfaceamento: envio de requisi\u00e7\u00e3o");
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractABXInterfaceamento: exce\u00e7\u00e3o em envio de requisi\u00e7\u00e3o");
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
        super.fcTimedOut(e);
    }

    @Override
    public void handShakeCharReceived(char c) {
        try {
            switch (c) {
                case '\u0005': {
                    this.recebeuENQ = true;
                    this.tratarEnquiry();
                    break;
                }
                case '\u0006': {
                    this.tratarAcknowledge();
                    break;
                }
                case '\u0015': {
                    this.tratarNegativeAck();
                    break;
                }
                case '\u0004': {
                    this.tratarEndOfTX();
                    break;
                }
                case '\u0001': {
                    this.tratarSOH();
                }
                default: {
                    this.caracterNaoEsperado();
                    break;
                }
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "InterfaceABXListener: evento de caracter de handshake recebido");
            this.fireMensagemEnviada("Erro ao estabelecer comunica\u00e7\u00e3o com o equipamento: " + ex.getMessage(), 1, 5000);
            this.setIdle();
        }
    }

    @Override
    protected void parseRecord(String record_type, HashMap<String, Object> lines) throws Exception {
        super.parseRecord(record_type, lines);
        this.fireAtualizarTabela();
    }

    @Override
    protected void tratarAcknowledge() throws Exception {
        if (this.ackFrameEnd) {
            this.ackFrameEnd = false;
        }
        if (this.isTX()) {
            if (!this.tx_list.isEmpty() && this.tx_list.getUltimoLido() == this.tx_list.size() - 1) {
                this.encerrarTransmissao();
            } else if (this.tx_list.isEmpty()) {
                this.enviarProximoFrame();
            }
        } else if (!this.isRX()) {
            this.caracterNaoEsperado();
        } else {
            this.caracterNaoEsperado();
        }
    }

    public void enviaEnd() throws Exception {
        if (!this.ackFrameEnd) {
            this.ackFrameEnd = true;
            this.tx_list.clear();
            StringBuilder msg = new StringBuilder();
            msg.append('\u00ff').append(" ");
            msg.append("END     ").append('\r');
            this.tx_list.add(msg.toString());
            this.tx_list = this.makeFrames(this.tx_list);
            this.getPortaCOM().write((String)this.tx_list.remove(0));
        }
    }

    @Override
    protected void abortarTransmissao() throws Exception {
        this.limpaDadosRequisicao();
        this.setPausa(this.TIME_TX_ABORTADO);
        if (this.recebeuENQ) {
            this.enviaEnd();
            this.recebeuENQ = false;
        }
        this.fireMensagemEnviada("Tempo esgotado ao transmitir dados ao equipamento", 1, 5000);
    }

    @Override
    protected void encerrarTransmissao() throws Exception {
        super.encerrarTransmissao();
        this.tx_list.clear();
        if (Funcoes.textoVazio(this.fil_codigo) || Funcoes.textoVazio(this.int_codigo) || Funcoes.textoVazio(this.req_codigo) || Funcoes.textoVazio(this.mco_codigo) || Funcoes.textoVazio(this.rec_codigo) || Funcoes.textoVazio(this.acao)) {
            this.setIdle();
        }
        this.enviaEnd();
    }

    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao) {
        try {
            String short_name;
            this.tx_list.clear();
            this.rx_list.clear();
            this.fil_codigo = fil_codigo;
            this.acao = acao;
            this.int_codigo = int_codigo;
            this.req_codigo = req_codigo;
            this.pac_nome = pac_nome;
            this.pac_sexo = pac_sexo;
            this.req_idade = pac_idade;
            this.req_data = data;
            this.req_hora = hora;
            this.mco_codigo = mco_codigo;
            this.rec_codigo = rec_codigo;
            this.pac_exames = pac_exames;
            this.exames = pac_exames.split(" ", 0);
            String[] age = BDUtil.getIdadeNacimentoPaciente(fil_codigo, req_codigo);
            String idade = age[0];
            String tipoIdade = age[1];
            Date nascimento = StringUtil.getDataDeString(age[2]);
            String medico = BDUtil.buscaMedicoRequisicao(fil_codigo, req_codigo);
            if (!Funcoes.textoVazio(medico)) {
                medico = StringUtil.removerAcentos(medico);
            }
            if ((short_name = StringUtil.removerAcentos(pac_nome)).length() > this.MAX_PATIENT_NAME_CHARS) {
                short_name = short_name.substring(0, this.MAX_PATIENT_NAME_CHARS);
            }
            fil_codigo = Funcoes.preencheZero(fil_codigo, ParametrosGerais.getDigitosTuboFilial());
            StringBuilder codigo = new StringBuilder(fil_codigo);
            req_codigo = Funcoes.preencheZero(req_codigo, ParametrosGerais.getDigitosTuboRequisicao());
            codigo.append(req_codigo);
            rec_codigo = Funcoes.preencheZero(rec_codigo, ParametrosGerais.getDigitosTuboTubo());
            codigo.append(rec_codigo);
            this.tx_list.clear();
            this.tx_list.add(ABXStandard.getDefaultHeaderRecord());
            this.tx_list.add(this.getOrderRecord(codigo.toString(), short_name, nascimento, idade, tipoIdade, pac_sexo, this.exames[0], codigo.toString(), medico, "", data, hora));
            this.tx_list.add(ABXStandard.getDefaultFooterRecord());
            this.tx_list = this.makeFrames(this.tx_list);
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.enviarProximoFrame();
            this.tx_counter = 0;
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractABXInterfaceamento: envio de requisi\u00e7\u00e3o");
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractABXInterfaceamento: exce\u00e7\u00e3o em envio de requisi\u00e7\u00e3o");
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    @Override
    public MemoryList<String> makeFrames(MemoryList<String> raw_list) throws Exception {
        try {
            MemoryList<String> new_list = new MemoryList<String>();
            StringBuilder temp_list = new StringBuilder();
            if (raw_list != null) {
                while (!raw_list.isEmpty()) {
                    temp_list.append(raw_list.remove(0));
                }
                int size = temp_list.toString().getBytes().length + 6 + 7;
                temp_list.insert(0, Funcoes.preencheZero(size, 5) + '\r');
                String check = Checksum.getHexSum(temp_list.toString(), 4);
                temp_list.append('\u00fd').append(' ');
                temp_list.append(check);
                temp_list.append('\r');
                temp_list.insert(0, this.getMsgStart());
                temp_list.append(this.getMsgEnd());
                new_list.add(temp_list.toString());
                return new_list;
            }
            return null;
        }
        catch (Exception ex) {
            throw new Exception("Erro ao recuperar lista de frames (size:" + raw_list.size() + ")");
        }
    }

    @Override
    public void dataChanged() {
        try {
            String msg = this.getPortaCOM().getInputString();
            if (msg.length() == 1) {
                this.getPortaCOM().clearInputString();
                if (msg.equalsIgnoreCase(String.valueOf('\u0001'))) {
                    this.tratarSOH();
                } else if (msg.equalsIgnoreCase(String.valueOf('\u0005'))) {
                    this.requisicaoAck = true;
                    this.tratarEnquiry();
                } else if (msg.equalsIgnoreCase(String.valueOf('\u0006')) && this.requisicaoAck) {
                    this.requisicaoAck = false;
                    this.encerrarEnvioRequisicao();
                } else if (msg.equalsIgnoreCase(String.valueOf('\u0006')) && this.ackFrameEnd) {
                    this.encerrarTransmissao();
                }
            } else {
                String message = this.getPortaCOM().removeInputString(this.getMsgEnd());
                if (!message.equals("")) {
                    this.addListaRecebimento(message);
                    this.restartThreadRecebimento();
                } else {
                    this.aguardarProximoFrame();
                }
            }
        }
        catch (Exception ex) {
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractABXInterfaceamento: evento de dados recebidos");
                }
            };
            SwingUtilities.invokeLater(run);
            this.fireMensagemEnviada("Erro ao receber dados do equipamento: " + ex.getMessage(), 1, 5000);
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private void encerrarEnvioRequisicao() throws IOException {
        StringBuilder msg = new StringBuilder();
        msg.append(String.valueOf('\u0002'));
        msg.append("END     ");
        msg.append(String.valueOf('\u0003'));
        this.getPortaCOM().write(msg.toString());
    }

    @Override
    public void recordFound(String record) throws Exception {
        this.getPortaCOM().write(String.valueOf('\u0006'));
        int index = record.indexOf(String.valueOf('\r'));
        String packetType = record.substring(index + 1, index + 3);
        StringTokenizer stks = new StringTokenizer(record, String.valueOf('\r'));
        HashMap<String, Object> lines = new HashMap<String, Object>();
        while (stks.hasMoreTokens()) {
            String token = stks.nextToken();
            String cmd = token.substring(0, 1);
            String value = "";
            if (token.length() > 2) {
                value = token.substring(2, token.length());
            }
            lines.put(cmd, value);
        }
        String dataPacket = (String)lines.get(String.valueOf('\u00ff'));
        if (dataPacket == null) {
            dataPacket = (String)lines.get(packetType);
        }
        if (dataPacket.equalsIgnoreCase("RESULT  ") || dataPacket.equalsIgnoreCase("RES-RR  ")) {
            String type = (String)lines.get(String.valueOf(this.anlysisType));
            if (type == null || type.trim().isEmpty()) {
                String string = type = lines.get("\u20ac") != null ? lines.get("\u20ac").toString() : null;
            }
            if (type == null || type.trim().isEmpty()) {
                type = lines.get("\ufffd") != null ? lines.get("\ufffd").toString() : null;
            }
            String record_type = "";
            if (type != null && !type.trim().isEmpty()) {
                record_type = InterfaceListener.getRecordTypeIdentifier(type);
            }
            if (Funcoes.textoVazio(record_type)) {
                record_type = "B";
            }
            this.parseRecord(record_type, lines);
        } else if (dataPacket.equalsIgnoreCase("FILE    ")) {
            String string = (String)lines.get(String.valueOf('u'));
        } else if (dataPacket.equalsIgnoreCase("END     ") && this.tx_list.size() > 0) {
            this.getPortaCOM().write(String.valueOf('\u0001'));
            this.recebeuENQ = false;
        }
    }

    private String getOrderRecord(String id, String nomePaciente, Date dataNascimento, String idade, String tipoIdade, String sexo, String tipoAnalise, String identificao, String medico, String departamento, String data, String hora) {
        StringBuilder record = new StringBuilder();
        record.append('p');
        record.append(' ');
        record.append("01");
        record.append('\r');
        record.append('u');
        record.append(' ');
        record.append(Funcoes.preencheVazio(id, 16, 2));
        record.append('\r');
        record.append('v');
        record.append(' ');
        record.append(Funcoes.preencheVazio(nomePaciente, 30, 2).substring(0, 30));
        record.append('\r');
        if (dataNascimento != null) {
            record.append('w');
            record.append(' ');
            record.append(Funcoes.formataData("yyyyMMdd", dataNascimento));
            record.append('\r');
        }
        if (Funcoes.isNumeric(idade) && !Funcoes.textoVazio(tipoIdade)) {
            tipoIdade = tipoIdade.equalsIgnoreCase("A") ? "y" : tipoIdade.toLowerCase();
            String idadePaciente = Funcoes.preencheVazio(String.format("%s%s", idade, tipoIdade), 3, 2);
            if (Integer.parseInt(idade) > 99) {
                idadePaciente = String.format("%s", idade);
            }
            record.append('x');
            record.append(' ');
            record.append(idadePaciente);
            record.append('\r');
        }
        record.append('y');
        record.append(' ');
        record.append(sexo.equals("M") ? "1" : (sexo.equals("F") ? "2" : "0"));
        record.append('\r');
        if (!Funcoes.textoVazio(medico)) {
            record.append('{');
            record.append(' ');
            record.append(Funcoes.preencheVazio(medico, 15, 2).substring(0, 15));
            record.append('\r');
        }
        if (!Funcoes.textoVazio(data) && !Funcoes.textoVazio(hora)) {
            record.append('}');
            record.append(' ');
            record.append(data.substring(data.length() - 2, data.length())).append("/");
            record.append(data.substring(3, 5)).append("/");
            record.append(data.substring(0, 2));
            record.append(' ');
            record.append(hora.replace(':', 'h'));
            record.append('\r');
        }
        return record.toString();
    }

    @Override
    protected void tratarEnquiry() throws Exception {
        if (this.requisicoes.size() > 0) {
            this.enviarProximaRequisicao();
        } else if (this.heartbit) {
            this.enviaEnd();
            this.heartbit = false;
        }
    }

    private void enviarProximaRequisicao() {
        if (this.requisicoes.size() > 0) {
            try {
                String emi_alternativo;
                String hora;
                String data;
                String pac_sexo;
                String pac_idade;
                String pac_nome;
                String int_codigo;
                String mco_codigo;
                String req = this.requisicoes.remove(0);
                String fil_codigo = req.substring(0, ParametrosGerais.getDigitosTuboFilial());
                String req_codigo = req.substring(ParametrosGerais.getDigitosTuboFilial());
                String rec_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                req_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
                Object[] linha = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 0);
                PanelAbaAbstrata aba = this.equipamento.getTab(0);
                String exames = "";
                if (linha != null) {
                    exames = (String)linha[aba.getColIndice("Exame")];
                } else {
                    linha = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                    aba = this.equipamento.getTab(1);
                    if (linha != null) {
                        exames = exames + " ";
                        List<Object[]> reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                        for (Object[] r : reqs) {
                            exames = exames + (String)r[aba.getColIndice("Exame")] + " ";
                        }
                        exames = exames.trim();
                    }
                }
                if (linha != null && exames.trim().length() > 0) {
                    mco_codigo = (String)linha[aba.getColIndice("C\u00f3d. Mat.")];
                    int_codigo = (String)linha[aba.getColIndice("Interface")];
                    pac_nome = (String)linha[aba.getColIndice("Paciente")];
                    pac_idade = (String)linha[aba.getColIndice("Ide")];
                    pac_sexo = (String)linha[aba.getColIndice("S")];
                    data = (String)linha[aba.getColIndice("Data")];
                    hora = (String)linha[aba.getColIndice("Hora")];
                    String exa_codigo = exames.trim().split(" ")[0];
                    emi_alternativo = BDUtil.getExmCodigoAlternativo(fil_codigo, exa_codigo, mco_codigo, int_codigo);
                    ExameMaterial exame = this.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo);
                    if (exame == null) {
                        this.fireExcecaoEncontrada("Nenhum exame foi encontrado para a requisi\u00e7\u00e3o: " + fil_codigo + " " + req_codigo + " " + rec_codigo + " " + emi_alternativo);
                        return;
                    }
                } else {
                    this.fireExcecaoEncontrada("N\u00e3o foi poss\u00edvel encontrar a interface para a requisi\u00e7\u00e3o: " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                    return;
                }
                this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, null, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, emi_alternativo, "N");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected void encerrar() {
        super.encerrar();
        if (this.porta != null) {
            this.porta.stop();
        }
    }
}

