/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.pentra60;

import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamento;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoFactory;
import jalis.laboratorio.interfaceamento.interfaces.pentra60.Pentra60;
import jalis.laboratorio.interfaceamento.padroes.abx.ABXStandard;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import javax.swing.JFrame;

public class InterfaceamentoFactory
implements AbstractInterfaceamentoFactory {
    @Override
    public AbstractInterfaceamento getInterfaceamento(JFrame parent) {
        return new Pentra60(parent);
    }

    @Override
    public String getNomeInterfaceamento() {
        return "Horiba Pentra 60";
    }

    @Override
    public String getEnvioRequisicao() {
        String fil_codigo = "01";
        String req_codigo = "23456789";
        String rec_codigo = "10";
        String pac_nome = "Paciente Thread Teste";
        String pac_idade = "25";
        String pac_sexo = "M";
        StringBuilder requisicao = new StringBuilder();
        int max_patient_name_chars = 30;
        String short_name = StringUtil.removerAcentos(pac_nome);
        if (short_name.length() > max_patient_name_chars) {
            short_name = short_name.substring(0, max_patient_name_chars);
        }
        fil_codigo = Funcoes.preencheZero(fil_codigo, ParametrosGerais.getDigitosTuboFilial());
        StringBuilder codigo = new StringBuilder(fil_codigo);
        req_codigo = Funcoes.preencheZero(req_codigo, ParametrosGerais.getDigitosTuboRequisicao());
        codigo.append(req_codigo);
        rec_codigo = Funcoes.preencheZero(rec_codigo, ParametrosGerais.getDigitosTuboTubo());
        codigo.append(rec_codigo);
        requisicao.append(ABXStandard.getDefaultHeaderRecord());
        requisicao.append(ABXStandard.getDefaultOrderRecord(codigo.toString(), short_name, "", pac_idade, pac_sexo, "<EXAME>", codigo.toString()));
        requisicao.append(ABXStandard.getDefaultFooterRecord());
        return requisicao.toString();
    }

    @Override
    public String getRetornoRequisicao() {
        return "";
    }

    @Override
    public String getSerialInfo() {
        StringBuilder info = new StringBuilder("-Jalis-\n");
        info.append("BaudRate: 9600\n");
        info.append("DataBits: 8\n");
        info.append("StopBits: 1\n");
        info.append("Paridade: Nenhuma\n");
        info.append("FlowControl: Software\n");
        info.append("Pentra 60 -\n");
        info.append("Cabo:\n");
        info.append("DB9 -> DB25\n");
        info.append("  5  -  7 \n");
        info.append("  3  -  2 \n");
        info.append("  2  -  3 \n");
        return info.toString();
    }

    @Override
    public int getTipoComunicacao() {
        return 0;
    }
}

