/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.pentra60;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.padroes.abx.InterfaceABXListener;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InterfaceListener
extends InterfaceABXListener {
    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao) {
        try {
            this.tx_list.clear();
            this.rx_list.clear();
            this.fil_codigo = fil_codigo;
            this.acao = acao;
            this.int_codigo = int_codigo;
            this.req_codigo = req_codigo;
            this.pac_nome = pac_nome;
            this.pac_sexo = pac_sexo;
            this.req_idade = pac_idade;
            this.req_data = data;
            this.req_hora = hora;
            this.mco_codigo = mco_codigo;
            this.rec_codigo = rec_codigo;
            this.pac_exames = pac_exames;
            this.exames = pac_exames.split(" ", 0);
            this.encerrarTransmissao();
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractABXInterfaceamento: envio de requisi\u00e7\u00e3o");
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractABXInterfaceamento: exce\u00e7\u00e3o em envio de requisi\u00e7\u00e3o");
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    @Override
    protected void parseRecord(String record_type, HashMap<String, Object> lines) throws Exception {
        if (record_type != null) {
            int qtde = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
            String req_codigo = null;
            if (lines.containsKey(String.valueOf('v'))) {
                req_codigo = ((String)lines.get(String.valueOf('v'))).trim();
            }
            if ((req_codigo == null || req_codigo.length() != qtde) && lines.containsKey(String.valueOf('u'))) {
                req_codigo = ((String)lines.get(String.valueOf('u'))).trim();
            }
            if (req_codigo == null || req_codigo.length() != qtde) {
                this.fireExcecaoEncontrada(req_codigo + " - N\u00e3o existe ou n\u00e3o esta interfaceada");
                return;
            }
            String tuboId = req_codigo;
            String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
            String rec_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
            req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
            DescritorCodigoEtiqueta etiqueta = DescritorCodigoEtiqueta.getDescritor(tuboId);
            if (etiqueta != null) {
                fil_codigo = Funcoes.preencheZero(etiqueta.getFilial(), ParametrosGerais.getDigitosTuboFilial());
                req_codigo = Funcoes.preencheZero(etiqueta.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao());
                rec_codigo = Funcoes.preencheZero(etiqueta.getTubo(), ParametrosGerais.getDigitosTuboTubo());
            }
            if (!(Funcoes.isNumeric(fil_codigo) && Funcoes.isNumeric(req_codigo) && Funcoes.isNumeric(rec_codigo))) {
                this.fireExcecaoEncontrada(String.format("C\u00f3digo da amostra fora do padr\u00e3o %s %s %s ", fil_codigo, req_codigo, rec_codigo));
                return;
            }
            String int_codigo = "";
            Map<String, Object> dados = null;
            if (record_type.equals("A")) {
                dados = this.trataResultCBC(lines);
                int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, "A");
            } else if (record_type.equals("B")) {
                dados = this.trataResultDIF(lines);
                int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, "B");
            } else if (record_type.equals("C")) {
                dados = this.trataResultRET(lines);
                int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, "C");
            } else if (record_type.equals("D")) {
                dados = this.trataResultLMG(lines);
                int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, "D");
            } else if (record_type.equals("E")) {
                dados = this.trataResultCBR(lines);
                int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, "E");
            } else if (record_type.equals("F")) {
                dados = this.trataResultDIR(lines);
                int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, "F");
            } else if (record_type.equals("G")) {
                dados = this.trataResultSPS(lines);
                int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, "G");
            }
            List<String> flags = this.getFlags(lines);
            if (!flags.isEmpty()) {
                StringBuilder strFlags = new StringBuilder();
                for (String str : flags) {
                    strFlags.append(str).append(" ");
                }
                dados.put("flag", strFlags.toString());
            }
            if (dados == null) {
                this.fireExcecaoEncontrada("Tipo do resultado recebido n\u00e3o existe ou n\u00e3o interfaceado");
                return;
            }
            if (Funcoes.textoVazio(int_codigo)) {
                this.fireExcecaoEncontrada(fil_codigo + " " + req_codigo + " " + rec_codigo + " - " + "Requisi\u00e7\u00e3o n\u00e3o encontrada ou n\u00e3o interfaceada!");
                return;
            }
            ExameMaterial exame = this.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, record_type);
            if (exame == null) {
                this.fireExcecaoEncontrada(fil_codigo + " " + req_codigo + " " + rec_codigo + " - " + ("Exame n\u00e3o existe ou n\u00e3o esta interfaceado (int: " + (int_codigo == null ? "-1" : int_codigo) + ", type: " + record_type + ")"));
                return;
            }
            Statement st = Conexao.getStatement();
            List<BDExame> exames = BDUtil.getReqExamesMultGuia(fil_codigo, int_codigo, req_codigo, rec_codigo);
            for (BDExame e : exames) {
                this.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, e.getExame(), e.getMaterial(), int_codigo, dados, flags);
            }
            this.fireAtualizarTabela(2);
            Conexao.arquivaSQL();
        }
    }
}

