/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.pentra120;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.padroes.abx.InterfaceABXListener;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.TempoUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;

public class InterfaceListener
extends InterfaceABXListener {
    private List<String> hostList = new ArrayList<String>();

    @Override
    public void dataChanged() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    if (InterfaceListener.this.getPortaCOM().getInputString().length() == 1) {
                        String msg = InterfaceListener.this.getPortaCOM().getInputString();
                        InterfaceListener.this.getPortaCOM().clearInputString();
                        if (msg.equalsIgnoreCase(String.valueOf('\u0001'))) {
                            InterfaceListener.this.tratarSOH();
                        } else if (msg.equalsIgnoreCase(String.valueOf('\u0005'))) {
                            InterfaceListener.this.tratarEnquiry();
                        }
                    } else {
                        String message = InterfaceListener.this.getPortaCOM().removeInputString(InterfaceListener.this.getMsgEnd());
                        if (!message.equals("")) {
                            InterfaceListener.this.addListaRecebimento(message);
                            InterfaceListener.this.restartThreadRecebimento();
                        } else {
                            InterfaceListener.this.aguardarProximoFrame();
                        }
                    }
                }
                catch (Exception ex) {
                    ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractABXInterfaceamento: evento de dados recebidos");
                    InterfaceListener.this.fireMensagemEnviada("Erro ao receber dados do equipamento: " + ex.getMessage(), 1, 5000);
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
            }
        };
        SwingUtilities.invokeLater(run);
    }

    @Override
    public void recordFound(String record) throws Exception {
        this.getPortaCOM().write(String.valueOf('\u0006'));
        StringTokenizer stks = new StringTokenizer(record, String.valueOf('\r'));
        HashMap<String, Object> lines = new HashMap<String, Object>();
        while (stks.hasMoreTokens()) {
            String token = stks.nextToken();
            String cmd = token.substring(0, 1);
            String value = "";
            if (token.length() > 2) {
                value = token.substring(2, token.length());
            }
            lines.put(cmd, value);
        }
        String dataPacket = (String)lines.get(String.valueOf('\u00ff'));
        if (dataPacket.equalsIgnoreCase("RESULT  ")) {
            String type = (String)lines.get(String.valueOf(this.anlysisType));
            if (type == null || type.trim().isEmpty()) {
                String string = type = lines.get("\u20ac") != null ? lines.get("\u20ac").toString() : null;
            }
            if (type == null || type.trim().isEmpty()) {
                this.fireExcecaoEncontrada("ANLYSIS_TYPE (" + this.anlysisType + ") n\u00e3o encontrado");
            } else {
                String record_type = InterfaceListener.getRecordTypeIdentifier(type);
                this.parseRecord(record_type, lines);
            }
        } else if (dataPacket.equalsIgnoreCase("FILE    ")) {
            String req = (String)lines.get(String.valueOf('u'));
            this.hostList.add(req.trim());
        } else if (dataPacket.equalsIgnoreCase("END     ") && this.hostList.size() > 0) {
            this.getPortaCOM().write(String.valueOf('\u0001'));
        }
    }

    private void enviarProximaRequisicao() {
        if (this.hostList.size() > 0) {
            try {
                String emi_alternativo;
                String hora;
                String data;
                String pac_sexo;
                String pac_idade;
                String pac_nome;
                String int_codigo;
                String mco_codigo;
                String req = this.hostList.remove(0);
                String fil_codigo = req.substring(0, ParametrosGerais.getDigitosTuboFilial());
                String req_codigo = req.substring(ParametrosGerais.getDigitosTuboFilial());
                String rec_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                req_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
                Object[] linha = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 0);
                PanelAbaAbstrata aba = this.equipamento.getTab(0);
                String exames = "";
                if (linha != null) {
                    exames = (String)linha[aba.getColIndice("Exame")];
                } else {
                    linha = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                    aba = this.equipamento.getTab(1);
                    if (linha != null) {
                        exames = exames + " ";
                        List<Object[]> reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                        for (Object[] r : reqs) {
                            exames = exames + (String)r[aba.getColIndice("Exame")] + " ";
                        }
                        exames = exames.trim();
                    }
                }
                if (linha != null && exames.trim().length() > 0) {
                    mco_codigo = (String)linha[aba.getColIndice("C\u00f3d. Mat.")];
                    int_codigo = (String)linha[aba.getColIndice("Interface")];
                    pac_nome = (String)linha[aba.getColIndice("Paciente")];
                    pac_idade = (String)linha[aba.getColIndice("Ide")];
                    pac_sexo = (String)linha[aba.getColIndice("S")];
                    data = TempoUtil.getCurrentDateBr();
                    hora = TempoUtil.getCurrentTime();
                    String exa_codigo = exames.split(" ")[0];
                    emi_alternativo = BDUtil.getExmCodigoAlternativo(fil_codigo, exa_codigo, mco_codigo, int_codigo);
                    ExameMaterial exame = this.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo);
                    if (exame == null) {
                        this.fireExcecaoEncontrada("Nenhum exame foi encontrado para a requisi\u00e7\u00e3o: " + fil_codigo + " " + req_codigo + " " + rec_codigo + " " + emi_alternativo);
                        return;
                    }
                } else {
                    this.fireExcecaoEncontrada("N\u00e3o foi poss\u00edvel encontrar a interface para a requisi\u00e7\u00e3o: " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                    return;
                }
                this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, null, null, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, emi_alternativo, "N");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected void tratarEnquiry() throws Exception {
        if (this.hostList.size() > 0) {
            this.enviarProximaRequisicao();
        }
    }
}

