/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.optmize;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.abas.RefreshTimer;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.EventObject;
import java.util.HashMap;
import javax.swing.SwingUtilities;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    private String NOME_EXAME = "HEMOG";
    public static final int EQUIP_TIMEOUT = 5000;
    String int_codigo = "";
    String fil_codigo;
    String req_codigo;
    String mco_codigo;
    String rec_codigo;
    String pac_nome;
    String pac_exames;
    String pac_sexo;
    String req_idade;
    String req_data;
    String req_hora;
    String acao;
    String frame;

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        this.fil_codigo = fil_codigo;
        this.req_codigo = req_codigo;
        this.pac_nome = pac_nome;
        this.pac_sexo = pac_sexo;
        this.req_idade = pac_idade;
        this.req_data = data;
        this.req_hora = hora;
        this.mco_codigo = mco_codigo;
        this.rec_codigo = rec_codigo;
        this.pac_exames = exames;
        this.int_codigo = int_codigo;
        this.acao = acao;
        try {
            this.encerrarTransmissao();
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    @Override
    public String getMsgEnd() {
        return String.valueOf('\u0003');
    }

    @Override
    public String getMsgStart() {
        return String.valueOf('\u0002');
    }

    @Override
    public synchronized String parse(String message) {
        String retorno = null;
        Object checksum = null;
        if (!message.startsWith(this.getMsgStart()) || !message.endsWith(this.getMsgEnd())) {
            return "Erro ao receber o bloco de resultados, caracter inicial ou final n\u00e3o localizado";
        }
        if (message.startsWith(this.getMsgStart())) {
            message = message.replaceFirst(this.getMsgStart(), "");
        }
        if (message.endsWith(this.getMsgEnd())) {
            message = message.replaceFirst(this.getMsgEnd(), "");
        }
        if (!this.validaCheckSum(message)) {
            return "Erro ao receber o bloco de resultados, checksum inv\u00e1lido";
        }
        String[] fields = message.split(";");
        if (fields != null && fields.length > 0) {
            try {
                retorno = this.parseResults(fields);
                if (retorno == null) {
                    return "";
                }
                if (retorno.startsWith("Erro")) {
                    return retorno;
                }
                Conexao.arquivaSQL();
                RefreshTimer.waitAndRefresh(this, 2000);
                return retorno;
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, "Erro ao inserir resultados recebidos ao banco de dados.\n" + ex.getMessage(), ex.getStackTrace());
                try {
                    Conexao.anulaSQL();
                    return "Erro ao inserir resultados recebidos ao banco de dados";
                }
                catch (SQLException e) {
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                    return "Erro ao anular os dados recebidos";
                }
            }
        }
        return "Erro ao realizar parse dos dados recebidos";
    }

    @Override
    public void dataChanged() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    String retorno;
                    String message = InterfaceListener.this.getPortaCOM().removeInputString(InterfaceListener.this.getMsgEnd());
                    if (!message.equals("") && (retorno = InterfaceListener.this.parse(message)) != null && !retorno.equals("")) {
                        if (retorno.startsWith("Erro")) {
                            InterfaceListener.this.fireExcecaoEncontrada(retorno);
                        }
                        InterfaceListener.this.fireMensagemEnviada(retorno, 0, 10000);
                    }
                }
                catch (Exception ex) {
                    ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
                    InterfaceListener.this.fireMensagemEnviada("Erro ao receber dados do equipamento.", 1, 5000);
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
            }
        };
        SwingUtilities.invokeLater(run);
    }

    public void encerrarTransmissao() throws Exception {
        Statement st = Conexao.getStatement();
        this.atualizarSituacaoTubo(st, this.fil_codigo, this.req_codigo, this.rec_codigo, this.mco_codigo, this.int_codigo, this.acao.equals("N") ? 1 : 3);
        Conexao.arquivaSQL();
        this.fireMensagemEnviada("Pedido(s) enviado(s) com sucesso para " + this.pac_nome, 0, 10000);
        if (this.acao.equals("N")) {
            this.firePacienteEnviado(this.req_codigo, this.pac_nome, this.pac_sexo, this.req_idade, this.req_data, this.req_hora, this.pac_exames);
        }
        this.interromperTimer();
        this.limpaDadosRequisicao();
        this.fireAtualizarTabela(0);
        this.setIdle();
    }

    void limpaDadosRequisicao() {
        this.frame = null;
        this.req_codigo = null;
        this.mco_codigo = null;
        this.rec_codigo = null;
        this.pac_nome = null;
        this.pac_sexo = null;
        this.req_idade = null;
        this.req_data = null;
        this.req_hora = null;
    }

    private String parseResults(String[] fields) throws SQLException {
        String req_codigo = fields[0];
        if (Funcoes.textoVazio(req_codigo) || !Funcoes.isNumeric(req_codigo)) {
            this.fireExcecaoEncontrada("C\u00f3digo da requisi\u00e7\u00e3o n\u00e3o localizado nos dados recebidos");
            return null;
        }
        try {
            Long.parseLong(req_codigo);
        }
        catch (Exception ex) {
            this.fireExcecaoEncontrada("Resultados recebidos para requisi\u00e7\u00e3o inv\u00e1lida ou n\u00e3o interfaceada: " + req_codigo);
            return null;
        }
        Statement st = Conexao.getStatement();
        if (req_codigo.length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
            this.fireExcecaoEncontrada("Resultados recebidos para requisi\u00e7\u00e3o inv\u00e1lida ou n\u00e3o interfaceada: " + req_codigo);
            return null;
        }
        try {
            String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
            String rec_codigo = req_codigo.substring(req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
            req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial(), req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
            String int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, this.NOME_EXAME);
            String mco_codigo = BDUtil.getExmCodigoMaterial(fil_codigo, int_codigo, req_codigo, rec_codigo);
            if (int_codigo == null) {
                int situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, this.NOME_EXAME, mco_codigo, rec_codigo);
                StringBuilder s = new StringBuilder();
                s.append("N\u00e3o foi poss\u00edvel encontrar o exame! O exame encontra-se ");
                if (situacao == 8) {
                    s.append("exportado!");
                } else {
                    s.append("sem situa\u00e7\u00e3o!");
                }
                s.append("(").append(req_codigo).append(")");
                this.fireExcecaoEncontrada(s.toString());
                return null;
            }
            BDExame[] exames = BDUtil.getReqExames(fil_codigo, int_codigo, req_codigo, rec_codigo);
            HashMap<String, Object> hemograma = new HashMap<String, Object>();
            hemograma.put("leucocitos", fields[3]);
            hemograma.put("linfocitos_tipicos_percentual", fields[5]);
            hemograma.put("linfocitos_tipicos_contagem", fields[7]);
            hemograma.put("monocitos_percentual", fields[9]);
            hemograma.put("monocitos_contagem", fields[11]);
            hemograma.put("neutrofilo_contagem", fields[13]);
            hemograma.put("neutrofilo_percentual", fields[15]);
            hemograma.put("eosinofilos_contagem", fields[17]);
            hemograma.put("bastonados_contagem", fields[18]);
            hemograma.put("hemacias", fields[19]);
            hemograma.put("rdw", fields[21]);
            hemograma.put("rdw_sd", fields[23]);
            hemograma.put("plaquetas", fields[25]);
            hemograma.put("vpm", fields[27]);
            hemograma.put("pct", fields[29]);
            hemograma.put("pdw", fields[31]);
            hemograma.put("hgb", fields[33]);
            hemograma.put("hct", fields[35]);
            hemograma.put("vcm", fields[37]);
            hemograma.put("hcm", fields[39]);
            hemograma.put("chcm", fields[41]);
            ExameMaterial exame = this.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, this.NOME_EXAME);
            if (exame == null) {
                this.fireExcecaoEncontrada(req_codigo + " - " + "N\u00e3o foi encontrada");
            } else {
                this.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo, hemograma);
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
        }
        return "";
    }

    private boolean validaCheckSum(String message) {
        return true;
    }

    @Override
    public void handShakeCharReceived(char c) {
    }

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
    }
}

