/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.opera.mensagens.recebimento;

import jalis.laboratorio.interfaceamento.AbstractInterfaceamento;
import jalis.laboratorio.interfaceamento.interfaces.opera.mensagens.ChemistryResult;
import jalis.laboratorio.interfaceamento.interfaces.opera.mensagens.TubePosition;
import jalis.util.Funcoes;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ResultMensagem {
    private String tubeId;
    private TubePosition tubePosition;
    private Date aspirationDate;
    private Map<Integer, ChemistryResult> chemistryNumberResults;

    public ResultMensagem(String data) {
        int i = 0;
        this.tubeId = data.substring(++i, i += 12).trim();
        this.tubePosition = new TubePosition(Integer.parseInt(data.substring(++i, i += 3).trim()), Integer.parseInt(data.substring(++i, i += 2).trim()));
        this.aspirationDate = Funcoes.getData("MM/dd/yy HH:mm:ss", data.substring(i += 11, i += 17).trim());
        this.chemistryNumberResults = new HashMap<Integer, ChemistryResult>();
        int iResultEnd = data.indexOf(AbstractInterfaceamento.LINE, i += 12);
        while (i < iResultEnd) {
            int chemistryNumber = Integer.parseInt(data.substring(i, i += 3));
            String result = data.substring(i, i += 5);
            String flag = data.substring(i++, i);
            this.chemistryNumberResults.put(chemistryNumber, new ChemistryResult(result, flag));
        }
    }

    public String getTubeId() {
        return this.tubeId;
    }

    public TubePosition getTubePosition() {
        return this.tubePosition;
    }

    public Date getAspirationDate() {
        return this.aspirationDate;
    }

    public ChemistryResult getChemistryResult(int chemistryNumber) {
        return this.chemistryNumberResults.get(chemistryNumber);
    }

    public Set<Integer> getChemistryNumbers() {
        return this.chemistryNumberResults.keySet();
    }

    public String toString() {
        String string = this.getClass().getSimpleName() + "[tubeId: " + this.tubeId + "; chemistryNumberResults: " + this.chemistryNumberResults + "]";
        return string;
    }
}

