/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.opera.mensagens.envio;

import jalis.laboratorio.interfaceamento.AbstractInterfaceamento;
import jalis.laboratorio.interfaceamento.interfaces.opera.mensagens.BaseEnvio;
import jalis.laboratorio.interfaceamento.interfaces.opera.mensagens.IMensagemEnvio;
import jalis.laboratorio.interfaceamento.interfaces.opera.mensagens.Tipos;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class WorkOrderMensagem
implements IMensagemEnvio {
    private BaseEnvio base;
    private Tipos tipo = Tipos.WORK_ORDER;
    private char mt;
    private String tubeId;
    private List<Integer> chemistryNumbers;
    private UpdateIndicators updateIndicator;
    private String pacienteId;
    private String pacienteNome;
    private Date pacienteNascimento;
    private Sexos pacienteSexo;
    private Date coleta;

    public WorkOrderMensagem(String tubeId) {
        this.base = new BaseEnvio(this.tipo);
        this.updateIndicator = UpdateIndicators.NO_UPDATE;
        this.pacienteSexo = Sexos.DESCONHECIDO;
        this.tubeId = tubeId;
        this.chemistryNumbers = new ArrayList<Integer>();
    }

    public void addChemistryNumber(int chemistryNumber) {
        this.chemistryNumbers.add(chemistryNumber);
    }

    public void setUpdateIndicator(UpdateIndicators updateIndicator) {
        this.updateIndicator = updateIndicator;
    }

    public void setPacienteId(String pacienteId) {
        this.pacienteId = pacienteId;
    }

    public void setPacienteNome(String pacienteNome) {
        this.pacienteNome = pacienteNome;
    }

    public void setPacienteNascimento(Date pacienteNascimento) {
        this.pacienteNascimento = pacienteNascimento;
    }

    public void setPacienteSexo(Sexos pacienteSexo) {
        this.pacienteSexo = pacienteSexo;
    }

    public void setColeta(Date coleta) {
        this.coleta = coleta;
    }

    public List<Integer> getChemistryNumbers() {
        return Collections.unmodifiableList(this.chemistryNumbers);
    }

    public String getTubeId() {
        return this.tubeId;
    }

    @Override
    public String getTextoMensagem(char mt) {
        this.mt = mt;
        this.base.addDataEspaco(2);
        this.base.addDataItem(1, "");
        this.base.addDataItem(1, this.updateIndicator.valor);
        this.base.addDataEspaco(1);
        this.base.addDataItem(12, this.tubeId);
        this.base.addDataEspaco(25);
        this.base.addDataItem(14, this.pacienteId);
        this.base.addDataEspaco(3);
        this.base.addDataItem(30, this.pacienteNome);
        this.base.addDataEspaco(1);
        this.base.addDataItem(10, this.pacienteNascimento == null ? "" : Funcoes.formataData("MM/dd/yyyy", this.pacienteNascimento));
        this.base.addDataEspaco(1);
        this.base.addDataItem(1, this.pacienteSexo.valor);
        this.base.addDataEspaco(1);
        this.base.addDataItem(8, this.coleta == null ? "" : Funcoes.formataData("MM/dd/yy", this.coleta));
        this.base.addDataEspaco(1);
        this.base.addDataItem(4, this.coleta == null ? "" : Funcoes.formataData("HHmm", this.coleta));
        this.base.addDataEspaco(1);
        this.base.addDataItem(6, "");
        this.base.addDataEspaco(1);
        this.base.addDataItem(6, "");
        this.base.addDataEspaco(1);
        this.base.addDataItem(2, AbstractInterfaceamento.LINE);
        for (int chemistryNumber : this.chemistryNumbers) {
            this.base.addDataItem(3, StringUtil.preencheString(String.valueOf(chemistryNumber), 3, '0', 1));
        }
        this.base.addDataItem(2, AbstractInterfaceamento.LINE);
        return this.base.getTextoMensagem(mt);
    }

    @Override
    public char getMt() {
        return this.mt;
    }

    @Override
    public Tipos getTipo() {
        return this.tipo;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[tubeId: " + this.tubeId + "; chemistryNumbers: " + StringUtil.implode(this.chemistryNumbers, ", ") + "]";
    }

    public static enum Sexos {
        MASCULINO("M"),
        FEMININO("F"),
        DESCONHECIDO(" ");

        public String valor;

        private Sexos(String valor) {
            this.valor = valor;
        }
    }

    public static enum UpdateIndicators {
        NO_UPDATE(" "),
        UPDATE("A");

        public String valor;

        private UpdateIndicators(String valor) {
            this.valor = valor;
        }
    }
}

