/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.opera;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.InfoExameRequisicao;
import jalis.laboratorio.interfaceamento.interfaces.opera.mensagens.BaseRecebimento;
import jalis.laboratorio.interfaceamento.interfaces.opera.mensagens.ChemistryResult;
import jalis.laboratorio.interfaceamento.interfaces.opera.mensagens.IMensagemEnvio;
import jalis.laboratorio.interfaceamento.interfaces.opera.mensagens.Tipos;
import jalis.laboratorio.interfaceamento.interfaces.opera.mensagens.envio.InitializationMensagem;
import jalis.laboratorio.interfaceamento.interfaces.opera.mensagens.envio.ResultValidation;
import jalis.laboratorio.interfaceamento.interfaces.opera.mensagens.envio.TokenTransferMensagem;
import jalis.laboratorio.interfaceamento.interfaces.opera.mensagens.envio.WorkOrderMensagem;
import jalis.laboratorio.interfaceamento.interfaces.opera.mensagens.recebimento.ResultMensagem;
import jalis.laboratorio.interfaceamento.interfaces.opera.mensagens.recebimento.WorkOrderValidationMensagem;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    private final int MAX_TENTATIVAS_ENVIO = 2;
    private final int INTERVALO_TENTATIVA_INICIALIZACAO = 2;
    private final int MAX_QT_ENVIO = 10;
    private final int MAX_QT_RECEBIMENTO = 10;
    private char mt;
    private boolean aguardandoMt;
    private boolean master = true;
    private IMensagemEnvio ultimaMensagemEnviada;
    private int tentativasEnvio = 0;
    private javax.swing.Timer timerInicializacao;
    private Timer agendadorDeTarefas;
    private LinkedHashMap<String, WorkOrderMensagem> filaWorkOrdersPorTuboId;
    private Map<String, InfoExameRequisicao> exameRequisicaoPorTuboId = new HashMap<String, InfoExameRequisicao>();
    private List<String> tubosIdComErro;
    private int qtEnviados;
    private int qtRecebidos;

    public InterfaceListener() {
        this.filaWorkOrdersPorTuboId = new LinkedHashMap();
        this.agendadorDeTarefas = new Timer();
        this.tubosIdComErro = new ArrayList<String>();
        this.timerInicializacao = new javax.swing.Timer(2000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InterfaceListener.this.inicia();
            }
        });
        this.timerInicializacao.setInitialDelay(0);
        this.timerInicializacao.start();
    }

    @Override
    public String enviarRequisicao(String pacNome, String pacSexo, String pacIdade, String data, String hora, String rackposition, String prioridade, String filCodigo, String intCodigo, String reqCodigo, String mcoCodigo, String recCodigo, String exames, String acao) {
        block18: {
            filCodigo = Funcoes.preencheZero(filCodigo, ParametrosGerais.getDigitosTuboFilial());
            reqCodigo = Funcoes.preencheZero(reqCodigo, ParametrosGerais.getDigitosTuboRequisicao());
            recCodigo = Funcoes.preencheZero(recCodigo, ParametrosGerais.getDigitosTuboTubo());
            String tuboId = filCodigo + reqCodigo + recCodigo;
            try {
                if (tuboId.length() > 12) {
                    throw new Exception("tuboId n\u00e3o pode ter mais de 12 d\u00edgitos");
                }
                if (acao.equalsIgnoreCase("N") || acao.equalsIgnoreCase("A")) {
                    if (this.tubosIdComErro.contains(tuboId)) {
                        return "Erro: requisi\u00e7\u00e3o cont\u00e9m exames com c\u00f3digos alternativos inv\u00e1lidos";
                    }
                    if (this.filaWorkOrdersPorTuboId.containsKey(tuboId)) break block18;
                    Statement st = Conexao.getStatement();
                    String sql = "select b.pac_codigo, b.pac_datanasc from requisicao a left join paciente b on b.pac_codigo = a.pac_codigo and b.fil_codigo = a.fil_codigo where a.fil_codigo = " + filCodigo + " and req_codigo = " + reqCodigo;
                    ResultSet rs = st.executeQuery(sql);
                    rs.next();
                    String pacCodigo = rs.getString("pac_codigo");
                    Date pacNascimento = rs.getDate("pac_datanasc");
                    ArrayList<ExameMaterial> examesMateriais = new ArrayList<ExameMaterial>();
                    for (String exame : exames.split(" ", 0)) {
                        examesMateriais.add(new ExameMaterial(exame, new Integer(mcoCodigo)));
                    }
                    HashSet<ExameMaterial> examesNaoEnviados = new HashSet<ExameMaterial>();
                    HashSet<Integer> chemistryNumbers = new HashSet<Integer>();
                    ExameMaterial primeiroExame = null;
                    for (ExameMaterial exame : examesMateriais) {
                        if (primeiroExame == null) {
                            primeiroExame = exame;
                        }
                        ExameMaterial[] exameMaterialFilhos = BDUtil.isExameDesmembrado(filCodigo, intCodigo, exame.getString(), mcoCodigo) ? BDUtil.getExamesFilhos(filCodigo, intCodigo, exame.getString(), mcoCodigo) : new ExameMaterial[]{exame};
                        for (ExameMaterial exameFilho : exameMaterialFilhos) {
                            int chemistryNumber = 0;
                            try {
                                chemistryNumber = Integer.parseInt(BDUtil.getExmCodigoAlternativo(filCodigo, exameFilho.getNomeExame(), mcoCodigo, intCodigo));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (chemistryNumber <= 0) {
                                examesNaoEnviados.add(exameFilho);
                                String msg = String.valueOf(reqCodigo) + " - Exame " + exameFilho.getNomeExame() + " requisitado, mas seu c\u00f3digo alternativo est\u00e1 incorreto ou n\u00e3o configurado";
                                this.fireExcecaoEncontrada(msg);
                                return "Erro: exame com c\u00f3digo alternativo incorreto ou n\u00e3o configurado";
                            }
                            chemistryNumbers.add(chemistryNumber);
                        }
                    }
                    if (Funcoes.textoVazio(((Object)examesNaoEnviados).toString())) {
                        this.equipamento.addLinhaErro(tuboId, ((Object)examesNaoEnviados).toString().trim());
                    }
                    WorkOrderMensagem workOrder = new WorkOrderMensagem(tuboId);
                    workOrder.setUpdateIndicator(acao.equalsIgnoreCase("A") ? WorkOrderMensagem.UpdateIndicators.UPDATE : WorkOrderMensagem.UpdateIndicators.NO_UPDATE);
                    workOrder.setPacienteNome(StringUtil.removerAcentos(pacNome));
                    workOrder.setPacienteId(pacCodigo);
                    workOrder.setPacienteNascimento(pacNascimento);
                    workOrder.setColeta(BDUtil.getExmColeta(filCodigo, reqCodigo, primeiroExame.getNomeExame(), primeiroExame.getCodigoMaterial()));
                    if (pacSexo != null) {
                        if (pacSexo.equalsIgnoreCase("M")) {
                            workOrder.setPacienteSexo(WorkOrderMensagem.Sexos.MASCULINO);
                        } else if (pacSexo.equalsIgnoreCase("F")) {
                            workOrder.setPacienteSexo(WorkOrderMensagem.Sexos.FEMININO);
                        }
                    }
                    Iterator iterator = chemistryNumbers.iterator();
                    while (iterator.hasNext()) {
                        int chemistryNumber = (Integer)iterator.next();
                        workOrder.addChemistryNumber(chemistryNumber);
                    }
                    this.filaWorkOrdersPorTuboId.put(tuboId, workOrder);
                    this.exameRequisicaoPorTuboId.put(tuboId, new InfoExameRequisicao(filCodigo, reqCodigo, mcoCodigo, recCodigo, pacNome, pacIdade, pacSexo, data, hora, exames));
                    return pacNome + " colocado na fila de envio para o equipamento";
                }
                return "A\u00e7\u00e3o n\u00e3o suportada pelo equipamento";
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
            }
        }
        return null;
    }

    private void alteraSituacao(InfoExameRequisicao exameRequisicao) {
        try {
            Statement st = Conexao.getStatement();
            for (String exame : exameRequisicao.getExames().split(" ")) {
                String rec_codigo;
                String int_codigo;
                String fil_codigo = exameRequisicao.getFilial();
                String req_codigo = exameRequisicao.getCodigo();
                String mco_codigo = exameRequisicao.getMaterial();
                int atual = this.getExameSituacao(st, fil_codigo, int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo = exameRequisicao.getRecipiente(), exame, mco_codigo), req_codigo, exame, mco_codigo, rec_codigo);
                this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exame, mco_codigo, int_codigo, null, atual < 2 ? 1 : 3);
                this.firePacienteEnviado(exameRequisicao.getCodigo(), exameRequisicao.getNome(), exameRequisicao.getSexo(), exameRequisicao.getIdade(), exameRequisicao.getData(), exameRequisicao.getHora(), exameRequisicao.getExames());
            }
            Conexao.arquivaSQL();
            this.fireAtualizarTabela(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
    }

    @Override
    public String getMsgEnd() {
        return String.valueOf('\u0003');
    }

    @Override
    public String getMsgStart() {
        return String.valueOf('\u0002');
    }

    @Override
    public void handShakeCharReceived(char c) {
        if (c == '\u0015') {
            this.mtRecebido(c);
        }
    }

    @Override
    public String parse(String message) {
        return null;
    }

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
        this.reinicia();
    }

    @Override
    public void dataChanged() {
        String mensagemString = this.getPortaCOM().getInputString();
        if (mensagemString != null && !mensagemString.isEmpty()) {
            if (this.aguardandoMt) {
                this.mtRecebido(mensagemString.charAt(0));
                this.getPortaCOM().clearInputString();
            } else if (mensagemString.startsWith(this.getMsgStart()) && mensagemString.endsWith(this.getMsgEnd())) {
                BaseRecebimento mensagem = new BaseRecebimento(mensagemString);
                this.getPortaCOM().clearInputString();
                try {
                    if (mensagem.getMt() == this.mt) {
                        if (mensagem.isLrcValido()) {
                            this.nextMt();
                            this.getPortaCOM().write(String.valueOf(mensagem.getMt()));
                            this.mensagemRecebida(mensagem);
                        } else {
                            this.getPortaCOM().write(String.valueOf('\u0015'));
                            this.fireExcecaoEncontrada("LRC inv\u00e1lido (" + mensagem + ")");
                        }
                    } else {
                        this.fireExcecaoEncontrada("Mensagem com MT fora de sequ\u00eancia (" + mensagem + ")");
                        this.reinicia();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void mtRecebido(char mt) {
        if (this.ultimaMensagemEnviada != null) {
            if (mt == this.ultimaMensagemEnviada.getMt()) {
                this.nextMt();
                this.aguardandoMt = false;
                this.tentativasEnvio = 0;
                this.mensagemEnviadaConfirmada(this.ultimaMensagemEnviada);
            } else if (mt == '\u0015') {
                if (this.tentativasEnvio <= 2) {
                    this.enviaMensagem(this.ultimaMensagemEnviada);
                } else {
                    String msg = "Esgotado o n\u00famero m\u00e1ximo de tentativas de envio (" + this.ultimaMensagemEnviada + ")";
                    this.fireExcecaoEncontrada(msg);
                    this.reinicia();
                }
            } else {
                String msg = "Confirma\u00e7\u00e3o de MT enviado pelo aparelho \u00e9 diferente do MT da \u00faltima mensagem enviada (" + this.ultimaMensagemEnviada + ")";
                this.fireExcecaoEncontrada(msg);
                this.reinicia();
            }
        }
    }

    private void mensagemRecebida(BaseRecebimento baseMensagem) {
        switch (baseMensagem.getTipo()) {
            case RESULT: {
                this.resultMensagemRecebida(new ResultMensagem(baseMensagem.getData()));
                break;
            }
            case WORK_ORDER_VALIDATION: {
                this.workOrderValidationMensagemRecebida(new WorkOrderValidationMensagem(baseMensagem.getData()));
                break;
            }
            case TOKEN_TRANSFER: {
                this.tokenTranferMensagemRecebida();
                break;
            }
            default: {
                this.fireExcecaoEncontrada("Mensagem de tipo desconhecido recebida");
            }
        }
    }

    private void mensagemEnviadaConfirmada(IMensagemEnvio mensagem) {
        switch (mensagem.getTipo()) {
            case INITIALIZATION: {
                this.initializationMensagemConfirmada();
                break;
            }
            case RESULT_VALIDATION: {
                this.resultValidationMensagemConfirmada((ResultValidation)mensagem);
                break;
            }
            case TOKEN_TRANSFER: {
                this.tokenTranferMensagemConfirmada();
                break;
            }
            case WORK_ORDER: {
                this.workOrderMensagemConfirmada();
            }
        }
    }

    private void enviaMensagem(IMensagemEnvio mensagem) {
        try {
            this.ultimaMensagemEnviada = mensagem;
            this.aguardandoMt = true;
            ++this.tentativasEnvio;
            this.getPortaCOM().write(mensagem.getTextoMensagem(this.mt));
            this.getPortaCOM().flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void inicia() {
        this.mt = (char)48;
        this.enviaMensagem(new InitializationMensagem());
        this.fireMensagemEnviada("Pedido de inicializa\u00e7\u00e3o enviado", 0, 10000);
    }

    private void reinicia() {
        this.aguardandoMt = false;
        this.ultimaMensagemEnviada = null;
        this.tentativasEnvio = 0;
        this.master = true;
        this.zeraQtEnviadosRecebidos();
        this.getPortaCOM().clearInputString();
        this.timerInicializacao.start();
    }

    private char nextMt() {
        this.mt = (char)(this.mt + '\u0001');
        if (this.mt > 'Z') {
            this.mt = (char)48;
        }
        return this.mt;
    }

    private void enviaProximaWorkOrder() {
        if (this.master && !this.filaWorkOrdersPorTuboId.isEmpty()) {
            ++this.qtEnviados;
            this.enviaMensagem(this.filaWorkOrdersPorTuboId.values().iterator().next());
        } else {
            this.enviaMensagem(new TokenTransferMensagem());
        }
    }

    private void zeraQtEnviadosRecebidos() {
        this.qtEnviados = 0;
        this.qtRecebidos = 0;
    }

    private void initializationMensagemConfirmada() {
        this.timerInicializacao.stop();
        this.fireMensagemEnviada("Comunica\u00e7\u00e3o iniciada", 0, 10000);
        this.enviaProximaWorkOrder();
    }

    private void resultValidationMensagemConfirmada(ResultValidation resultValidation) {
        switch (resultValidation.getFlag()) {
            case NOT_ACCEPT_AND_HOST_IS_MASTER: {
                this.master = true;
                this.enviaProximaWorkOrder();
                break;
            }
            case VALID_AND_HOST_IS_MASTER: {
                this.master = true;
                this.enviaProximaWorkOrder();
                break;
            }
        }
    }

    private void tokenTranferMensagemConfirmada() {
        this.master = false;
        this.zeraQtEnviadosRecebidos();
    }

    private void workOrderMensagemConfirmada() {
    }

    private void resultMensagemRecebida(ResultMensagem mensagem) {
        ResultValidation.Flags flagResultado = ResultValidation.Flags.VALID_AND_SEND_NEXT;
        ++this.qtRecebidos;
        if (this.qtRecebidos >= 10 && !this.filaWorkOrdersPorTuboId.isEmpty()) {
            this.zeraQtEnviadosRecebidos();
            flagResultado = ResultValidation.Flags.VALID_AND_HOST_IS_MASTER;
        }
        try {
            Statement st = Conexao.getStatement();
            String tuboId = mensagem.getTubeId();
            String filCodigo = tuboId.substring(0, ParametrosGerais.getDigitosTuboFilial());
            String reqCodigo = tuboId.substring(ParametrosGerais.getDigitosTuboFilial());
            String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
            reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
            for (int chemistryNumber : mensagem.getChemistryNumbers()) {
                ChemistryResult result = mensagem.getChemistryResult(chemistryNumber);
                String emiAlternativo = String.valueOf(chemistryNumber);
                String int_codigo = this.getIntCodigo(filCodigo, reqCodigo, recCodigo, emiAlternativo);
                ExameMaterial exame = this.getReqExameLIS(filCodigo, int_codigo, reqCodigo, recCodigo, emiAlternativo);
                if (exame == null) {
                    this.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emiAlternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + filCodigo + " " + reqCodigo + " " + recCodigo);
                    continue;
                }
                if (result == null || result.getResult() == null || result.getResult().isEmpty()) continue;
                HashMap<String, Object> dados = new HashMap<String, Object>();
                int sit = this.getExameSituacao(st, filCodigo, int_codigo, reqCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), recCodigo);
                String campo = sit < 3 ? "resultado_quantitativo" : "repeticao_quantitativo";
                dados.put(campo, result.getResult().replace('.', ','));
                dados.put("flag_alerta", result.getFlag());
                this.atualizarDadosExame(st, filCodigo, reqCodigo, recCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo, dados);
            }
            Conexao.arquivaSQL();
            this.fireAtualizarTabela();
        }
        catch (Exception e) {
            try {
                Conexao.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            flagResultado = ResultValidation.Flags.NOT_ACCEPT_AND_HOST_IS_MASTER;
            this.zeraQtEnviadosRecebidos();
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            e.printStackTrace();
        }
        this.enviaMensagem(new ResultValidation(flagResultado));
    }

    private void workOrderValidationMensagemRecebida(WorkOrderValidationMensagem mensagem) {
        if (this.ultimaMensagemEnviada != null && this.ultimaMensagemEnviada.getTipo() == Tipos.WORK_ORDER) {
            WorkOrderMensagem workOrderMensagem = (WorkOrderMensagem)this.ultimaMensagemEnviada;
            switch (mensagem.getFlag()) {
                case VALID: {
                    this.alteraSituacao(this.exameRequisicaoPorTuboId.get(workOrderMensagem.getTubeId()));
                    break;
                }
                case INVALID_CHEMISTRY_NUMBER: {
                    this.tubosIdComErro.add(workOrderMensagem.getTubeId());
                    String msg = "A seguinte ordem de trabalho cont\u00e9m exames com c\u00f3digos alternativos inv\u00e1lidos: " + workOrderMensagem;
                    this.fireExcecaoEncontrada(msg);
                }
            }
            this.filaWorkOrdersPorTuboId.values().remove(workOrderMensagem);
            if (this.qtEnviados >= 10) {
                this.enviaMensagem(new TokenTransferMensagem());
            } else {
                this.agendadorDeTarefas.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        InterfaceListener.this.enviaProximaWorkOrder();
                    }
                }, 2000L);
            }
        } else {
            String msg = "WorkOrderValidationMensagem recebida, por\u00e9m a \u00faltima mensagem enviada n\u00e3o \u00e9 um WorkOrder (" + this.ultimaMensagemEnviada + ")";
            this.fireExcecaoEncontrada(msg);
            this.reinicia();
        }
    }

    private void tokenTranferMensagemRecebida() {
        this.master = true;
        this.enviaProximaWorkOrder();
    }
}

