/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.mythic22al;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.interfaces.mythic22al.RecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.interfaceamento.padroes.astm.InterfaceASTMListener;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.interfaceamento.util.TestesInterface;
import jalis.util.Funcoes;
import jalis.util.MemoryList;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;

public class InterfaceListener
extends InterfaceASTMListener {
    public InterfaceListener() {
        RecordParser record = new RecordParser();
        record.setInterfaceASTMListener(this);
        super.setASTMRecordParser(record);
        this.INSTRUMENT_NAME = "ORPHEE AL22";
        this.MAX_PATIENT_NAME_CHARS = 50;
    }

    @Override
    public String getErroTraduzido(String erro) {
        return null;
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao) {
        try {
            if (this.tx_list == null) {
                this.tx_list = new MemoryList();
            }
            if (this.rx_list == null) {
                this.rx_list = new MemoryList();
            }
            this.tx_list.clear();
            this.rx_list.clear();
            this.fil_codigo = fil_codigo;
            this.int_codigo = int_codigo;
            this.req_codigo = req_codigo;
            this.pac_nome = pac_nome;
            this.pac_sexo = pac_sexo;
            this.req_idade = pac_idade;
            this.req_data = data;
            this.req_hora = hora;
            this.mco_codigo = mco_codigo;
            this.rec_codigo = rec_codigo;
            this.pac_exames = pac_exames;
            this.exames = pac_exames.split(" ", 0);
            this.ultima_acao = acao;
            Statement st = Conexao.getStatement();
            String short_name = StringUtil.removerAcentos(pac_nome);
            if (short_name.length() > this.MAX_PATIENT_NAME_CHARS) {
                short_name = short_name.substring(0, this.MAX_PATIENT_NAME_CHARS);
            }
            fil_codigo = Funcoes.preencheZero(fil_codigo, ParametrosGerais.getDigitosTuboFilial());
            req_codigo = Funcoes.preencheZero(req_codigo, ParametrosGerais.getDigitosTuboRequisicao());
            StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo);
            rec_codigo = Funcoes.preencheZero(rec_codigo, ParametrosGerais.getDigitosTuboTubo());
            codigo.append(rec_codigo);
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(this.exames, mco_codigo);
            String tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, exa_lista[0].getString(), exa_lista[0].getCodigo().toString(), int_codigo);
            exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_lista);
            ExameMaterial[] alternativos = ExamesUtil.getAlternativos(st, fil_codigo, int_codigo, exa_lista);
            String patient_id = BDUtil.getCodigoPaciente(fil_codigo, req_codigo);
            Object laboratory_pid = null;
            Date dataNascimento = BDUtil.getDataNacimentoPaciente(fil_codigo, req_codigo);
            String pac_nascimento = "";
            if (dataNascimento != null) {
                pac_nascimento = Funcoes.formataData("yyyyMMdd", dataNascimento);
            }
            this.tx_list.add(ASTMStandard.getDefaultHeaderRecord(this.DELIMITERS, this.PASSWORD, this.INSTRUMENT_NAME, null, null, this.HOST_NAME, this.INSTRUMENT_SYSTEM_VERSION, "E 1394-97"));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o cabe\u00e7alho de envio");
            }
            this.tx_list.add(this.getPatientRecord(1, patient_id, codigo.toString(), null, short_name, pac_sexo, pac_nascimento, null, null, null));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel  montar o registro do paciente");
            }
            for (ExameMaterial exameMaterial : alternativos) {
                this.tx_list.add(this.getOrderRecord(1, codigo.toString(), exameMaterial, "R", "0000", acao, tipo_amostra, rackposition, "O"));
            }
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o registro da requisicao");
            }
            this.tx_list.add(ASTMStandard.getDefaultTerminationRecord("N"));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o rodap\u00e9 de envio");
            }
            this.tx_list = this.makeFrames(this.tx_list);
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            this.getPortaCOM().write(String.valueOf('\u0005'));
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: envio de requisi\u00e7\u00e3o");
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o em envio de requisi\u00e7\u00e3o");
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    private String getOrderRecord(int sequence, String sampleId, ExameMaterial alternativo, String priorty, String horaColeta, String acao, String tipo_amostra, String rackPos, String reportType) {
        StringBuilder record = new StringBuilder("O");
        record.append("|").append(sequence);
        record.append("|").append(sampleId);
        record.append("|").append("");
        record.append("|^^^").append(alternativo.getNomeExame());
        record.append("|").append(priorty);
        record.append("|");
        record.append("|0").append(horaColeta);
        record.append("|");
        record.append("|");
        record.append("|");
        record.append("|");
        record.append("|");
        record.append("|");
        record.append("|");
        record.append("|").append(Funcoes.textoVazio(tipo_amostra) ? "STANDARD" : tipo_amostra);
        record.append("|");
        record.append("|");
        record.append("|");
        record.append("|");
        record.append("|").append(rackPos == null ? "00000" : rackPos);
        record.append("|^");
        record.append("|");
        record.append("|");
        record.append("|");
        record.append("|");
        record.append("|||||");
        record.append('\r');
        return record.toString();
    }

    private String getPatientRecord(int patient_sequence, String patient_id, String laboratory_pid, String patient_id3, String pac_nome, String pac_sexo, String pac_nascimento, String med_nome, String comment, String location) {
        StringBuilder record = new StringBuilder("P");
        record.append("|").append(patient_sequence);
        record.append("|").append(patient_id == null ? "" : patient_id);
        record.append("|").append(laboratory_pid == null ? "" : laboratory_pid);
        record.append("|").append(patient_id3 == null ? "" : patient_id3);
        record.append("|").append(pac_nome == null ? "" : pac_nome);
        record.append("|");
        record.append("|").append(pac_nascimento == null ? "" : pac_nascimento);
        record.append("|").append(pac_sexo == null ? "U" : pac_sexo);
        record.append("|");
        record.append("|");
        record.append("|");
        record.append("|");
        record.append("|").append(med_nome == null ? "" : med_nome);
        record.append("|").append(comment == null ? "" : comment);
        record.append("|");
        record.append("|");
        record.append("|");
        record.append("|");
        record.append("|");
        record.append("|");
        record.append("|");
        record.append("|");
        record.append("|");
        record.append("|");
        record.append("|").append(location == null ? "" : location);
        record.append("|||||||||");
        record.append('\r');
        return record.toString();
    }

    @Override
    public void teste() {
        this.mythic22al();
    }

    public void mythic22al() {
        String req = "7001133703";
        this.parse(TestesInterface.arruma("[STX]H|\\^&|||ORPHEE AL22|||||LIS_ID||P|E 1394-97|20110211033633[CR]"));
        this.parse(TestesInterface.arruma("[STX]P|1|TEST PID 1|" + req + "|34|TEST ID||19900101|M|||||HOUSE|comment|||||||||||NY|||||||||[CR]"));
        this.parse(TestesInterface.arruma("[STX]O|1|" + req + "|34|^^^DIF|R||20000||||||||STANDARD|||||00000|^||||F|||||[CR]"));
        this.parse(TestesInterface.arruma("[STX]R|1|^^^WBC|0 |10e2/uL|4 to 12 |LL||F||||20110211033633|[CR]"));
        this.parse(TestesInterface.arruma("[STX]R|2|^^^RBC|0 |10e4/uL|4 to 6 |LL||F||||20110211033633|[CR]"));
        this.parse(TestesInterface.arruma("[STX]R|3|^^^HGB|.....|g/dL|11.0 to 17.0|||F||||20110211033633|[CR]"));
        this.parse(TestesInterface.arruma("[STX]R|4|^^^HCT|0.0 |%|35.0 to 55.0|LL||F||||20110211033633|[CR]"));
        this.parse(TestesInterface.arruma("[STX]R|5|^^^PLT|0.0 |10e4/uL|150.0 to 400.0|LL||F||||20110211033633|[CR]"));
        this.parse(TestesInterface.arruma("[STX]R|6|^^^LYM|0 |10e3/uL|1 to 5 |LL||F||||20110211033633|[CR]"));
        this.parse(TestesInterface.arruma("[STX]R|7|^^^MON|0 |10e3/uL|0 to 1 |L||F||||20110211033633|[CR]"));
        this.parse(TestesInterface.arruma("[STX]R|8|^^^NEU|0 |10e3/uL|2 to 8 |LL||F||||20110211033633|[CR]"));
        this.parse(TestesInterface.arruma("[STX]R|9|^^^LYM%|0.0 |%|25.0 to 50.0|LL||F||||20110211033633[CR]"));
        this.parse(TestesInterface.arruma("[STX]R|10|^^^MON%|0.0 |%|2.0 to 10.0|LL||F||||20110211033633|[CR]"));
        this.parse(TestesInterface.arruma("[STX]R|11|^^^NEU%|0.0 |%|50.0 to 80.0|LL||F||||20110211033633|[CR]"));
        this.parse(TestesInterface.arruma("[STX]R|12|^^^MCV|.....|fL|80.0 to 100.0|||F||||20110211033633|[CR]"));
        this.parse(TestesInterface.arruma("[STX]R|13|^^^MCH|.....|pg|26.0 to 34.0 |||F||||20110211033633|[CR]"));
        this.parse(TestesInterface.arruma("[STX]R|14|^^^MCHC|.....|g/dL|31.0 to 35.5 |||F||||20110211033633|[CR]"));
        this.parse(TestesInterface.arruma("[STX]R|15|^^^RDW|.....|%|10.0 to 16.0 |||F||||20110211033633|[CR]"));
        this.parse(TestesInterface.arruma("[STX]R|16|^^^MPV|.....|fL|7.0 to 11.0 |||F||||20110211033633|[CR]"));
        this.parse(TestesInterface.arruma("[STX]R|17|^^^PCT|.....|%|0.200 to 0.500|||F||||20110211033633|[CR]"));
        this.parse(TestesInterface.arruma("[STX]R|18|^^^PDW|.....|%|10.0 to 18.0 |||F||||20110211033633|[CR]"));
        this.parse(TestesInterface.arruma("[STX]R|19|^^^EOS|0 |10e3/uL|0 to 0 |N||F||||20110211033633|[CR]"));
        this.parse(TestesInterface.arruma("[STX]R|20|^^^BAS|0 |10e3/uL|0 to 0 |N||F||||20110211033633|[CR]"));
        this.parse(TestesInterface.arruma("[STX]R|21|^^^EOS%|0.0 |%|0.0 to 5.0 |N||F||||20110211033633|[CR]"));
        this.parse(TestesInterface.arruma("[STX]R|22|^^^BAS%|0.0 |%|0.0 to 2.0 |N||F||||20110211033633|[CR]"));
        this.parse(TestesInterface.arruma("[STX]M|1|Alert=00011010000000|Flag=000000000000000[CR]"));
        this.parse(TestesInterface.arruma("[STX]L|1|N[CR]"));
    }
}

