/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.mythic22;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.InterfaceamentoConfiguracao;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    private static final String RESULT_FIELD_SID = "SID";
    private static final String RESULT_FIELD_PID = "PID";
    private static final String RESULT_FIELD_ID = "ID";
    private static final String RESULT_FIELD_CALIBRATION = "CALIBRATION";
    private static final String RESULT_FIELD_MODE = "MODE";
    private static final String TOKEN_MSG_BEGIN = "MYTHIC";
    private static final String TOKEN_MSG_END = "END_RESULT";
    private static final String ACK_RESULT_READY = "ACK_RESULT_READY";
    private static final String ACK_RESULT = "ACK_RESULT";
    private String NOME_EXAME = "HEMOG";
    private InterfaceamentoConfiguracao configuracao;
    private ThreadRecebimento threadRecebimento = new ThreadRecebimento();
    private Map<String, String> parametros = new HashMap<String, String>();
    String int_codigo;
    String fil_codigo;
    String req_codigo;
    String mco_codigo;
    String rec_codigo;
    String pac_nome;
    String pac_exames;
    String pac_sexo;
    String req_idade;
    String req_data;
    String req_hora;
    String acao;
    private String restoMsgAnterior = "";

    public InterfaceListener() {
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        this.configuracao = new InterfaceamentoConfiguracao();
        this.configuracao.setXmlVariaveis(c.getVariaveisConfiguracao());
        this.parametros.put("WBC", "leucocitos");
        this.parametros.put("RBC", "hemacias");
        this.parametros.put("HGB", "hgb");
        this.parametros.put("HCT", "hct");
        this.parametros.put("MCV", "celulas_media_contagem");
        this.parametros.put("MCH", "hcm");
        this.parametros.put("MCHC", "mchc");
        this.parametros.put("RDW", "rdw");
        this.parametros.put("PLT", "plaquetas");
        this.parametros.put("MPV", "vpm");
        this.parametros.put("PCT", "pct");
        this.parametros.put("PDW", "pdw");
        this.parametros.put("LYM%", "linfocitos_tipicos_percentual");
        this.parametros.put("MON%", "monocitos_percentual");
        this.parametros.put("NEU%", "neutrofilo_percentual");
        this.parametros.put("EOS%", "eosinofilos_percentual");
        this.parametros.put("BAS%", "basofilos_percentual");
        this.parametros.put("LYM", "linfocitos_tipicos_contagem");
        this.parametros.put("MON", "basofilos_contagem");
        this.parametros.put("NEU", "neutrofilo_contagem");
        this.parametros.put("EOS", "eosinofilos_contagem");
        this.parametros.put("BAS", "basofilos_contagem");
        this.parametros.put("GRA%", "granulocitos_percentual");
        this.parametros.put("GRA", "granulocitos_contagem");
    }

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
    }

    @Override
    public void dataChanged() {
        try {
            String message = this.getPortaCOM().getInputString();
            int pos = message.indexOf(this.getMsgEnd());
            if (message.startsWith(this.getMsgStart()) && message.length() > this.getMsgEnd().length() && pos > -1 && message.substring(pos).contains(this.getMsgEnd()) && message.substring(pos).contains(String.valueOf('\r'))) {
                this.addListaRecebimento(message);
                this.restartThreadRecebimento();
                this.getPortaCOM().clearInputString();
                if (this.isRX()) {
                    this.aguardarProximoFrame();
                }
            } else if (this.isRX()) {
                this.aguardarProximoFrame();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            this.fireMensagemEnviada("Erro ao receber dados do equipamento.", 1, 5000);
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public String getMsgStart() {
        return TOKEN_MSG_BEGIN;
    }

    @Override
    public String getMsgEnd() {
        return TOKEN_MSG_END;
    }

    @Override
    public String parse(String message) {
        String retorno = null;
        List<String> messages = this.checksum(message);
        if (!messages.isEmpty()) {
            try {
                for (String msg : messages) {
                    retorno = this.parseResults(msg);
                }
                return retorno;
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, "Erro ao inserir resultados recebidos ao banco de dados.\n" + ex.getMessage(), ex.getStackTrace());
                try {
                    Conexao.anulaSQL();
                    return "Erro ao inserir resultados recebidos ao banco de dados";
                }
                catch (SQLException e) {
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                    return "Erro ao inserir resultados recebidos ao banco de dados";
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.toString() + "\n" + e.getMessage(), e.getStackTrace());
                return "Erro ao realizar parse dos dados recebidos";
            }
        }
        return "Erro ao receber resultado: CheckSum inv\u00e1lidos!";
    }

    private String parseResults(String message) throws Exception {
        String[] messages = message.split(String.format("%s", String.valueOf('\n')));
        HashMap<String, String[]> results = new HashMap<String, String[]>();
        for (String lines : messages) {
            String[] fields = lines.split(";");
            if (fields.length <= 1) continue;
            String[] values = new String[fields.length - 1];
            for (int i = 1; i < fields.length; ++i) {
                values[i - 1] = fields[i];
            }
            results.put(fields[0], values);
        }
        if (!results.isEmpty() && !((String[])results.get(RESULT_FIELD_MODE))[0].equalsIgnoreCase(RESULT_FIELD_CALIBRATION)) {
            String sampleId = "";
            if (results.containsKey(RESULT_FIELD_ID) && results.get(RESULT_FIELD_ID) != null && ((String[])results.get(RESULT_FIELD_ID)).length > 0 && !Funcoes.textoVazio(((String[])results.get(RESULT_FIELD_ID))[0])) {
                sampleId = ((String[])results.get(RESULT_FIELD_ID))[0].trim();
            }
            if (Funcoes.textoVazio(sampleId) && results.containsKey(RESULT_FIELD_PID) && results.get(RESULT_FIELD_PID) != null && ((String[])results.get(RESULT_FIELD_PID)).length > 0 && !Funcoes.textoVazio(((String[])results.get(RESULT_FIELD_PID))[0])) {
                sampleId = ((String[])results.get(RESULT_FIELD_PID))[0].trim();
            }
            if (Funcoes.textoVazio(sampleId) && results.containsKey(RESULT_FIELD_SID) && results.get(RESULT_FIELD_SID) != null && ((String[])results.get(RESULT_FIELD_SID)).length > 0 && !Funcoes.textoVazio(((String[])results.get(RESULT_FIELD_SID))[0])) {
                sampleId = ((String[])results.get(RESULT_FIELD_SID))[0].trim();
            }
            if (Funcoes.textoVazio(sampleId) || sampleId.length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                this.fireExcecaoEncontrada("Resultados recebidos para requisi\u00e7\u00e3o inv\u00e1lida ou n\u00e3o interfaceada: " + sampleId);
                return null;
            }
            DescritorCodigoEtiqueta descritorCodigoEtiqueta = DescritorCodigoEtiqueta.getDescritor(sampleId);
            if (descritorCodigoEtiqueta == null) {
                this.fireExcecaoEncontrada("Etiqueta n\u00e3o localizada: " + sampleId);
                return null;
            }
            if (descritorCodigoEtiqueta != null && descritorCodigoEtiqueta.getFilial() != null && descritorCodigoEtiqueta.getRequisicao() != null && descritorCodigoEtiqueta.getTubo() != null) {
                this.fil_codigo = Funcoes.preencheZero(descritorCodigoEtiqueta.getFilial(), ParametrosGerais.getDigitosTuboFilial());
                this.rec_codigo = Funcoes.preencheZero(descritorCodigoEtiqueta.getTubo(), ParametrosGerais.getDigitosTuboTubo());
                this.req_codigo = Funcoes.preencheZero(descritorCodigoEtiqueta.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao());
            }
            this.int_codigo = this.getIntCodigo(this.fil_codigo, this.req_codigo, this.rec_codigo, this.NOME_EXAME);
            Statement st = Conexao.getStatement();
            if (this.int_codigo == null) {
                int situacao = this.getExameSituacao(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.NOME_EXAME, this.mco_codigo, this.rec_codigo);
                StringBuilder s = new StringBuilder();
                s.append("N\u00e3o foi poss\u00edvel encontrar o exame! O exame encontra-se ");
                if (situacao == 8) {
                    s.append("exportado!");
                } else {
                    s.append("sem situa\u00e7\u00e3o!");
                }
                s.append("(").append(sampleId).append(")");
                this.fireExcecaoEncontrada(s.toString());
                return null;
            }
            HashMap<String, Object> hemograma = new HashMap<String, Object>();
            for (String key : results.keySet()) {
                if (((String[])results.get(key)).length <= 0) continue;
                this.parseParameter(hemograma, key, ((String[])results.get(key))[0]);
            }
            List<BDExame> exames = BDUtil.getReqExamesMultGuia(this.fil_codigo, this.int_codigo, this.req_codigo, this.rec_codigo);
            for (BDExame exame : exames) {
                this.atualizarDadosExame(st, this.fil_codigo, exame.getRequisicao(), exame.getRecipiente(), exame.getExame(), exame.getMaterial(), this.int_codigo, hemograma);
            }
            Conexao.arquivaSQL();
        }
        return "";
    }

    private void parseParameter(Map<String, Object> hemograma, String parametroInterface, String resultado) {
        if (this.parametros.containsKey(parametroInterface)) {
            hemograma.put(this.parametros.get(parametroInterface), resultado.trim().replace('.', ','));
        }
    }

    @Override
    public void teste() {
        StringBuilder tmp = new StringBuilder();
        tmp.append("MYTHIC[SP]1;;RESULT[CR]");
        tmp.append("DATE;31/01/2013[CR]");
        tmp.append("TIME;09:13:27[CR]");
        tmp.append("MODE;NORMAL[CR]");
        tmp.append("UNIT;1[CR]");
        tmp.append("SEQ;25;0[CR]");
        tmp.append("SID;00023[CR]");
        tmp.append("PID;[CR]");
        tmp.append("ID;770005231602[CR]");
        tmp.append("TYPE;STANDARD[CR]");
        tmp.append("TEST;DIF[CR]");
        tmp.append("OPERATOR;[CR]");
        tmp.append("PREL;OT[CR]");
        tmp.append("CYCLE;N[CR]");
        tmp.append("WBC;9.9[SP][SP];;;2.0[SP][SP];3.6[SP][SP];11.0[SP];15.0[SP][CR]");
        tmp.append("RBC;4.09[SP];;;2.50[SP];4.00[SP];5.50[SP];7.00[SP][CR]");
        tmp.append("HGB;12.4;;;8.5[SP];12.0;16.0;19.0[CR]");
        tmp.append("HCT;37.3;;;25.0;36.0;50.0;60.0[CR]");
        tmp.append("PLT;351[SP][SP];;;70[SP][SP][SP];140[SP][SP];450[SP][SP];500[SP][SP][CR]");
        tmp.append("LYM;2.4[SP][SP];;;0.7[SP][SP];1.0[SP][SP];5.0[SP][SP];5.5[SP][SP][CR]");
        tmp.append("MON;0.7[SP][SP];;;0.0[SP][SP];0.1[SP][SP];1.0[SP][SP];1.1[SP][SP][CR]");
        tmp.append("NEU;6.7[SP][SP];;;1.5[SP][SP];2.0[SP][SP];8.0[SP][SP];9.0[SP][SP][CR]");
        tmp.append("LYM%;24.1;;l;15.0;25.0;50.0;55.0[CR]");
        tmp.append("MON%;6.6[SP];;;1.0[SP];2.0[SP];10.0;12.0[CR]");
        tmp.append("NEU%;68.1;;;45.0;50.0;80.0;85.0[CR]");
        tmp.append("MCV;91.2[SP];;;70.0[SP];80.0[SP];97.0[SP];120.0[CR]");
        tmp.append("MCH;30.3[SP];;;25.0[SP];26.0[SP];33.0[SP];35.0[SP][CR]");
        tmp.append("MCHC;33.2[SP];;;28.0[SP];31.0[SP];36.0[SP];37.0[SP][CR]");
        tmp.append("RDW;13.5[SP];;;7.0[SP][SP];10.0[SP];16.0[SP];25.0[SP][CR]");
        tmp.append("MPV;7.7[SP][SP];;;6.0[SP][SP];7.0[SP][SP];11.0[SP];12.5[SP][CR]");
        tmp.append("PCT;0.270;;;0.100;0.200;0.500;0.600[CR]");
        tmp.append("PDW;14.1[SP];;;8.0[SP][SP];10.0[SP];18.0[SP];25.0[SP][CR]");
        tmp.append("EOS;0.1[SP][SP];;;0.0[SP][SP];0.0[SP][SP];0.4[SP][SP];0.6[SP][SP][CR]");
        tmp.append("BAS;0.0[SP][SP];;;0.0[SP][SP];0.0[SP][SP];0.2[SP][SP];0.3[SP][SP][CR]");
        tmp.append("EOS%;0.8[SP];;;0.0[SP];0.0[SP];5.0[SP];8.0[SP][CR]");
        tmp.append("BAS%;0.4[SP];;;0.0[SP];0.0[SP];2.0[SP];5.0[SP][CR]");
        tmp.append("WBC[SP]CURVE;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;1;4;8;13;18;20;19;18;17;15;14;13;13;14;18;24;29;34;39;44;51;59;64;69;77;84;90;98;108;119;127;130;129;129;134;139;140;139;142;148;147;144;149;160;172;182;193;205;212;212;214;222;229;227;227;234;238;239;235;227;223;222;217;212;213;213;206;198;188;171;153;144;138;129;116;104;98;96;93;86;78;72;67;63;58;53;50;47;43;39;36;34;31;27;24;23;21;17;14;13;13;11;10;9;8;7;6;6;6;[CR]");
        tmp.append("WBC[SP]THRESHOLDS;28;49;0;[CR]");
        tmp.append("RBC[SP]CURVE;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;1;3;6;10;16;25;37;52;72;96;122;151;179;206;228;240;245;246;239;227;212;194;173;151;130;111;94;80;67;55;45;35;27;21;16;12;8;5;3;2;1;1;0;0;0;0;0;0;0;0;0;0;0;0;1;2;2;2;2;2;2;2;2;2;2;1;1;1;1;1;1;1;1;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;[CR]");
        tmp.append("RBC[SP]THRESHOLDS;32;57[CR]");
        tmp.append("PLT[SP]CURVE;0;0;0;0;0;0;0;2;6;12;21;32;44;56;67;77;85;91;95;98;100;100;100;99;97;93;89;85;80;75;70;65;61;56;52;48;44;39;35;32;29;26;23;21;20;18;16;15;14;12;11;10;9;8;7;7;6;6;5;4;4;3;3;2;2;2;2;1;1;1;1;1;1;1;1;1;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;[CR]");
        tmp.append("PLT[SP]THRESHOLDS;76[CR]");
        tmp.append("ALARMS;[CR]");
        tmp.append("INTERPRETIVE_WBC;LYM<;[CR]");
        tmp.append("INTERPRETIVE_RBC;[CR]");
        tmp.append("INTERPRETIVE_PLT;[CR]");
        tmp.append("COMMENT;;[CR]");
        tmp.append("LMNE[SP]MATRIX;[CR]");
        tmp.append("Z18;4;80;Zd;2;Zf;12;0;10;Ze;80;Ze;10;48;28;Ze;3;Z1e;10;Z10;1;8;Z1f;84;10;Zd;8;Zf;80;20;Ze;4;40;40;Z1d;2;Z4;4;Z9;80;Z2;80;Zc;10;c0;20;Ze;8;30;Ze;41;c2;Ze;40;10;Z1e;20;80;Zf;8;Ze;80;Z20;2a;Ze;23;Z1f;2;Z11;40;Zd;10;1;Z4e;40;20;Z5;1;Z9;28;Ze;20;[CR]");
        tmp.append(";1;Z4;8;Z10;1;Zf;1;Z8;4;Z6;1;Z18;1;Z13;40;Zb;8;Z2;10;Z13;3;Z6;40;Z3;1;Z4;81;Ze;2;1;Z9;20;Z5;1;Zb;40;0;8;Za;4;Z12;8;Zd;40;2;88;Ze;1;c0;0;4;Zb;10;4;ca;80;Z2;11;Za;86;99;Ze;5;c1;Z2;62;Za;10;9;6;9b;0;80;20;Za;b7;82;0;4;0;1;Z9;a;66;be;40;8;1;Za;6;[CR]");
        tmp.append(";fb;e1;c4;0;10;Za;82;df;7d;84;80;Zb;8;U1;fc;80;Zc;21;U1;f6;60;Zc;f;U1;f2;a4;Zc;6;U1;f4;90;8;Za;44;1f;U1;fa;40;4;Zb;5f;ef;be;30;4;Za;1;bb;U1;fe;Zc;43;U2;fb;Z9;1;Z3;7f;U1;fd;4;Zb;3;U2;e2;Zc;1;U2;f3;Zc;83;U2;f0;Z9;80;Z2;4f;U2;f2;0;10;Za;7;U2;fc;[CR]");
        tmp.append(";0;40;Z7;80;Z2;bf;U2;c8;Za;80;1;ef;U1;fb;f0;0;10;Z9;1;U3;c0;Za;1;6;U3;80;Zb;3;U3;80;Zb;3;U3;a0;Z9;1;0;f;U2;ee;20;Zb;1f;U2;f4;Zc;5f;U2;fc;Zb;1;3f;U2;fc;Zb;3;U3;8;Zb;e;U2;fe;20;10;Za;3;U2;fd;90;80;Za;f;U2;fd;Z4;10;Z7;2e;U2;f6;Z2;40;Z9;8f;U2;fa;[CR]");
        tmp.append(";29;0;40;8;Z8;5f;U2;e0;0;a0;Za;4f;U2;a0;48;4;80;10;Z7;42;3f;U1;e7;80;10;8;c0;Z8;40;7f;fe;f7;0;8f;c1;20;Z5;4;0;10;6;5f;U1;f8;4;32;28;Za;fe;fe;40;3a;c7;78;1;Z8;21;d7;ee;c4;c;b5;U1;2a;Z8;10;4b;fc;85;26;ef;7f;51;Z6;4;0;2;f5;ae;c3;ae;6f;f4;c8;10;Z7;58;[CR]");
        tmp.append(";71;e6;1;37;U1;75;20;Z6;1;1;3;3f;45;3;7;U1;7c;b8;Z7;10;2;31;10;b3;cf;bf;eb;Z9;54;31;0;4c;cf;U1;ec;10;Z7;64;47;7b;f0;41;77;U1;ef;Z7;10;0;4f;fb;f2;7;ee;U1;3a;c0;Z6;4;c8;df;df;7f;4d;7b;dd;a1;Z7;10;47;U2;dc;de;d1;b0;Z8;8;4b;7f;U2;d5;56;c0;40;Z8;2f;[CR]");
        tmp.append(";U2;ee;50;ab;94;c;Z6;20;40;f;U2;ce;1;9a;10;40;Z8;U3;d2;0;8;Z8;5;80;f;U1;fb;e4;20;40;Z8;4;4;7b;U1;fd;c0;2;Za;b0;1f;U1;fd;c4;Za;20;54;7b;U1;fa;40;Za;31;39;d7;U1;b0;Zb;bf;ec;9;f5;8;Zb;7f;85;1f;a8;80;Zb;d2;6c;3;44;Zc;2;40;41;0;10;Z49;T[CR]");
        tmp.append("LMNE[SP]SHADE[SP]MATRIX;[CR]");
        tmp.append("Z18;4;80;Zd;2;Zf;12;0;10;Ze;80;Ze;10;48;28;Ze;2;Z1e;10;Z10;1;8;Z1f;84;10;Zd;8;Zf;80;20;Ze;4;40;40;Z1d;2;Z4;4;Z9;80;Z2;80;Zc;10;c0;20;Ze;8;30;Ze;41;c2;Ze;40;10;Z1e;20;80;Zf;8;Ze;80;Z20;a;Ze;23;Z1f;2;Z11;40;Zd;10;1;Z4e;40;20;Z5;1;Z9;28;Ze;20;1;[CR]");
        tmp.append(";Z4;8;Z10;1;Zf;1;Z8;4;Z1f;1;Z13;40;Zb;8;Z2;10;Z13;3;Z6;40;Z3;1;Z4;81;Ze;2;1;Z9;20;Z5;1;Zb;40;0;8;Za;4;Z12;8;Zd;40;2;88;Ze;1;c0;0;4;Zb;10;4;ca;80;Z2;11;Za;86;98;Ze;4;c1;Z2;62;Za;10;1;2;9b;0;80;20;Za;24;2;0;4;0;1;Z9;8;20;6;0;8;1;Za;4;b9;40;84;0;10;[CR]");
        tmp.append(";Za;82;c0;35;84;80;Zb;8;80;90;80;Zc;20;8;6;60;Zc;e;42;0;84;Zc;4;0;40;90;8;Za;44;2;0;42;0;4;Zb;1c;0;24;30;4;Zb;90;0;6;Zc;43;c6;4;b;Z9;1;Z3;40;Z2;4;Zb;1;0;1;Zd;1;Z2;43;Zc;82;c0;0;10;Z9;80;Z2;4c;Z2;22;0;10;Za;6;Z2;c;0;40;Z7;80;Z2;20;Zd;80;0;e0;Z2;70;[CR]");
        tmp.append(";0;10;Z9;1;Z3;40;Za;1;6;80;0;3;80;Zb;2;Z2;3;80;Zb;2;Z2;a;20;Z9;1;0;8;Z2;2;20;Zb;1;Z2;14;Zc;48;Z2;3c;Zb;1;20;Z2;5c;Zb;1;60;Z2;8;Zb;c;e0;0;2;20;10;Za;3;40;0;25;90;80;Za;c;Z2;1;Z4;10;Z7;22;Z2;6;Z2;40;Z9;8a;Z2;5a;29;0;40;8;Z8;10;Z2;c0;0;a0;Za;48;[CR]");
        tmp.append(";0;1;20;48;0;80;10;Z7;42;2;0;1;80;10;8;c0;Z8;40;70;0;7;0;8f;41;20;Z5;4;0;10;4;2;40;d8;4;10;8;Za;50;4;0;3a;c2;28;1;Z8;21;44;22;c4;c;4;82;2a;Z8;10;3;6c;5;20;20;22;41;Z6;4;0;2;a4;e;c3;a4;22;60;c8;10;Z7;50;61;6;1;35;c;24;20;Z7;1;3;35;45;2;4;0;14;[CR]");
        tmp.append(";b8;Z7;10;2;30;10;93;c9;0;1;Z9;54;11;0;4c;4a;68;8c;10;Z7;64;2;5a;90;41;40;8;c7;Z7;10;0;4e;28;92;0;ca;e7;3a;c0;Z6;4;c8;d0;0;36;4c;3a;c;a1;Z7;10;42;80;0;50;de;d0;b0;Z8;8;40;Z2;4;90;14;c0;40;Z8;28;Z2;80;50;a3;94;c;Z6;20;40;8;Z2;e;1;9a;10;40;Z8;f4;[CR]");
        tmp.append(";0;2;12;0;8;Z8;5;80;8;0;a;84;20;40;Z8;4;4;50;0;4;40;2;Za;b0;18;0;8;c4;Za;20;50;8;0;18;40;Za;10;19;d4;80;20;Zb;8a;cc;8;5;8;Zb;c;5;17;20;80;Zb;d2;6c;3;44;Zd;40;41;0;10;Z49;T[CR]");
        tmp.append("THRES[SP]5D[SP]LMNE[SP]MATRIX;[CR]");
        tmp.append("N1X;18;N1Y;15;N2X;35;N2Y;23;EosY;100;LneX;55;LneY;60;LnlX;50;LnlY;28;RneY;105;NmY;46;LmX;69;LmnX;63;LmnY;26;ICX;105;[CR]");
        tmp.append("BasoX1;60;BasoY1;26;BasoX2;64;BasoY2;30;BasoX3;70;BasoY3;29;BasoX4;65;BasoY4;20;NHH;2;NHL;2;RLL;2;RLR;3;NLH;2;NLL;2;HLH;2;HLL;2;[CR]");
        tmp.append("END_RESULT;37900[CR]");
        tmp.setLength(0);
        tmp.append("MYTHIC[SP]1;BIOLOGIST;RESULT[CR]");
        tmp.append("DATE;02/09/2013[CR]");
        tmp.append("TIME;15:59:43[CR]");
        tmp.append("MODE;NORMAL[CR]");
        tmp.append("UNIT;1[CR]");
        tmp.append("SEQ;70;0[CR]");
        tmp.append("SID;770005231602[CR]");
        tmp.append("PID;770005231602[CR]");
        tmp.append("ID;[CR]");
        tmp.append("TYPE;STANDARD[CR]");
        tmp.append("TEST;DIF[CR]");
        tmp.append("OPERATOR;BIOLOGIST[CR]");
        tmp.append("PREL;OT[CR]");
        tmp.append("CYCLE;N[CR]");
        tmp.append("WBC;8.5[SP][SP];;;2.0[SP][SP];4.0[SP][SP];12.0[SP];15.0[SP][CR]");
        tmp.append("RBC;4.52[SP];;;2.50[SP];4.00[SP];6.20[SP];7.00[SP][CR]");
        tmp.append("HGB;12.3;;;8.5[SP];11.0;17.0;19.0[CR]");
        tmp.append("HCT;36.3;;;25.0;35.0;55.0;60.0[CR]");
        tmp.append("PLT;358[SP][SP];;;70[SP][SP][SP];150[SP][SP];400[SP][SP];500[SP][SP][CR]");
        tmp.append("LYM;3.5[SP][SP];;;0.7[SP][SP];1.0[SP][SP];5.0[SP][SP];5.5[SP][SP][CR]");
        tmp.append("MON;0.7[SP][SP];;;0.0[SP][SP];0.1[SP][SP];1.0[SP][SP];1.1[SP][SP][CR]");
        tmp.append("NEU;4.0[SP][SP];;;1.5[SP][SP];2.0[SP][SP];8.0[SP][SP];9.0[SP][SP][CR]");
        tmp.append("LYM%;40.6;;;15.0;25.0;50.0;55.0[CR]");
        tmp.append("MON%;8.1[SP];;;1.0[SP];2.0[SP];10.0;12.0[CR]");
        tmp.append("NEU%;47.4;;l;45.0;50.0;80.0;85.0[CR]");
        tmp.append("MCV;80.3[SP];;;70.0[SP];80.0[SP];100.0;120.0[CR]");
        tmp.append("MCH;27.2[SP];;;25.0[SP];26.0[SP];34.0[SP];35.0[SP][CR]");
        tmp.append("MCHC;33.9[SP];;;28.0[SP];31.0[SP];35.5[SP];37.0[SP][CR]");
        tmp.append("RDW;13.1[SP];;;7.0[SP][SP];10.0[SP];16.0[SP];25.0[SP][CR]");
        tmp.append("MPV;7.2[SP][SP];;;6.0[SP][SP];7.0[SP][SP];11.0[SP];12.5[SP][CR]");
        tmp.append("PCT;0.257;;;0.100;0.200;0.500;0.600[CR]");
        tmp.append("PDW;12.6[SP];;;8.0[SP][SP];10.0[SP];18.0[SP];25.0[SP][CR]");
        tmp.append("EOS;0.3[SP][SP];;;0.0[SP][SP];0.0[SP][SP];0.4[SP][SP];0.6[SP][SP][CR]");
        tmp.append("BAS;0.0[SP][SP];;;0.0[SP][SP];0.0[SP][SP];0.2[SP][SP];0.3[SP][SP][CR]");
        tmp.append("EOS%;3.4[SP];;;0.0[SP];0.0[SP];5.0[SP];8.0[SP][CR]");
        tmp.append("BAS%;0.5[SP];;;0.0[SP];0.0[SP];2.0[SP];5.0[SP][CR]");
        tmp.append("WBC[SP]CURVE;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;2;6;12;19;29;42;56;68;79;87;95;102;109;116;122;131;145;156;161;163;169;181;194;202;207;203;192;183;178;175;173;166;153;140;130;122;117;115;113;109;108;109;112;118;127;133;136;147;166;185;197;204;212;216;214;219;231;239;241;238;232;226;219;214;211;204;192;181;177;179;178;169;157;147;135;125;120;116;110;103;97;90;86;85;82;74;66;59;50;42;38;35;33;32;30;27;24;22;21;19;16;14;13;10;8;8;9;9;[CR]");
        tmp.append("WBC[SP]THRESHOLDS;32;49;0;[CR]");
        tmp.append("RBC[SP]CURVE;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;1;3;7;11;17;26;37;52;71;94;121;150;177;201;222;234;238;238;232;219;204;186;166;145;125;107;90;74;60;49;40;32;25;19;14;10;7;5;4;3;2;1;1;1;1;1;1;1;1;1;1;1;1;1;1;2;2;2;2;2;2;1;1;1;1;1;1;1;1;1;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;[CR]");
        tmp.append("RBC[SP]THRESHOLDS;32;57[CR]");
        tmp.append("PLT[SP]CURVE;0;0;0;0;0;0;1;3;7;14;23;34;45;57;68;77;84;90;93;94;93;91;88;85;81;76;72;67;62;58;53;49;45;42;38;35;32;29;26;23;21;18;16;14;13;11;10;9;8;7;6;5;4;3;3;2;2;2;2;1;1;1;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;0;[CR]");
        tmp.append("PLT[SP]THRESHOLDS;69[CR]");
        tmp.append("ALARMS;RL;[CR]");
        tmp.append("INTERPRETIVE_WBC;NEU<;ALY;[CR]");
        tmp.append("INTERPRETIVE_RBC;[CR]");
        tmp.append("INTERPRETIVE_PLT;[CR]");
        tmp.append("COMMENT;;[CR]");
        tmp.append("LMNE[SP]MATRIX;[CR]");
        tmp.append("Z19;e;Z2;40;Zd;84;c0;10;Z8;20;Z2;4;10;2;Ze;8;4;0;10;Zb;2;0;1;40;Zc;1;10;20;8;Z3;1;Z9;4;42;40;Zb;40;0;20;40;2;0;8;Zb;82;14;Ze;42;20;50;Zc;1;0;40;8;Zd;20;84;Za;80;Z3;60;4c;80;0;4;Za;4;40;10;Ze;9;12;80;Zc;21;25;60;Ze;98;5;48;40;Zb;40;46;b0;Zd;10;[CR]");
        tmp.append(";87;a0;Ze;12;86;8;Zd;20;71;Ze;30;10;Zd;a0;8;3a;40;8;Z2;2;Z8;4;a0;Ze;1;5;82;2;Zd;84;1;Zc;1;Z2;4;Zd;10;60;d0;20;Zd;4;Z5;1;Z9;2;1;8;80;Zc;58;a0;d0;Zc;88;e2;30;40;Zc;1;12;40;Zd;9;68;Z5;1;Z9;a1;14;0;10;1;Za;12;42;2;0;80;1;Z9;1;0;1;aa;80;Zb;4;21;85;[CR]");
        tmp.append(";0;40;Zd;40;80;Z3;1;Z8;1;0;18;0;20;Z3;1;Z9;35;28;10;Zc;e6;4;8;0;4;Zb;1;a0;91;84;Z2;2;Za;81;Zf;c0;1;Z4;1;Z9;c0;40;0;20;Zb;10;84;4;Z4;2;Zc;10;Z7;10;Z3;4;6;Ze;1;30;Ze;9;Zb;20;Z5;2;8;90;40;Zb;20;10;0;1;Zb;20;Z3;8;Zc;8;Z2;8;Zc;50;80;12;4;Z9;80;Z4;2;[CR]");
        tmp.append(";40;Ze;10;4;Z5;1;Z7;4;20;72;Z8;4;Z3;8;0;d;bd;Z8;2;Z3;4;96;aa;c8;0;1;Z9;10;80;12;63;10;Z2;1;Z4;20;Z4;2;fb;4f;92;Za;40;0;10;99;3b;e1;Zb;30;0;8f;cb;c8;80;Zc;a3;6f;e0;0;80;Z6;1;Z2;88;18;7f;b9;e0;0;2;Za;95;e7;fa;80;Z2;1;Z7;2;1;4;1f;fe;e0;8;Z9;10;0;7;[CR]");
        tmp.append(";U2;33;Zc;5d;3f;U1;c6;Zb;8;b7;U1;eb;80;Zc;6f;ef;U1;81;80;0;8;Z8;1;bf;U1;7b;Zc;1d;7f;U2;19;Za;40;7f;U2;f8;84;Za;4;3e;U2;fb;90;Za;1;1f;U2;ec;Z9;10;0;6;3f;U2;d8;Z2;2;Z6;2;40;c8;U3;f4;0;2;Z9;13;U3;84;40;Z9;80;12;U3;e9;Zb;35;U3;e4;Z8;20;Z2;ef;U2;fe;[CR]");
        tmp.append(";91;Za;9;9f;U2;f2;8;4;Z9;1;3f;U2;df;68;Z9;10;c;U3;f6;Zb;5;U3;bb;80;Z9;43;11;U3;90;Z9;40;0;16;U3;d0;Z2;40;Z7;10;3;U2;f1;c8;Za;24;35;U2;f6;4;8;Za;1f;U2;fd;Zc;7f;U2;e9;40;Z9;9;12;1b;U1;f7;74;Zb;c;3f;U1;f9;d0;Za;40;43;d3;f7;eb;c1;40;0;20;Z5;1;0;8;[CR]");
        tmp.append(";50;4f;U1;6b;c0;2;Z3;40;Z6;2;28;e1;ba;c2;d0;Z8;2;40;1;5;8c;95;70;80;Z8;20;8;cc;16;4a;86;70;c0;Z3;8;Z6;30;0;2d;55;bd;Z8;1;0;52;Z2;10;be;c2;88;Z9;29;c2;0;17;b6;7f;14;Z9;40;50;31;69;3f;U1;44;Z9;10;2;0;11;1f;c3;58;8;Z8;60;2;40;2d;U1;f6;64;80;Z7;8;[CR]");
        tmp.append(";42;0;51;7d;U1;fe;d2;8;Z8;90;22;60;17;U1;fc;50;8;Z7;20;1;42;21;77;U1;fe;54;Z7;17;0;13;db;3e;U2;fc;Z8;c;38;ae;3e;4e;bf;U1;e7;60;Z7;10;0;1f;U1;ad;U2;f9;80;Z8;60;df;U3;fe;e6;4;Z7;41;1;U2;f8;5f;U1;8c;20;Z7;24;f4;U2;fb;7f;f9;e0;0;8;Z6;24;1f;bf;U1;fa;[CR]");
        tmp.append(";16;ae;Z9;a1;1e;U2;fe;76;16;62;Z7;1;42;fb;U2;fb;a8;98;Z9;7d;fb;U2;fc;10;80;80;Z8;5f;9b;U2;e1;0;40;Z9;5b;d1;U2;Zc;32;40;f7;ee;4;Zd;17;a8;0;80;1;Z19;20;0;80;Z1b;T[CR]");
        tmp.append("LMNE[SP]SHADE[SP]MATRIX;[CR]");
        tmp.append("Z19;e;Z2;40;Zd;84;c0;10;Z8;20;Z2;4;10;Zf;8;4;0;10;Zb;2;0;1;40;Zc;1;10;20;8;Z3;1;Z9;4;42;40;Zb;40;0;20;40;2;0;8;Zb;82;14;Ze;42;20;50;Ze;40;8;Zd;20;4;Za;80;Z3;60;4c;80;0;4;Za;4;40;10;Ze;8;12;80;Zc;21;25;40;Ze;98;5;48;40;Zb;40;46;b0;Zd;10;87;a0;[CR]");
        tmp.append(";Ze;12;86;Ze;20;31;Ze;30;Ze;a0;8;3a;40;8;Z2;2;Z8;4;a0;Ze;1;5;82;2;Zd;84;1;Zc;1;Z10;10;60;d0;20;Zd;4;Z5;1;Z9;2;1;8;80;Zc;58;a0;d0;Zc;88;e2;30;40;Zc;1;12;40;Zd;9;68;Zf;a0;14;0;10;1;Za;12;40;2;0;80;1;Z9;1;0;1;aa;80;Zb;4;1;85;0;40;Zd;40;Z4;1;Z8;1;[CR]");
        tmp.append(";Z3;20;Z3;1;Z9;25;28;10;Zc;e6;4;8;0;4;Zb;1;a0;91;84;Z2;2;Za;81;Zf;c0;1;Z4;1;Z9;c0;40;0;20;Zb;10;4;4;Z4;2;Zc;10;Z7;10;Z3;4;6;Ze;1;10;Ze;9;Zb;20;Z5;2;8;90;40;Zb;20;10;0;1;Zb;20;Z3;8;Zc;8;Z2;8;Zc;50;80;12;4;Z9;80;Z4;2;40;Ze;10;4;Z5;1;Z7;4;20;72;[CR]");
        tmp.append(";Z8;4;Z3;8;0;d;2d;Z8;2;Z3;4;86;aa;48;0;1;Z9;10;80;12;63;10;Z2;1;Z4;20;Z4;2;da;4e;12;Za;40;0;10;99;38;a1;Zb;30;0;8b;49;c8;80;Zc;a0;41;20;0;80;Z6;1;Z2;88;18;74;28;e0;0;2;Za;94;e0;42;80;Z2;1;Z7;2;1;4;0;1a;20;8;Z9;10;0;7;84;9;33;Zc;5c;0;15;6;Zb;8;[CR]");
        tmp.append(";a0;90;3;80;Zc;28;2;2f;81;80;0;8;Z8;1;Z2;4b;Zc;19;Z2;4c;19;Za;40;6a;0;80;10;84;Za;4;28;Z2;5b;90;Za;1;1c;Z2;4c;Z9;10;0;6;c;0;8;58;Z2;2;Z6;2;40;c8;40;0;4;f4;0;2;Z9;10;20;Z2;84;40;Z9;80;10;Z2;3;29;Zb;35;Z2;3;e4;Z8;20;Z2;c6;Z2;2;11;Za;9;98;Z2;12;[CR]");
        tmp.append(";8;Za;1;10;Z2;9;68;Z9;10;c;20;Z2;e2;Zb;5;Z3;1a;80;Z9;43;11;40;0;4;10;Z9;40;0;12;80;0;1;d0;Z2;40;Z7;10;Z3;c0;48;Za;24;30;8c;0;96;4;8;Za;10;0;4;45;Zc;73;a0;6;9;40;Z9;9;12;8;0;1;24;Zb;c;2c;0;8;d0;Za;40;3;d2;0;28;c1;40;0;20;Z5;1;0;8;50;b;b6;69;c0;[CR]");
        tmp.append(";2;Z3;40;Z8;81;32;c2;d0;Z8;2;40;1;4;88;15;50;80;Z8;20;8;8c;16;40;84;70;c0;Z3;8;Z6;30;0;2d;54;8c;Z8;1;0;52;Z3;a8;0;88;Z9;28;c2;0;3;b4;2b;10;Z9;40;50;30;61;32;a;40;Z9;10;2;0;11;4;41;58;8;Z8;60;2;40;2d;8;2;64;80;Z7;8;42;0;51;20;80;58;52;8;Z8;90;[CR]");
        tmp.append(";22;60;Z3;50;8;Z7;20;1;2;21;14;Z2;54;Z7;15;0;2;d0;3e;2;0;1c;Z8;c;38;ac;0;8;a2;0;87;60;Z7;10;0;5;0;85;c0;0;1;80;Z8;60;c0;0;c;0;4;26;4;Z7;41;1;80;Z2;12;5;c;20;Z7;24;d4;c0;0;b;50;69;e0;0;8;Z6;24;7;80;0;a;4;ac;Z9;a1;a;80;0;2;76;16;62;Z7;1;2;41;Z3;a8;[CR]");
        tmp.append(";98;Z9;25;9b;Z2;4;10;80;80;Z8;56;3;Z2;1;0;40;Z9;52;d0;80;21;Zc;32;40;e2;2c;4;Zd;17;a0;0;80;1;Z19;20;0;80;Z1b;T[CR]");
        tmp.append("THRES[SP]5D[SP]LMNE[SP]MATRIX;[CR]");
        tmp.append("N1X;20;N1Y;15;N2X;35;N2Y;23;EosY;100;LneX;55;LneY;60;LnlX;50;LnlY;28;RneY;105;NmY;46;LmX;69;LmnX;63;LmnY;26;ICX;105;[CR]");
        tmp.append("BasoX1;60;BasoY1;26;BasoX2;64;BasoY2;30;BasoX3;70;BasoY3;29;BasoX4;65;BasoY4;20;NHH;2;NHL;2;RLL;2;RLR;3;NLH;2;NLL;2;HLH;2;HLL;2;[CR]");
        tmp.append("END_RESULT;52796[CR]");
        this.parse(this.equipamento.arruma(tmp.toString()));
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        try {
            String[] exms;
            Statement st = Conexao.getStatement();
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(exames.split(" ", 0), mco_codigo);
            for (String s : exms = exames.split(" ", 0)) {
                this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, s, mco_codigo, int_codigo, null, 1);
            }
            Conexao.arquivaSQL();
            this.fireMensagemEnviada("Pedido(s) enviado(s) com sucesso para " + pac_nome, 0, 10000);
            this.equipamento.atualizarTabela(0);
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
            return "";
        }
    }

    private void abortarTransmissao() throws Exception {
        this.limpaDadosRequisicao();
        this.setPausa(5000);
        this.fireMensagemEnviada("Tempo esgotado ao transmitir dados ao equipamento", 1, 5000);
    }

    private void abortarRecepcao() throws Exception {
        this.limpaDadosRequisicao();
        this.setPausa(3000);
    }

    void limpaDadosRequisicao() {
        this.req_codigo = null;
        this.mco_codigo = null;
        this.rec_codigo = null;
        this.pac_nome = null;
        this.pac_sexo = null;
        this.req_idade = null;
        this.req_data = null;
        this.req_hora = null;
    }

    private void addListaRecebimento(String message) {
        this.threadRecebimento.addListaRecebimento(message);
        this.restartThreadRecebimento();
    }

    private void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            ArrayList<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento();
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        if (this.threadRecebimento != null) {
            this.threadRecebimento.start();
        }
    }

    private void aguardarProximoFrame() throws Exception {
        this.fireMensagemEnviada("Recebendo dados...", 0, 10000);
    }

    public List<String> checksum(String bufferMessage) {
        ArrayList<String> msgValidas = new ArrayList<String>();
        ArrayList<String> messages = new ArrayList<String>();
        bufferMessage = bufferMessage.replaceAll(String.valueOf('\n'), "");
        bufferMessage = bufferMessage.replaceAll(LINE, String.valueOf('\n'));
        bufferMessage = bufferMessage.replaceAll(String.valueOf('\r'), String.valueOf('\n'));
        for (String str : bufferMessage.split(this.getMsgStart())) {
            if (Funcoes.textoVazio(str) || !str.contains(this.getMsgEnd())) continue;
            messages.add(String.format("%s%s", this.getMsgStart(), str));
        }
        for (String message : messages) {
            byte cs1 = 0;
            byte cs2 = 0;
            int posBegin = message.indexOf(this.getMsgStart());
            String[] beginToken = message.substring(posBegin + this.getMsgStart().length(), posBegin + this.getMsgStart().length() + 5).split(":");
            if (beginToken.length >= 1 && beginToken[0].equals("0")) {
                msgValidas.add(message.substring(posBegin + 23, message.indexOf(this.getMsgEnd())));
                continue;
            }
            int posEnd = message.indexOf(this.getMsgEnd());
            int posEnterFinal = message.indexOf("\n", posEnd);
            String[] checkSumTransferred = message.substring(posEnterFinal).split(":");
            String msg = message;
            for (byte b : msg.getBytes()) {
                cs1 = (byte)(cs1 + b);
                cs2 = (byte)(cs2 + cs1);
            }
            String idMsg = "";
            msgValidas.add(msg);
        }
        return msgValidas;
    }

    private String verificaMensagem(String message) {
        int posBegin = message.indexOf(TOKEN_MSG_BEGIN);
        int posEnd = message.indexOf(TOKEN_MSG_END);
        String[] beginToken = message.substring(posBegin + TOKEN_MSG_BEGIN.length(), posBegin + TOKEN_MSG_BEGIN.length() + 7).split(":");
        String[] endToken = message.substring(posEnd + TOKEN_MSG_END.length(), posEnd + TOKEN_MSG_END.length() + 7).split(":");
        if (beginToken.length >= 2 && endToken.length >= 2 && beginToken[0].equals(endToken[0])) {
            if (beginToken[1].equals("1")) {
                return beginToken[0];
            }
            if (beginToken[1].equals("2")) {
                return "";
            }
        } else {
            return "";
        }
        return beginToken[0];
    }

    public void solicitarResultados() {
    }

    @Override
    public void handShakeCharReceived(char c) {
    }

    class ThreadRecebimento
    extends Thread {
        private ArrayList<String> listaRecebimento = new ArrayList();

        ThreadRecebimento() {
        }

        public ArrayList<String> getListaRecebimento() {
            return this.listaRecebimento;
        }

        public void addListaRecebimento(String message) {
            this.listaRecebimento.add(message);
        }

        public void addListaRecebimentos(ArrayList<String> messages) {
            this.listaRecebimento.addAll(messages);
        }

        @Override
        public void run() {
            try {
                while (this.listaRecebimento.size() > 0) {
                    String message = this.listaRecebimento.remove(0);
                    String resultado = InterfaceListener.this.parse(message);
                    if (resultado != null) {
                        InterfaceListener.this.fireMensagemEnviada(resultado, 0, 10000);
                    }
                    ThreadRecebimento.sleep(450L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

