/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.mykov360;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.InfoExameRequisicao;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.EncodingCharacters;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.ErrorCondition;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.Message;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.MessageParser;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageAckQ03;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageAckR01;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageDsrQ03;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageOrmO01;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageOrrO02;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageOruR01;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageQckQ02;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageQryQ02;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentDsp;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentMsa;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentObx;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentQak;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.TempoUtil;
import jalis.util.logger.ErrorLogger;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    private static final String RECEIVING_APPLICATION = "Mindray";
    private static final String MODELO = "Mykov360";
    private static final String MENSAGEM_ACEITA = "Mensagem aceita";
    private MessageParser messageParser;
    private Map<String, InfoExameRequisicao> examesEnviadosPorMid;
    private Map<String, InfoExameRequisicao> examesEnviadosPorSid;
    private ThreadRecebimento threadRecebimento = new ThreadRecebimento();

    public InterfaceListener() {
        this.messageParser = new MessageParser();
        this.examesEnviadosPorMid = new HashMap<String, InfoExameRequisicao>();
        this.examesEnviadosPorSid = new HashMap<String, InfoExameRequisicao>();
        this.threadRecebimento.start();
    }

    @Override
    public synchronized void dataChanged() {
        String message = this.getPortaCOM().removeInputString(this.getMsgEnd());
        if (!Funcoes.textoVazio(message) && this.messageParser.checkMessage(message)) {
            this.parse(message);
            if (this.getPortaCOM().getInputString().length() > 0) {
                this.dataChanged();
            }
        }
    }

    @Override
    public String parse(String text) {
        try {
            String[] messages = text.split(this.getMsgEnd());
            if (messages.length > 1) {
                for (String m : messages) {
                    m = m + this.getMsgEnd();
                    Message msg = this.messageParser.textToMessage(m);
                    this.mensagemRecebida(msg);
                }
            } else {
                Message message = this.messageParser.textToMessage(text);
                this.mensagemRecebida(message);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
            return "Erro ao efetuar o parse da mensagem";
        }
        return null;
    }

    private void mensagemRecebida(Message message) {
        switch (message.getType()) {
            case ORU_R01: {
                this.messageOruR01Recebida((MessageOruR01)message);
                break;
            }
            case QRY_Q02: {
                this.messageQryQ02Recebida((MessageQryQ02)message);
                break;
            }
            case ACK_Q03: {
                this.messageAckQ03Recebida((MessageAckQ03)message);
                break;
            }
            case ORM_O01: {
                this.messageOrmO01Recebida((MessageOrmO01)message);
                break;
            }
            default: {
                this.fireExcecaoEncontrada("Mensagem de tipo desconhecido recebida");
            }
        }
    }

    private void messageOruR01Recebida(MessageOruR01 oruR01) {
        MessageAckR01 ackR01 = new MessageAckR01();
        ackR01.getMsh().setApplicationAckType(oruR01.getMsh().getApplicationAckType());
        ackR01.getMsa().setAckCode(MessageSegmentMsa.AckCode.ACCEPTED);
        ackR01.getMsa().setTextMessage(MENSAGEM_ACEITA);
        ackR01.getMsa().setErrorCondition(ErrorCondition.MESSAGE_ACCEPTED);
        this.addListaRecebimento(oruR01);
        this.restartThreadRecebimento();
        this.enviaMensagem(oruR01.getMsh().getMessageControlId(), ackR01);
    }

    public void messageQryQ02Recebida(MessageQryQ02 qryQ02) {
        block19: {
            String messageId = qryQ02.getMsh().getMessageControlId();
            MessageQckQ02 qckQ02 = new MessageQckQ02();
            qckQ02.getMsa().setAckCode(MessageSegmentMsa.AckCode.ACCEPTED);
            qckQ02.getMsa().setTextMessage(MENSAGEM_ACEITA);
            qckQ02.getMsa().setErrorCondition(ErrorCondition.MESSAGE_ACCEPTED);
            qckQ02.getErr().setErrorCode(0);
            qckQ02.getQak().setQueryTag("SR");
            try {
                String tuboId = qryQ02.getQrd().getWhoSubjectFilter();
                if (this.tuboValido(tuboId)) {
                    String filCodigo = tuboId.substring(0, ParametrosGerais.getDigitosTuboFilial());
                    String reqCodigo = tuboId.substring(ParametrosGerais.getDigitosTuboFilial());
                    String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                    reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
                    DescritorCodigoEtiqueta etiqueta = DescritorCodigoEtiqueta.getDescritor(tuboId);
                    if (etiqueta != null) {
                        filCodigo = Funcoes.preencheZero(etiqueta.getFilial(), ParametrosGerais.getDigitosTuboFilial());
                        reqCodigo = Funcoes.preencheZero(etiqueta.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao());
                        recCodigo = Funcoes.preencheZero(etiqueta.getTubo(), ParametrosGerais.getDigitosTuboTubo());
                    }
                    Object[] req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 0);
                    PanelAbaAbstrata aba = this.equipamento.getTab(0);
                    String exames = "";
                    StringBuilder examesFilho = new StringBuilder();
                    if (req != null) {
                        exames = (String)req[aba.getColIndice("Exame")];
                    }
                    if (req == null && Funcoes.textoVazio(exames = this.getExames(filCodigo, reqCodigo, recCodigo, req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 1), aba = this.equipamento.getTab(1), exames, 1)) && req != null && !Funcoes.preencheZero((String)req[aba.getColIndice("Tubo")], ParametrosGerais.getDigitosTuboFilial()).equals(recCodigo)) {
                        exames = this.getExames(filCodigo, reqCodigo, (String)req[aba.getColIndice("Tubo")], req, aba, exames, 1);
                    }
                    if (req == null && Funcoes.textoVazio(exames = this.getExames(filCodigo, reqCodigo, recCodigo, req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 2), aba = this.equipamento.getTab(2), exames, 2)) && req != null && !Funcoes.preencheZero((String)req[aba.getColIndice("Tubo")], ParametrosGerais.getDigitosTuboFilial()).equals(recCodigo)) {
                        exames = this.getExames(filCodigo, reqCodigo, (String)req[aba.getColIndice("Tubo")], req, aba, exames, 2);
                    }
                    if (req == null) {
                        qckQ02.getQak().setQueryResponseStatus(MessageSegmentQak.QueryResponseStatus.NO_DATA_FOUND);
                        this.enviaMensagem(messageId, qckQ02);
                        return;
                    }
                    String mcoCodigo = (String)req[aba.getColIndice("C\u00f3d. Mat.")];
                    String intCodigo = (String)req[aba.getColIndice("Interface")];
                    String pacNome = (String)req[aba.getColIndice("Paciente")];
                    String pacIdade = (String)req[aba.getColIndice("Ide")];
                    String pacSexo = (String)req[aba.getColIndice("S")];
                    String recTuboPai = (String)req[aba.getColIndice("Tubo")];
                    String data = TempoUtil.getCurrentDateBr();
                    String hora = TempoUtil.getCurrentTime();
                    List<ExameMaterial> examesDaRequisicao = this.carregarListaExamesEMateriais(exames, mcoCodigo);
                    Date dataColeta = null;
                    ArrayList<ExameMaterial> examesParaEnviar = new ArrayList<ExameMaterial>();
                    for (ExameMaterial exameMaterial : examesDaRequisicao) {
                        if (dataColeta == null) {
                            dataColeta = BDUtil.getExmColeta(filCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial());
                        }
                        int situacao = this.getExameSituacao(Conexao.getStatement(), filCodigo, intCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial(), recCodigo);
                        boolean curva = BDUtil.isExameCurva(filCodigo, intCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial());
                        if (BDUtil.isExameDesmembrado(filCodigo, intCodigo, exameMaterial.getString(), mcoCodigo)) {
                            int sitFilho;
                            List<ExameMaterial> examesFilhos = Arrays.asList(BDUtil.getExamesFilhos(filCodigo, intCodigo, exameMaterial.getString(), mcoCodigo));
                            if (!(situacao != 0 && situacao != 1 || curva)) {
                                examesParaEnviar.addAll(examesFilhos);
                                continue;
                            }
                            if (curva) {
                                for (ExameMaterial exameFilho : examesFilhos) {
                                    sitFilho = BDUtil.getDesmSituacao(filCodigo, intCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial(), recTuboPai, exameFilho.getNomeExame(), exameFilho.getCodigoMaterial());
                                    String tuboFilho = BDUtil.getExameDesmembradoTubo(filCodigo, reqCodigo, recTuboPai, intCodigo, exameFilho.getNomeExame(), exameFilho.getCodigoMaterial());
                                    if (sitFilho != 0 && sitFilho != 1 && sitFilho != 3 || !Funcoes.preencheZero(tuboFilho, ParametrosGerais.getDigitosTuboTubo()).equals(recCodigo)) continue;
                                    examesFilho.append(exameFilho.getNomeExame()).append(" ");
                                    examesParaEnviar.add(exameFilho);
                                }
                                continue;
                            }
                            for (ExameMaterial exameFilho : examesFilhos) {
                                sitFilho = BDUtil.getDesmSituacao(filCodigo, intCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial(), recCodigo, exameFilho.getNomeExame(), exameFilho.getCodigoMaterial());
                                if (sitFilho != 3) continue;
                                examesParaEnviar.add(exameFilho);
                            }
                            continue;
                        }
                        if (!this.situacaoParaEnvio(situacao)) continue;
                        examesParaEnviar.add(exameMaterial);
                    }
                    Set<Integer> tests = this.carregarAlternativosParaEnviar(examesParaEnviar, filCodigo, mcoCodigo, intCodigo, reqCodigo, recCodigo);
                    if (tests.isEmpty()) {
                        qckQ02.getQak().setQueryResponseStatus(MessageSegmentQak.QueryResponseStatus.NO_DATA_FOUND);
                        this.enviaMensagem(messageId, qckQ02);
                        this.fireExcecaoEncontrada(tuboId + " - Nenhum exame enviado.");
                    } else {
                        InfoExameRequisicao infoExameRequisicao = new InfoExameRequisicao(filCodigo, reqCodigo, mcoCodigo, recCodigo, pacNome, pacIdade, pacSexo, data, hora, exames);
                        infoExameRequisicao.setInterface(intCodigo);
                        if (!Funcoes.preencheZero(recTuboPai, ParametrosGerais.getDigitosTuboTubo()).equals(recCodigo) && !Funcoes.textoVazio(examesFilho.toString().trim())) {
                            infoExameRequisicao.setTuboPai(recTuboPai);
                            infoExameRequisicao.setExamesFilho(examesFilho.toString().trim());
                            infoExameRequisicao.setCurva(true);
                        }
                        this.examesEnviadosPorSid.put(tuboId, infoExameRequisicao);
                        this.examesEnviadosPorMid.put(messageId, infoExameRequisicao);
                        String pacNasc = "";
                        pacNome = StringUtil.removerAcentos(pacNome);
                        if (!Funcoes.textoVazio(pacNome) && pacNome.length() > 30) {
                            pacNome = pacNome.substring(0, 30);
                        }
                        MessageDsrQ03 dsrQ03 = this.construirMessageDsrQ03(pacNome, pacNasc, pacSexo, tuboId, tests);
                        qckQ02.getQak().setQueryResponseStatus(MessageSegmentQak.QueryResponseStatus.DATA_FOUND);
                        this.enviaMensagem(messageId, qckQ02);
                        this.enviaMensagem(messageId, dsrQ03);
                    }
                    break block19;
                }
                qckQ02.getQak().setQueryResponseStatus(MessageSegmentQak.QueryResponseStatus.APPLICATION_REJECT);
                this.enviaMensagem(messageId, qckQ02);
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
            }
        }
    }

    private MessageDsrQ03 construirMessageDsrQ03(String pacNome, String pacNasc, String pacSexo, String tuboId, Set<Integer> tests) {
        MessageDsrQ03 dsrQ03 = new MessageDsrQ03();
        dsrQ03.getMsa().setAckCode(MessageSegmentMsa.AckCode.ACCEPTED);
        dsrQ03.getMsa().setTextMessage(MENSAGEM_ACEITA);
        dsrQ03.getMsa().setErrorCondition(ErrorCondition.MESSAGE_ACCEPTED);
        dsrQ03.getErr().setErrorCode(0);
        dsrQ03.getQak().setQueryResponseStatus(MessageSegmentQak.QueryResponseStatus.DATA_FOUND);
        dsrQ03.getQak().setQueryTag("SR");
        dsrQ03.addDsp(new MessageSegmentDsp());
        dsrQ03.addDsp(new MessageSegmentDsp());
        dsrQ03.addDsp(new MessageSegmentDsp(pacNome));
        dsrQ03.addDsp(new MessageSegmentDsp(pacNasc));
        dsrQ03.addDsp(new MessageSegmentDsp(pacSexo));
        dsrQ03.addDsp(new MessageSegmentDsp());
        dsrQ03.addDsp(new MessageSegmentDsp());
        dsrQ03.addDsp(new MessageSegmentDsp());
        dsrQ03.addDsp(new MessageSegmentDsp());
        dsrQ03.addDsp(new MessageSegmentDsp());
        dsrQ03.addDsp(new MessageSegmentDsp());
        dsrQ03.addDsp(new MessageSegmentDsp());
        dsrQ03.addDsp(new MessageSegmentDsp());
        dsrQ03.addDsp(new MessageSegmentDsp());
        dsrQ03.addDsp(new MessageSegmentDsp());
        dsrQ03.addDsp(new MessageSegmentDsp());
        dsrQ03.addDsp(new MessageSegmentDsp());
        dsrQ03.addDsp(new MessageSegmentDsp());
        dsrQ03.addDsp(new MessageSegmentDsp());
        dsrQ03.addDsp(new MessageSegmentDsp());
        dsrQ03.addDsp(new MessageSegmentDsp(tuboId));
        dsrQ03.addDsp(new MessageSegmentDsp());
        dsrQ03.addDsp(new MessageSegmentDsp());
        dsrQ03.addDsp(new MessageSegmentDsp());
        dsrQ03.addDsp(new MessageSegmentDsp());
        dsrQ03.addDsp(new MessageSegmentDsp());
        dsrQ03.addDsp(new MessageSegmentDsp());
        dsrQ03.addDsp(new MessageSegmentDsp());
        tests.forEach(test -> dsrQ03.addDsp(new MessageSegmentDsp(test + "^^^")));
        return dsrQ03;
    }

    private Set<Integer> carregarAlternativosParaEnviar(List<ExameMaterial> examesParaEnviar, String filCodigo, String mcoCodigo, String intCodigo, String reqCodigo, String recCodigo) throws SQLException {
        HashSet<Integer> tests = new HashSet<Integer>();
        for (ExameMaterial exameParaEnviar : examesParaEnviar) {
            String test = BDUtil.getExmCodigoAlternativo(filCodigo, exameParaEnviar.getNomeExame(), mcoCodigo, intCodigo);
            if (test == null || test.trim().isEmpty()) continue;
            if (!Funcoes.isNumeric(test)) {
                this.fireExcecaoEncontrada(String.format("Amostra com exame configurado errado %s %s %s Alternativo %s corrija o Alternativo", filCodigo, reqCodigo, recCodigo, test));
                continue;
            }
            tests.add(Integer.valueOf(test));
        }
        return tests;
    }

    private List<ExameMaterial> carregarListaExamesEMateriais(String exames, String mcoCodigo) {
        ArrayList<ExameMaterial> examesDaRequisicao = new ArrayList<ExameMaterial>();
        for (String exame : exames.trim().split(" ", 0)) {
            examesDaRequisicao.add(new ExameMaterial(exame, new Integer(mcoCodigo)));
        }
        return examesDaRequisicao;
    }

    private boolean tuboValido(String tuboId) {
        int digitosCodigoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
        return tuboId != null && !tuboId.trim().isEmpty() && !tuboId.equals("null") && Funcoes.isNumeric(tuboId) && tuboId.length() == digitosCodigoTubo;
    }

    private void messageOrmO01Recebida(MessageOrmO01 ormO01) {
        String messageId = ormO01.getMsh().getMessageControlId();
        MessageOrrO02 orrO02 = new MessageOrrO02();
        try {
            String tuboId = ormO01.getOrc().getFilterOrderNumber();
            if (this.tuboValido(tuboId)) {
                String filCodigo = tuboId.substring(0, ParametrosGerais.getDigitosTuboFilial());
                String reqCodigo = tuboId.substring(ParametrosGerais.getDigitosTuboFilial());
                String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
                Object[] req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 0);
                PanelAbaAbstrata aba = this.equipamento.getTab(0);
                if (req == null) {
                    req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 1);
                    aba = this.equipamento.getTab(1);
                }
                if (req == null) {
                    req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 2);
                    aba = this.equipamento.getTab(2);
                }
                if (req == null) {
                    orrO02.getMsa().setAckCode(MessageSegmentMsa.AckCode.REJECTED);
                    this.enviaMensagem(messageId, orrO02);
                    return;
                }
                String exames = (String)req[aba.getColIndice("Exame")];
                String mcoCodigo = (String)req[aba.getColIndice("C\u00f3d. Mat.")];
                String intCodigo = (String)req[aba.getColIndice("Interface")];
                String pacNome = (String)req[aba.getColIndice("Paciente")];
                String pacIdade = (String)req[aba.getColIndice("Ide")];
                String pacSexo = (String)req[aba.getColIndice("S")];
                List<ExameMaterial> examesDaRequisicao = this.carregarListaExamesEMateriais(exames, mcoCodigo);
                List<ExameMaterial> examesParaEnviar = this.carregarExamesParaEnviar(examesDaRequisicao, filCodigo, intCodigo, reqCodigo, mcoCodigo, recCodigo);
                HashSet<String> tests = new HashSet<String>();
                for (ExameMaterial exameParaEnviar : examesParaEnviar) {
                    String test = BDUtil.getExmCodigoAlternativo(filCodigo, exameParaEnviar.getNomeExame(), mcoCodigo, intCodigo);
                    if (test == null || test.trim().isEmpty()) continue;
                    tests.add(test);
                }
                if (tests.isEmpty()) {
                    orrO02.getMsa().setAckCode(MessageSegmentMsa.AckCode.REJECTED);
                    this.enviaMensagem(messageId, orrO02);
                    this.fireExcecaoEncontrada(tuboId + " - Nenhum exame enviado.");
                } else {
                    String data = TempoUtil.getCurrentDateBr();
                    String hora = TempoUtil.getCurrentTime();
                    InfoExameRequisicao exame = new InfoExameRequisicao(filCodigo, reqCodigo, mcoCodigo, recCodigo, pacNome, pacIdade, pacSexo, data, hora, exames);
                    this.examesEnviadosPorSid.put(tuboId, exame);
                    this.examesEnviadosPorMid.put(messageId, exame);
                    pacNome = StringUtil.removerAcentos(pacNome);
                    if (!Funcoes.textoVazio(pacNome) && pacNome.length() > 30) {
                        pacNome = pacNome.substring(0, 30);
                    }
                    StringBuilder pacIdentifier = new StringBuilder();
                    pacIdentifier.append(filCodigo).append(reqCodigo).append("^^^^");
                    Date dataHoraRequisicao = new Date();
                    orrO02.getMsa().setAckCode(MessageSegmentMsa.AckCode.ACCEPTED);
                    orrO02.getPid().setId(1);
                    orrO02.getPid().setPatientName("^" + pacNome);
                    orrO02.getPid().setSex(pacSexo);
                    orrO02.getPid().setPatientIdentifierList(pacIdentifier.toString());
                    orrO02.getOrc().setOrderControl("AF");
                    orrO02.getOrc().setPlaceOrderNumber(ormO01.getOrc().getFilterOrderNumber());
                    orrO02.getObr().setPlacerOrderNumber(ormO01.getOrc().getFilterOrderNumber());
                    orrO02.getObr().setRequestDateTime(dataHoraRequisicao);
                    orrO02.getObr().setCollectorIdentifier("MA");
                    orrO02.getObr().setSpecimenReceiveDateTime(dataHoraRequisicao);
                    orrO02.getObr().setDiagnosticServSect("HM");
                    this.constuirMessageSegmentObx(orrO02, tests);
                    this.enviaMensagem(messageId, orrO02);
                    this.alteraSituacaoParaPendentes(this.examesEnviadosPorSid.get(tuboId));
                    this.examesEnviadosPorSid.remove(tuboId);
                }
            } else {
                orrO02.getMsa().setAckCode(MessageSegmentMsa.AckCode.REJECTED);
                this.enviaMensagem(messageId, orrO02);
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
        }
    }

    private void constuirMessageSegmentObx(MessageOrrO02 orrO02, Set<String> tests) {
        MessageSegmentObx obx = new MessageSegmentObx();
        obx.setId(1);
        obx.setValueType(MessageSegmentObx.ValueType.IS);
        obx.setObservationId("08001^Take Mode^99MRC");
        obx.setObservationValue("A");
        obx.setObserveResultStatus("F");
        orrO02.addObx(obx);
        obx = new MessageSegmentObx();
        obx.setId(2);
        obx.setValueType(MessageSegmentObx.ValueType.IS);
        obx.setObservationId("08002^Blood Mode^99MRC");
        obx.setObservationValue("W");
        obx.setObserveResultStatus("F");
        orrO02.addObx(obx);
        for (String alternativo : tests) {
            obx = new MessageSegmentObx();
            obx.setId(3);
            obx.setValueType(MessageSegmentObx.ValueType.IS);
            obx.setObservationId("08003^Test Mode^99MRC");
            obx.setObservationValue(alternativo);
            obx.setObserveResultStatus("F");
            orrO02.addObx(obx);
        }
        obx = new MessageSegmentObx();
        obx.setId(4);
        obx.setValueType(MessageSegmentObx.ValueType.IS);
        obx.setObservationId("01002^Ref Group^99MRC");
        obx.setObservationValue("Geral");
        obx.setObserveResultStatus("F");
        orrO02.addObx(obx);
    }

    private List<ExameMaterial> carregarExamesParaEnviar(List<ExameMaterial> examesDaRequisicao, String filCodigo, String intCodigo, String reqCodigo, String mcoCodigo, String recCodigo) throws SQLException {
        ArrayList<ExameMaterial> examesParaEnviar = new ArrayList<ExameMaterial>();
        for (ExameMaterial exame : examesDaRequisicao) {
            int situacao = this.getExameSituacao(Conexao.getStatement(), filCodigo, intCodigo, reqCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), recCodigo);
            if (BDUtil.isExameDesmembrado(filCodigo, intCodigo, exame.getString(), mcoCodigo)) {
                List<ExameMaterial> examesFilhos = Arrays.asList(BDUtil.getExamesFilhos(filCodigo, intCodigo, exame.getString(), mcoCodigo));
                if (situacao == 0 || situacao == 1) {
                    examesParaEnviar.addAll(examesFilhos);
                    continue;
                }
                for (ExameMaterial exameFilho : examesFilhos) {
                    int sitFilho = BDUtil.getDesmSituacao(filCodigo, intCodigo, reqCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), recCodigo, exameFilho.getNomeExame(), exameFilho.getCodigoMaterial());
                    if (sitFilho != 3) continue;
                    examesParaEnviar.add(exameFilho);
                }
                continue;
            }
            if (!this.situacaoParaEnvio(situacao)) continue;
            examesParaEnviar.add(exame);
        }
        return examesParaEnviar;
    }

    private boolean situacaoParaEnvio(int situacao) {
        return situacao == 0 || situacao == 1 || situacao == 3;
    }

    private String getExames(String filCodigo, String reqCodigo, String recCodigo, Object[] req, PanelAbaAbstrata aba, String exames, int abaSelecionada) {
        StringBuilder sb = new StringBuilder(exames);
        if (req != null) {
            sb.append(" ");
            List<Object[]> reqs = this.getTodasRequisicaoAba(filCodigo, reqCodigo, recCodigo, abaSelecionada);
            for (Object[] r : reqs) {
                sb.append((String)r[aba.getColIndice("Exame")]).append(" ");
            }
        }
        return sb.toString().trim();
    }

    private void messageAckQ03Recebida(MessageAckQ03 ackQ03) {
        String messageId = ackQ03.getMsa().getMessageControlId();
        if (messageId != null) {
            switch (ackQ03.getMsa().getAckCode()) {
                case ACCEPTED: {
                    this.alteraSituacaoParaPendentes(this.examesEnviadosPorMid.remove(messageId));
                    break;
                }
                case ERROR: 
                case REJECTED: {
                    this.fireExcecaoEncontrada("Erro ao enviar " + ackQ03.toString());
                }
            }
        }
    }

    private void enviaMensagem(String id, Message mensagem) {
        try {
            char fieldSeparator = '|';
            mensagem.getMsh().setEncodingCharacters(new EncodingCharacters('^', '~', '\\', '&'));
            mensagem.getMsh().setReceivingApplication(RECEIVING_APPLICATION);
            mensagem.getMsh().setReceivingFacility(MODELO);
            mensagem.getMsh().setDateTime(new Date());
            mensagem.getMsh().setProcessingId("P");
            mensagem.getMsh().setVersionId("2.3.1");
            mensagem.getMsh().setCharacterSet("ASCII");
            mensagem.setId(id);
            this.getPortaCOM().write(this.messageParser.messageToText(mensagem, fieldSeparator));
        }
        catch (IOException e) {
            ErrorLogger.mostraMensagem(null, "Falha na comunica\u00e7\u00e3o com o equipamento.", e.getStackTrace());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void alteraSituacaoParaPendentes(InfoExameRequisicao exameRequisicao) {
        Statement st = Conexao.getStatement();
        try {
            if (exameRequisicao != null && exameRequisicao.getExames() != null) {
                for (String exame : exameRequisicao.getExames().split(" ")) {
                    int situacao;
                    String codFilial = exameRequisicao.getFilial();
                    String codRequisicao = exameRequisicao.getCodigo();
                    String codMaterial = exameRequisicao.getMaterial();
                    String codRecipiente = exameRequisicao.getRecipiente();
                    String recTuboPai = exameRequisicao.getTuboPai();
                    String codInterface = exameRequisicao.getInterface();
                    if (this.exameCurva(recTuboPai, exameRequisicao)) {
                        recTuboPai = Funcoes.preencheZero(recTuboPai, ParametrosGerais.getDigitosTuboTubo());
                        codInterface = this.getIntCodigo(codFilial, codRequisicao, recTuboPai, exame, codMaterial);
                        situacao = -1;
                        String[] stringArray = exameRequisicao.getExamesFilho().split(" ");
                        int n = stringArray.length;
                        for (int i = 0; i < n; ++i) {
                            String exameFilho;
                            situacao = BDUtil.getDesmSituacao(codFilial, codInterface, codRequisicao, exame, codMaterial, recTuboPai, exameFilho = stringArray[i], codMaterial);
                            BDUtil.setExmSituacaoFilho(st, codFilial, codInterface, codRequisicao, exame, codMaterial, exameFilho, codMaterial, recTuboPai, situacao < 2 ? 1 : 3);
                        }
                        situacao = this.getExameSituacao(st, codFilial, codInterface, codRequisicao, exame, codMaterial, recTuboPai);
                        if (BDUtil.isGrupoInteiroPendente(codFilial, codInterface, codRequisicao, exame, codMaterial, recTuboPai)) {
                            this.atualizarSituacaoExame(st, codFilial, codRequisicao, recTuboPai, exame, codMaterial, codInterface, null, situacao < 2 ? 1 : 3);
                        }
                    } else {
                        if (codInterface == null) {
                            codInterface = this.getIntCodigo(codFilial, codRequisicao, codRecipiente, exame, codMaterial);
                        }
                        this.atualizarSituacaoExame(st, codFilial, codRequisicao, codRecipiente, exame, codMaterial, codInterface, null, (situacao = this.getExameSituacao(st, codFilial, codInterface, codRequisicao, exame, codMaterial, codRecipiente)) < 2 ? 1 : 3);
                    }
                    this.firePacienteEnviado(exameRequisicao.getCodigo(), exameRequisicao.getNome(), exameRequisicao.getSexo(), exameRequisicao.getIdade(), exameRequisicao.getData(), exameRequisicao.getHora(), exameRequisicao.getExames());
                }
            }
            Conexao.arquivaSQL();
            this.fireAtualizarTabela(0);
        }
        catch (Exception e) {
            try {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    private boolean exameCurva(String recTuboPai, InfoExameRequisicao exameRequisicao) {
        return recTuboPai != null && exameRequisicao.isCurva() != false;
    }

    public void addListaRecebimento(MessageOruR01 message) {
        this.threadRecebimento.addListaRecebimento(message);
    }

    public void restartThreadRecebimento() {
        if (this.threadRecebimento == null || this.threadRecebimento.isInterrupted() || !this.threadRecebimento.isAlive()) {
            if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
                List<MessageOruR01> lista = this.threadRecebimento.getListaRecebimento();
                this.threadRecebimento = new ThreadRecebimento();
                this.threadRecebimento.addListaRecebimentos(lista);
            }
            if (this.threadRecebimento != null) {
                this.threadRecebimento.start();
            }
        }
    }

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
    }

    @Override
    public void handShakeCharReceived(char c) {
    }

    @Override
    public String getMsgEnd() {
        return String.valueOf('\u001c') + String.valueOf('\r');
    }

    @Override
    public String getMsgStart() {
        return String.valueOf('\u000b');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String enviarRequisicao(String pacNome, String pacSexo, String pacIdade, String data, String hora, String rackposition, String prioridade, String filCodigo, String intCodigo, String reqCodigo, String mcoCodigo, String recCodigo, String exames, String acao) {
        if (acao.equals("A")) {
            Statement st = Conexao.getStatement();
            try {
                String[] stringArray = exames.split(" ");
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String exame;
                    int situacao = this.getExameSituacao(st, filCodigo, intCodigo, reqCodigo, exame = stringArray[i], mcoCodigo, recCodigo);
                    this.atualizarSituacaoExame(st, filCodigo, reqCodigo, recCodigo, exame, mcoCodigo, intCodigo, null, situacao < 2 ? 1 : 3);
                }
                Conexao.arquivaSQL();
                this.fireAtualizarTabela();
            }
            catch (Exception e) {
                try {
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
        }
        return null;
    }

    @Override
    public void teste() {
        this.resultado();
    }

    private void resultado() {
        String idAmostra = JOptionPane.showInputDialog("Informe o Id da amostra");
        StringBuilder message = new StringBuilder();
        message.append("[SB]MSH|^~\\&|||||20230615124458||ORU^R01|1|P|2.3.1||||0||ASCII|||[CR]");
        message.append("PID|22||||Maisa[SP]Krewer|||F|||||||||||||||||||||||[CR]");
        message.append("OBR|22|" + idAmostra + "|1|^|N|20230615095255|20230615095255|||1^1||||20230615095255|Outr|||||||||||||||||||||||||||||||||[CR]");
        message.append("OBX|1|NM|8|Colesterol|135.855632|mg/dL|-|N|||F||135.855632|20230615100900|||0||[CR]");
        message.append("OBX|2|NM|9|Creatinina|0.865698|mg/dL|-|N|||F||0.865698|20230615101015|||0|SLP|[CR]");
        message.append("OBX|4|NM|15|HDL|125.856193|mg/dL|-|N|||F||125.856193|20230615101501|||0||[CR]");
        message.append("OBX|5|NM|22|TRIG|88.710616|mg/dL|-|N|||F||88.710616|20230615100930|||0||[CR]");
        message.append("[EB][CR]");
        this.parse(this.equipamento.arruma(message.toString()));
    }

    class ThreadRecebimento
    extends Thread {
        private ArrayList<MessageOruR01> listaRecebimento = new ArrayList();

        ThreadRecebimento() {
        }

        public List<MessageOruR01> getListaRecebimento() {
            return this.listaRecebimento;
        }

        public void addListaRecebimento(MessageOruR01 message) {
            this.listaRecebimento.add(message);
        }

        public void addListaRecebimentos(List<MessageOruR01> messages) {
            this.listaRecebimento.addAll(messages);
        }

        @Override
        public void run() {
            try {
                while (!this.listaRecebimento.isEmpty()) {
                    MessageOruR01 message = this.listaRecebimento.remove(0);
                    this.processaMensagem(message);
                    ThreadRecebimento.sleep(450L);
                }
            }
            catch (InterruptedException e) {
                ErrorLogger.mostraMensagem(null, "Falha no processamento da ThreadRecebimento", e.getStackTrace(), "Mykov360.InterfaceListener.ThreadRecebimento");
                Thread.currentThread().interrupt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processaMensagem(MessageOruR01 oruR01) {
            Statement st;
            block7: {
                st = Conexao.getStatement();
                try {
                    int digitosCodigoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
                    String tuboId = oruR01.getObr().getPlacerOrderNumber();
                    if (!this.tuboValido(tuboId, digitosCodigoTubo)) break block7;
                    String filCodigo = tuboId.substring(0, ParametrosGerais.getDigitosTuboFilial());
                    String reqCodigo = tuboId.substring(ParametrosGerais.getDigitosTuboFilial());
                    String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                    reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
                    DescritorCodigoEtiqueta etiqueta = DescritorCodigoEtiqueta.getDescritor(tuboId);
                    if (etiqueta != null) {
                        filCodigo = Funcoes.preencheZero(etiqueta.getFilial(), ParametrosGerais.getDigitosTuboFilial());
                        reqCodigo = Funcoes.preencheZero(etiqueta.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao());
                        recCodigo = Funcoes.preencheZero(etiqueta.getTubo(), ParametrosGerais.getDigitosTuboTubo());
                    }
                    this.processarExames(st, oruR01, filCodigo, reqCodigo, recCodigo);
                    Conexao.arquivaSQL();
                    InterfaceListener.this.fireAtualizarTabela();
                }
                catch (Exception e) {
                    try {
                        try {
                            Conexao.anulaSQL();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                    }
                    catch (Throwable throwable) {
                        Conexao.fecharStatement(st);
                        throw throwable;
                    }
                    Conexao.fecharStatement(st);
                }
            }
            Conexao.fecharStatement(st);
        }

        private boolean tuboValido(String tuboId, int digitosCodigoTubo) {
            return tuboId != null && tuboId.length() == digitosCodigoTubo && Funcoes.isNumeric(tuboId);
        }

        private void processarExames(Statement st, MessageOruR01 oruR01, String filCodigo, String reqCodigo, String recCodigo) throws Exception {
            for (MessageSegmentObx obx : oruR01.getObxList()) {
                String emiAlternativo = String.valueOf(obx.getObservationId());
                String intCodigo = InterfaceListener.this.getIntCodigo(filCodigo, reqCodigo, recCodigo, emiAlternativo);
                ExameMaterial exame = InterfaceListener.this.getReqExameLIS(filCodigo, intCodigo, reqCodigo, recCodigo, emiAlternativo);
                if (exame == null) continue;
                HashMap<String, Object> dados = new HashMap<String, Object>();
                ArrayList<String> flags = new ArrayList<String>();
                if (obx.getAbnormalFlag() != null) {
                    flags.add(obx.getAbnormalFlag().toString());
                }
                int sit = InterfaceListener.this.getExameSituacao(st, filCodigo, intCodigo, reqCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), recCodigo);
                String campo = this.carregarCampo(obx, sit);
                String resultado = this.carregarResultado(obx, filCodigo, exame, intCodigo, reqCodigo);
                dados.put(campo, resultado);
                InterfaceListener.this.atualizarDadosExame(st, filCodigo, reqCodigo, recCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), intCodigo, dados, flags);
            }
        }

        private String carregarCampo(MessageSegmentObx obx, int sit) {
            String campo = "resultado_quantitativo";
            if (obx.getValueType().equals((Object)MessageSegmentObx.ValueType.NUMERIC)) {
                String string = campo = sit < 3 ? "resultado_quantitativo" : "repeticao_quantitativo";
            }
            if (obx.getValueType().equals((Object)MessageSegmentObx.ValueType.STRING)) {
                campo = sit < 3 ? "resultado_qualitativo" : "repeticao_qualitativo";
            }
            return campo;
        }

        private String carregarResultado(MessageSegmentObx obx, String filCodigo, ExameMaterial exame, String intCodigo, String reqCodigo) {
            String resultado = "";
            if (obx.getValueType().equals((Object)MessageSegmentObx.ValueType.NUMERIC)) {
                resultado = obx.getObservationValue();
                resultado = InterfaceListener.this.arrendondaValor(resultado, filCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), intCodigo, reqCodigo);
                resultado = resultado.replace('.', ',');
            }
            if (obx.getValueType().equals((Object)MessageSegmentObx.ValueType.STRING)) {
                resultado = obx.getObservationValue();
            }
            return resultado;
        }
    }
}

