/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.miura200;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.interfaces.miura200.InterfaceListener;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMRecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public class RecordParser
extends ASTMRecordParser {
    @Override
    protected void trataHeaderRecord(String record) {
        super.trataHeaderRecord(record);
        ((InterfaceListener)this.equip).limparWorklistEnvio();
    }

    @Override
    protected void trataOrderRecord(String record) throws Exception {
        if (this.exame_atual != null && this.exame_atual.get(INT_CODIGO) != null) {
            this.salvaExame(this.exame_atual);
        }
        this.exame_atual = new HashMap();
        Hashtable<Integer, String> order_fields = ASTMStandard.parseDefaultOrderRecord(record);
        this.exame_atual.put(ACTION_CODE, order_fields.get(ASTMStandard.ORDER_FIELD_ACTION_CODE));
        this.exame_atual.put(REPORT_TYPE, order_fields.get(ASTMStandard.ORDER_FIELD_REPORT_TYPE));
        String instSID = (String)order_fields.get(ASTMStandard.ORDER_FIELD_SYSTEM_SID);
        Map<Integer, String> sys_sample_id = this.equip.parseOrderSystemSID(instSID);
        String req_codigo = (String)order_fields.get(ASTMStandard.ORDER_FIELD_SAMPLE_ID);
        if (req_codigo == null || req_codigo.equals("")) {
            req_codigo = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_ID);
        }
        try {
            Long.parseLong(req_codigo);
        }
        catch (Exception ex) {
            StringBuilder msg = new StringBuilder();
            msg.append("Resultados recebidos para requisi\u00e7\u00e3o n\u00e3o existente ou n\u00e3o interfaceada: ");
            msg.append(req_codigo);
            this.equip.fireExcecaoEncontrada(msg.toString());
            this.exame_atual = null;
            return;
        }
        int qtde = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
        req_codigo = Funcoes.preencheZero(req_codigo, qtde);
        String rack_id = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_RACK_ID);
        String rack_pos = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_RACK_POS);
        this.exame_atual.put("rack_position", rack_id != null ? rack_id + (rack_pos != null ? "-" + rack_pos : "") : rack_pos);
        String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
        String rec_codigo = req_codigo.substring(req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
        req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial(), req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
        this.exame_atual.put(FIL_CODIGO, fil_codigo);
        this.exame_atual.put(REC_CODIGO, rec_codigo);
        this.exame_atual.put(REQ_CODIGO, req_codigo);
    }

    @Override
    protected void trataResultRecord(String record) throws SQLException {
        int sit;
        String resultado;
        if (this.exame_atual == null) {
            return;
        }
        String action_code = (String)this.exame_atual.get(ACTION_CODE);
        String report_type = (String)this.exame_atual.get(REPORT_TYPE);
        if (action_code != null) {
            this.equip.getClass();
            if (action_code.equals("Q")) {
                this.exame_atual = null;
                return;
            }
        }
        if (report_type != null) {
            this.equip.getClass();
            if (report_type.equals("X")) {
                this.exame_atual = null;
                return;
            }
        }
        Hashtable result_fields = ASTMStandard.parseDefaultResultRecord(record);
        Map<Integer, String> components = this.equip.parseOrderTestIDField((String)result_fields.get(ASTMStandard.RESULT_FIELD_TEST_ID));
        String emi_alternativo = components.get(this.equip.TEST_ITEM_NUMBER);
        String fil_codigo = this.exame_atual.get(FIL_CODIGO).toString();
        String rec_codigo = this.exame_atual.get(REC_CODIGO).toString();
        String req_codigo = this.exame_atual.get(REQ_CODIGO).toString();
        Statement st = Conexao.getStatement();
        String int_codigo = this.equip.getIntCodigo(fil_codigo, req_codigo, rec_codigo, emi_alternativo);
        if (int_codigo == null) {
            int_codigo = BDUtil.getInterfaceExameAlternativo(fil_codigo, req_codigo, rec_codigo, emi_alternativo);
        }
        if (int_codigo == null) {
            this.equip.fireExcecaoEncontrada("C\u00f3digo do interfaceamento do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo + " n\u00e3o localizado.");
            this.exame_atual = null;
            return;
        }
        ExameMaterial exame = this.equip.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo);
        this.exame_atual.put(INT_CODIGO, int_codigo);
        if (exame == null) {
            this.equip.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
            this.exame_atual = null;
            return;
        }
        this.exame_atual.put(EXA_CODIGO, exame.getNomeExame());
        this.exame_atual.put(MCO_CODIGO, exame.getCodigoMaterial());
        String exa_codigo = exame.getNomeExame();
        String mco_codigo = exame.getCodigoMaterial();
        String result_status = (String)result_fields.get(ASTMStandard.RESULT_FIELD_RESULT_STATUS);
        if (result_status != null) {
            this.equip.getClass();
            if (!result_status.equals("F")) {
                this.equip.getClass();
                if (!result_status.equals("R")) {
                    this.exame_atual = null;
                    return;
                }
            }
        }
        if ((resultado = (String)result_fields.get(ASTMStandard.RESULT_FIELD_MEASUREMENT_VALUE)).startsWith(".")) {
            resultado = "0" + resultado;
        }
        if (resultado.charAt(resultado.length() - 1) == '.') {
            resultado = resultado + "0";
        }
        resultado = this.equip.arrendondaValor(resultado, fil_codigo, exa_codigo, mco_codigo, int_codigo);
        this.equip.getClass();
        if (result_status.equals("F")) {
            resultado = resultado.replaceAll("\\.", ",");
        }
        String campo = (sit = this.equip.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo)) < 3 ? "resultado_quantitativo" : "repeticao_quantitativo";
        this.exame_atual.put(campo, resultado);
        String flags = (String)result_fields.get(ASTMStandard.RESULT_FIELD_ABNORMAL_FLAGS);
        if (flags != null && !flags.equals("")) {
            this.exame_atual.put("flag_alerta", flags);
        }
        if (this.exame_atual != null) {
            try {
                String filial = (String)this.exame_atual.get(FIL_CODIGO);
                String requisicao = (String)this.exame_atual.get(REQ_CODIGO);
                String tubo = (String)this.exame_atual.get(REC_CODIGO);
                this.salvaExame(this.exame_atual);
                this.exame_atual.put(FIL_CODIGO, filial);
                this.exame_atual.put(REQ_CODIGO, requisicao);
                this.exame_atual.put(REC_CODIGO, tubo);
                this.exame_atual.remove(campo);
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            }
        }
    }

    @Override
    protected void trataTerminationRecord() throws Exception {
        this.exame_atual = null;
    }
}

