/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.miura200;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.interfaces.miura200.RecordParser;
import jalis.laboratorio.interfaceamento.interfaces.miurahostquery.InterfaceConfiguracao;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.interfaceamento.padroes.astm.InterfaceASTMListener;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.interfaceamento.util.TestesInterface;
import jalis.laboratorio.interfaceamento.util.ThreadRecebimento;
import jalis.util.CodString;
import jalis.util.Funcoes;
import jalis.util.MemoryList;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class InterfaceListener
extends InterfaceASTMListener {
    private ThreadRecebimento threadRecebimento;
    private List<String> request = new ArrayList<String>();
    protected boolean hostQuery = false;
    private InterfaceConfiguracao configuracao = new InterfaceConfiguracao();

    public InterfaceListener() {
        RecordParser record = new RecordParser();
        record.setInterfaceASTMListener(this);
        super.setASTMRecordParser(record);
        this.MAX_PATIENT_NAME_CHARS = 100;
        this.HOST_NAME = "HOST-1";
        this.threadRecebimento = new ThreadRecebimento(this);
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        this.configuracao.setXmlVariaveis(c.getVariaveisConfiguracao());
    }

    @Override
    public void responderRequest(String starting_range, String ending_range, String test_id) {
        try {
            String sampleId = starting_range.trim();
            this.hostQuery = true;
            if (!Funcoes.textoVazio(sampleId)) {
                String amostra;
                ArrayList<Object> amostras = new ArrayList<String>();
                if (sampleId.contains("\\")) {
                    amostras = StringUtil.explode(sampleId, "\\");
                } else {
                    amostras.add(sampleId);
                }
                if (amostras != null && amostras.size() == 1 && !Funcoes.textoVazio(amostra = (String)amostras.get(0)) && amostra.equalsIgnoreCase("ALL")) {
                    amostras.remove(0);
                    ArrayList arrayList = this.getExamesAba(0);
                    if (arrayList != null && arrayList.size() > 0) {
                        PanelAbaAbstrata aba = this.equipamento.getTab(0);
                        for (Object linha : arrayList) {
                            if (!(linha instanceof Object[])) continue;
                            Object[] a = (Object[])linha;
                            String req = (String)a[aba.getColIndice("C\u00f3digo")];
                            String tubo = (String)a[aba.getColIndice("Tubo")];
                            this.request.add(req + Funcoes.preencheZero(tubo, ParametrosGerais.getDigitosTuboTubo()));
                        }
                    } else {
                        this.fireExcecaoEncontrada(String.format("Nenhuma requisi\u00e7\u00e3o encontrada para %s ", sampleId));
                    }
                }
                if (amostras != null) {
                    for (String string : amostras) {
                        if (Funcoes.textoVazio(string)) {
                            this.fireExcecaoEncontrada(String.format("Amostra com o c\u00f3digo fora do padr\u00e3o %s ", sampleId));
                            continue;
                        }
                        if (string.trim().length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                            this.fireExcecaoEncontrada(String.format("Amostra com o c\u00f3digo fora do padr\u00e3o %s ", sampleId));
                            continue;
                        }
                        if (this.request.contains(string)) continue;
                        this.request.add(string);
                    }
                }
                if (!this.request.isEmpty()) {
                    this.hostQuery = true;
                } else {
                    this.fireExcecaoEncontrada(String.format("Pedido de amostra do aparelho sem nenhum Sample ID: %s", starting_range));
                }
            } else {
                this.fireExcecaoEncontrada("Pedido de amostra do aparelho sem nenhum Sample ID");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
    }

    public void responseHostQuery() {
        try {
            if (this.request.isEmpty()) {
                return;
            }
            String sampleId = this.request.remove(0);
            String fil_codigo = sampleId.substring(0, ParametrosGerais.getDigitosTuboFilial());
            sampleId = sampleId.substring(ParametrosGerais.getDigitosTuboFilial());
            String req_codigo = sampleId.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
            String rec_codigo = sampleId.substring(ParametrosGerais.getDigitosTuboRequisicao());
            String pac_nome = null;
            String pac_sexo = null;
            String pac_idade = null;
            String data = null;
            String hora = null;
            String prioridade = null;
            String int_codigo = null;
            String mco_codigo = null;
            StringBuilder pac_exames = new StringBuilder("");
            String acao = "A";
            Object[] req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 0);
            PanelAbaAbstrata aba = this.equipamento.getTab(0);
            if (req != null) {
                pac_exames.append((String)req[aba.getColIndice("Exame")]);
            }
            String situacao = null;
            if (req == null && (req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2)) != null) {
                aba = this.equipamento.getTab(2);
                if (req != null) {
                    String tuboPai = Funcoes.preencheZero((String)req[aba.getColIndice("Tubo")], ParametrosGerais.getDigitosTuboTubo());
                    List<Object[]> reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, tuboPai.equals(rec_codigo) ? rec_codigo : tuboPai, 2);
                    for (Object[] r : reqs) {
                        if (Integer.parseInt((String)r[aba.getColIndice("Sit")]) <= 2) continue;
                        if (Integer.parseInt((String)r[aba.getColIndice("Sit")]) >= 7) continue;
                        situacao = (String)r[aba.getColIndice("Sit")];
                        String exame = (String)r[aba.getColIndice("Exame")];
                        mco_codigo = (String)req[aba.getColIndice("C\u00f3d. Mat.")];
                        int_codigo = (String)req[aba.getColIndice("Interface")];
                        if (BDUtil.isGrupoInteiroRepetido(fil_codigo, int_codigo, req_codigo, exame, mco_codigo, tuboPai.equals(rec_codigo) ? rec_codigo : tuboPai)) {
                            pac_exames.append(exame).append(" ");
                            continue;
                        }
                        BDExame[] filhos = BDUtil.getDesmExamesFilhos(fil_codigo, int_codigo, req_codigo, exame, mco_codigo, tuboPai.equals(rec_codigo) ? rec_codigo : tuboPai);
                        if (filhos == null) continue;
                        for (BDExame bdExame : filhos) {
                            if (!Funcoes.preencheZero(bdExame.getRecipienteFilho(), ParametrosGerais.getDigitosTuboTubo()).equals(rec_codigo) || bdExame.getSituacao() <= 2 || bdExame.getSituacao() >= 7) continue;
                            pac_exames.append(bdExame.getExame()).append(" ");
                        }
                    }
                }
            }
            if (req != null && !Funcoes.textoVazio(pac_exames.toString())) {
                pac_nome = aba.getColIndice("Paciente") >= 0 ? (String)req[aba.getColIndice("Paciente")] : null;
                pac_sexo = aba.getColIndice("S") >= 0 ? (String)req[aba.getColIndice("S")] : null;
                data = aba.getColIndice("Data") >= 0 ? (String)req[aba.getColIndice("Data")] : null;
                hora = aba.getColIndice("Hora") >= 0 ? (String)req[aba.getColIndice("Hora")] : null;
                int_codigo = aba.getColIndice("Interface") >= 0 ? (String)req[aba.getColIndice("Interface")] : null;
                mco_codigo = aba.getColIndice("C\u00f3d. Mat.") >= 0 ? (String)req[aba.getColIndice("C\u00f3d. Mat.")] : null;
                this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, "", prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames.toString().trim(), acao);
            } else {
                this.fireExcecaoEncontrada(String.format("Nenhuma requisi\u00e7\u00e3o encontrada para a amostra %s %s %s", fil_codigo, req_codigo, rec_codigo));
                if (!this.request.isEmpty()) {
                    this.responseHostQuery();
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
    }

    @Override
    protected void tratarAcknowledge() throws Exception {
        super.tratarAcknowledge();
        if (this.tx_list.isEmpty() && this.request.size() > 0) {
            Thread.sleep(6000L);
            this.responseHostQuery();
        }
    }

    public void limparWorklistEnvio() {
        this.request.clear();
    }

    private void enviarRequisicaoSemExame(String fil_codigo, String req_codigo) {
        try {
            if (this.tx_list == null) {
                this.tx_list = new MemoryList();
            }
            if (this.rx_list == null) {
                this.rx_list = new MemoryList();
            }
            this.tx_list.add(ASTMStandard.getDefaultHeaderRecord(this.DELIMITERS, this.PASSWORD, this.HOST_NAME, this.HOST_SYSTEM_VERSION, null, this.INSTRUMENT_NAME, this.INSTRUMENT_SYSTEM_VERSION));
            this.tx_list.add(this.getPatientRecord(1, fil_codigo + req_codigo, fil_codigo + req_codigo, "", "", ""));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o cabe\u00e7alho de envio");
            }
            this.tx_list.add(ASTMStandard.getDefaultTerminationRecord("I"));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o rodap\u00e9 de envio");
            }
            this.tx_list = this.makeFrames(this.tx_list);
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            this.getPortaCOM().write(String.valueOf('\u0005'));
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: envio de requisi\u00e7\u00e3o");
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o em envio de requisi\u00e7\u00e3o");
            }
        }
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao) {
        try {
            int todosTubosCurva;
            Object exameCurva;
            this.tx_list.clear();
            this.rx_list.clear();
            this.req_codigo = req_codigo;
            this.fil_codigo = fil_codigo;
            this.int_codigo = int_codigo;
            this.pac_nome = pac_nome;
            this.pac_sexo = pac_sexo;
            this.req_idade = pac_idade;
            this.req_data = data;
            this.req_hora = hora;
            this.mco_codigo = mco_codigo;
            this.rec_codigo = rec_codigo;
            this.pac_exames = pac_exames;
            this.exames = pac_exames.split(" ", 0);
            this.ultima_acao = acao;
            this.curva = false;
            this.rec_tuboPai = "";
            this.examesFilho = new LinkedList();
            ExameMaterial[] alternativos = null;
            ExameMaterial[] listaCurva = null;
            Map<String, List<ExameMaterial>> alternativosCurva = null;
            String short_name = StringUtil.removerAcentos(pac_nome);
            if (short_name.length() > this.MAX_PATIENT_NAME_CHARS) {
                short_name = short_name.substring(0, this.MAX_PATIENT_NAME_CHARS);
            }
            fil_codigo = StringUtil.preencheString(fil_codigo, ParametrosGerais.getDigitosTuboFilial(), '0', 1);
            StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo);
            StringBuilder sample_id = new StringBuilder(fil_codigo).append(req_codigo);
            rec_codigo = StringUtil.preencheString(rec_codigo, ParametrosGerais.getDigitosTuboTubo(), '0', 1);
            codigo.append(rec_codigo);
            Statement st = Conexao.getStatement();
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(this.exames, mco_codigo);
            String exame = exa_lista[0].toString();
            ArrayList<ExameMaterial> exa_listaCurva = new ArrayList<ExameMaterial>();
            exa_lista = ExamesUtil.separaExamesCurva(fil_codigo, int_codigo, mco_codigo, exa_lista, exa_listaCurva);
            String tipo_amostra = "";
            if (exa_lista != null) {
                tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, (exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_lista))[0].getString(), exa_lista[0].getCodigo().toString(), int_codigo);
                if (Funcoes.textoVazio(tipo_amostra)) {
                    tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, exame, mco_codigo, int_codigo);
                }
                alternativos = ExamesUtil.getAlternativos(st, fil_codigo, int_codigo, exa_lista);
                alternativos = ExamesUtil.removeDuplicados(alternativos);
            }
            if (Funcoes.textoVazio(tipo_amostra)) {
                tipo_amostra = "S";
            }
            if (!exa_listaCurva.isEmpty()) {
                exameCurva = new ArrayList();
                for (ExameMaterial exameMaterial : exa_listaCurva) {
                    exameCurva.add(exameMaterial.getNomeExame());
                }
                if (Funcoes.textoVazio(this.rec_tuboPai)) {
                    this.rec_tuboPai = BDUtil.getExameDesmembradoTuboPai(fil_codigo, req_codigo, rec_codigo, int_codigo, (String)exameCurva.get(0), mco_codigo);
                    if (Funcoes.textoVazio(this.rec_tuboPai)) {
                        this.rec_tuboPai = rec_codigo;
                    }
                }
                if (Funcoes.textoVazio(tipo_amostra)) {
                    tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, ((ExameMaterial)exa_listaCurva.get(0)).getString(), ((ExameMaterial)exa_listaCurva.get(0)).getCodigo().toString(), int_codigo);
                }
                listaCurva = ExamesUtil.anexarCodigoMaterial(exameCurva.toArray(new String[exameCurva.size()]), mco_codigo);
                listaCurva = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_listaCurva.toArray(new ExameMaterial[exa_listaCurva.size()]));
                todosTubosCurva = 0;
                if (!Funcoes.textoVazio(this.rec_tuboPai) && Funcoes.isNumeric(this.rec_tuboPai)) {
                    todosTubosCurva = Integer.parseInt(rec_codigo) == Integer.parseInt(this.rec_tuboPai) ? 1 : 0;
                }
                alternativosCurva = ExamesUtil.getAlternativosCurva(fil_codigo, int_codigo, req_codigo, mco_codigo, String.valueOf(Integer.parseInt(rec_codigo)), st, exa_listaCurva, this.rec_tuboPai, true, this.examesFilho, todosTubosCurva != 0);
            }
            if (Funcoes.textoVazio(tipo_amostra)) {
                if (exa_lista != null) {
                    Object ex;
                    exameCurva = exa_lista;
                    todosTubosCurva = ((ExameMaterial[])exameCurva).length;
                    for (int exameMaterial = 0; exameMaterial < todosTubosCurva && Funcoes.textoVazio(tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, ((CodString)(ex = exameCurva[exameMaterial])).getString(), ((CodString)ex).getCodigo().toString(), int_codigo)); exameMaterial += 1) {
                    }
                }
                if (Funcoes.textoVazio(tipo_amostra)) {
                    for (String exFilho : this.examesFilho) {
                        tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, exFilho, mco_codigo, int_codigo);
                    }
                }
            }
            this.tx_list.add(ASTMStandard.getDefaultHeaderRecord(this.DELIMITERS, this.PASSWORD, this.HOST_NAME, this.HOST_SYSTEM_VERSION, null, this.INSTRUMENT_NAME, this.INSTRUMENT_SYSTEM_VERSION));
            StringBuilder patient_id = new StringBuilder();
            patient_id.append(fil_codigo).append(req_codigo);
            Date dataNasc = BDUtil.getDataNacimentoPaciente(fil_codigo, req_codigo);
            Object laboratory_pid = null;
            String tipoPaciente = "";
            if (this.configuracao.getModoHostQuery()) {
                String tipo = Funcoes.calculaAnoMes(Funcoes.formataData(dataNasc));
                tipoPaciente = this.configuracao.getTipoPacienteOutros();
                if (tipo.equalsIgnoreCase("D")) {
                    String idade = Funcoes.calculaIdade(Funcoes.formataData(dataNasc), false);
                    if (Funcoes.isNumeric(idade) && Integer.parseInt(idade) <= 28) {
                        tipoPaciente = this.configuracao.getTipoPacienteRecemNascido();
                    }
                } else if (pac_sexo.equalsIgnoreCase("M")) {
                    tipoPaciente = this.configuracao.getTipoPacienteHomem();
                } else if (pac_sexo.equalsIgnoreCase("F")) {
                    tipoPaciente = this.configuracao.getTipoPacienteMulher();
                }
            }
            String t = this.getPatientRecord(1, patient_id.toString(), short_name, "", pac_sexo, Funcoes.formataData("yyyyMMdd", dataNasc));
            this.tx_list.add(t);
            int seq = 0;
            if (alternativos != null && alternativos.length > 0) {
                for (ExameMaterial exameMaterial : alternativos) {
                    t = this.getOrderRecord(++seq, codigo.toString(), exameMaterial, "R", tipo_amostra, tipoPaciente);
                    this.tx_list.add(t);
                }
            }
            if (alternativosCurva != null && alternativosCurva.size() > 0) {
                String cod = sample_id.toString();
                this.curva = true;
                for (String key : alternativosCurva.keySet()) {
                    sample_id.setLength(0);
                    sample_id.append(cod);
                    String tubo = Funcoes.preencheZero(key, ParametrosGerais.getDigitosTuboTubo());
                    t = this.getOrderRecord(++seq, sample_id.append(tubo).toString(), alternativosCurva.get(key).get(0), "R", tipo_amostra, tipoPaciente);
                    this.tx_list.add(t);
                }
            }
            t = ASTMStandard.getDefaultTerminationRecord("N");
            this.tx_list.add(t);
            this.tx_list = this.makeFrames(this.tx_list);
            this.tx_list.resetUltimoLido();
            if (acao.equalsIgnoreCase("A") && !this.hostQuery) {
                this.tx_list.clear();
                this.encerrarTransmissao();
                return "";
            }
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            this.getPortaCOM().write(String.valueOf('\u0005'));
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    @Override
    protected void tratarNegativeAck() throws Exception {
        super.tratarNegativeAck();
    }

    private String getOrderRecord(int order_sequence, String sample_id, ExameMaterial test_item_numbers, String priority, String material, String tipoPaciente) {
        StringBuilder record = new StringBuilder("O|");
        record.append(order_sequence);
        record.append("|");
        record.append(sample_id == null ? "" : sample_id);
        record.append("|");
        record.append(sample_id == null ? "" : sample_id);
        record.append("|");
        if (test_item_numbers != null) {
            String tmp = test_item_numbers.getNomeExame();
            if (tmp != null && !tmp.matches("\\^\\d+\\^\\w+\\^\\d+")) {
                record.append("^^^").append(test_item_numbers.getNomeExame());
            } else {
                record.append(tmp);
            }
        }
        record.append("|");
        record.append(priority == null ? "" : priority);
        record.append("|");
        record.append(ASTMStandard.getCurrentMoment());
        record.append("|||||");
        record.append("A");
        record.append("||||");
        record.append(material);
        record.append("|||");
        record.append(tipoPaciente);
        record.append("|||||||O||||||");
        record.append('\r');
        return record.toString();
    }

    public void addListaRecebimento(String message) {
        this.threadRecebimento.addListaRecebimento(message);
    }

    public void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            ArrayList<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento(this);
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        if (this.threadRecebimento != null) {
            this.threadRecebimento.start();
        }
    }

    @Override
    protected void tratarEndOfTX() throws Exception {
        super.tratarEndOfTX();
        if (this.hostQuery && !this.request.isEmpty()) {
            this.responseHostQuery();
        }
    }

    private String getPatientRecord(int patient_sequence, String patient_id, String pac_nome, String pac_sobrenome, String pac_sexo, String pac_nascimento) {
        StringBuilder record = new StringBuilder("P|");
        record.append(patient_sequence);
        record.append("|");
        record.append(patient_id == null ? "" : patient_id);
        record.append("|");
        record.append(patient_id == null ? "" : patient_id);
        record.append("||");
        record.append(pac_sobrenome == null ? "" : pac_sobrenome);
        record.append(pac_nome == null ? "" : "^" + pac_nome);
        record.append("||");
        record.append(pac_nascimento == null ? "" : pac_nascimento);
        record.append("|");
        record.append(pac_sexo == null ? "" : pac_sexo);
        record.append("||||||||||||||||||||||||||A||");
        record.append('\r');
        return record.toString();
    }

    @Override
    protected void encerrarTransmissao() throws Exception {
        if (this.tx_list.getUltimoLido() == this.tx_list.size() - 1) {
            if (!(Funcoes.textoVazio(this.fil_codigo) || Funcoes.textoVazio(this.req_codigo) || Funcoes.textoVazio(this.rec_codigo) || Funcoes.textoVazio(this.mco_codigo) || this.exames == null)) {
                Statement st = Conexao.getStatement();
                for (int i = 0; i < this.exames.length; ++i) {
                    int situacao;
                    if (!Funcoes.textoVazio(this.rec_tuboPai) && this.curva && !this.examesFilho.isEmpty()) {
                        for (String exame : this.examesFilho) {
                            int situacao2 = BDUtil.getDesmSituacao(this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_tuboPai, exame, this.mco_codigo);
                            boolean sit = this.ultima_acao.equals("A") && situacao2 == 2;
                            BDUtil.setExmSituacaoFilho(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, exame, this.mco_codigo, this.rec_tuboPai, situacao2 < 2 || !sit ? 1 : 3);
                        }
                        situacao = this.getExameSituacao(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_codigo);
                        if (!BDUtil.isGrupoInteiroPendente(this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_tuboPai)) continue;
                        this.atualizarSituacaoExame(st, this.fil_codigo, this.req_codigo, this.rec_tuboPai, this.exames[i], this.mco_codigo, this.int_codigo, null, situacao < 2 ? 1 : 3);
                        continue;
                    }
                    if (!this.examesFilho.isEmpty()) {
                        situacao = this.getExameSituacao(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_codigo);
                        this.atualizarSituacaoExame(st, this.fil_codigo, this.req_codigo, this.rec_codigo, this.exames[i], this.mco_codigo, this.int_codigo, null, situacao < 2 ? 1 : 3);
                        BDUtil.setExmSituacaoTodosFilhos(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_codigo, situacao < 2 ? 1 : 3);
                        continue;
                    }
                    situacao = this.getExameSituacao(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_codigo);
                    this.atualizarSituacaoExame(st, this.fil_codigo, this.req_codigo, this.rec_codigo, this.exames[i], this.mco_codigo, this.int_codigo, null, situacao < 2 ? 1 : 3);
                }
                Conexao.arquivaSQL();
                String acao = this.ultima_acao.equals("C") ? "excluido(s)" : "enviado(s)";
                this.fireMensagemEnviada("Exame(s) " + acao + " com sucesso para " + this.pac_nome, 0, 10000);
            } else {
                this.fireMensagemEnviada("Nenhum exame localizado para encerrar para " + this.pac_nome, 0, 10000);
            }
        }
        this.interromperTimer();
        if (this.hostQuery || this.ultima_acao.equals("N")) {
            this.getPortaCOM().write(String.valueOf('\u0004'));
            this.getPortaCOM().clearInputString();
        }
        if (this.ultima_acao.equals("N")) {
            this.firePacienteEnviado(this.req_codigo, this.pac_nome, this.pac_sexo, this.req_idade, this.req_data, this.req_hora, this.pac_exames);
        }
        this.limpaDadosRequisicao();
        this.fireAtualizarTabela();
        this.fireAtualizarTabela(0);
        this.setIdle();
        if (this.request.size() == 0) {
            this.hostQuery = false;
        }
    }

    @Override
    public void dataChanged() {
        try {
            String message = this.getPortaCOM().getInputString();
            if (message != null && message.equals(String.valueOf('\u0004'))) {
                this.tratarEndOfTX();
            } else if (message.length() == 2 && message.equals(String.valueOf('\u0004') + String.valueOf('\u0005'))) {
                this.getPortaCOM().write(String.valueOf('\u0006'));
            }
            message = this.getPortaCOM().removeInputString(this.getMsgEnd());
            if (!message.equals("")) {
                this.addListaRecebimento(message);
                this.restartThreadRecebimento();
                this.getPortaCOM().write(String.valueOf('\u0006'));
                if (this.isRX()) {
                    this.aguardarProximoFrame();
                }
            } else if (this.isRX()) {
                this.aguardarProximoFrame();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: evento de dados recebidos");
            this.fireMensagemEnviada("Erro ao receber dados do equipamento: " + ex.getMessage(), 1, 5000);
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public String getErroTraduzido(String erro) {
        return null;
    }

    @Override
    public void teste() {
        this.testeMiura200Query();
    }

    private void testeMiura200Query() {
        ArrayList<String> reqs = new ArrayList<String>();
        reqs.add("0101170446");
        reqs.add("0101170447");
        this.parse(TestesInterface.arruma("[STX]1H|\\^&|||Miura200||||||PH[SP]LABORATORIO[SP]|P|LIS2-A2|20151109152936[ETX]25[LINE]"));
        this.parse(TestesInterface.arruma("[STX]2Q|1|ALL||ALL||||||||O[ETX]08[LINE]"));
        this.parse(TestesInterface.arruma("[STX]3L|1|N[ETX]F9[LINE]"));
        this.handShakeCharReceived('\u0004');
        for (int i = 0; i < 100; ++i) {
            this.handShakeCharReceived('\u0006');
        }
    }

    private void testeMiura200Result() {
        HashMap<String, String> reqs = new HashMap<String, String>();
        reqs.put("1001114441", "02");
        reqs.put("1001114442", "03");
        reqs.put("1001114443", "04");
        reqs.put("1001114444", "05");
        Integer resultado = 90;
        for (String req : reqs.keySet()) {
            this.parse(TestesInterface.arruma("[STX]1H|\\^&|||Miura200||||||PH[SP]LABORATORIO[SP]|P|LIS2-A2|20151112113703[ETX]14[LINE]"));
            this.parse(TestesInterface.arruma("[STX]2P|1|[ETX]AE[LINE]"));
            this.parse(TestesInterface.arruma("[STX]3O|1|" + req + "|" + req + "|^^^" + (String)reqs.get(req) + "|R||||||N||||S|||M|||||||F||||||[ETX]77[LINE]"));
            Integer n = resultado;
            Integer n2 = resultado = Integer.valueOf(resultado + 1);
            this.parse(TestesInterface.arruma("[STX]4R|1|^^^" + (String)reqs.get(req) + "|" + n + "|mg/dl|70.0000:100.0000|N||F||DENISE|||Miura200[ETX]1B[LINE]"));
            this.parse(TestesInterface.arruma("[STX]5L|1|N[ETX]FB[LINE]"));
        }
        this.handShakeCharReceived('\u0004');
        for (int i = 0; i < 6; ++i) {
            this.handShakeCharReceived('\u0006');
        }
    }
}

