/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.miura200;

import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamento;
import jalis.laboratorio.interfaceamento.abas.AbaDefaultProntos;
import jalis.laboratorio.interfaceamento.interfaces.miura200.SelecionaExame;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.TempoUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;

public class AbaProntos
extends AbaDefaultProntos {
    public AbaProntos(JFrame parent, AbstractInterfaceamento equip) {
        super(parent, equip);
    }

    @Override
    public void repetirExame() {
        int row = this.tabelaExames.getSelectedRow();
        if (row < 0) {
            return;
        }
        ArrayList requisicaoExames = this.getRequisicaoExames(row, this.exames);
        if ((requisicaoExames = (ArrayList)requisicaoExames.clone()).size() > 1) {
            SelecionaExame tela = new SelecionaExame(this.equipamento, requisicaoExames, this.colunas, this.colunasVisiveis, this.colunasOcultas);
            tela.setVisible(true);
            requisicaoExames = tela.getRequisicaoExames();
        } else {
            Object[] exame = (Object[])requisicaoExames.get(0);
            String aux = (String)exame[this.getColIndice("C\u00f3digo")];
            if (ParametrosGerais.isAgruparGuiasInterface()) {
                aux = (String)exame[this.getColIndice("Multiguia")];
            }
            String fil_codigo = aux.substring(0, ParametrosGerais.getDigitosTuboFilial());
            String int_codigo = (String)exame[this.getColIndice("Interface")];
            String exa_codigo = (String)exame[this.getColIndice("Exame")];
            String mco_codigo = (String)exame[this.getColIndice("C\u00f3d. Mat.")];
            try {
                if (BDUtil.isExameDesmembrado(fil_codigo, int_codigo, exa_codigo, mco_codigo)) {
                    SelecionaExame tela = new SelecionaExame(this.equipamento, requisicaoExames, this.colunas, this.colunasVisiveis, this.colunasOcultas);
                    tela.setVisible(true);
                    requisicaoExames = tela.getRequisicaoExames();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        ArrayList<Exame> exames = new ArrayList<Exame>();
        ArrayList<Integer> linhas = new ArrayList<Integer>();
        for (int i = 0; i < requisicaoExames.size(); ++i) {
            Object[] linhaRepeticao = (Object[])requisicaoExames.get(i);
            String reqRepetir = (String)linhaRepeticao[this.getColIndice("C\u00f3digo")];
            if (ParametrosGerais.isAgruparGuiasInterface()) {
                reqRepetir = (String)linhaRepeticao[this.getColIndice("Multiguia")];
            }
            String exaRepetir = (String)linhaRepeticao[this.getColIndice("Exame")];
            String matRepetir = (String)linhaRepeticao[this.getColIndice("C\u00f3d. Mat.")];
            for (int j = 0; j < this.tabelaExames.getRowCount(); ++j) {
                ArrayList desmembrado;
                Object[] linhaProntos = this.tabelaExames.getRow(j);
                String reqPronto = (String)linhaProntos[this.getColIndice("C\u00f3digo")];
                if (ParametrosGerais.isAgruparGuiasInterface()) {
                    reqPronto = (String)linhaProntos[this.getColIndice("Multiguia")];
                }
                if (!reqRepetir.equalsIgnoreCase(reqPronto)) continue;
                String exaPronto = (String)linhaProntos[this.getColIndice("Exame")];
                String matPronto = (String)linhaProntos[this.getColIndice("C\u00f3d. Mat.")];
                if (!exaRepetir.equalsIgnoreCase(exaPronto) || !matRepetir.equalsIgnoreCase(matPronto)) continue;
                try {
                    desmembrado = (ArrayList)linhaRepeticao[linhaRepeticao.length - 1];
                }
                catch (Exception e) {
                    desmembrado = null;
                }
                if (desmembrado != null) {
                    for (int k = 0; k < desmembrado.size(); ++k) {
                        Object[] exame = (Object[])desmembrado.get(k);
                        String situacao = (String)exame[exame.length - 2];
                        String tubo = (String)exame[exame.length - 3];
                        if (!situacao.equalsIgnoreCase(SelecionaExame.SIT_REPETIR)) continue;
                        exames.add(new Exame((String)exame[1], tubo));
                    }
                    linhas.add(j);
                    continue;
                }
                String sit = (String)linhaRepeticao[this.getColIndice("Sit")];
                if (!sit.equalsIgnoreCase(SelecionaExame.SIT_REPETIR) && (requisicaoExames.size() != 1 || !sit.equalsIgnoreCase(SelecionaExame.SIT_PRONTO))) continue;
                exames.add(new Exame(exaPronto, ""));
                linhas.add(j);
            }
        }
        String listaExames = "";
        if (!exames.isEmpty()) {
            listaExames = StringUtil.implode(exames, " ");
            boolean curva = false;
            try {
                String req_codigo = (String)this.tabelaExames.getValueAt((Integer)linhas.get(0), this.getColIndice("C\u00f3digo"));
                String rec_codigo = (String)this.tabelaExames.getValueAt((Integer)linhas.get(0), this.getColIndice("Tubo"));
                List filhos = (List)this.tabelaExames.getValueAt((Integer)linhas.get(0), this.getColIndice("Tubos Filhos"));
                String mco_codigo = (String)this.tabelaExames.getValueAt((Integer)linhas.get(0), this.getColIndice("C\u00f3d. Mat."));
                String pac_sexo = (String)this.tabelaExames.getValueAt((Integer)linhas.get(0), this.getColIndice("S"));
                String pac_idade = (String)this.tabelaExames.getValueAt((Integer)linhas.get(0), this.getColIndice("Ide"));
                String pac_nome = (String)this.tabelaExames.getValueAt((Integer)linhas.get(0), this.getColIndice("Paciente"));
                String rack = (String)this.tabelaExames.getValueAt((Integer)linhas.get(0), this.getColIndice("Rack"));
                String hora = TempoUtil.getCurrentTime();
                String data = TempoUtil.getCurrentDateBr();
                rec_codigo = Funcoes.preencheZero(rec_codigo, ParametrosGerais.getDigitosTuboTubo());
                if (filhos != null && filhos.size() > 0 && !Funcoes.preencheZero((String)filhos.get(0), ParametrosGerais.getDigitosTuboTubo()).equals(rec_codigo)) {
                    curva = true;
                }
                if (ParametrosGerais.isAgruparGuiasInterface()) {
                    req_codigo = (String)this.tabelaExames.getValueAt((Integer)linhas.get(0), this.getColIndice("C\u00f3digo Temp."));
                }
                String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
                String int_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Interface"));
                req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial());
                String resposta = this.equipamento.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rack, null, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, listaExames, "A");
                if (curva) {
                    for (Exame ex : exames) {
                        this.equipamento.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rack, null, fil_codigo, int_codigo, req_codigo, mco_codigo, ex.tubo, ex.nome, "A");
                    }
                }
                if (resposta != null) {
                    this.equipamento.novaMensagem(resposta, 0, resposta.startsWith("Erro") ? 5000 : 10000);
                }
                for (Integer i : linhas) {
                    this.reloadLinha(i);
                }
                this.revalidate();
                this.repaint();
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(this.parent, ex.getMessage(), ex.getStackTrace());
            }
        }
    }

    class Exame {
        String nome;
        String tubo;

        public Exame(String nome, String tubo) {
            this.nome = nome;
            this.tubo = tubo;
        }

        public String toString() {
            return this.nome;
        }
    }
}

