/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.miura.astm;

import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.LinkedList;

public class ASTMStandard {
    public static int HEADER_RECORD_FIELDS_NUMBER = 14;
    public static int PATIENT_RECORD_FIELDS_NUMBER = 35;
    public static int ORDER_RECORD_FIELDS_NUMBER = 31;
    public static int RESULT_RECORD_FIELDS_NUMBER = 14;
    public static int COMMENT_RECORD_FIELDS_NUMBER = 5;
    public static int REQUEST_RECORD_FIELDS_NUMBER = 13;
    public static int TERMINATION_RECORD_FIELDS_NUMBER = 3;
    public static int MANUFACTURER_RECORD_FIELDS_NUMBER = 5;
    public static Integer RECORD_TYPE = new Integer(1);
    public static Integer SEQUENCE_NUMBER = new Integer(2);
    public static Integer HEADER_FIELD_RECORD_ID = new Integer(1);
    public static Integer HEADER_FIELD_DELIMITERS = new Integer(2);
    public static Integer HEADER_FIELD_MSG_CONTROL_ID = new Integer(3);
    public static Integer HEADER_FIELD_ACCESS_PASSWORD = new Integer(4);
    public static Integer HEADER_FIELD_SENDER_ID = new Integer(5);
    public static Integer HEADER_FIELD_SENDER_ADDRESS = new Integer(6);
    public static Integer HEADER_FIELD_RESERVED = new Integer(7);
    public static Integer HEADER_FIELD_SENDER_PHONE = new Integer(8);
    public static Integer HEADER_FIELD_SENDER_QUALITY = new Integer(9);
    public static Integer HEADER_FIELD_RECEIVER_ID = new Integer(10);
    public static Integer HEADER_FIELD_ANNOTATION = new Integer(11);
    public static Integer HEADER_FIELD_PROCESS_ID = new Integer(12);
    public static Integer HEADER_FIELD_VERSION_NUMBER = new Integer(13);
    public static Integer HEADER_FIELD_DATETIME = new Integer(14);
    public static Integer PATIENT_FIELD_RECORD_ID = new Integer(1);
    public static Integer PATIENT_FIELD_SEQUENCE = new Integer(2);
    public static Integer PATIENT_FIELD_PATIENT_ID = new Integer(3);
    public static Integer PATIENT_FIELD_LABORATORY_PID = new Integer(4);
    public static Integer PATIENT_FIELD_SYSTEM_PID = new Integer(5);
    public static Integer PATIENT_FIELD_NAME = new Integer(6);
    public static Integer PATIENT_FIELD_MAIDEN_NAME = new Integer(7);
    public static Integer PATIENT_FIELD_BIRTHDATE = new Integer(8);
    public static Integer PATIENT_FIELD_SEX = new Integer(9);
    public static Integer PATIENT_FIELD_RACE = new Integer(10);
    public static Integer PATIENT_FIELD_ADDRESS = new Integer(11);
    public static Integer PATIENT_FIELD_RESERVED = new Integer(12);
    public static Integer PATIENT_FIELD_PHONE = new Integer(13);
    public static Integer PATIENT_FIELD_DOCTOR = new Integer(14);
    public static Integer PATIENT_FIELD_SPECIAL1 = new Integer(15);
    public static Integer PATIENT_FIELD_SPECIAL2 = new Integer(16);
    public static Integer PATIENT_FIELD_HEIGHT = new Integer(17);
    public static Integer PATIENT_FIELD_WEIGHT = new Integer(18);
    public static Integer PATIENT_FIELD_DIAGNOSIS = new Integer(19);
    public static Integer PATIENT_FIELD_MEDICATIONS = new Integer(20);
    public static Integer PATIENT_FIELD_DIET = new Integer(21);
    public static Integer PATIENT_FIELD_PRACTICE1 = new Integer(22);
    public static Integer PATIENT_FIELD_PRACTICE2 = new Integer(23);
    public static Integer PATIENT_FIELD_DATE_IN_HOSPITAL = new Integer(24);
    public static Integer PATIENT_FIELD_ADMISSION_STATUS = new Integer(25);
    public static Integer PATIENT_FIELD_LOCATION = new Integer(26);
    public static Integer PATIENT_FIELD_ALTERNATIVE_DIAGNOSTIC_CODES = new Integer(27);
    public static Integer PATIENT_FIELD_DIAGNOSTIC_CODES = new Integer(28);
    public static Integer PATIENT_FIELD_RELIGION = new Integer(29);
    public static Integer PATIENT_FIELD_MARITAL_STATUS = new Integer(30);
    public static Integer PATIENT_FIELD_ISOLATION_STATUS = new Integer(31);
    public static Integer PATIENT_FIELD_LANGUAGE = new Integer(32);
    public static Integer PATIENT_FIELD_HOSPITAL_SERVICE = new Integer(33);
    public static Integer PATIENT_FIELD_HOSPITAL_INSTITUTION = new Integer(34);
    public static Integer PATIENT_FIELD_DOSAGE_CATEGORY = new Integer(35);
    public static Integer ORDER_FIELD_RECORD_ID = new Integer(1);
    public static Integer ORDER_FIELD_SEQUENCE = new Integer(2);
    public static Integer ORDER_FIELD_SAMPLE_ID = new Integer(3);
    public static Integer ORDER_FIELD_SYSTEM_SID = new Integer(4);
    public static Integer ORDER_FIELD_TEST_ID = new Integer(5);
    public static Integer ORDER_FIELD_PRIORITY = new Integer(6);
    public static Integer ORDER_FIELD_REQUESTED_DATETIME = new Integer(7);
    public static Integer ORDER_FIELD_COLLECTION_DATETIME = new Integer(8);
    public static Integer ORDER_FIELD_COLLECTION_LASTTIME = new Integer(9);
    public static Integer ORDER_FIELD_COLLECTION_AMOUNT = new Integer(10);
    public static Integer ORDER_FIELD_COLLECTOR_ID = new Integer(11);
    public static Integer ORDER_FIELD_ACTION_CODE = new Integer(12);
    public static Integer ORDER_FIELD_DANGER_CODE = new Integer(13);
    public static Integer ORDER_FIELD_RELEVANT_CLINICAL_INFO = new Integer(14);
    public static Integer ORDER_FIELD_DATE_SAMPLE_RECEIVED = new Integer(15);
    public static Integer ORDER_FIELD_SAMPLE_INFO = new Integer(16);
    public static Integer ORDER_FIELD_ORDERING_DOCTOR = new Integer(17);
    public static Integer ORDER_FIELD_DOCTOR_PHONE = new Integer(18);
    public static Integer ORDER_FIELD_USER1 = new Integer(19);
    public static Integer ORDER_FIELD_USER2 = new Integer(20);
    public static Integer ORDER_FIELD_LAB1 = new Integer(21);
    public static Integer ORDER_FIELD_LAB2 = new Integer(22);
    public static Integer ORDER_FIELD_DATETIME_REPORTED = new Integer(23);
    public static Integer ORDER_FIELD_CHARGE = new Integer(24);
    public static Integer ORDER_FIELD_SYSTEM_SECTION = new Integer(25);
    public static Integer ORDER_FIELD_REPORT_TYPE = new Integer(26);
    public static Integer ORDER_FIELD_RESERVED = new Integer(27);
    public static Integer ORDER_FIELD_COLLECTION_WARD = new Integer(28);
    public static Integer ORDER_FIELD_NOSOCOMIAL_FLAG = new Integer(29);
    public static Integer ORDER_FIELD_SAMPLE_SERVICE = new Integer(30);
    public static Integer ORDER_FIELD_SAMPLE_INSTITUTION = new Integer(31);
    public static Integer RESULT_FIELD_RECORD_ID = new Integer(1);
    public static Integer RESULT_FIELD_SEQUENCE_ID = new Integer(2);
    public static Integer RESULT_FIELD_TEST_ID = new Integer(3);
    public static Integer RESULT_FIELD_MEASUREMENT_VALUE = new Integer(4);
    public static Integer RESULT_FIELD_UNITS = new Integer(5);
    public static Integer RESULT_FIELD_REFERENCE_RANGES = new Integer(6);
    public static Integer RESULT_FIELD_ABNORMAL_FLAGS = new Integer(7);
    public static Integer RESULT_FIELD_CAUSE_OF_ABNORMALITY = new Integer(8);
    public static Integer RESULT_FIELD_RESULT_STATUS = new Integer(9);
    public static Integer RESULT_FIELD_CHANGE_DATE = new Integer(10);
    public static Integer RESULT_FIELD_OPERATOR_ID = new Integer(11);
    public static Integer RESULT_FIELD_DATETIME_STARTED = new Integer(12);
    public static Integer RESULT_FIELD_DATETIME_ENDED = new Integer(13);
    public static Integer RESULT_FIELD_INSTRUMENT_ID = new Integer(14);
    public static Integer COMMENT_FIELD_RECORD_ID = new Integer(1);
    public static Integer COMMENT_FIELD_SEQUENCE = new Integer(2);
    public static Integer COMMENT_FIELD_SOURCE = new Integer(3);
    public static Integer COMMENT_FIELD_TEXT = new Integer(4);
    public static Integer COMMENT_FIELD_TYPE = new Integer(5);
    public static Integer MANUFACTURER_FIELD_RECORD_ID = new Integer(1);
    public static Integer MANUFACTURER_FIELD_SEQUENCE = new Integer(2);
    public static Integer MANUFACTURER_FIELD_RECORD_SUB_ID = new Integer(3);
    public static Integer MANUFACTURER_FIELD_RAW_OR_TEST_CODE = new Integer(4);
    public static Integer MANUFACTURER_FIELD_RESULT_VALUE = new Integer(5);
    public static Integer REQUEST_FIELD_RECORD_ID = new Integer(1);
    public static Integer REQUEST_FIELD_SEQUENCE = new Integer(2);
    public static Integer REQUEST_FIELD_STARTING_RANGE_ID = new Integer(3);
    public static Integer REQUEST_FIELD_ENDING_RANGE_ID = new Integer(4);
    public static Integer REQUEST_FIELD_TEST_ID = new Integer(5);
    public static Integer REQUEST_FIELD_TIME_RANGE = new Integer(6);
    public static Integer REQUEST_FIELD_START_DATETIME = new Integer(7);
    public static Integer REQUEST_FIELD_END_DATETIME = new Integer(8);
    public static Integer REQUEST_FIELD_DOCTOR_NAME = new Integer(9);
    public static Integer REQUEST_FIELD_DOCTOR_PHONE = new Integer(10);
    public static Integer REQUEST_FIELD_USER1 = new Integer(11);
    public static Integer REQUEST_FIELD_USER2 = new Integer(12);
    public static Integer REQUEST_FIELD_STATUS_CODES = new Integer(13);
    public static Integer TERMINATION_FIELD_RECORD_ID = new Integer(1);
    public static Integer TERMINATION_FIELD_SEQUENCE = new Integer(2);
    public static Integer TERMINATION_FIELD_CODE = new Integer(3);
    public static String RECORD_TYPE_HEADER = "H";
    public static String RECORD_TYPE_PATIENT = "P";
    public static String RECORD_TYPE_ORDER = "O";
    public static String RECORD_TYPE_REQUEST = "Q";
    public static String RECORD_TYPE_RESULT = "R";
    public static String RECORD_TYPE_COMMENT = "C";
    public static String RECORD_TYPE_MANUFACTURER = "M";
    public static String RECORD_TYPE_TERMINATION = "L";
    public static String CR = String.valueOf('\r');

    public static String getDefaultHeaderRecord(String delimiters, String password, String sender_name, String soft_version) {
        StringBuilder record = new StringBuilder("H|");
        record.append(delimiters == null ? "" : delimiters);
        record.append("||");
        record.append(password == null ? "" : password);
        record.append("|");
        record.append(sender_name == null ? "" : sender_name);
        record.append(soft_version == null ? "" : "^" + soft_version);
        record.append("|||||||P|1|");
        record.append(ASTMStandard.getCurrentMoment());
        record.append("|");
        record.append(CR);
        return record.toString();
    }

    public static String getDefaultHeaderRecord(String delimiters, String password, String sender_id_name, String sender_id_system, String control, String receiver_id_name, String receiver_id_system) {
        return ASTMStandard.getDefaultHeaderRecord(delimiters, password, sender_id_name, sender_id_system, control, receiver_id_name, receiver_id_system, "1");
    }

    public static String getDefaultHeaderRecord(String delimiters, String password, String sender_id_name, String sender_id_system, String control, String receiver_id_name, String receiver_id_system, String version_number) {
        StringBuilder record = new StringBuilder("H|");
        record.append(delimiters == null ? "" : delimiters);
        record.append("||");
        record.append(password == null ? "" : password);
        record.append("|");
        record.append(sender_id_name == null ? "" : sender_id_name);
        record.append(sender_id_system == null ? "" : "^" + sender_id_system);
        record.append("||||");
        record.append(control == null ? "" : control);
        record.append("|");
        record.append(receiver_id_name == null ? "" : receiver_id_name);
        record.append(receiver_id_system == null ? "" : "^" + receiver_id_system);
        record.append("||P|");
        record.append(version_number);
        record.append("|");
        record.append(ASTMStandard.getCurrentMoment());
        record.append("|");
        record.append(CR);
        return record.toString();
    }

    public static String getDefaultPatientRecord(int patient_sequence, String patient_id, String laboratory_pid, String pac_nome, String pac_sobrenome, String pac_sexo) {
        StringBuilder record = new StringBuilder("P|");
        record.append(patient_sequence);
        record.append("|");
        record.append(patient_id == null ? "" : patient_id);
        record.append("|");
        record.append(laboratory_pid == null ? "" : laboratory_pid);
        record.append("||");
        record.append(pac_sobrenome == null ? "" : pac_sobrenome);
        record.append(pac_nome == null ? "" : "^" + pac_nome);
        record.append("|||");
        record.append(pac_sexo == null ? "" : pac_sexo);
        record.append("|");
        record.append(CR);
        return record.toString();
    }

    public static String getDefaultPatientRecord(int patient_sequence, String patient_id, String laboratory_pid, String pac_nome, String pac_sobrenome, String pac_sexo, String pac_nascimento, String med_nome) {
        StringBuilder record = new StringBuilder("P|");
        record.append(patient_sequence);
        record.append("|");
        record.append(patient_id == null ? "" : patient_id);
        record.append("|");
        record.append(laboratory_pid == null ? "" : laboratory_pid);
        record.append("||");
        record.append(pac_sobrenome == null ? "" : pac_sobrenome);
        record.append(pac_nome == null ? "" : "^" + pac_nome);
        record.append("||");
        record.append(pac_nascimento == null ? "" : pac_nascimento);
        record.append("|");
        record.append(pac_sexo == null ? "" : pac_sexo);
        record.append("|||||");
        record.append(med_nome);
        record.append("|");
        record.append(CR);
        return record.toString();
    }

    public static String getDefaultOrderRecord(int order_sequence, String sample_id, String test_item_number, String test_item_name, String dilution, String priority, String action_code, String report_type) {
        StringBuilder record = new StringBuilder("O|");
        record.append(order_sequence);
        record.append("|");
        record.append(sample_id == null ? "" : sample_id);
        record.append("||");
        if (test_item_number != null) {
            record.append("^^^");
            record.append(test_item_number);
            record.append(test_item_name == null ? "" : "^" + test_item_name);
            record.append(dilution == null ? "" : "^" + dilution);
        }
        record.append("|");
        record.append(priority == null ? "" : priority);
        record.append("||||||");
        record.append(action_code == null ? "" : action_code);
        record.append("||||||||||||||");
        record.append(report_type == null ? "" : report_type);
        record.append("|");
        record.append(CR);
        return record.toString();
    }

    public static String getDefaultOrderRecord(int order_sequence, String sample_id, ExameMaterial[] test_item_numbers, ExameMaterial[] test_item_names, String dilution, String priority, String action_code, String sample_type, String report_type) {
        StringBuilder record = new StringBuilder("O|");
        record.append(order_sequence);
        record.append("|");
        record.append(sample_id == null ? "" : sample_id);
        record.append("||");
        if (test_item_numbers != null && test_item_numbers[0] != null) {
            record.append("^^^");
            record.append(test_item_numbers[0].getNomeExame());
            record.append(test_item_names == null || test_item_names[0] == null ? "" : "^" + test_item_names[0].getNomeExame());
            record.append(dilution == null ? "" : "^" + dilution);
            for (int i = 1; i < test_item_numbers.length; ++i) {
                if (test_item_numbers[i] == null) continue;
                record.append("\\^^^");
                record.append(test_item_numbers[i].getNomeExame());
                record.append(test_item_names == null || test_item_names[i] == null ? "" : "^" + test_item_names[i].getNomeExame());
                record.append(dilution == null ? "" : "^" + dilution);
            }
        }
        record.append("|");
        record.append(priority == null ? "" : priority);
        record.append("||||||");
        record.append(action_code == null ? "" : action_code);
        record.append("||||");
        record.append(sample_type == null ? "" : sample_type);
        record.append("||||||||||");
        record.append(report_type == null ? "" : report_type);
        record.append("|");
        record.append(CR);
        return record.toString();
    }

    public static String getDefaultOrderRecord(int order_sequence, String sample_id, String sample_id_type, ExameMaterial[] test_item_numbers, ExameMaterial[] test_item_names, String dilution, String priority, String action_code, String sample_type, String report_type) {
        StringBuilder record = new StringBuilder("O|");
        record.append(order_sequence);
        record.append("|");
        record.append(sample_id == null ? "" : sample_id);
        record.append("|");
        record.append(sample_id_type == null ? "" : sample_id_type);
        record.append("|");
        if (test_item_numbers != null && test_item_numbers[0] != null) {
            record.append("^^^");
            record.append(test_item_numbers[0].getNomeExame());
            record.append(test_item_names == null || test_item_names[0] == null ? "" : "^" + test_item_names[0].getNomeExame());
            record.append(dilution == null ? "" : "^" + dilution);
            for (int i = 1; i < test_item_numbers.length; ++i) {
                if (test_item_numbers[i] == null) continue;
                record.append("\\^^^");
                record.append(test_item_numbers[i].getNomeExame());
                record.append(test_item_names == null || test_item_names[i] == null ? "" : "^" + test_item_names[i].getNomeExame());
                record.append(dilution == null ? "" : "^" + dilution);
            }
        }
        record.append("|");
        record.append(priority == null ? "" : priority);
        record.append("||||||");
        record.append(action_code == null ? "" : action_code);
        record.append("||||");
        record.append(sample_type == null ? "" : sample_type);
        record.append("||||||||||");
        record.append(report_type == null ? "" : report_type);
        record.append("|");
        record.append(CR);
        return record.toString();
    }

    public static String getDefaultEnquiryRecord(String patient_id, String sample_id, String test_item_id, String test_item_name, String request_time_range, String request_code) {
        StringBuilder record = new StringBuilder("Q|1|");
        record.append(patient_id == null ? "" : patient_id);
        record.append(sample_id == null ? "" : "^" + sample_id);
        record.append("||");
        record.append(test_item_id == null ? "" : (test_item_id.toUpperCase().equals("ALL") ? test_item_id : "^^^" + test_item_id));
        record.append(test_item_name == null ? "" : "^" + test_item_name);
        record.append("|");
        record.append(request_time_range == null ? "" : request_time_range);
        record.append("|||||||");
        record.append(request_code == null ? "" : request_code);
        record.append("|");
        record.append(CR);
        return record.toString();
    }

    public static String getDefaultTerminationRecord(String termination_code) {
        StringBuilder record = new StringBuilder("L|1|");
        record.append(termination_code == null ? "" : termination_code);
        record.append("|");
        record.append(CR);
        return record.toString();
    }

    public static String getDefaultCommentRecord(String crc) {
        StringBuilder record = new StringBuilder("C|1|I|");
        record.append("CRC:&X" + crc + "&");
        record.append("|G");
        record.append(CR);
        return record.toString();
    }

    public static String removeCR(String record) {
        if (record.endsWith(CR)) {
            record = record.substring(0, record.length() - 1);
        }
        return record;
    }

    public static String fillRecordFields(String record, int fields_number) {
        StringBuilder temp = new StringBuilder(record);
        for (int n = StringUtil.contaOcorrencias(new StringBuilder(record), '|'); n < fields_number - 1; ++n) {
            temp.append("|");
        }
        return temp.toString();
    }

    public static String[] tokenizeRecordFields(String record, int fields_number) {
        String[] temp = record.split("[|]");
        String[] tokens = new String[fields_number];
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = i < temp.length ? temp[i] : "";
        }
        return tokens;
    }

    public static LinkedList splitMessage(String message) {
        LinkedList<String> message_records = new LinkedList<String>();
        String[] records = message.split(String.valueOf(CR));
        for (int i = 0; i < records.length; ++i) {
            message_records.addLast(records[i]);
        }
        return message_records;
    }

    public static Hashtable parseDefaultHeaderRecord(String record) {
        try {
            record = ASTMStandard.removeCR(record);
            record = ASTMStandard.fillRecordFields(record, HEADER_RECORD_FIELDS_NUMBER);
            String[] tokens = ASTMStandard.tokenizeRecordFields(record, HEADER_RECORD_FIELDS_NUMBER);
            Hashtable<Integer, String> header_fields = new Hashtable<Integer, String>();
            header_fields.put(RECORD_TYPE, tokens[0]);
            header_fields.put(HEADER_FIELD_DELIMITERS, tokens[1]);
            header_fields.put(HEADER_FIELD_MSG_CONTROL_ID, tokens[2]);
            header_fields.put(HEADER_FIELD_ACCESS_PASSWORD, tokens[3]);
            header_fields.put(HEADER_FIELD_SENDER_ID, tokens[4]);
            header_fields.put(HEADER_FIELD_SENDER_ADDRESS, tokens[5]);
            header_fields.put(HEADER_FIELD_RESERVED, tokens[6]);
            header_fields.put(HEADER_FIELD_SENDER_PHONE, tokens[7]);
            header_fields.put(HEADER_FIELD_SENDER_QUALITY, tokens[8]);
            header_fields.put(HEADER_FIELD_RECEIVER_ID, tokens[9]);
            header_fields.put(HEADER_FIELD_ANNOTATION, tokens[10]);
            header_fields.put(HEADER_FIELD_PROCESS_ID, tokens[11]);
            header_fields.put(HEADER_FIELD_VERSION_NUMBER, tokens[12]);
            header_fields.put(HEADER_FIELD_DATETIME, tokens[13]);
            return header_fields;
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            return null;
        }
    }

    public static Hashtable parseDefaultPatientRecord(String record) {
        try {
            record = ASTMStandard.removeCR(record);
            record = ASTMStandard.fillRecordFields(record, PATIENT_RECORD_FIELDS_NUMBER);
            String[] tokens = ASTMStandard.tokenizeRecordFields(record, PATIENT_RECORD_FIELDS_NUMBER);
            Hashtable<Integer, String> patient_fields = new Hashtable<Integer, String>();
            patient_fields.put(RECORD_TYPE, tokens[0]);
            patient_fields.put(SEQUENCE_NUMBER, tokens[1]);
            patient_fields.put(PATIENT_FIELD_PATIENT_ID, tokens[2]);
            patient_fields.put(PATIENT_FIELD_LABORATORY_PID, tokens[3]);
            patient_fields.put(PATIENT_FIELD_SYSTEM_PID, tokens[4]);
            patient_fields.put(PATIENT_FIELD_NAME, tokens[5]);
            patient_fields.put(PATIENT_FIELD_MAIDEN_NAME, tokens[6]);
            patient_fields.put(PATIENT_FIELD_BIRTHDATE, tokens[7]);
            patient_fields.put(PATIENT_FIELD_SEX, tokens[8]);
            patient_fields.put(PATIENT_FIELD_RACE, tokens[9]);
            patient_fields.put(PATIENT_FIELD_ADDRESS, tokens[10]);
            patient_fields.put(PATIENT_FIELD_RESERVED, tokens[11]);
            patient_fields.put(PATIENT_FIELD_PHONE, tokens[12]);
            patient_fields.put(PATIENT_FIELD_DOCTOR, tokens[13]);
            patient_fields.put(PATIENT_FIELD_SPECIAL1, tokens[14]);
            patient_fields.put(PATIENT_FIELD_SPECIAL2, tokens[15]);
            patient_fields.put(PATIENT_FIELD_HEIGHT, tokens[16]);
            patient_fields.put(PATIENT_FIELD_WEIGHT, tokens[17]);
            patient_fields.put(PATIENT_FIELD_DIAGNOSIS, tokens[18]);
            patient_fields.put(PATIENT_FIELD_MEDICATIONS, tokens[19]);
            patient_fields.put(PATIENT_FIELD_DIET, tokens[20]);
            patient_fields.put(PATIENT_FIELD_PRACTICE1, tokens[21]);
            patient_fields.put(PATIENT_FIELD_PRACTICE2, tokens[22]);
            patient_fields.put(PATIENT_FIELD_DATE_IN_HOSPITAL, tokens[23]);
            patient_fields.put(PATIENT_FIELD_ADMISSION_STATUS, tokens[24]);
            patient_fields.put(PATIENT_FIELD_LOCATION, tokens[25]);
            patient_fields.put(PATIENT_FIELD_ALTERNATIVE_DIAGNOSTIC_CODES, tokens[26]);
            patient_fields.put(PATIENT_FIELD_DIAGNOSTIC_CODES, tokens[27]);
            patient_fields.put(PATIENT_FIELD_RELIGION, tokens[28]);
            patient_fields.put(PATIENT_FIELD_MARITAL_STATUS, tokens[29]);
            patient_fields.put(PATIENT_FIELD_ISOLATION_STATUS, tokens[30]);
            patient_fields.put(PATIENT_FIELD_LANGUAGE, tokens[31]);
            patient_fields.put(PATIENT_FIELD_HOSPITAL_SERVICE, tokens[32]);
            patient_fields.put(PATIENT_FIELD_HOSPITAL_INSTITUTION, tokens[33]);
            patient_fields.put(PATIENT_FIELD_DOSAGE_CATEGORY, tokens[34]);
            return patient_fields;
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            return null;
        }
    }

    public static Hashtable<Integer, String> parseDefaultOrderRecord(String record) {
        try {
            record = ASTMStandard.removeCR(record);
            record = ASTMStandard.fillRecordFields(record, ORDER_RECORD_FIELDS_NUMBER);
            String[] tokens = ASTMStandard.tokenizeRecordFields(record, ORDER_RECORD_FIELDS_NUMBER);
            Hashtable<Integer, String> order_fields = new Hashtable<Integer, String>();
            order_fields.put(RECORD_TYPE, tokens[0]);
            order_fields.put(SEQUENCE_NUMBER, tokens[1]);
            order_fields.put(ORDER_FIELD_SAMPLE_ID, tokens[2]);
            order_fields.put(ORDER_FIELD_SYSTEM_SID, tokens[3]);
            order_fields.put(ORDER_FIELD_TEST_ID, tokens[4]);
            order_fields.put(ORDER_FIELD_PRIORITY, tokens[5]);
            order_fields.put(ORDER_FIELD_REQUESTED_DATETIME, tokens[6]);
            order_fields.put(ORDER_FIELD_COLLECTION_DATETIME, tokens[7]);
            order_fields.put(ORDER_FIELD_COLLECTION_LASTTIME, tokens[8]);
            order_fields.put(ORDER_FIELD_COLLECTION_AMOUNT, tokens[9]);
            order_fields.put(ORDER_FIELD_COLLECTOR_ID, tokens[10]);
            order_fields.put(ORDER_FIELD_ACTION_CODE, tokens[11]);
            order_fields.put(ORDER_FIELD_DANGER_CODE, tokens[12]);
            order_fields.put(ORDER_FIELD_RELEVANT_CLINICAL_INFO, tokens[13]);
            order_fields.put(ORDER_FIELD_DATE_SAMPLE_RECEIVED, tokens[14]);
            order_fields.put(ORDER_FIELD_SAMPLE_INFO, tokens[15]);
            order_fields.put(ORDER_FIELD_ORDERING_DOCTOR, tokens[16]);
            order_fields.put(ORDER_FIELD_DOCTOR_PHONE, tokens[17]);
            order_fields.put(ORDER_FIELD_USER1, tokens[18]);
            order_fields.put(ORDER_FIELD_USER2, tokens[19]);
            order_fields.put(ORDER_FIELD_LAB1, tokens[20]);
            order_fields.put(ORDER_FIELD_LAB2, tokens[21]);
            order_fields.put(ORDER_FIELD_DATETIME_REPORTED, tokens[22]);
            order_fields.put(ORDER_FIELD_CHARGE, tokens[23]);
            order_fields.put(ORDER_FIELD_SYSTEM_SECTION, tokens[24]);
            order_fields.put(ORDER_FIELD_REPORT_TYPE, tokens[25]);
            order_fields.put(ORDER_FIELD_RESERVED, tokens[26]);
            order_fields.put(ORDER_FIELD_COLLECTION_WARD, tokens[27]);
            order_fields.put(ORDER_FIELD_NOSOCOMIAL_FLAG, tokens[28]);
            order_fields.put(ORDER_FIELD_SAMPLE_SERVICE, tokens[29]);
            order_fields.put(ORDER_FIELD_SAMPLE_INSTITUTION, tokens[30]);
            return order_fields;
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            return null;
        }
    }

    public static Hashtable parseDefaultResultRecord(String record) {
        try {
            record = ASTMStandard.removeCR(record);
            record = ASTMStandard.fillRecordFields(record, RESULT_RECORD_FIELDS_NUMBER);
            String[] tokens = ASTMStandard.tokenizeRecordFields(record, RESULT_RECORD_FIELDS_NUMBER);
            Hashtable<Integer, String> result_fields = new Hashtable<Integer, String>();
            result_fields.put(RECORD_TYPE, tokens[0]);
            result_fields.put(SEQUENCE_NUMBER, tokens[1]);
            result_fields.put(RESULT_FIELD_TEST_ID, tokens[2]);
            result_fields.put(RESULT_FIELD_MEASUREMENT_VALUE, tokens[3]);
            result_fields.put(RESULT_FIELD_UNITS, tokens[4]);
            result_fields.put(RESULT_FIELD_REFERENCE_RANGES, tokens[5]);
            result_fields.put(RESULT_FIELD_ABNORMAL_FLAGS, tokens[6]);
            result_fields.put(RESULT_FIELD_CAUSE_OF_ABNORMALITY, tokens[7]);
            result_fields.put(RESULT_FIELD_RESULT_STATUS, tokens[8]);
            result_fields.put(RESULT_FIELD_CHANGE_DATE, tokens[9]);
            result_fields.put(RESULT_FIELD_OPERATOR_ID, tokens[10]);
            result_fields.put(RESULT_FIELD_DATETIME_STARTED, tokens[11]);
            result_fields.put(RESULT_FIELD_DATETIME_ENDED, tokens[12]);
            result_fields.put(RESULT_FIELD_INSTRUMENT_ID, tokens[13]);
            return result_fields;
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            return null;
        }
    }

    public static Hashtable parseDefaultCommentRecord(String record) {
        try {
            record = ASTMStandard.removeCR(record);
            record = ASTMStandard.fillRecordFields(record, COMMENT_RECORD_FIELDS_NUMBER);
            String[] tokens = ASTMStandard.tokenizeRecordFields(record, COMMENT_RECORD_FIELDS_NUMBER);
            Hashtable<Integer, String> comment_fields = new Hashtable<Integer, String>();
            comment_fields.put(RECORD_TYPE, tokens[0]);
            comment_fields.put(SEQUENCE_NUMBER, tokens[1]);
            comment_fields.put(COMMENT_FIELD_SOURCE, tokens[2]);
            comment_fields.put(COMMENT_FIELD_TEXT, tokens[3]);
            comment_fields.put(COMMENT_FIELD_TYPE, tokens[4]);
            return comment_fields;
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            return null;
        }
    }

    public static Hashtable parseDefaultRequestRecord(String record) {
        try {
            record = ASTMStandard.removeCR(record);
            record = ASTMStandard.fillRecordFields(record, REQUEST_RECORD_FIELDS_NUMBER);
            String[] tokens = ASTMStandard.tokenizeRecordFields(record, REQUEST_RECORD_FIELDS_NUMBER);
            Hashtable<Integer, String> request_fields = new Hashtable<Integer, String>();
            request_fields.put(RECORD_TYPE, tokens[0]);
            request_fields.put(REQUEST_FIELD_SEQUENCE, tokens[1]);
            request_fields.put(REQUEST_FIELD_STARTING_RANGE_ID, tokens[2]);
            request_fields.put(REQUEST_FIELD_ENDING_RANGE_ID, tokens[3]);
            request_fields.put(REQUEST_FIELD_TEST_ID, tokens[4]);
            request_fields.put(REQUEST_FIELD_TIME_RANGE, tokens[5]);
            request_fields.put(REQUEST_FIELD_START_DATETIME, tokens[6]);
            request_fields.put(REQUEST_FIELD_END_DATETIME, tokens[7]);
            request_fields.put(REQUEST_FIELD_DOCTOR_NAME, tokens[8]);
            request_fields.put(REQUEST_FIELD_DOCTOR_PHONE, tokens[9]);
            request_fields.put(REQUEST_FIELD_USER1, tokens[10]);
            request_fields.put(REQUEST_FIELD_USER2, tokens[11]);
            request_fields.put(REQUEST_FIELD_STATUS_CODES, tokens[12]);
            return request_fields;
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            return null;
        }
    }

    public static Hashtable parseDefaultTerminationRecord(String record) {
        try {
            record = ASTMStandard.removeCR(record);
            record = ASTMStandard.fillRecordFields(record, TERMINATION_RECORD_FIELDS_NUMBER);
            String[] tokens = ASTMStandard.tokenizeRecordFields(record, TERMINATION_RECORD_FIELDS_NUMBER);
            Hashtable<Integer, String> termination_fields = new Hashtable<Integer, String>();
            termination_fields.put(RECORD_TYPE, tokens[0]);
            termination_fields.put(SEQUENCE_NUMBER, tokens[1]);
            termination_fields.put(TERMINATION_FIELD_CODE, tokens[2]);
            return termination_fields;
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            return null;
        }
    }

    public static Hashtable<Integer, String> parseDefaultManufacturerRecord(String record) {
        try {
            record = ASTMStandard.removeCR(record);
            record = ASTMStandard.fillRecordFields(record, MANUFACTURER_RECORD_FIELDS_NUMBER);
            String[] tokens = ASTMStandard.tokenizeRecordFields(record, MANUFACTURER_RECORD_FIELDS_NUMBER);
            Hashtable<Integer, String> manufacturer_fields = new Hashtable<Integer, String>();
            manufacturer_fields.put(RECORD_TYPE, tokens[0]);
            manufacturer_fields.put(SEQUENCE_NUMBER, tokens[1]);
            manufacturer_fields.put(MANUFACTURER_FIELD_RECORD_SUB_ID, tokens[2]);
            manufacturer_fields.put(MANUFACTURER_FIELD_RAW_OR_TEST_CODE, tokens[3]);
            manufacturer_fields.put(MANUFACTURER_FIELD_RESULT_VALUE, tokens[4]);
            return manufacturer_fields;
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            return null;
        }
    }

    public static String readFirstRecordInMessage(String message) {
        if (message != null && !message.equals("")) {
            int record_end = message.indexOf(CR);
            if (record_end > 0) {
                return message.substring(0, record_end + 1);
            }
            return null;
        }
        return null;
    }

    public static String[] removeFirstRecordInMessage(String message) {
        if (message != null && !message.equals("")) {
            int record_end = message.indexOf(CR);
            if (record_end > 0) {
                String[] record_and_message = new String[]{message.substring(0, record_end + 1), record_end + 1 < message.length() ? message.substring(record_end + 1) : null};
                return record_and_message;
            }
            return new String[]{null, null};
        }
        return new String[]{null, null};
    }

    public static String getRecordTypeIdentifier(String record) {
        if (record != null && !record.equals("")) {
            char record_type = record.charAt(0);
            switch (record_type) {
                case 'h': {
                    return RECORD_TYPE_HEADER;
                }
                case 'H': {
                    return RECORD_TYPE_HEADER;
                }
                case 'p': {
                    return RECORD_TYPE_PATIENT;
                }
                case 'P': {
                    return RECORD_TYPE_PATIENT;
                }
                case 'o': {
                    return RECORD_TYPE_ORDER;
                }
                case 'O': {
                    return RECORD_TYPE_ORDER;
                }
                case 'r': {
                    return RECORD_TYPE_RESULT;
                }
                case 'R': {
                    return RECORD_TYPE_RESULT;
                }
                case 'q': {
                    return RECORD_TYPE_REQUEST;
                }
                case 'Q': {
                    return RECORD_TYPE_REQUEST;
                }
                case 'l': {
                    return RECORD_TYPE_TERMINATION;
                }
                case 'L': {
                    return RECORD_TYPE_TERMINATION;
                }
                case 'm': {
                    return RECORD_TYPE_MANUFACTURER;
                }
                case 'M': {
                    return RECORD_TYPE_MANUFACTURER;
                }
                case 'c': {
                    return RECORD_TYPE_COMMENT;
                }
                case 'C': {
                    return RECORD_TYPE_COMMENT;
                }
            }
            return null;
        }
        return null;
    }

    public static String getCurrentMoment() {
        return new SimpleDateFormat("yyyyMMddHHmmss").format(new Date(System.currentTimeMillis()));
    }
}

