/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.miura;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.interfaces.miura.InterfaceConfiguracao;
import jalis.laboratorio.interfaceamento.interfaces.miura.RecordParser;
import jalis.laboratorio.interfaceamento.interfaces.miura.astm.InterfaceASTMListener;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.interfaceamento.util.ThreadRecebimento;
import jalis.util.Funcoes;
import jalis.util.MemoryList;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class InterfaceListener
extends InterfaceASTMListener {
    private ThreadRecebimento threadRecebimento;
    private long tempoEnvio = 100L;
    private InterfaceConfiguracao configuracao = new InterfaceConfiguracao();

    public InterfaceListener() {
        this.threadRecebimento = new ThreadRecebimento(this, 150);
        RecordParser record = new RecordParser();
        record.setInterfaceASTMListener(this);
        super.setASTMRecordParser(record);
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        this.configuracao.setXmlVariaveis(c.getVariaveisConfiguracao());
    }

    @Override
    public String getErroTraduzido(String erro) {
        return erro;
    }

    public static InterfaceConfiguracao configuracaoTempo() {
        InterfaceConfiguracao configuracao = new InterfaceConfiguracao();
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        configuracao.setXmlVariaveis(c.getVariaveisConfiguracao());
        return configuracao;
    }

    @Override
    public void dataChanged() {
        try {
            String message = this.getPortaCOM().getInputString();
            if (message.length() == 2 && message.equals(String.valueOf('\u0004') + String.valueOf('\u0005'))) {
                this.getPortaCOM().write(String.valueOf('\u0006'));
            }
            if (!(message = this.getPortaCOM().removeInputString(this.getMsgEnd())).equals("")) {
                if (message.charAt(0) == '\u0005' && message.length() > 1 && message.charAt(message.length() - 1) == '\u0005') {
                    this.handShakeCharReceived('\u0006');
                } else {
                    this.getPortaCOM().write(String.valueOf('\u0006'));
                    if (this.isRX()) {
                        this.aguardarProximoFrame();
                    }
                    this.addListaRecebimento(message);
                    this.restartThreadRecebimento();
                }
            } else if (this.isRX()) {
                this.aguardarProximoFrame();
            }
        }
        catch (Exception ex) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: evento de dados recebidos");
                }
            });
            this.fireMensagemEnviada("Erro ao receber dados do equipamento: " + ex.getMessage(), 1, 5000);
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public void addListaRecebimento(String message) {
        this.threadRecebimento.addListaRecebimento(message);
    }

    public void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            ArrayList<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento(this);
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        if (this.threadRecebimento != null) {
            this.threadRecebimento.start();
        }
    }

    public void setTuboPai(String rec_tuboPai) {
        this.rec_tuboPai = rec_tuboPai;
    }

    public void setCurva(boolean curva) {
        this.curva = curva;
    }

    public boolean isCurva() {
        return this.curva;
    }

    public void addExameFilho(String exame) {
        this.examesFilho.add(exame);
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        return this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rackposition, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, exames, acao, null);
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao, HashMap<String, String> mapaParametros) {
        try {
            ExameMaterial[] exa_lista;
            if (this.tx_list == null) {
                this.tx_list = new MemoryList();
            }
            if (this.rx_list == null) {
                this.rx_list = new MemoryList();
            }
            this.tx_list.clear();
            this.rx_list.clear();
            this.fil_codigo = fil_codigo;
            this.int_codigo = int_codigo;
            this.req_codigo = req_codigo;
            this.pac_nome = pac_nome;
            this.pac_sexo = pac_sexo;
            this.req_idade = pac_idade;
            this.req_data = data;
            this.req_hora = hora;
            this.mco_codigo = mco_codigo;
            this.rec_codigo = rec_codigo;
            this.pac_exames = pac_exames;
            this.exames = pac_exames.split(" ", 0);
            this.ultima_acao = acao;
            Statement st = Conexao.getStatement();
            String short_name = StringUtil.removerAcentos(pac_nome);
            if (short_name.length() > this.MAX_PATIENT_NAME_CHARS) {
                short_name = short_name.substring(0, this.MAX_PATIENT_NAME_CHARS);
            }
            fil_codigo = Funcoes.preencheZero(fil_codigo, ParametrosGerais.getDigitosTuboFilial());
            req_codigo = Funcoes.preencheZero(req_codigo, ParametrosGerais.getDigitosTuboRequisicao());
            StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo);
            rec_codigo = Funcoes.preencheZero(rec_codigo, ParametrosGerais.getDigitosTuboTubo());
            codigo.append(rec_codigo);
            if (mapaParametros != null && !Funcoes.textoVazio(mapaParametros.get("codigoApoiado")) && !mapaParametros.get("codigoApoiado").equals(codigo.toString())) {
                codigo.setLength(0);
                codigo.append(mapaParametros.get("codigoApoiado"));
            }
            String tipoAmostra = "";
            if (this.curva) {
                ExameMaterial[] exameFilho = BDUtil.getExameMaterialRecipiente(fil_codigo, req_codigo, rec_codigo, int_codigo);
                exa_lista = ExamesUtil.anexarCodigoMaterial(new String[]{exameFilho[0].getNomeExame()}, exameFilho[0].getCodigoMaterial());
                tipoAmostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, exameFilho[0].getString(), exameFilho[0].getCodigo().toString(), int_codigo);
                if (tipoAmostra == null) {
                    tipoAmostra = "";
                }
            } else {
                exa_lista = ExamesUtil.anexarCodigoMaterial(this.exames, mco_codigo);
            }
            exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_lista);
            ExameMaterial[] alternativos = ExamesUtil.getAlternativos(st, fil_codigo, int_codigo, exa_lista);
            alternativos = ExamesUtil.removeDuplicados(alternativos);
            String nome = short_name;
            String sobrenome = null;
            this.tx_list.add(this.getHeaderRecord());
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o cabe\u00e7alho de envio");
            }
            String patient_id = codigo.toString();
            Object laboratory_pid = null;
            Date dtNascimento = BDUtil.getDataNacimentoPaciente(fil_codigo, req_codigo);
            if (dtNascimento == null) {
                dtNascimento = new Date();
            }
            this.tx_list.add(this.getPatientRecord(1, patient_id, nome, sobrenome, pac_sexo, Funcoes.formataData("yyyyMMdd", dtNascimento)));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel  montar o registro do paciente");
            }
            exa_lista = null;
            for (int i = 0; i < alternativos.length; ++i) {
                this.tx_list.add(this.getOrderRecord(i + 1, codigo.toString(), alternativos[i], exa_lista, null, "R", acao, tipoAmostra));
            }
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o registro da requisicao");
            }
            this.tx_list.add(this.getTerminationRecord("N"));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o rodap\u00e9 de envio");
            }
            this.tx_list = this.makeFrames(this.tx_list);
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            this.getPortaCOM().write(String.valueOf('\u0005'));
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: envio de requisi\u00e7\u00e3o");
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o em envio de requisi\u00e7\u00e3o");
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    @Override
    public void encerrarTransmissao() throws Exception {
        if (this.curva) {
            if (this.tx_list.getUltimoLido() == this.tx_list.size() - 1) {
                Statement st = Conexao.getStatement();
                if (this.exames != null) {
                    for (int i = 0; i < this.exames.length; ++i) {
                        int situacao;
                        if (!Funcoes.textoVazio(this.rec_tuboPai) && this.curva && !this.examesFilho.isEmpty()) {
                            for (String exame : this.examesFilho) {
                                int situacao2 = BDUtil.getDesmSituacao(this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_tuboPai, exame, this.mco_codigo);
                                if (situacao2 >= 0) {
                                    BDUtil.setExmSituacaoFilho(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, exame, this.mco_codigo, this.rec_tuboPai, situacao2 < 2 ? 1 : 3);
                                    continue;
                                }
                                BDExame[] filho = BDUtil.getDesmExamesFilhos(this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_tuboPai, this.rec_codigo);
                                if (filho == null) continue;
                                BDUtil.setExmSituacaoFilho(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, exame, filho[0].getMaterial(), this.rec_tuboPai, situacao2 < 2 ? 1 : 3);
                            }
                            situacao = this.getExameSituacao(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_codigo);
                            if (!BDUtil.isGrupoInteiroPendente(this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_tuboPai)) continue;
                            this.atualizarSituacaoExame(st, this.fil_codigo, this.req_codigo, this.rec_tuboPai, this.exames[i], this.mco_codigo, this.int_codigo, null, situacao < 2 ? 1 : 3);
                            continue;
                        }
                        if (!this.examesFilho.isEmpty()) {
                            situacao = this.getExameSituacao(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_codigo);
                            this.atualizarSituacaoExame(st, this.fil_codigo, this.req_codigo, this.rec_codigo, this.exames[i], this.mco_codigo, this.int_codigo, null, situacao < 2 ? 1 : 3);
                            BDUtil.setExmSituacaoTodosFilhos(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_codigo, situacao < 2 ? 1 : 3);
                            continue;
                        }
                        situacao = this.getExameSituacao(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_codigo);
                        this.atualizarSituacaoExame(st, this.fil_codigo, this.req_codigo, this.rec_codigo, this.exames[i], this.mco_codigo, this.int_codigo, null, situacao < 2 ? 1 : 3);
                    }
                    Conexao.arquivaSQL();
                    String acao = this.ultima_acao.equals("C") ? "excluido(s)" : "enviado(s)";
                    this.fireMensagemEnviada("Exame(s) " + acao + " com sucesso para " + this.pac_nome, 0, 10000);
                } else {
                    this.fireMensagemEnviada("Nenhum exame localizado para encerrar para " + this.pac_nome, 0, 10000);
                }
            }
            this.curva = false;
            this.rec_tuboPai = "";
            this.examesFilho.clear();
            this.getPortaCOM().write(String.valueOf('\u0004'));
            this.getPortaCOM().clearInputString();
            this.interromperTimer();
            if (this.ultima_acao.equals("N")) {
                this.firePacienteEnviado(this.req_codigo, this.pac_nome, this.pac_sexo, this.req_idade, this.req_data, this.req_hora, this.pac_exames);
            }
            this.fireAtualizarTabela(0);
            this.limpaDadosRequisicao();
            this.setIdle();
        } else {
            super.encerrarTransmissao();
        }
    }

    @Override
    public void teste() {
        int op = JOptionPane.showOptionDialog(null, "Op\u00e7\u00e3o", "Tipo teste", 0, 0, null, new String[]{"Query", "ACK", "Resultado", "EOT"}, null);
        if (op == 0) {
            this.query();
        } else if (op == 1) {
            this.confirmacaoACK();
        } else if (op == 2) {
            this.resultado();
        } else if (op == 3) {
            this.finalizaTransmissao();
        }
    }

    protected void finalizaTransmissao() {
        this.handShakeCharReceived('\u0004');
    }

    protected void confirmacaoACK() {
        this.handShakeCharReceived('\u0006');
    }

    private void query() {
        String idAmosta = JOptionPane.showInputDialog("Informe o Id da amostra?");
        this.parse(this.equipamento.arruma("[STX]1H|\\^&|||ASI^1.0^s/n^H1P1O1R1Q1L1C1|||||My^Host^System||P|1|19930631[CR][ETX]FF[LINE]"));
        this.parse(this.equipamento.arruma("[STX]2Q|1|^" + idAmosta + "||^^^ALL||||||||O[CR][ETX]FF[LINE]"));
        this.parse(this.equipamento.arruma("[STX]3L|1|N[CR][ETX]FF[LINE]"));
        this.finalizaTransmissao();
    }

    private void resultado() {
        String idAmostra = JOptionPane.showInputDialog("Informe o Id da amostra?");
        String alternativo = JOptionPane.showInputDialog("Informe o alternativo do exame?");
        if (Funcoes.textoVazio(idAmostra) || Funcoes.textoVazio(alternativo)) {
            return;
        }
        this.parse(this.equipamento.arruma("[STX]0H|\\^&|||Miura||||||Laboratorio[SP]Vicenlab[SP]|P|LIS2-A2|20140906103004[ETX]4F[LINE]"));
        this.parse(this.equipamento.arruma("[STX]1P|1||0101114302|||||M|W|||||||||||||||||||U|S|||||A[ETX]C3[LINE]"));
        this.parse(this.equipamento.arruma("[STX]2O|1||" + idAmostra + "|C^CR^NONE^1|R||||||N||||S||||||||||O||||||[ETX]57[LINE]"));
        this.parse(this.equipamento.arruma("[STX]3R|1|C^" + alternativo + "^NONE^1|1.246159|mg/dl|0.700000:1.200000|H||F||VICENLAB1|||Miura[ETX]07[LINE]"));
        this.parse(this.equipamento.arruma("[STX]4C|1|I|ONO|I[ETX]19[LINE]"));
        this.parse(this.equipamento.arruma("[STX]5L|1|N[ETX]FB[LINE]"));
    }

    public String getHeaderRecord() {
        StringBuilder record = new StringBuilder("H|");
        record.append(this.DELIMITERS);
        record.append("||||||||||P|LIS2-A2|");
        record.append(this.getCurrentMoment()).append("|");
        record.append('\r');
        return record.toString();
    }

    public String getPatientRecord(int patient_sequence, String patient_id, String pac_nome, String pac_sobrenome, String pac_sexo, String pac_nascimento) {
        StringBuilder record = new StringBuilder("P|");
        record.append(patient_sequence);
        record.append("|");
        record.append(patient_id == null ? "" : patient_id);
        record.append("|");
        record.append(patient_id == null ? "" : patient_id);
        record.append("||");
        record.append(pac_sobrenome == null ? "" : pac_sobrenome);
        record.append(pac_nome == null ? "" : "^" + pac_nome);
        record.append("||");
        record.append(pac_nascimento == null ? "" : pac_nascimento);
        record.append("|");
        record.append(pac_sexo == null ? "" : pac_sexo);
        record.append("||||||||||||||||||||||||||A||");
        record.append('\r');
        return record.toString();
    }

    public String getOrderRecord(int order_sequence, String sample_id, ExameMaterial test_item_numbers, ExameMaterial[] test_item_names, String dilution, String priority, String action_code, String tipoAmostra) {
        StringBuilder record = new StringBuilder("O|");
        record.append(order_sequence);
        record.append("|");
        record.append(sample_id == null ? "" : sample_id);
        record.append("|");
        record.append(sample_id == null ? "" : sample_id);
        record.append("|");
        if (test_item_numbers != null) {
            String tmp = test_item_numbers.getNomeExame();
            if (tmp != null && !tmp.matches("\\^\\d+\\^\\w+\\^\\d+")) {
                tmp = "^" + test_item_numbers.getNomeExame() + "^NONE^1";
            }
            record.append(tmp);
        }
        record.append("|");
        record.append(priority == null ? "" : priority);
        record.append("|");
        record.append(this.getCurrentMoment());
        record.append("|||||");
        record.append("A");
        record.append("||||");
        record.append(tipoAmostra).append("|||||||||O||||||");
        record.append("|||||||||||||O||||||");
        record.append('\r');
        return record.toString();
    }

    public String getTerminationRecord(String termination_code) {
        StringBuilder record = new StringBuilder("L|1|");
        record.append(termination_code == null ? "" : termination_code);
        record.append("|");
        record.append('\r');
        return record.toString();
    }

    public String getCurrentMoment() {
        return new SimpleDateFormat("yyyyMMddHHmmss").format(new Date(System.currentTimeMillis()));
    }

    @Override
    public Map<Integer, String> parseOrderTestIDField(String test_id_field) {
        try {
            StringBuilder temp = StringUtil.preencheStringOcorrencias(new StringBuilder(test_id_field), 4, '^', 0);
            HashMap<Integer, String> components = new HashMap<Integer, String>();
            String[] tokens = temp.toString().split("\\^", -1);
            components.put(this.TEST_ITEM_NUMBER, tokens[1]);
            return components;
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: parse de Test ID Field (Order Frame)");
            return null;
        }
    }

    @Override
    public void handShakeCharReceived(char c) {
        try {
            switch (c) {
                case '\u0005': {
                    if (this.isTX() || this.tx_list.size() > 0 && this.rx_counter < this.MAX_TENTATIVAS_RX) {
                        this.getPortaCOM().write(String.valueOf('\u0015'));
                        ++this.rx_counter;
                        break;
                    }
                    this.rx_counter = 0;
                    this.tratarEnquiry();
                    break;
                }
                case '\u0006': {
                    this.tratarAcknowledge();
                    break;
                }
                case '\u0015': {
                    this.tratarNegativeAck();
                    break;
                }
                case '\u0004': {
                    this.tratarEndOfTX();
                    Thread.sleep(this.configuracao.getTempoDeAutoEnvio());
                    break;
                }
                default: {
                    this.caracterNaoEsperado();
                    break;
                }
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: evento de caracter de handshake recebido");
            this.fireMensagemEnviada("Erro ao estabelecer comunica\u00e7\u00e3o com o equipamento: " + ex.getMessage(), 1, 5000);
            if (this.tx_list.size() > 0) {
                this.limpaDadosRequisicao();
            }
            this.setIdle();
        }
    }
}

