/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.miura;

import jalis.laboratorio.interfaceamento.InterfaceamentoConfiguracao;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;

public class InterfaceConfiguracao
extends InterfaceamentoConfiguracao {
    private static final String TEMPO_DE_ENVIO_PARA_CURVAS = "tempoDeEnvioParaCurvas";
    private static final String TEMPO_DE_AUTOENVIO = "tempoDeAutoEnvio";
    private String tempoDeEnvioParaCurvas = "2";
    private long tempoDeAutoEnvio;

    @Override
    public String getXmlVariaveis() {
        String str = super.getXmlVariaveis();
        try {
            XMLStringBuilder xml = new XMLStringBuilder();
            xml.abrir("variavel");
            xml.escrever("nome", TEMPO_DE_ENVIO_PARA_CURVAS);
            xml.escrever("valor", this.getTempoDeEnvioParaCurvas());
            xml.escrever("tipo", EDIT);
            xml.fechar("variavel");
            xml.abrir("variavel");
            xml.escrever("nome", TEMPO_DE_AUTOENVIO);
            xml.escrever("valor", this.getTempoDeAutoEnvio().toString());
            xml.escrever("tipo", EDIT);
            xml.fechar("variavel");
            return str + xml.getXML();
        }
        catch (XMLStringBuilderException e) {
            e.printStackTrace();
            return str;
        }
    }

    @Override
    public void setXmlVariaveis(String xml) {
        String[] variaveis;
        for (String s : variaveis = StringUtil.getValores(xml, "variavel")) {
            String nome = StringUtil.getValor(s, "nome");
            String valor = StringUtil.getValor(s, "valor");
            if (nome.equalsIgnoreCase(TEMPO_DE_ENVIO_PARA_CURVAS)) {
                this.setTempoDeEnvioParaCurvas(StringUtil.getValor(s, "valor"));
            }
            if (!nome.equalsIgnoreCase(TEMPO_DE_AUTOENVIO)) continue;
            if (Funcoes.isNumeric(StringUtil.getValor(s, "valor"))) {
                this.tempoDeAutoEnvio = Long.parseLong(StringUtil.getValor(s, "valor"));
            }
            this.setTempoDeAutoEnvio(this.tempoDeAutoEnvio);
        }
        super.setXmlVariaveis(xml);
    }

    @Override
    public String getNomeVariavel(String variavel) {
        if (variavel.equalsIgnoreCase(TEMPO_DE_ENVIO_PARA_CURVAS)) {
            return "Tempo de envio entre cada exames de curva";
        }
        if (variavel.equalsIgnoreCase(TEMPO_DE_AUTOENVIO)) {
            return "Tempo de Auto Envio (Milissegundos)";
        }
        return super.getNomeVariavel(variavel);
    }

    public String getTempoDeEnvioParaCurvas() {
        return this.tempoDeEnvioParaCurvas;
    }

    public void setTempoDeEnvioParaCurvas(String tempoDeEnvioParaCurvas) {
        this.tempoDeEnvioParaCurvas = tempoDeEnvioParaCurvas;
    }

    public Long getTempoDeAutoEnvio() {
        return this.tempoDeAutoEnvio;
    }

    public void setTempoDeAutoEnvio(long tempoDeAutoEnvio) {
        this.tempoDeAutoEnvio = tempoDeAutoEnvio;
    }
}

