/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.microses60;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.padroes.astm2.InterfaceASTMListener;
import jalis.laboratorio.interfaceamento.padroes.astm2.Message;
import jalis.laboratorio.interfaceamento.padroes.astm2.MessageReceivedListener;
import jalis.laboratorio.interfaceamento.padroes.astm2.PacketParser;
import jalis.laboratorio.interfaceamento.padroes.astm2.Record;
import jalis.laboratorio.interfaceamento.padroes.astm2.RecordType;
import jalis.laboratorio.interfaceamento.padroes.astm2.records.Result;
import jalis.laboratorio.interfaceamento.padroes.astm2.records.TestOrder;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InterfaceListener
extends InterfaceASTMListener
implements MessageReceivedListener {
    private static final Map<String, String> examesById = new HashMap<String, String>();
    private static final String CODIGO_ALTERNATIVO = "es60";

    @Override
    public String enviarRequisicao(String pacNome, String pacSexo, String pacIdade, String data, String hora, String rackposition, String prioridade, String filCodigo, String intCodigo, String reqCodigo, String mcoCodigo, String recCodigo, String exames, String acao) {
        try {
            Statement st = Conexao.getStatement();
            for (String exame : exames.split(" ")) {
                this.atualizarSituacaoExame(st, filCodigo, reqCodigo, recCodigo, exame, mcoCodigo, intCodigo, null, acao.equals("N") ? 1 : 3);
            }
            Conexao.arquivaSQL();
            this.fireAtualizarTabela();
            this.fireMensagemEnviada("Pedido(s) enviado(s) com sucesso para " + pacNome, 0, 10000);
            return "Enviando requisi\u00e7\u00e3o de " + pacNome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return "Erro ao enviar exames: " + e.getMessage();
        }
    }

    @Override
    protected MessageReceivedListener getMessageReceivedListener() {
        return this;
    }

    @Override
    public void messageReceived(Message message) {
        for (Record record : message.getRecords()) {
            if (record.getType() != RecordType.RESULT) continue;
            this.measureData(message);
            break;
        }
    }

    private void measureData(Message message) {
        try {
            int digitosCodigoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
            if (message.getRecordsByType(RecordType.TEST_ORDER).isEmpty()) {
                this.fireExcecaoEncontrada("Resultado recebido do equipamento incompleto pois est\u00e1 sem o registro da requisi\u00e7\u00e3o");
                return;
            }
            TestOrder testOrder = (TestOrder)message.getRecordsByType(RecordType.TEST_ORDER).get(0);
            String tuboId = testOrder.getSpecimenId().trim();
            if (tuboId != null && tuboId.trim().length() == digitosCodigoTubo && Funcoes.isNumeric(tuboId)) {
                String intCodigo;
                Statement st = Conexao.getStatement();
                String filCodigo = tuboId.substring(0, ParametrosGerais.getDigitosTuboFilial());
                String reqCodigo = tuboId.substring(ParametrosGerais.getDigitosTuboFilial());
                String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
                DescritorCodigoEtiqueta etiqueta = DescritorCodigoEtiqueta.getDescritor(tuboId);
                if (etiqueta != null) {
                    filCodigo = Funcoes.preencheZero(etiqueta.getFilial(), ParametrosGerais.getDigitosTuboFilial());
                    reqCodigo = Funcoes.preencheZero(etiqueta.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao());
                    recCodigo = Funcoes.preencheZero(etiqueta.getTubo(), ParametrosGerais.getDigitosTuboTubo());
                }
                if (Funcoes.textoVazio(intCodigo = this.getIntCodigo(filCodigo, reqCodigo, recCodigo, CODIGO_ALTERNATIVO))) {
                    this.fireExcecaoEncontrada("Nenhum exame localizado para o tubo " + tuboId);
                    return;
                }
                ExameMaterial exame = this.getReqExameLIS(filCodigo, intCodigo, reqCodigo, recCodigo, CODIGO_ALTERNATIVO);
                if (exame != null) {
                    HashMap<String, Object> dados = new HashMap<String, Object>();
                    for (Record resultRecord : message.getRecordsByType(RecordType.RESULT)) {
                        Result result = (Result)resultRecord;
                        String campo = examesById.get(result.getUniversalTestId().getTestNumber());
                        if (campo == null) continue;
                        dados.put(campo, result.getMeasurementValue().replace('.', ','));
                    }
                    List<BDExame> exames = BDUtil.getReqExamesMultGuia(filCodigo, intCodigo, reqCodigo, recCodigo);
                    for (BDExame e : exames) {
                        this.atualizarDadosExame(st, filCodigo, reqCodigo, recCodigo, e.getExame(), e.getMaterial(), intCodigo, dados);
                    }
                } else {
                    this.fireExcecaoEncontrada("Nenhum exame localizado para o tubo " + tuboId);
                    return;
                }
                Conexao.arquivaSQL();
                this.fireAtualizarTabela();
            } else {
                this.fireExcecaoEncontrada("Amostra n\u00e3o identificada: " + tuboId);
            }
        }
        catch (Exception e) {
            try {
                Conexao.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
    }

    @Override
    public void dataChanged(String text) {
        block5: {
            try {
                if (text == null || !this.packetParser.checkFormat(text)) break block5;
                try {
                    PacketParser.PacketParseResult result = this.packetParser.textToData(text);
                    if (result.getParseResult() == PacketParser.ParseResult.SUCCESS) {
                        this.packetRecebido(result.getData());
                        this.enviarHandShake('\u0006');
                        break block5;
                    }
                    this.enviarHandShake('\u0015');
                }
                catch (ParseException e) {
                    this.enviarHandShake('\u0015');
                }
            }
            catch (IOException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Falha na comunica\u00e7\u00e3o");
            }
        }
    }

    @Override
    public void teste() {
        this.handShakeCharReceived('\u0005');
        this.dataChanged(this.equipamento.arruma("[ACK]"));
        this.dataChanged(this.equipamento.arruma("[STX]1H|\\^&|||SAT|||||||P|E[SP]1394-97|20240705153031[CR][ETX]81[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]2P|1||1076017401|||||M||||||||||||||||||||||||||[CR][ETX]E8[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]3O|1|1076017401||^^^LMG|||240705150545|240705150545|||||||||||||||||F|||||[CR][ETX]0A[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]4C|1|I|alarm^^G1^G2|I[CR][ETX]52[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]5R|1|^^^MPV^776-5|7.5|1||||F||labtech||20240705150545|[CR][ETX]31[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]6R|2|^^^PLT^777-3|231|1||||F||labtech||20240705150545|[CR][ETX]2B[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]7R|3|^^^HCT^4544-3|34.4|1||L||F||labtech||20240705150545|[CR][ETX]C7[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]0R|4|^^^HGB^717-9|11.6|1||L||F||labtech||20240705150545|[CR][ETX]84[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]1R|5|^^^MCH^785-6|32.2|1||||F||labtech||20240705150545|[CR][ETX]42[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]2R|6|^^^MCHC^786-4|33.9|1||H||F||labtech||20240705150545|[CR][ETX]D6[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]3R|7|^^^MCV^787-2|95|1||||F||labtech||20240705150545|[CR][ETX]FB[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]4R|8|^^^RBC^789-9|3.61|1||L||F||labtech||20240705150545|[CR][ETX]9D[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]5R|9|^^^RDW^788-0|16.0|1||H||F||labtech||20240705150545|[CR][ETX]A4[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]6R|10|^^^GRA#^20482-6|5.00|1||||F||labtech||20240705150545|[CR][ETX]F2[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]7R|11|^^^GRA%^14773-6|72.2|1||||F||labtech||20240705150545|[CR][ETX]02[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]0R|12|^^^LYM#^731-0|1.50|1||||F||labtech||20240705150545|[CR][ETX]9C[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]1R|13|^^^LYM%^736-9|22.2|1||||F||labtech||20240705150545|[CR][ETX]AE[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]2R|14|^^^MON#^742-7|0.30|1||||F||labtech||20240705150545|[CR][ETX]9E[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]3R|15|^^^MON%^744-3|5.6|1||||F||labtech||20240705150545|[CR][ETX]78[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]4R|16|^^^WBC^804-5|6.8|1||||F||labtech||20240705150545|[CR][ETX]49[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]5L|1|N[CR][ETX]08[LINE]"));
        this.handShakeCharReceived('\u0004');
    }

    static {
        examesById.put("WBC", "leucocitos");
        examesById.put("LYM#", "linfocitos_tipicos_contagem");
        examesById.put("LYM%", "linfocitos_tipicos_percentual");
        examesById.put("MON#", "monocitos_contagem");
        examesById.put("MON%", "monocitos_percentual");
        examesById.put("GRA#", "granulocitos_contagem");
        examesById.put("GRA%", "granulocitos_percentual");
        examesById.put("RBC", "hemacias");
        examesById.put("HGB", "hgb");
        examesById.put("HCT", "hct");
        examesById.put("MCV", "vcm");
        examesById.put("MCH", "hcm");
        examesById.put("MCHC", "mchc");
        examesById.put("RDW", "rdw");
        examesById.put("PLT", "plaquetas");
        examesById.put("MPV", "vpm");
        examesById.put("PCT", "pct");
        examesById.put("THT", "tht");
        examesById.put("PDW", "pdw");
        examesById.put("EOS#", "eosinofilos_contagem");
        examesById.put("EOS%", "eosinofilos_percentual");
        examesById.put("NEU#", "neutrofilo_contagem");
        examesById.put("NEU%", "neutrofilo_percentual");
        examesById.put("BAS#", "basofilos_contagem");
        examesById.put("BAS%", "basofilos_percentual");
        examesById.put("ALY#", "linfocitos_atipicos_contagem");
        examesById.put("ALY%", "linfocitos_atipicos_percentual");
        examesById.put("LIC%", "bastonados_percentual");
    }
}

