/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.microscan;

import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamento;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoFactory;
import jalis.laboratorio.interfaceamento.interfaces.microscan.MicroScan;
import jalis.laboratorio.interfaceamento.padroes.abx.ABXStandard;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import javax.swing.JFrame;

public class InterfaceamentoFactory
implements AbstractInterfaceamentoFactory {
    @Override
    public AbstractInterfaceamento getInterfaceamento(JFrame parent) {
        return new MicroScan(parent);
    }

    @Override
    public String getNomeInterfaceamento() {
        return "MicroScan";
    }

    @Override
    public String getEnvioRequisicao() {
        String fil_codigo = "01";
        String req_codigo = "23456789";
        String rec_codigo = "10";
        String pac_nome = "Paciente Thread Teste";
        String pac_idade = "25";
        String pac_sexo = "M";
        StringBuilder requisicao = new StringBuilder();
        int max_patient_name_chars = 30;
        String short_name = StringUtil.removerAcentos(pac_nome);
        if (short_name.length() > max_patient_name_chars) {
            short_name = short_name.substring(0, max_patient_name_chars);
        }
        fil_codigo = Funcoes.preencheZero(fil_codigo, ParametrosGerais.getDigitosTuboFilial());
        StringBuilder codigo = new StringBuilder(fil_codigo);
        req_codigo = Funcoes.preencheZero(req_codigo, ParametrosGerais.getDigitosTuboRequisicao());
        codigo.append(req_codigo);
        rec_codigo = Funcoes.preencheZero(rec_codigo, ParametrosGerais.getDigitosTuboTubo());
        codigo.append(rec_codigo);
        requisicao.append(ABXStandard.getDefaultHeaderRecord());
        requisicao.append(ABXStandard.getDefaultOrderRecord(codigo.toString(), short_name, "", pac_idade, pac_sexo, "<EXAME>", codigo.toString()));
        requisicao.append(ABXStandard.getDefaultFooterRecord());
        return requisicao.toString();
    }

    @Override
    public String getRetornoRequisicao() {
        return "";
    }

    @Override
    public String getSerialInfo() {
        return "/jalis/laboratorio/interfaceamento/ajuda/microscan.html";
    }

    @Override
    public int getTipoComunicacao() {
        return 0;
    }
}

