/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.microscan;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.InterfaceamentoConfiguracao;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.util.ThreadRecebimento;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    private String HEADER = "H";
    private String PACIENTE = "P";
    private String ORDER = "B";
    private String RESULTADO = "R";
    private String ITEMRESULTADO = "M";
    private String FINAL = "L";
    protected int TIME_TX_ABORTADO = 5000;
    private ThreadRecebimento threadRecebimento;
    private List<String> mensagens = new ArrayList<String>();
    protected Map<String, Object> exame_atual = null;
    private List<String> flagsExame = new ArrayList<String>();
    private List<String[]> resultados = new ArrayList<String[]>();

    public InterfaceListener() {
        this.threadRecebimento = new ThreadRecebimento(this, 100);
        this.carregaConfiguracoes();
    }

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
        if (this.isTX()) {
            this.abortarTransmissao();
        }
        this.setIdle();
    }

    private void carregaConfiguracoes() {
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        InterfaceamentoConfiguracao configuracao = new InterfaceamentoConfiguracao();
        configuracao.setXmlVariaveis(c.getVariaveisConfiguracao());
    }

    @Override
    public void dataChanged() {
        try {
            String message = this.getPortaCOM().removeInputString(this.getMsgEnd());
            if (!message.equals("")) {
                String[] messages;
                System.out.println("Adicionou msg");
                for (String msg : messages = message.split(String.valueOf('\u0003'))) {
                    this.threadRecebimento.addListaRecebimento(msg);
                }
                this.restartThreadRecebimento();
            } else {
                System.out.println(message);
                this.aguardarProximoFrame();
            }
        }
        catch (Exception ex) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ErrorLogger.mostraMensagem(null, "Erro ao receber dados do equipamento", ex.getStackTrace());
                }
            });
        }
    }

    protected void aguardarProximoFrame() throws Exception {
        this.setRX(15000);
        this.fireMensagemEnviada("Recebendo dados...", 0, 10000);
    }

    public void dataChanged(String message) {
        try {
            if (!message.equals("")) {
                this.threadRecebimento.addListaRecebimento(message);
                this.restartThreadRecebimento();
            }
        }
        catch (Exception ex) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ErrorLogger.mostraMensagem(null, "Erro ao receber dados do equipamento", ex.getStackTrace());
                }
            });
        }
    }

    @Override
    public void handShakeCharReceived(char c) {
    }

    @Override
    public String getMsgEnd() {
        return String.valueOf('\u0003');
    }

    @Override
    public String getMsgStart() {
        return String.valueOf('\u0002');
    }

    @Override
    public String parse(String message) {
        if (!Funcoes.textoVazio(message)) {
            String operacao = (message = message.substring(1, message.length() > 2 ? message.length() - 2 : 1)).substring(0, 1);
            if (operacao.equals(this.FINAL)) {
                this.resultados.add(message.split(","));
                ArrayList<String[]> listaMsgs = new ArrayList<String[]>(this.resultados);
                this.registraResultado(listaMsgs);
                this.resultados.clear();
            } else {
                this.resultados.add(message.split(","));
            }
        }
        return "";
    }

    protected void abortarTransmissao() throws Exception {
        this.setPausa(this.TIME_TX_ABORTADO);
        this.getPortaCOM().write(String.valueOf('\u0004'));
        this.fireMensagemEnviada("Tempo esgotado ao transmitir dados ao equipamento", 1, 5000);
    }

    private void registraResultado(List<String[]> resultados) {
        Map<String, Object> exameAtual = new HashMap<String, Object>();
        String req_codigo = "";
        String mco_codigo = "";
        String rec_codigo = "";
        String fil_codigo = "";
        String int_codigo = "";
        String exa_codigo = "";
        String codigoExame = "";
        String descricaoExame = "";
        ArrayList<String[]> listaDeResultado = new ArrayList<String[]>();
        for (String[] stringArray : resultados) {
            String string = stringArray[0];
            if (string.equals(this.PACIENTE)) continue;
            if (string.equals(this.ORDER)) {
                String tuboId = stringArray[3];
                tuboId = tuboId.replaceAll("\"", "");
                int tuboTamanho = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
                if (Funcoes.textoVazio(tuboId) || tuboId.length() != tuboTamanho) {
                    this.fireExcecaoEncontrada(String.format("Amostra com o c\u00f3digo fora do padr\u00e3o %s ", tuboId));
                    continue;
                }
                fil_codigo = tuboId.substring(0, ParametrosGerais.getDigitosTuboFilial());
                req_codigo = tuboId.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
                rec_codigo = tuboId.substring(ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao(), ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo());
                continue;
            }
            if (string.equals(this.RESULTADO) && !Funcoes.textoVazio(req_codigo)) {
                codigoExame = "CULT";
                descricaoExame = stringArray[5];
                exameAtual = this.leResultado(stringArray, exameAtual);
                continue;
            }
            if (!string.equals(this.ITEMRESULTADO)) continue;
            listaDeResultado.add(stringArray);
        }
        if (!Funcoes.textoVazio(codigoExame)) {
            try {
                int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, codigoExame);
                if (int_codigo == null) {
                    this.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + codigoExame + " n\u00e3o encontrado na interface para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                    exameAtual = null;
                    return;
                }
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, "Erro ao receber dados do equipamento", e.getStackTrace());
            }
            int pos = 1;
            for (String[] stringArray : listaDeResultado) {
                String campoNome = this.getNomeFarmaco(pos, "farmacoNome01".substring(0, "farmacoNome01".length() - 2));
                String campoVlr = this.getNomeFarmaco(pos, "farmacoVlr01".substring(0, "farmacoVlr01".length() - 2));
                String campoInterpretacao = this.getNomeFarmaco(pos, "farmacoInterpretacao01".substring(0, "farmacoInterpretacao01".length() - 2));
                String campoSystemic = this.getNomeFarmaco(pos, "farmacoSystemic01".substring(0, "farmacoSystemic01".length() - 2));
                String campoUrine = this.getNomeFarmaco(pos, "farmacoUrine01".substring(0, "farmacoUrine01".length() - 2));
                String siglaFarmaco = stringArray[2].replaceAll("\"", "");
                String nomeFarmaco = stringArray[3].replaceAll("\"", "");
                String exameResposta = stringArray[4].replaceAll("\"", "");
                String testeInterpretacao = stringArray[7].replaceAll("\"", "");
                String clsi = stringArray[7].replaceAll("\"", "");
                String clsiUrine = stringArray[8].replaceAll("\"", "");
                ++pos;
                exameAtual.put(campoNome, this.formatarNome(nomeFarmaco, siglaFarmaco));
                exameAtual.put(campoVlr, exameResposta);
                exameAtual.put(campoInterpretacao, testeInterpretacao);
                exameAtual.put(campoSystemic, clsi);
                exameAtual.put(campoUrine, clsiUrine);
            }
            try {
                ExameMaterial exameMaterial = this.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, codigoExame);
                if (exameMaterial == null) {
                    this.fireExcecaoEncontrada(String.format("Exame n\u00e3o encontrado %s ", codigoExame));
                } else {
                    Statement statement = Conexao.getStatement();
                    this.atualizarDadosExame(statement, fil_codigo, req_codigo, rec_codigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial().toString(), int_codigo, exameAtual, this.flagsExame);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            InterfaceListener.this.fireAtualizarTabela(1);
                            InterfaceListener.this.fireAtualizarTabela(2);
                        }
                    });
                }
            }
            catch (SQLException sQLException) {
                ErrorLogger.mostraMensagem(null, "Erro ao receber dados do equipamento", sQLException.getStackTrace());
            }
            catch (Exception exception) {
                ErrorLogger.mostraMensagem(null, "Erro ao receber dados do equipamento", exception.getStackTrace());
            }
        }
    }

    private String formatarNome(String nome, String sigla) {
        return String.format("%s (%s)", nome, sigla);
    }

    private String getNomeFarmaco(int pos, String campo) {
        return String.format("%s%s", campo, Funcoes.preencheZero(pos, 2));
    }

    private Map<String, Object> leResultado(String[] linha, Map<String, Object> exameAtual) {
        String nosocomialInfectionFlag = "";
        String codigoOrganismo = "";
        String descricaoOrganismo = "";
        String biotipoNumero = "";
        String betaLactamaseResult = "";
        String reacaoOxidase = "";
        String resultadoStreptomycin = "";
        String resultadoGentamicin = "";
        String resultadoThymidine = "";
        String flagBetaHemolytic = "";
        String excludeResult = "";
        String esblResult = "";
        String organismClass = "";
        String organismSet = "";
        String isolateStatus = "";
        if (linha.length >= 8) {
            nosocomialInfectionFlag = linha[8];
            codigoOrganismo = linha[11];
            descricaoOrganismo = linha[12].replaceAll("\"", "");
            biotipoNumero = linha[13];
            betaLactamaseResult = linha[14];
            reacaoOxidase = linha[15];
            resultadoStreptomycin = linha[16];
            resultadoGentamicin = linha[17];
            resultadoThymidine = linha[18];
            flagBetaHemolytic = linha[21];
            excludeResult = linha[24];
            esblResult = linha[27];
            organismSet = linha[29];
            organismClass = linha[35];
            isolateStatus = linha[37];
        }
        exameAtual.put("OrganismClass", descricaoOrganismo);
        exameAtual.put("esbl", esblResult);
        return exameAtual;
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao, HashMap<String, String> mapaParametros) {
        return this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rackposition, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, exames, acao);
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        try {
            String[] exms;
            Statement st = Conexao.getStatement();
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(exames.split(" ", 0), mco_codigo);
            for (String s : exms = exames.split(" ", 0)) {
                this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, s, mco_codigo, int_codigo, null, 1);
            }
            Conexao.arquivaSQL();
            this.fireMensagemEnviada("Pedido(s) enviado(s) com sucesso para " + pac_nome, 0, 10000);
            this.equipamento.atualizarTabela(0);
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
            return "";
        }
    }

    @Override
    public void teste() {
        String[] letras;
        StringBuilder bui = new StringBuilder();
        bui.append("[STX]\"H\",\"\",\"\",\"LabPro\",\"4.43\",\",\",\"\"\"\",\"N\",\"\",\"1\",15,\"Y\",\"\",\"\"[LINE][ETX]\n");
        bui.append("[STX]P,\"1\",\"4\",,,,,,,,,,,,,,,,,N,,,,0,[LINE][ETX]\n");
        bui.append("[STX]B,\"L\",\"4\",\"010007730821\",\"7291\",\"DILCEU[SP]MEDEIROS[SP]LOPES\",\"UROCU\",\"UROCULTURA\",Y,20201015,,20201015,,,,,P,0,N,,,,,[LINE][ETX]\n");
        bui.append("[STX]R,\"L\",\"01\",\"4\",\"NC66\",\"Neg[SP]Combo[SP]66\",20201017,,N,,,,,,,,,,,,,,,,N,,,,,0,,N,,,,,0,P,,[LINE][ETX]\n");
        bui.append("[STX]L,\"1\",N,0[LINE][ETX]\n");
        bui.append("[STX]P,\"2\",\"010007730821\",,,,,,,,,,,,,,,,,N,,,,0,[LINE][ETX]\n");
        bui.append("[STX]B,\"L\",\"010007730821\",\"010007730821\",\"7291\",\"DILCEU[SP]MEDEIROS[SP]LOPES\",\"UROCU\",\"UROCULTURA\",Y,20201015,,20201015,,,,,F,0,N,,,,,[LINE][ETX]\n");
        bui.append("[STX]R,\"L\",\"2\",\"010007730821\",\"NC66\",\"Neg[SP]Combo[SP]66\",20201017,,N,,,\"17\",\"Klebsiella[SP]ozaenae\",\"77704010064\",,N,,,,,,,,,N,,,,,28,,N,,1,1,,0,F,,[LINE][ETX]\n");
        bui.append("[STX]M,\"1\",\"A/S\",\"Amp/Sulbactam\",\"<=8/4\",N,,\"S\",\"S\",,,,,,,,,,,,,,,,,N[LINE][ETX]\n");
        bui.append("[STX]M,\"2\",\"AK\",\"Amicacina\",\"<=16\",N,,\"S\",\"S\",,,,,,,,,,,,,,,,,N[LINE][ETX]\n");
        bui.append("[STX]M,\"3\",\"AM\",\"Ampicilina\",\"<=8\",N,,\"S\",\"S\",,,,,,,,,,,,,,,,,N[LINE][ETX]\n");
        bui.append("[STX]M,\"4\",\"AUG\",\"Amox/K[SP]Clav\",\"<=8/4\",N,,\"S\",\"S\",,,,,,,,,,,,,,,,,N[LINE][ETX]\n");
        bui.append("[STX]M,\"5\",\"AZT\",\"Aztreonam\",\"<=1\",N,,\"S\",\"S\",,,,,,,,,,,,,,,,,N[LINE][ETX]\n");
        bui.append("[STX]M,\"6\",\"CAZ\",\"Ceftazidima\",\"<=1\",N,,\"S\",\"S\",,,,,,,,,,,,,,,,,N[LINE][ETX]\n");
        bui.append("[STX]M,\"7\",\"CAZ/CA\",\"Ceftazidima/Clavulanato[SP]K\",\"<=0.25\",N,,,,,,,,,,,,,,,,,,,,N[LINE][ETX]\n");
        bui.append("[STX]M,\"8\",\"CF\",\"Cefalotina\",\"<=8\",N,,,\"S\",,,,,,,,,,,,,,,,,N[LINE][ETX]\n");
        bui.append("[STX]M,\"9\",\"CFT\",\"Cefotaxima\",\"<=1\",N,,\"S\",\"S\",,,,,,,,,,,,,,,,,N[LINE][ETX]\n");
        bui.append("[STX]M,\"10\",\"CFT/CA\",\"Cefotaxima/Clavulanato[SP]K\",\"<=0.5\",N,,,,,,,,,,,,,,,,,,,,N[LINE][ETX]\n");
        bui.append("[STX]M,\"11\",\"CFX\",\"Cefoxitina\",\"<=8\",N,,\"S\",\"S\",,,,,,,,,,,,,,,,,N[LINE][ETX]\n");
        bui.append("[STX]M,\"12\",\"CL\",\"Colistina\",\"<=2\",N,,\"S\",\"S\",,,,,,,,,,,,,,,,,N[LINE][ETX]\n");
        bui.append("[STX]M,\"13\",\"CP\",\"Ciprofloxacina\",\"<=1\",N,,\"S\",\"S\",,,,,,,,,,,,,,,,,N[LINE][ETX]\n");
        bui.append("[STX]M,\"14\",\"CPE\",\"Cefepima\",\"<=1\",N,,\"S\",\"S\",,,,,,,,,,,,,,,,,N[LINE][ETX]\n");
        bui.append("[STX]M,\"15\",\"CRM\",\"Cefuroxima\",\"<=8\",N,,\"S\",\"S\",,,,,,,,,,,,,,,,,N[LINE][ETX]\n");
        bui.append("[STX]M,\"16\",\"ETP\",\"Ertapenem\",\"<=0.5\",N,,\"S\",\"S\",,,,,,,,,,,,,,,,,N[LINE][ETX]\n");
        bui.append("[STX]M,\"17\",\"FD\",\"Nitrofuranto?na\",\"<=32\",N,,,\"S\",,,,,,,,,,,,,,,,,N[LINE][ETX]\n");
        bui.append("[STX]M,\"18\",\"FOS\",\"Fosfomicina\",\">64\",N,,\"R\",\"R\",,,,,,,,,,,,,,,,,N[LINE][ETX]\n");
        bui.append("[STX]M,\"19\",\"GM\",\"Gentamicina\",\"<=4\",N,,\"S\",\"S\",,,,,,,,,,,,,,,,,N[LINE][ETX]\n");
        bui.append("[STX]M,\"20\",\"IMP\",\"Imipenem\",\"<=1\",N,,\"S\",\"S\",,,,,,,,,,,,,,,,,N[LINE][ETX]\n");
        bui.append("[STX]M,\"21\",\"LVX\",\"Levofloxacina\",\"<=2\",N,,\"S\",\"S\",,,,,,,,,,,,,,,,,N[LINE][ETX]\n");
        bui.append("[STX]M,\"22\",\"MER\",\"Meropenem\",\"<=1\",N,,\"S\",\"S\",,,,,,,,,,,,,,,,,N[LINE][ETX]\n");
        bui.append("[STX]M,\"23\",\"NA\",\"Acido[SP]nalid?xico\",\"<=16\",N,,,\"S\",,,,,,,,,,,,,,,,,N[LINE][ETX]\n");
        bui.append("[STX]M,\"24\",\"NXN\",\"Norfloxacina\",\"<=4\",N,,,\"S\",,,,,,,,,,,,,,,,,N[LINE][ETX]\n");
        bui.append("[STX]M,\"25\",\"P/T\",\"Pip/Tazo\",\"<=16\",N,,\"S\",\"S\",,,,,,,,,,,,,,,,,N[LINE][ETX]\n");
        bui.append("[STX]M,\"26\",\"T/S\",\"Trimet./Sulfa\",\"<=2/38\",N,,\"S\",\"S\",,,,,,,,,,,,,,,,,N[LINE][ETX]\n");
        bui.append("[STX]M,\"27\",\"TGC\",\"Tigeciclina\",\"<=1\",N,,\"S\",\"S\",,,,,,,,,,,,,,,,,N[LINE][ETX]\n");
        bui.append("[STX]M,\"L\",\"TO\",\"Tobramicina\",\"<=4\",N,,\"S\",\"S\",,,,,,,,,,,,,,,,,N[LINE][ETX]\n");
        bui.append("[STX]L,\"2\",N,0[LINE][ETX]");
        String texto = bui.toString().replaceAll("\"", "");
        String[] stringArray = letras = texto.split("\n");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String letra;
            String message = letra = stringArray[i];
            this.dataChanged(this.equipamento.arruma(message));
        }
        this.restartThreadRecebimento();
    }

    public void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            ArrayList<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento(this);
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        if (this.threadRecebimento != null) {
            this.threadRecebimento.start();
        }
    }
}

