/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.micros60;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.padroes.abx.InterfaceABXListener;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;

public class InterfaceListener
extends InterfaceABXListener {
    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao) {
        try {
            this.tx_list.clear();
            this.rx_list.clear();
            this.fil_codigo = fil_codigo;
            this.acao = acao;
            this.int_codigo = int_codigo;
            this.req_codigo = req_codigo;
            this.pac_nome = pac_nome;
            this.pac_sexo = pac_sexo;
            this.req_idade = pac_idade;
            this.req_data = data;
            this.req_hora = hora;
            this.mco_codigo = mco_codigo;
            this.rec_codigo = rec_codigo;
            this.pac_exames = pac_exames;
            this.exames = pac_exames.split(" ", 0);
            this.encerrarTransmissao();
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractABXInterfaceamento: envio de requisi\u00e7\u00e3o");
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractABXInterfaceamento: exce\u00e7\u00e3o em envio de requisi\u00e7\u00e3o");
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    @Override
    protected Object parseValor(Object valor, boolean removerPonto) {
        try {
            String s = valor.toString().trim();
            if (removerPonto) {
                s = s.replaceFirst("\\.", ",");
            }
            s = s.substring(0, 5).trim();
            return s;
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getCodigoApoiado(String sampleID) {
        DescritorCodigoEtiqueta dce = DescritorCodigoEtiqueta.getDescritor(sampleID);
        if (dce != null) {
            StringBuilder id = new StringBuilder();
            id.append(Funcoes.preencheZero(dce.getFilial(), ParametrosGerais.getDigitosTuboFilial()));
            id.append(Funcoes.preencheZero(dce.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao()));
            id.append(Funcoes.preencheZero(dce.getTubo(), ParametrosGerais.getDigitosTuboTubo()));
            return id.toString();
        }
        return sampleID;
    }
}

