/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.mhlabpkl125;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.exames.InfoExameRequisicao;
import jalis.laboratorio.interfaceamento.interfaces.mhlabpkl125.RecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.interfaceamento.padroes.astm.InterfaceASTMListener;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.interfaceamento.util.Checksum;
import jalis.util.Funcoes;
import jalis.util.MemoryList;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;

public class InterfaceListener
extends InterfaceASTMListener {
    protected String host_fil_codigo = null;
    protected String host_req_codigo = null;
    protected String host_rec_codigo = null;
    protected boolean hostQuery = false;
    protected boolean hostQueryVazio = false;
    private List<String> tubos = new ArrayList<String>();
    protected List<InfoExameRequisicao> examesEnviados = new ArrayList<InfoExameRequisicao>();
    private String diskID = "";
    private String positionNO = "";

    public InterfaceListener() {
        RecordParser record = new RecordParser();
        record.setInterfaceASTMListener(this);
        super.setASTMRecordParser(record);
    }

    @Override
    public void responderRequest(String starting_range, String ending_range, String test_id) {
        try {
            this.diskID = "";
            this.positionNO = "";
            String[] specimenID = starting_range.split("\\^");
            if (specimenID.length > 3) {
                this.diskID = specimenID[2];
                this.positionNO = specimenID[3];
            }
            starting_range = specimenID[1];
            this.hostQuery = true;
            if (Funcoes.textoVazio(starting_range)) {
                this.fireExcecaoEncontrada(String.format("Amostra com o c\u00f3digo fora do padr\u00e3o %s ", starting_range));
                return;
            }
            if (starting_range.length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                this.fireExcecaoEncontrada(String.format("Amostra com o c\u00f3digo fora do padr\u00e3o %s ", starting_range));
                return;
            }
            this.tubos.add(starting_range);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "MHLab PKL 125: Host Query Response");
        }
    }

    @Override
    protected void tratarAcknowledge() throws Exception {
        if (this.isTX()) {
            if (!this.tx_list.isEmpty() && this.tx_list.getUltimoLido() == this.tx_list.size() - 1) {
                this.encerrarTransmissao();
                if (this.tubos.size() > 0) {
                    this.enviaProximaAmostra();
                    this.responseHostQuery();
                }
            } else {
                this.enviarProximoFrame();
            }
        } else if (!this.isRX()) {
            this.caracterNaoEsperado();
        } else {
            this.caracterNaoEsperado();
        }
    }

    @Override
    protected void tratarEndOfTX() throws Exception {
        super.tratarEndOfTX();
        if (this.hostQuery && this.tubos.size() > 0) {
            this.enviaProximaAmostra();
            this.responseHostQuery();
        }
    }

    private void enviaProximaAmostra() {
        String amostra = this.tubos.remove(0);
        this.host_fil_codigo = amostra.substring(0, ParametrosGerais.getDigitosTuboFilial());
        amostra = amostra.substring(ParametrosGerais.getDigitosTuboFilial());
        this.host_req_codigo = amostra.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
        this.host_rec_codigo = amostra.substring(ParametrosGerais.getDigitosTuboRequisicao());
        this.hostQuery = true;
        this.hostQueryVazio = false;
    }

    public void responseHostQuery() {
        try {
            List<Object[]> reqs;
            String fil_codigo = this.host_fil_codigo;
            String req_codigo = this.host_req_codigo;
            String rec_codigo = this.host_rec_codigo;
            String pac_nome = null;
            String pac_sexo = null;
            String pac_idade = null;
            String data = null;
            String hora = null;
            String rack = null;
            String prioridade = null;
            String int_codigo = null;
            String mco_codigo = null;
            String pac_exames = null;
            String acao = "A";
            Object[] req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 0, false, true);
            PanelAbaAbstrata aba = this.equipamento.getTab(0);
            if (!Funcoes.objectIsNull(req)) {
                pac_exames = (String)req[aba.getColIndice("Exame")];
            }
            List<Object[]> listRequisicao = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 0);
            for (Object[] r : listRequisicao) {
                if (!pac_exames.isEmpty()) {
                    pac_exames = pac_exames + " ";
                }
                pac_exames = pac_exames + (String)r[aba.getColIndice("Exame")];
            }
            if (Funcoes.objectIsNull(req)) {
                req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                aba = this.equipamento.getTab(1);
                if (Funcoes.textoVazio(pac_exames) && !Funcoes.objectIsNull(req) && !Funcoes.objectIsNull(aba)) {
                    pac_exames = (String)req[aba.getColIndice("Exame")];
                }
                if (!Funcoes.objectIsNull(req)) {
                    reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                    for (Object[] r : reqs) {
                        if (!pac_exames.isEmpty()) {
                            pac_exames = pac_exames + " ";
                        }
                        pac_exames = pac_exames + (String)r[aba.getColIndice("Exame")];
                    }
                }
            }
            if (Funcoes.objectIsNull(req) && !Funcoes.objectIsNull(req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2))) {
                aba = this.equipamento.getTab(2);
                if (Funcoes.textoVazio(pac_exames)) {
                    pac_exames = (String)req[aba.getColIndice("Exame")];
                }
                if (!Funcoes.objectIsNull(req)) {
                    reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2);
                    for (Object[] r : reqs) {
                        if (!pac_exames.isEmpty()) {
                            pac_exames = pac_exames + " ";
                        }
                        pac_exames = pac_exames + (String)r[aba.getColIndice("Exame")];
                    }
                }
            }
            this.host_fil_codigo = null;
            this.host_req_codigo = null;
            this.host_rec_codigo = null;
            if (!Funcoes.objectIsNull(req)) {
                pac_nome = aba.getColIndice("Paciente") >= 0 ? (String)req[aba.getColIndice("Paciente")] : null;
                pac_sexo = aba.getColIndice("S") >= 0 ? (String)req[aba.getColIndice("S")] : null;
                data = aba.getColIndice("Data") >= 0 ? (String)req[aba.getColIndice("Data")] : null;
                hora = aba.getColIndice("Hora") >= 0 ? (String)req[aba.getColIndice("Hora")] : null;
                rack = aba.getColIndice("Rack") >= 0 ? (String)req[aba.getColIndice("Rack")] : null;
                int_codigo = aba.getColIndice("Interface") >= 0 ? (String)req[aba.getColIndice("Interface")] : null;
                mco_codigo = aba.getColIndice("C\u00f3d. Mat.") >= 0 ? (String)req[aba.getColIndice("C\u00f3d. Mat.")] : null;
                pac_idade = aba.getColIndice("Ide") >= 0 ? (String)req[aba.getColIndice("Ide")] : null;
                this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rack, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames, acao);
            } else {
                this.tx_list.add(ASTMStandard.getDefaultHeaderRecord(this.DELIMITERS, this.PASSWORD, this.HOST_NAME, this.HOST_SYSTEM_VERSION, null, this.INSTRUMENT_NAME, this.INSTRUMENT_SYSTEM_VERSION));
                this.tx_list.add(ASTMStandard.getDefaultTerminationRecord("I"));
                this.tx_list = this.makeFrames(this.tx_list);
                this.tx_list.resetUltimoLido();
                this.setTX(this.TIME_TX);
                this.tx_counter = 0;
                this.getPortaCOM().write(String.valueOf('\u0005'));
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "MHLab PKL 125: Host Query Response");
        }
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao) {
        try {
            this.tx_list.clear();
            this.rx_list.clear();
            this.req_codigo = req_codigo;
            this.fil_codigo = fil_codigo;
            this.int_codigo = int_codigo;
            this.pac_nome = pac_nome;
            this.pac_sexo = pac_sexo;
            this.req_idade = pac_idade;
            this.req_data = data;
            this.req_hora = hora;
            this.mco_codigo = mco_codigo;
            this.rec_codigo = rec_codigo;
            this.pac_exames = pac_exames;
            this.exames = pac_exames.split(" ", 0);
            this.ultima_acao = acao;
            this.curva = false;
            this.rec_tuboPai = "";
            this.examesFilho = new LinkedList();
            ExameMaterial[] alternativos = null;
            String short_name = StringUtil.removerAcentos(pac_nome);
            if (short_name.length() > this.MAX_PATIENT_NAME_CHARS) {
                short_name = short_name.substring(0, this.MAX_PATIENT_NAME_CHARS);
            }
            fil_codigo = StringUtil.preencheString(fil_codigo, ParametrosGerais.getDigitosTuboFilial(), '0', 1);
            StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo);
            rec_codigo = StringUtil.preencheString(rec_codigo, ParametrosGerais.getDigitosTuboTubo(), '0', 1);
            codigo.append(rec_codigo);
            StringBuilder sample_id = new StringBuilder(fil_codigo).append(req_codigo);
            Statement st = Conexao.getStatement();
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(this.exames, mco_codigo);
            String tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, exa_lista[0].getString(), exa_lista[0].getCodigo().toString(), int_codigo);
            ArrayList<ExameMaterial> exa_listaCurva = new ArrayList<ExameMaterial>();
            exa_lista = ExamesUtil.separaExamesCurva(fil_codigo, int_codigo, mco_codigo, exa_lista, exa_listaCurva);
            exa_lista = !Funcoes.objectIsNull(exa_lista) ? ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_lista) : ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_listaCurva.toArray(new ExameMaterial[exa_listaCurva.size()]));
            if (this.hostQuery && !exa_listaCurva.isEmpty()) {
                this.rec_tuboPai = BDUtil.getExameDesmembradoTuboPai(fil_codigo, req_codigo, rec_codigo, int_codigo, ((ExameMaterial)exa_listaCurva.get(0)).getString(), mco_codigo);
            }
            alternativos = ExamesUtil.getAlternativos(st, fil_codigo, int_codigo, exa_lista);
            alternativos = ExamesUtil.removeDuplicados(alternativos);
            String nome = short_name;
            StringBuilder frame = new StringBuilder();
            String t = " ";
            if (!Funcoes.objectIsNull(alternativos) && alternativos.length > 0) {
                frame.append(this.getDefaultHeader());
                t = this.getDefaultPatientRecord(1, nome, pac_sexo, pac_idade);
                frame.append(t);
                int seq = 0;
                if (!Funcoes.objectIsNull(alternativos) && alternativos.length > 0) {
                    for (ExameMaterial exameMaterial : alternativos) {
                        t = this.getOrderRecord(++seq, codigo.toString(), rackposition, exameMaterial, "R", "N", tipo_amostra, "O");
                        frame.append(t);
                    }
                }
                t = "L|1|N\r";
                frame.append(t);
            }
            this.tx_list.add(frame.toString());
            this.tx_list = this.makeFrames(this.tx_list);
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            this.getPortaCOM().write(String.valueOf('\u0005'));
            this.hostQuery = false;
            InfoExameRequisicao infoExame = new InfoExameRequisicao(fil_codigo, req_codigo, mco_codigo, rec_codigo, pac_nome, pac_idade, pac_sexo, data, hora, pac_exames);
            infoExame.setInterface(int_codigo);
            infoExame.setTuboPai(this.rec_tuboPai);
            infoExame.setExamesFilho(StringUtil.implode(this.examesFilho, " "));
            infoExame.setCurva(this.curva);
            this.examesEnviados.add(infoExame);
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            this.hostQuery = false;
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    @Override
    public MemoryList<String> makeFrames(MemoryList<String> raw_list) throws Exception {
        try {
            MemoryList<String> new_list = new MemoryList<String>();
            this.frame_num = 0;
            if (raw_list != null) {
                while (!raw_list.isEmpty() && raw_list.size() > 0) {
                    String[] slices = StringUtil.dividir(raw_list.remove(0), 1024);
                    for (int j = 0; j < slices.length; ++j) {
                        StringBuilder temp = new StringBuilder(String.valueOf(this.nextFrameNum()));
                        temp.append(slices[j]);
                        temp.append(j < slices.length - 1 ? String.valueOf('\u0017') : String.valueOf('\u0003'));
                        temp.append(Checksum.getChecksumMod256(temp.toString()));
                        temp = new StringBuilder(this.getMsgStart()).append((CharSequence)temp);
                        temp.append(this.getMsgEnd());
                        new_list.add(temp.toString());
                    }
                }
                return new_list;
            }
            return null;
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "Erro ao recuperar lista de frames (size:" + raw_list.size() + ")");
            return null;
        }
    }

    public String getDefaultHeader() {
        StringBuilder header = new StringBuilder();
        header.append("H|\\^&");
        header.append('\r');
        return header.toString();
    }

    public String getDefaultPatientRecord(int patient_sequence, String pac_nome, String pac_sexo, String pac_idade) {
        StringBuilder nome = new StringBuilder();
        if (!Funcoes.textoVazio(pac_nome)) {
            String[] nomecompleto = pac_nome.split(" ");
            nome.append(nomecompleto[0]).append(" ");
            nome.append(nomecompleto[nomecompleto.length - 1]);
        }
        StringBuilder idadePadraoEqpto = new StringBuilder();
        if (!Funcoes.textoVazio(pac_idade)) {
            String[] idade = pac_idade.split(" ");
            idadePadraoEqpto.append(idade[0]).append("^");
            if (idade[1].startsWith("a")) {
                idadePadraoEqpto.append("Y");
            } else if (idade[1].startsWith("m")) {
                idadePadraoEqpto.append("M");
            } else if (idade[1].startsWith("d")) {
                idadePadraoEqpto.append("D");
            }
        }
        String codPaciente = "";
        if (!Funcoes.textoVazio(this.fil_codigo)) {
            Map<String, String> dadosPaciente = null;
            try {
                dadosPaciente = BDUtil.getDadosPacienteMaps(this.fil_codigo, this.req_codigo);
                codPaciente = dadosPaciente.get("pac_codigo");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        StringBuilder record = new StringBuilder("P|");
        record.append(patient_sequence).append("||");
        record.append(codPaciente).append("||");
        record.append(nome.toString()).append("|||");
        record.append(pac_sexo == null ? "" : pac_sexo).append("||||||");
        record.append(idadePadraoEqpto.length() > 0 ? idadePadraoEqpto.toString() : "");
        record.append('\r');
        return record.toString();
    }

    protected String getOrderRecord(int order_sequence, String sample_id, String sample_id_type, ExameMaterial exameMaterial, String priority, String action_code, String sample_type, String report_type) {
        StringBuilder record = new StringBuilder();
        if (!Funcoes.textoVazio(exameMaterial.getNomeExame())) {
            StringBuilder specimenID = new StringBuilder();
            if (!Funcoes.textoVazio(sample_id)) {
                specimenID.append(sample_id).append("^^");
                specimenID.append(this.diskID).append("^");
                specimenID.append(this.positionNO).append("^N");
            }
            record.append("O|").append(order_sequence).append("|");
            record.append(specimenID.toString()).append("||");
            record.append("^^^").append(exameMaterial.getNomeExame()).append("|");
            record.append(priority).append("|");
            record.append(ASTMStandard.getCurrentMoment()).append("|||||||||||||||||||");
            record.append('\r');
        }
        return record.toString();
    }

    @Override
    public void teste() {
        int op = JOptionPane.showOptionDialog(null, "Op\u00e7\u00e3o", "Tipo teste", 0, 0, null, new String[]{"Query", "ACK", "Resultado", "Desmembrado"}, null);
        if (op == 0) {
            this.query();
        } else if (op == 1) {
            this.handShakeCharReceived('\u0006');
        } else if (op == 2) {
            this.resultado();
        } else if (op == 3) {
            String idTubo = JOptionPane.showInputDialog("Informe o Id do tubo:");
            this.desmembrado1(idTubo);
            this.desmembrado2(idTubo);
            this.desmembrado3(idTubo);
        }
    }

    private void query() {
        String idTubo = JOptionPane.showInputDialog("Informe o Id do tubo:");
        this.parse(this.equipamento.arruma("[STX]1H|\\^&|||PPC 125|||||Host|||1|20211027160835[CR][ETX]25[CR][LF]"));
        this.parse(this.equipamento.arruma("[STX]2Q|1|" + idTubo + "^^1^1^N||ALL||||||||O[CR][ETX]B4[CR][LF]"));
        this.parse(this.equipamento.arruma("[STX]3L|1|N[CR][ETX]06[CR][LF]"));
        this.handShakeCharReceived('\u0004');
    }

    private void resultado() {
        String idTubo = JOptionPane.showInputDialog("Informe o Id do tubo:");
        this.parse(this.equipamento.arruma("[STX]1H|\\^&|||BioResult^3.6^11052213||||||||E-1394-97|20221011165017[CR]"));
        this.parse(this.equipamento.arruma("[STX]2P|1||" + idTubo + "||Paciente[SP]Jalis|||M||||||34^Y[CR]"));
        this.parse(this.equipamento.arruma("[STX]3O|1|" + idTubo + "^2^^^|SAGES[SP]200^||S|20221027114710|||||||||1||||||||||O[CR]"));
        this.parse(this.equipamento.arruma("[STX]4R|1|^^^FOSF|4.27|mg/dl|0^0|||N|F||||20221027114710[CR]"));
        this.parse(this.equipamento.arruma("[STX]5L|1|N[CR]"));
    }

    private void desmembrado1(String idTubo) {
        this.parse(this.equipamento.arruma("[STX]1H|\\^&|||BioResult^3.6^11052213||||||||E-1394-97|20221011165017[CR]"));
        this.parse(this.equipamento.arruma("[STX]2P|1||" + idTubo + "||PAULA[SP]NEVES|||F||||||37^Y[CR]"));
        this.parse(this.equipamento.arruma("[STX]3O|1|" + idTubo + "^18^^^|SAGES[SP]200^||S|20221011165018|||||||||1||||||||||O[CR]"));
        this.parse(this.equipamento.arruma("[STX]4R|1|^^^COL|244|mg/dl|0^0|||N|F||||20221027114617[CR]"));
        this.parse(this.equipamento.arruma("[STX]5L|1|N[CR]"));
    }

    private void desmembrado2(String idTubo) {
        this.parse(this.equipamento.arruma("[STX]1H|\\^&|||BioResult^3.6^11052213||||||||E-1394-97|20221011165035[CR]"));
        this.parse(this.equipamento.arruma("[STX]2P|1||" + idTubo + "||PAULA[SP]NEVES|||F||||||37^Y[CR]"));
        this.parse(this.equipamento.arruma("[STX]3O|1|" + idTubo + "^18^^^|SAGES[SP]200^||S|20221011165035|||||||||1||||||||||O[CR]"));
        this.parse(this.equipamento.arruma("[STX]4R|1|^^^TRIG|117|mg/dl|50^200||N|F||||20221027114635[CR]"));
        this.parse(this.equipamento.arruma("[STX]5L|1|N[CR]"));
    }

    private void desmembrado3(String idTubo) {
        this.parse(this.equipamento.arruma("[STX]1H|\\^&|||BioResult^3.6^11052213||||||||E-1394-97|20221011165333[CR]"));
        this.parse(this.equipamento.arruma("[STX]2P|1||" + idTubo + "||PAULA[SP]NEVES|||F||||||37^Y[CR]"));
        this.parse(this.equipamento.arruma("[STX]3O|1|" + idTubo + "^18^^^|SAGES[SP]200^||S|20221011165333|||||||||1||||||||||O[CR]"));
        this.parse(this.equipamento.arruma("[STX]4R|1|^^^HDL|303.0|mg/dl|30.0^70.0||N|F||||20221027114933[CR]"));
        this.parse(this.equipamento.arruma("[STX]5L|1|N[CR]"));
    }

    @Override
    public String getErroTraduzido(String erro) {
        return erro;
    }
}

