/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.mhlabpkl125;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamento;
import jalis.laboratorio.interfaceamento.abas.AbaDefaultProntos;
import jalis.laboratorio.interfaceamento.abas.SelecionaExame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFrame;

public class AbaProntos
extends AbaDefaultProntos {
    static boolean debug = Funcoes.arquivoExiste(System.getProperty("user.home") + System.getProperty("file.separator") + "debug.jalis");

    public AbaProntos(JFrame parent, AbstractInterfaceamento equip) {
        super(parent, equip);
    }

    @Override
    public void repetirExame() {
        int row = this.tabelaExames.getSelectedRow();
        if (row < 0) {
            return;
        }
        ArrayList requisicaoExames = this.getRequisicaoExames(row, this.exames);
        if ((requisicaoExames = (ArrayList)requisicaoExames.clone()).size() > 1) {
            SelecionaExame tela = new SelecionaExame(this.equipamento, requisicaoExames, this.colunas, this.colunasVisiveis, this.colunasOcultas);
            tela.setVisible(true);
            requisicaoExames = tela.getRequisicaoExames();
        } else {
            Object[] exame = (Object[])requisicaoExames.get(0);
            String aux = (String)exame[this.getColIndice("C\u00f3digo")];
            if (ParametrosGerais.isAgruparGuiasInterface()) {
                aux = (String)exame[this.getColIndice("Multiguia")];
            }
            String fil_codigo = aux.substring(0, ParametrosGerais.getDigitosTuboFilial());
            String int_codigo = (String)exame[this.getColIndice("Interface")];
            String exa_codigo = (String)exame[this.getColIndice("Exame")];
            String mco_codigo = (String)exame[this.getColIndice("C\u00f3d. Mat.")];
            try {
                if (BDUtil.isExameDesmembrado(fil_codigo, int_codigo, exa_codigo, mco_codigo)) {
                    SelecionaExame tela = new SelecionaExame(this.equipamento, requisicaoExames, this.colunas, this.colunasVisiveis, this.colunasOcultas);
                    tela.setVisible(true);
                    requisicaoExames = tela.getRequisicaoExames();
                } else {
                    for (int i = 0; i < requisicaoExames.size(); ++i) {
                        Object[] obj = (Object[])requisicaoExames.get(0);
                        if (null == obj) continue;
                        int col = this.getColIndice("Sit");
                        obj[col] = SelecionaExame.SIT_REPETIR;
                    }
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        ArrayList<String> exames = new ArrayList<String>();
        ArrayList<Integer> linhas = new ArrayList<Integer>();
        Object[] linhaRepeticao = null;
        for (int i = 0; i < requisicaoExames.size(); ++i) {
            linhaRepeticao = (Object[])requisicaoExames.get(i);
            String sit = (String)linhaRepeticao[this.getColIndice("Sit")];
            if (!sit.equalsIgnoreCase(SelecionaExame.SIT_REPETIR)) continue;
            String reqRepetir = (String)linhaRepeticao[this.getColIndice("C\u00f3digo")];
            if (Funcoes.textoVazio(reqRepetir)) {
                reqRepetir = (String)linhaRepeticao[this.getColIndice("C\u00f3digo") - 1];
            }
            String exaRepetir = (String)linhaRepeticao[this.getColIndice("Exame")];
            String matRepetir = (String)linhaRepeticao[this.getColIndice("C\u00f3d. Mat.")];
            for (int j = 0; j < this.tabelaExames.getRowCount(); ++j) {
                ArrayList desmembrado;
                Object[] linhaProntos = this.tabelaExames.getRow(j);
                String reqPronto = (String)linhaProntos[this.getColIndice("C\u00f3digo")];
                if (Funcoes.textoVazio(reqPronto)) {
                    reqPronto = (String)linhaProntos[this.getColIndice("C\u00f3digo") - 1];
                }
                if (!reqRepetir.equalsIgnoreCase(reqPronto)) continue;
                String exaPronto = (String)linhaProntos[this.getColIndice("Exame")];
                String matPronto = (String)linhaProntos[this.getColIndice("C\u00f3d. Mat.")];
                String recPronto = (String)linhaProntos[this.getColIndice("Tubo")];
                if (!exaRepetir.equalsIgnoreCase(exaPronto) || !matRepetir.equalsIgnoreCase(matPronto)) continue;
                try {
                    desmembrado = (ArrayList)linhaRepeticao[linhaRepeticao.length - 1];
                }
                catch (Exception e) {
                    desmembrado = null;
                }
                if (desmembrado != null) {
                    for (int k = 0; k < desmembrado.size(); ++k) {
                        Object[] exame = (Object[])desmembrado.get(k);
                        String situacao = (String)exame[exame.length - 1];
                        if (!situacao.equalsIgnoreCase(SelecionaExame.SIT_REPETIR)) continue;
                        exames.add((String)exame[1]);
                    }
                    linhas.add(j);
                    continue;
                }
                if (!sit.equalsIgnoreCase(SelecionaExame.SIT_REPETIR) && requisicaoExames.size() != 1) continue;
                exames.add(exaPronto);
                linhas.add(j);
            }
        }
        if (exames.size() > 0) {
            try {
                for (Integer linha : linhas) {
                    String aux = (String)this.tabelaExames.getValueAt(linha, this.getColIndice("C\u00f3digo"));
                    if (ParametrosGerais.isAgruparGuiasInterface()) {
                        aux = (String)this.tabelaExames.getValueAt(linha, this.getColIndice("Multiguia"));
                    }
                    String rec_codigo = (String)this.tabelaExames.getValueAt(linha, this.getColIndice("Tubo"));
                    String mco_codigo = (String)this.tabelaExames.getValueAt(linha, this.getColIndice("C\u00f3d. Mat."));
                    String pac_sexo = (String)this.tabelaExames.getValueAt(linha, this.getColIndice("S"));
                    String pac_idade = (String)this.tabelaExames.getValueAt(linha, this.getColIndice("Ide"));
                    String pac_nome = (String)this.tabelaExames.getValueAt(linha, this.getColIndice("Paciente"));
                    String rack = (String)this.tabelaExames.getValueAt(linha, this.getColIndice("Rack"));
                    String fil_codigo = aux.substring(0, ParametrosGerais.getDigitosTuboFilial());
                    String int_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Interface"));
                    String req_codigo = aux.substring(ParametrosGerais.getDigitosTuboFilial());
                    String exaPai = (String)this.tabelaExames.getValueAt((Integer)linhas.get(0), this.getColIndice("Exame"));
                    String codigoRequisicao = (String)linhaRepeticao[this.getColIndice("C\u00f3digo")];
                    if (Funcoes.textoVazio(codigoRequisicao)) {
                        codigoRequisicao = (String)linhaRepeticao[this.getColIndice("C\u00f3digo") - 1];
                    }
                    if (Funcoes.textoVazio(aux) || !aux.equals(codigoRequisicao)) continue;
                    Statement st = Conexao.getStatement();
                    for (String exame : exames) {
                        if (BDUtil.existeDesmembramento(fil_codigo, int_codigo, req_codigo, rec_codigo, exame, mco_codigo) || BDUtil.isExameCurva(fil_codigo, int_codigo, exaPai, mco_codigo)) {
                            List listaTubos = (List)this.tabelaExames.getValueAt(linha, this.getColIndice("Tubos Filhos"));
                            if (Funcoes.textoVazio(rec_codigo)) {
                                listaTubos.add(rec_codigo);
                            }
                            if (listaTubos != null) {
                                Iterator iterator = listaTubos.iterator();
                                while (iterator.hasNext()) {
                                    ExameMaterial[] exaFilho;
                                    String tb;
                                    String tubo = tb = (String)iterator.next();
                                    Integer tuboPai = BDUtil.getTuboPai(fil_codigo, req_codigo, tubo, int_codigo);
                                    for (ExameMaterial exameMaterial : exaFilho = BDUtil.getExameMaterialRecipiente(fil_codigo, req_codigo, tubo, int_codigo)) {
                                        ExameMaterial[] exaPais;
                                        for (ExameMaterial ePai : exaPais = BDUtil.getDesmExamesPai(fil_codigo, int_codigo, req_codigo, tubo, exameMaterial.getString(), exameMaterial.getCodigo().toString())) {
                                            BDUtil.setDesmSituacao(st, fil_codigo, int_codigo, req_codigo, ePai.getNomeExame(), mco_codigo, rec_codigo, exame, exameMaterial.getCodigo().toString(), 5);
                                            BDUtil.setExmSituacao(st, fil_codigo, req_codigo, ePai.getNomeExame(), mco_codigo, 5, int_codigo, rec_codigo);
                                        }
                                    }
                                }
                            }
                        }
                        try {
                            ExameMaterial exameMaterial = BDUtil.getReqExamePaiLIS(fil_codigo, int_codigo, req_codigo, rec_codigo);
                            if (exameMaterial != null && BDUtil.isExameDesmembrado(fil_codigo, int_codigo, exameMaterial.getString(), mco_codigo)) {
                                ExameMaterial[] exameFilhos;
                                for (ExameMaterial exameFilho : exameFilhos = BDUtil.getExamesFilhos(fil_codigo, int_codigo, exameMaterial.getString(), mco_codigo)) {
                                    if (!exameFilho.getString().equals(exame)) continue;
                                    BDUtil.setDesmSituacao(st, fil_codigo, int_codigo, req_codigo, exameMaterial.getString(), mco_codigo, rec_codigo, exame, mco_codigo, 5);
                                    BDUtil.setExmSituacao(st, fil_codigo, req_codigo, exameMaterial.getString(), mco_codigo, 5, int_codigo, rec_codigo);
                                }
                            }
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                        BDUtil.setExmSituacao(st, fil_codigo, req_codigo, exame, mco_codigo, 5, int_codigo, rec_codigo);
                    }
                }
                if (debug) {
                    System.out.println("Arquivando");
                }
                Conexao.arquivaSQL();
                for (Integer i : linhas) {
                    if (debug) {
                        System.out.println("Atualizando linha " + i);
                    }
                    this.atualizarRepeticaoLinha(i);
                }
                this.revalidate();
                this.repaint();
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(this.parent, ex.getMessage(), ex.getStackTrace());
            }
        }
    }

    private void atualizarRepeticaoLinha(int linha) {
        if (linha > -1 && linha <= this.tabelaExames.getRowCount()) {
            this.tabelaExames.setValueAt(String.valueOf(5), linha, this.getColIndice("Sit"));
        }
    }
}

