/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.metrolab2300plus;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.interfaces.metrolab2300plus.InterfaceConfiguracao;
import jalis.laboratorio.interfaceamento.padroes.astm2.InterfaceASTMListener;
import jalis.laboratorio.interfaceamento.padroes.astm2.Message;
import jalis.laboratorio.interfaceamento.padroes.astm2.MessageReceivedListener;
import jalis.laboratorio.interfaceamento.padroes.astm2.MessageSentCallback;
import jalis.laboratorio.interfaceamento.padroes.astm2.RangeId;
import jalis.laboratorio.interfaceamento.padroes.astm2.Record;
import jalis.laboratorio.interfaceamento.padroes.astm2.RecordType;
import jalis.laboratorio.interfaceamento.padroes.astm2.UniversalTestId;
import jalis.laboratorio.interfaceamento.padroes.astm2.records.MessageHeader;
import jalis.laboratorio.interfaceamento.padroes.astm2.records.MessageTerminator;
import jalis.laboratorio.interfaceamento.padroes.astm2.records.PatientInformation;
import jalis.laboratorio.interfaceamento.padroes.astm2.records.RequestInformation;
import jalis.laboratorio.interfaceamento.padroes.astm2.records.Result;
import jalis.laboratorio.interfaceamento.padroes.astm2.records.TestOrder;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.util.Funcoes;
import jalis.util.MemoryList;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class InterfaceListener
extends InterfaceASTMListener
implements MessageReceivedListener {
    private static final String CODIGO_APOIO_FILHO = "codigoApoioFilho";
    protected List<String> examesFilho = new LinkedList<String>();
    protected String rec_tuboPai = "";
    private List<String> tuboIdEnviados;
    private List<String> listaEnviados;
    protected boolean curva = false;
    protected String[] exames;
    protected String fil_codigo;
    protected String req_codigo;
    protected String mco_codigo;
    protected String rec_codigo;
    protected String pac_nome;
    protected String pac_exames;
    protected String pac_sexo;
    protected String req_idade;
    protected String req_data;
    protected String req_hora;
    protected MemoryList<String> tx_list = new MemoryList();
    private InterfaceConfiguracao configuracao = new InterfaceConfiguracao();

    public InterfaceListener() {
        this.tuboIdEnviados = new ArrayList<String>();
        this.listaEnviados = new LinkedList<String>();
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        this.configuracao = new InterfaceConfiguracao();
        this.configuracao.setXmlVariaveis(c.getVariaveisConfiguracao());
    }

    public InterfaceConfiguracao getConfiguracao() {
        return this.configuracao;
    }

    @Override
    public String enviarRequisicao(String pacNome, String pacSexo, String pacIdade, String data, String hora, String rackposition, String prioridade, String filCodigo, String intCodigo, String reqCodigo, String mcoCodigo, String recCodigo, String exames, String acao) {
        return this.enviarRequisicao(pacNome, pacSexo, pacIdade, data, hora, rackposition, prioridade, filCodigo, intCodigo, reqCodigo, mcoCodigo, recCodigo, exames, acao, null);
    }

    @Override
    public String enviarRequisicao(final String pacNome, final String pacSexo, final String pacIdade, final String data, final String hora, String rackposition, String prioridade, final String filCodigo, final String intCodigo, final String reqCodigo, final String mcoCodigo, final String recCodigo, final String exames, String acao, HashMap<String, String> parametros) {
        this.exames = exames.split(" ", 0);
        Statement st = Conexao.getStatement();
        Object listaCurva = null;
        String fil_codigo = filCodigo;
        String req_codigo = reqCodigo;
        ExameMaterial[] exa_lista = null;
        String rec_codigo = Funcoes.preencheZero(recCodigo, ParametrosGerais.getDigitosTuboTubo());
        String exr_codigoapoiado = parametros != null ? parametros.get("codigoApoiado") : "";
        final String tuboId = !Funcoes.textoVazio(exr_codigoapoiado) ? exr_codigoapoiado : Funcoes.preencheZero(filCodigo, ParametrosGerais.getDigitosTuboFilial()) + Funcoes.preencheZero(reqCodigo, ParametrosGerais.getDigitosTuboRequisicao()) + Funcoes.preencheZero(recCodigo, ParametrosGerais.getDigitosTuboTubo());
        try {
            if (this.tuboIdEnviados.contains(tuboId) || this.configuracao.getManterListaDeEnviados() && this.listaEnviados.contains(tuboId)) {
                return null;
            }
            exa_lista = this.curva ? BDUtil.getExameMaterialRecipiente(fil_codigo, req_codigo, rec_codigo, intCodigo) : ExamesUtil.anexarCodigoMaterial(this.exames, mcoCodigo);
            exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, intCodigo, exa_lista);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Date dataColeta = null;
        ArrayList<ExameMaterial> examesParaEnviar = new ArrayList<ExameMaterial>();
        try {
            Set<String> tests;
            if (exa_lista != null) {
                for (ExameMaterial exame : exa_lista) {
                    if (dataColeta == null) {
                        dataColeta = BDUtil.getExmColeta(filCodigo, reqCodigo, exame.getNomeExame(), exame.getCodigoMaterial());
                    }
                    if (BDUtil.isExameDesmembrado(filCodigo, intCodigo, exame.getNomeExame(), exame.getCodigoMaterial())) {
                        ExameMaterial[] exameMaterialFilhos;
                        System.out.println("Enviando desmembrado " + exame.getNomeExame());
                        for (ExameMaterial exameFilho : exameMaterialFilhos = BDUtil.getExamesFilhos(filCodigo, intCodigo, exame.getString(), exame.getCodigoMaterial())) {
                            String rec_kodigo = BDUtil.getExameDesmembradoTubo(filCodigo, reqCodigo, recCodigo, intCodigo, exameFilho.getNomeExame(), exameFilho.getCodigoMaterial());
                            if (rec_kodigo == null) {
                                Integer req;
                                Integer[] reqs;
                                Integer[] integerArray = reqs = RecepcaoUtil.verificaMultiGuias(filCodigo, reqCodigo, false);
                                int n = integerArray.length;
                                for (int i = 0; i < n && (rec_kodigo = BDUtil.getExameDesmembradoTubo(filCodigo, (req = integerArray[i]).toString(), recCodigo, intCodigo, exameFilho.getNomeExame(), exameFilho.getCodigoMaterial())) == null; ++i) {
                                }
                            }
                            if (rec_kodigo == null) {
                                this.fireExcecaoEncontrada(String.format("N\u00e3o encontrado o recipiente para o exame filho: %s", exameFilho.getNomeExame()));
                                continue;
                            }
                            if (rec_codigo.equalsIgnoreCase(rec_kodigo = Funcoes.preencheZero(rec_kodigo, ParametrosGerais.getDigitosTuboTubo()))) {
                                examesParaEnviar.add(exameFilho);
                                continue;
                            }
                            ArrayList<ExameMaterial> examesDaRequisicaoFilho = new ArrayList<ExameMaterial>();
                            examesDaRequisicaoFilho.add(exameFilho);
                            String codigoApoiado = BDUtil.getCodigoApoioRecipiente(Integer.parseInt(fil_codigo), Integer.parseInt(req_codigo), exame.getNomeExame(), Integer.parseInt(exame.getCodigoMaterial()), Integer.parseInt(rec_kodigo));
                            if (parametros != null) {
                                if (parametros.containsKey(CODIGO_APOIO_FILHO)) {
                                    parametros.remove(CODIGO_APOIO_FILHO);
                                    parametros.put(CODIGO_APOIO_FILHO, codigoApoiado);
                                } else {
                                    parametros.put(CODIGO_APOIO_FILHO, codigoApoiado);
                                }
                            }
                            this.enviarRequisicao(fil_codigo, req_codigo, rec_codigo, rec_kodigo, pacNome, mcoCodigo, intCodigo, pacSexo, pacIdade, data, hora, dataColeta, examesDaRequisicaoFilho, exames, parametros);
                        }
                        continue;
                    }
                    int situacao = this.getExameSituacao(st, filCodigo, intCodigo, reqCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), recCodigo);
                    if (BDUtil.isExameDesmembrado(filCodigo, intCodigo, exame.getString(), mcoCodigo)) {
                        List<ExameMaterial> examesFilhos = Arrays.asList(BDUtil.getExamesFilhos(filCodigo, intCodigo, exame.getString(), mcoCodigo));
                        if (situacao == 0 || situacao == 1) {
                            examesParaEnviar.addAll(examesFilhos);
                            continue;
                        }
                        for (ExameMaterial exameFilho : examesFilhos) {
                            int sitFilho = BDUtil.getDesmSituacao(filCodigo, intCodigo, reqCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), recCodigo, exameFilho.getNomeExame(), exameFilho.getCodigoMaterial());
                            if (sitFilho != 3) continue;
                            examesParaEnviar.add(exameFilho);
                        }
                        continue;
                    }
                    if (situacao != 0 && situacao != 1 && situacao != 3) continue;
                    examesParaEnviar.add(exame);
                }
            }
            TestOrder testOrder = new TestOrder();
            PatientInformation patientInfo = new PatientInformation();
            Message messageResp = new Message();
            messageResp.addRecord(new MessageHeader());
            messageResp.addRecord(patientInfo);
            messageResp.addRecord(testOrder);
            messageResp.addRecord(new MessageTerminator());
            patientInfo.setName(StringUtil.removerAcentos(pacNome));
            testOrder.setSpecimenId(tuboId);
            this.tuboIdEnviados.add(tuboId);
            if (this.configuracao.getManterListaDeEnviados()) {
                this.listaEnviados.add(tuboId);
            }
            if (!(tests = this.obtemAlternativos(filCodigo, mcoCodigo, intCodigo, examesParaEnviar)).isEmpty()) {
                for (String test : tests) {
                    UniversalTestId universalTestId = new UniversalTestId();
                    universalTestId.setTestNumber(String.valueOf(test));
                    testOrder.addUniversalTestId(universalTestId);
                }
                testOrder.setReportType(TestOrder.ReportType.FINAL_RESULTS);
                testOrder.setSpecimenDate(dataColeta);
                this.addMessageToSend(messageResp, new MessageSentCallback(){

                    @Override
                    public void messageSent(Message message, MessageSentCallback.MessageSentResult result) {
                        if (result == MessageSentCallback.MessageSentResult.SUCCESS) {
                            try {
                                Statement st = Conexao.getStatement();
                                InterfaceListener.this.tuboIdEnviados.remove(tuboId);
                                String[] stringArray = exames.split(" ");
                                int n = stringArray.length;
                                for (int i = 0; i < n; ++i) {
                                    String exame;
                                    int atual = InterfaceListener.this.getExameSituacao(st, filCodigo, intCodigo, reqCodigo, exame = stringArray[i], mcoCodigo, recCodigo);
                                    InterfaceListener.this.atualizarSituacaoExame(st, filCodigo, reqCodigo, recCodigo, exame, mcoCodigo, intCodigo, null, atual < 2 ? 1 : 3);
                                }
                                Conexao.arquivaSQL();
                            }
                            catch (Exception e) {
                                try {
                                    Conexao.anulaSQL();
                                }
                                catch (SQLException sQLException) {
                                    // empty catch block
                                }
                                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                            }
                            InterfaceListener.this.firePacienteEnviado(reqCodigo, pacNome, pacSexo, pacIdade, data, hora, exames);
                            InterfaceListener.this.fireAtualizarTabela(0);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return "Erro ao enviar exames: " + e.getMessage();
        }
        return null;
    }

    private void enviarRequisicao(final String fil_codigo, final String req_codigo, final String rec_codigo, String rec_kodigo, final String pac_nome, final String mco_codigo, final String int_codigo, final String pac_sexo, final String pac_idade, final String data, final String hora, Date dataColeta, List<ExameMaterial> examesParaEnviar, final String exames, HashMap<String, String> parametros) throws SQLException {
        final String tuboId = parametros != null && !Funcoes.textoVazio(parametros.get(CODIGO_APOIO_FILHO)) ? parametros.get(CODIGO_APOIO_FILHO) : Funcoes.preencheZero(fil_codigo, ParametrosGerais.getDigitosTuboFilial()) + Funcoes.preencheZero(req_codigo, ParametrosGerais.getDigitosTuboRequisicao()) + Funcoes.preencheZero(rec_kodigo, ParametrosGerais.getDigitosTuboTubo());
        if (this.tuboIdEnviados.contains(tuboId) || this.configuracao.getManterListaDeEnviados() && this.listaEnviados.contains(tuboId)) {
            return;
        }
        TestOrder testOrder = new TestOrder();
        PatientInformation patientInfo = new PatientInformation();
        Message messageResp = new Message();
        messageResp.addRecord(new MessageHeader());
        messageResp.addRecord(patientInfo);
        messageResp.addRecord(testOrder);
        messageResp.addRecord(new MessageTerminator());
        patientInfo.setName(StringUtil.removerAcentos(pac_nome));
        testOrder.setSpecimenId(tuboId);
        this.tuboIdEnviados.add(tuboId);
        if (this.configuracao.getManterListaDeEnviados()) {
            this.listaEnviados.add(tuboId);
        }
        System.out.println(tuboId);
        Set<String> tests = this.obtemAlternativos(fil_codigo, mco_codigo, int_codigo, examesParaEnviar);
        if (tests.isEmpty()) {
            testOrder.setReportType(TestOrder.ReportType.NO_RECORD);
            this.fireExcecaoEncontrada(fil_codigo + req_codigo + rec_kodigo + " - Nenhum exame enviado.");
        } else {
            for (String test : tests) {
                UniversalTestId universalTestId = new UniversalTestId();
                universalTestId.setTestNumber(String.valueOf(test));
                testOrder.addUniversalTestId(universalTestId);
            }
            testOrder.setReportType(TestOrder.ReportType.FINAL_RESULTS);
            testOrder.setSpecimenDate(dataColeta);
            this.addMessageToSend(messageResp, new MessageSentCallback(){

                @Override
                public void messageSent(Message message, MessageSentCallback.MessageSentResult result) {
                    if (result == MessageSentCallback.MessageSentResult.SUCCESS) {
                        try {
                            Statement st = Conexao.getStatement();
                            InterfaceListener.this.tuboIdEnviados.remove(tuboId);
                            String[] stringArray = exames.split(" ");
                            int n = stringArray.length;
                            for (int i = 0; i < n; ++i) {
                                String exame;
                                int atual = InterfaceListener.this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exame = stringArray[i], mco_codigo, rec_codigo);
                                InterfaceListener.this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exame, mco_codigo, int_codigo, null, atual < 2 ? 1 : 3);
                            }
                            Conexao.arquivaSQL();
                        }
                        catch (Exception e) {
                            try {
                                Conexao.anulaSQL();
                            }
                            catch (SQLException sQLException) {
                                // empty catch block
                            }
                            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                        }
                        InterfaceListener.this.firePacienteEnviado(req_codigo, pac_nome, pac_sexo, pac_idade, data, hora, exames);
                        InterfaceListener.this.fireAtualizarTabela(0);
                    }
                }
            });
        }
    }

    private Set<String> obtemAlternativos(String fil_codigo, String mco_codigo, String int_codigo, List<ExameMaterial> examesParaEnviar) throws SQLException {
        HashSet<String> tests = new HashSet<String>();
        for (ExameMaterial exameParaEnviar : examesParaEnviar) {
            System.out.println(exameParaEnviar.getNomeExame());
            String test = BDUtil.getExmCodigoAlternativo(fil_codigo, exameParaEnviar.getNomeExame(), mco_codigo, int_codigo);
            if (test == null || test.trim().isEmpty()) continue;
            tests.add(test);
        }
        return tests;
    }

    @Override
    protected MessageReceivedListener getMessageReceivedListener() {
        return this;
    }

    @Override
    public void messageReceived(Message message) {
        for (Record record : message.getRecords()) {
            if (record.getType() == RecordType.RESULT) {
                this.measureData(message);
                break;
            }
            System.out.println("Registro recebido do tipo=" + record.getType().getId());
        }
    }

    public void buscarResultadosIndividuais(List<String> requisicoes) {
        for (String req : requisicoes) {
            RequestInformation r = new RequestInformation();
            RangeId range = new RangeId();
            range.setSpecimenId(req);
            r.setStartingRange(range);
            r.setEndingRange(range);
            r.setRequestInfoStatus(RequestInformation.RequestInfoStatus.REQUEST_RESULTS_PENDING);
            Message message = new Message();
            message.addRecord(new MessageHeader());
            message.addRecord(r);
            message.addRecord(new MessageTerminator());
            this.addMessageToSend(message);
        }
    }

    public void buscarResultados(Date inicio, Date fim) {
        RequestInformation requestInfo = new RequestInformation();
        requestInfo.setBeginningRequestResults(inicio);
        requestInfo.setEndingRequestResults(fim);
        requestInfo.setRequestInfoStatus(RequestInformation.RequestInfoStatus.REQUEST_RESULTS_PENDING);
        Message message = new Message();
        message.addRecord(new MessageHeader());
        message.addRecord(requestInfo);
        message.addRecord(new MessageTerminator());
        this.addMessageToSend(message);
    }

    private void measureData(Message message) {
        try {
            int digitosCodigoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
            Statement st = Conexao.getStatement();
            String tuboId = null;
            String req_pai = null;
            for (Record record : message.getRecords()) {
                if (record.getType() == RecordType.TEST_ORDER) {
                    TestOrder testOrder = (TestOrder)record;
                    String tuboIdAtual = testOrder.getSpecimenId();
                    if (!this.matches(tuboIdAtual)) {
                        tuboId = null;
                        this.fireExcecaoEncontrada(String.format("C\u00f3digo da etiqueta est\u00e1 incorreto: %s", tuboIdAtual));
                        continue;
                    }
                    DescritorCodigoEtiqueta etiqueta = DescritorCodigoEtiqueta.getDescritor(tuboIdAtual);
                    req_pai = tuboIdAtual;
                    if (etiqueta != null) {
                        tuboIdAtual = Funcoes.preencheZero(etiqueta.getFilial(), ParametrosGerais.getDigitosTuboFilial()) + Funcoes.preencheZero(etiqueta.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao()) + Funcoes.preencheZero(etiqueta.getTubo(), ParametrosGerais.getDigitosTuboTubo());
                    }
                    if (tuboIdAtual != null && tuboIdAtual.length() == digitosCodigoTubo && Funcoes.isNumeric(tuboIdAtual)) {
                        tuboId = tuboIdAtual;
                        continue;
                    }
                    this.fireExcecaoEncontrada(String.format("Id da amostra fora do padr\u00e3o: %s", tuboIdAtual));
                    tuboId = null;
                    continue;
                }
                if (record.getType() == RecordType.RESULT) {
                    ExameMaterial exame;
                    Result result = (Result)record;
                    if (tuboId == null) {
                        this.fireExcecaoEncontrada(String.format("Exame alternativo %s n\u00e3o localizado sem id da amostra", result.getUniversalTestId().getTestNumber()));
                        continue;
                    }
                    String emiAlternativo = result.getUniversalTestId().getTestNumber();
                    String filCodigo = tuboId.substring(0, ParametrosGerais.getDigitosTuboFilial());
                    String reqCodigo = tuboId.substring(ParametrosGerais.getDigitosTuboFilial());
                    String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                    reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
                    String intCodigo = this.getIntCodigo(filCodigo, reqCodigo, recCodigo, emiAlternativo);
                    if (ParametrosGerais.isAgruparGuiasInterface() && intCodigo == null) {
                        filCodigo = req_pai.substring(0, ParametrosGerais.getDigitosTuboFilial());
                        reqCodigo = req_pai.substring(ParametrosGerais.getDigitosTuboFilial());
                        recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                        reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
                        intCodigo = this.getIntCodigo(filCodigo, reqCodigo, recCodigo, emiAlternativo);
                    }
                    if ((exame = this.getReqExameLIS(filCodigo, intCodigo, reqCodigo, recCodigo, emiAlternativo)) != null) {
                        HashMap<String, Object> dados = new HashMap<String, Object>();
                        int sit = this.getExameSituacao(st, filCodigo, intCodigo, reqCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), recCodigo);
                        String campo = sit < 3 ? "resultado_quantitativo" : "repeticao_quantitativo";
                        String resultado = result.getMeasurementValue().replace('.', ',');
                        dados.put(campo, resultado);
                        this.atualizarDadosExame(st, filCodigo, reqCodigo, recCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), intCodigo, dados);
                        if (!this.configuracao.getAtualizarProntosPorResultado()) continue;
                        Conexao.arquivaSQL();
                        this.fireAtualizarTabela(2);
                        this.fireAtualizarTabela(1);
                        continue;
                    }
                    this.fireExcecaoEncontrada(String.format("Exame alternativo %s n\u00e3o localizado para amostra: %s", emiAlternativo, tuboId));
                    continue;
                }
                tuboId = null;
            }
            if (!this.configuracao.getAtualizarProntosPorResultado()) {
                Conexao.arquivaSQL();
                this.fireAtualizarTabela(2);
                this.fireAtualizarTabela(1);
            }
            st.close();
        }
        catch (Exception e) {
            try {
                Conexao.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
    }

    private boolean matches(String texto) {
        return texto.matches("[0-9]+");
    }

    @Override
    public void dataChanged(String text) {
        block6: {
            try {
                if (text != null && this.packetParser.checkFormat(text)) {
                    this.getPortaCOM().clearInputString();
                    try {
                        String data = text.substring(2, text.length() - 5);
                        if (!Funcoes.textoVazio(data)) {
                            this.packetRecebido(data);
                            this.enviarHandShake('\u0006');
                            break block6;
                        }
                        this.enviarHandShake('\u0015');
                    }
                    catch (Exception e) {
                        this.enviarHandShake('\u0015');
                    }
                    break block6;
                }
                this.enviarHandShake('\u0015');
            }
            catch (IOException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Falha na comunica\u00e7\u00e3o");
            }
        }
    }

    @Override
    public void teste() {
        this.handShakeCharReceived('\u0005');
        this.dataChanged(this.equipamento.arruma("[STX]1H|\\^&|[CR][ETX]99[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]2P|1||||INES[SP]DA[SP]SILVA[SP]SAURO|||F[CR][ETX]99[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]3O|1|010070329804|123037|^^^POT|||||||||||||||||||||Q[CR][ETX]99[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]4R|1|^^^K|6,155|g/dL|6,1^6,1|N||F||||20230901162810[CR][ETX]99[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]5O|2|010070329801|123038|^^^HEMOG|||||||||||||||||||||Q[CR][ETX]99[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]6R|1|^^^HEMOG|99,66|mg/dL|10^10|N||F||||20230901162852[CR][ETX]99[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]7O|3|010070329801|123038|^^^TIPSA|||||||||||||||||||||Q[CR][ETX]99[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]0R|1|^^^TIPSA|16,87|U/L|0^0|N||F||||20230901163517[CR][ETX]99[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]1O|4|010070329804|123038|^^^FOSFO|||||||||||||||||||||Q[CR][ETX]99[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]2R|1|^^^FOS|3,399|mg/dL|2,5^2,5|N||F||||20230901162543[CR][ETX]99[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]3O|5|010070329808|123038|^^^TAP|||||||||||||||||||||Q[CR][ETX]99[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]4R|1|^^^TAP|2,98|mg/dL|0,4^0,4|N||F||||20230901162908[CR][ETX]99[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]5O|6|010070329807|123038|^^^KPTT|||||||||||||||||||||Q[CR][ETX]99[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]6R|1|^^^KPTT|8,192|mg/dl|8,5^8,5|N||F||||20230901162642[CR][ETX]99[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]7O|7|010070329804|123037|^^^CAL|||||||||||||||||||||Q[CR][ETX]99[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]0R|1|^^^COD|3,431|g/dL|3,5^3,5|N||F||||20230901162756[CR][ETX]99[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]1O|8|010070329804|123037|^^^TGP|||||||||||||||||||||Q[CR][ETX]99[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]2R|1|^^^TGP|3,431|g/dL|3,5^3,5|N||F||||20230901162756[CR][ETX]99[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]3O|9|010070329804|123037|^^^CREAT|||||||||||||||||||||Q[CR][ETX]99[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]4R|1|^^^CREAT|3,431|g/dL|3,5^3,5|N||F||||20230901162756[CR][ETX]99[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]5O|10|010070329804|123037|^^^SODIO|||||||||||||||||||||Q[CR][ETX]99[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]6R|1|^^^Na|3,431|g/dL|3,5^3,5|N||F||||20230901162756[CR][ETX]99[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]7O|11|010070329804|123037|^^^UREIA|||||||||||||||||||||Q[CR][ETX]99[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]0R|1|^^^UREIA|3,431|g/dL|3,5^3,5|N||F||||20230901162756[CR][ETX]99[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]1O|12|010070329704|123037|^^^HDL|||||||||||||||||||||Q[CR][ETX]99[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]2R|1|^^^HDL|47,64|mg/dL|40^40|N||F||||20230901162629[CR][ETX]99[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]3O|13|010070329710|123037|^^^GLICO|||||||||||||||||||||Q[CR][ETX]99[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]4R|1|^^^GLICO|92,9|mg/dL|70^70|N||F||||20230901162725[CR][ETX]99[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]5O|14|010070329704|123037|^^^FERRO|||||||||||||||||||||Q[CR][ETX]99[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]6R|1|^^^FERRO|36,17|ng/mL|0^0|N||F||||20230901162737[CR][ETX]99[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]7O|15|010070329704|123037|^^^FERRI|||||||||||||||||||||Q[CR][ETX]99[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]0R|1|^^^FERRI|64,86|ug/dL|60^60|N||F||||20230901162658[CR][ETX]99[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]1O|16|010070329704|123037|^^^FAL|||||||||||||||||||||Q[CR][ETX]99[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]2R|1|^^^FALCAO|76,7|U/L|1^1|N||F||||20230901162839[CR][ETX]99[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]3O|17|010070329704|123037|^^^COL|||||||||||||||||||||Q[CR][ETX]99[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]4R|1|^^^COL|148,5|mg/dL|0^0|N||F||||20230901162712[CR][ETX]99[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]5O|18|010070329704|123037|^^^AURIC|||||||||||||||||||||Q[CR][ETX]99[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]6R|1|^^^AURICO|4,481|mg/dL|2^2|N||F||||20230901162616[CR][ETX]99[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]7O|19|010070329714|123037|^^^ALUMI|||||||||||||||||||||Q[CR][ETX]99[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]0R|1|^^^ALUMI|4,481|mg/dL|2^2|N||F||||20230901162616[CR][ETX]99[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]1O|20|010070329704|123037|^^^PTF|||||||||||||||||||||Q[CR][ETX]99[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]2R|1|^^^PTF|4,481|mg/dL|2^2|N||F||||20230901162616[CR][ETX]99[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]3O|21|010070329704|123037|^^^CFF|||||||||||||||||||||Q[CR][ETX]99[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]4R|1|^^^CFF|4,481|mg/dL|2^2|N||F||||20230901162616[CR][ETX]99[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]5O|22|010070329704|123037|^^^PTHIN|||||||||||||||||||||Q[CR][ETX]99[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]6R|1|^^^PERTIN|4,481|mg/dL|2^2|N||F||||20230901162616[CR][ETX]99[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]7O|23|010070329707|123037|^^^LDL|||||||||||||||||||||Q[CR][ETX]99[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]0R|1|^^^LDL|4,481|mg/dL|2^2|N||F||||20230901162616[CR][ETX]99[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]1O|24|010070329704|123037|^^^TRIG|||||||||||||||||||||Q[CR][ETX]99[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]2R|1|^^^TRIG|4,481|mg/dL|2^2|N||F||||20230901162616[CR][ETX]99[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]3O|25|010070329704|123037|^^^HCV|||||||||||||||||||||Q[CR][ETX]99[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]4R|1|^^^UNICV|4,481|mg/dL|2^2|N||F||||20230901162616[CR][ETX]99[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]5O|26|010070329704|123037|^^^HBS|||||||||||||||||||||Q[CR][ETX]99[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]6R|1|^^^HBS|4,481|mg/dL|2^2|N||F||||20230901162616[CR][ETX]99[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]7L|1|N[CR][ETX]99[LINE]"));
        this.handShakeCharReceived('\u0004');
    }

    public void addExameFilho(String exame) {
        this.examesFilho.add(exame);
    }

    public void setCurva(boolean curva) {
        this.curva = curva;
    }

    public boolean isCurva() {
        return this.curva;
    }

    public void setTuboPai(String rec_tuboPai) {
        this.rec_tuboPai = rec_tuboPai;
    }
}

